// implementatin of this specific plug-in is here:
//

#define SIGNATURE_AUTO_COMPLETE_LIST 0x00FF0800

// forward declaration
INT_PTR CALLBACK AutoCompleteDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

class CAutoComplete
{
public:
	wstring  m_sWord;
	wstring  m_sTo;
	int		m_nCaret;
	char    m_bEnable;
	char	m_bCase;
	CAutoComplete( wstring pszWord, wstring pszTo, int nCaret, bool bEnable, bool bCase ){
		m_sWord = pszWord;  m_sTo = pszTo;  m_nCaret = nCaret;  m_bEnable = bEnable;  m_bCase = bCase;
	};
	CAutoComplete( CAutoComplete* pAutoComplete ){
		m_sWord = pAutoComplete->m_sWord;  m_sTo = pAutoComplete->m_sTo;  m_nCaret = pAutoComplete->m_nCaret;  m_bEnable = pAutoComplete->m_bEnable;  m_bCase = pAutoComplete->m_bCase;
	};
};

typedef vector<CAutoComplete*> CAutoCompleteArray;

#define IS_ALPHA_NUM(x) ((x>=L'a'&&x<=L'z')||(x>=L'A'&&x<=L'Z')||(x>=L'0'&&x<=L'9'))
#define IS_SPACE(x) (x==L' '||x==L'\t')

LPCTSTR szAC = _T("AC");
LPCTSTR szAltChar = _T("AltChar");
LPCTSTR szIndent = _T("Indent");
LPCTSTR szTip = _T("Tip");
LPCTSTR szUseConfig = _T("UseConfig");
LPCTSTR szConfigNameKey = _T("ConfigName");


#define CMD_T				0
#define MAX_ESY_COMMAND		1
#define NOT_AUTO_COMPLETE (-2)

static LPCWSTR aszCmd[MAX_ESY_COMMAND] = {
	L"T",
};

LPCWSTR szDirection = 
	L"; EmEditor Auto Complete File\r\n"
	L";\r\n"
	L"; To utilize the auto complete feature, you must download and install the \r\n"
	L"; Auto Complete plug-in and import this (or a similiar) file. \r\n"
	L";\r\n"
	L"; To set up the Auto Complete plug-in, select Customize Plug-Ins\r\n"
	L"; under the Tool menu, select AutoComplete in the Plug-In Settings window, \r\n"
	L"; press [Properties], and then press [Import]. Locate and select the auto \r\n"
	L"; complete file (.eac extension) you would like to use. Click [Open]\r\n"
	L"; and then [OK] twice to close the Auto Complete and Plug-In Settings windows.\r\n"
	L";\r\n"
	L"; The next step is choosing the keyboard key you will use to activate the auto\r\n"
	L"; complete feature while typing. Select [Properties for All Configurations] \r\n"
	L"; under the Tool Menu (it is also possible to set up seperate settings for\r\n"
	L"; different configurations by choosing [Properties for Current Configuration]\r\n"
	L"; at this point). Click on the Keyboard tab and scroll through the \r\n"
	L"; Category list until you find and select Plug-In. Under Commands, select\r\n"
	L"; Auto Complete. Place the cursor in the Press New Shortcut Key box and choose\r\n"
	L"; a keyboard key to use by pressing the key of your choice once. Then press\r\n"
	L"; [Add], [OK], and [Close].\r\n"
	L";\r\n"
	L"; Submit your customized file to submit@emurasoft.com \r\n"
	L"; to be listed in www.emurasoft.com user files pages.\r\n"
	L";\r\n";



BOOL IsTextUnicodeE( CONST LPVOID lpBuffer, int cb, LPINT lpi )
{
	*lpi = 0;
	if( cb >= 2 ){
		if( *(LPBYTE)lpBuffer == 0xff && *((LPBYTE)lpBuffer + 1) == 0xfe ){
			*lpi = IS_TEXT_UNICODE_SIGNATURE;
		}
		else if( *(LPBYTE)lpBuffer == 0xfe && *((LPBYTE)lpBuffer + 1) == 0xff ){
			*lpi = IS_TEXT_UNICODE_REVERSE_SIGNATURE;
		}
		else if( *(LPBYTE)lpBuffer != 0 && *((LPBYTE)lpBuffer + 1) == 0 ){
			*lpi = IS_TEXT_UNICODE_ASCII16;
		}
		else if( *(LPBYTE)lpBuffer == 0 && *((LPBYTE)lpBuffer + 1) != 0 ){
			*lpi = IS_TEXT_UNICODE_REVERSE_ASCII16;
		}
	}
	return TRUE;
}


BOOL IsWordSpaceCase( WCHAR ch )
{
	if( (ch >=L'A' && ch <=L'Z') || (ch >=L'a' && ch <=L'z') || (ch >=L'0' && ch <=L'9') || ch ==L'_' ){
		return FALSE;
	}
	return TRUE;
}


LPWSTR GetNextCrLf( LPCWSTR psz )
{
	LPWSTR p = (LPWSTR)psz;
	while( *p != L'\0' ){
		if( *p == L'\r' ){
			if( *(p+1) == L'\n' ){
				p += 2;
				return p;
			}
			else {
				p++;
				return p;
			}
		}
		else if( *p == L'\n' ){
			p++;
			return p;
		}
		p++;
	}
	return NULL;
}


int GetLines( LPCWSTR psz )
{
	int nLines = 0;
	LPWSTR p = (LPWSTR)psz;
	do {
		p = GetNextCrLf( p );
		nLines++;
	} while( p != NULL );
	return nLines;
}


void AddIndent( LPCWSTR pszText, LPCWSTR pszIndent, LPWSTR pBuf0, SIZE_T cchBuf, INT_PTR nCaretLen, POINT_PTR* pptCaret )
{
	LPWSTR p = (LPWSTR)pszText;
	LPWSTR pBuf = (LPWSTR)pBuf0;
	int y = 0;
	for( ;; ) {
		LPWSTR p0 = p;
		p = GetNextCrLf( p );
		if( p == NULL ){
			StringCopyW( pBuf, cchBuf, p0 );
			if( nCaretLen != -1 ){
				pptCaret->x = nCaretLen;
				pptCaret->y = y;
			}
			break;
		}
		else {
			INT_PTR nLineLen = p - p0;
			StringCopyNW( pBuf, cchBuf, p0, nLineLen );
			pBuf += nLineLen;
			cchBuf -= nLineLen;
			if( nCaretLen != -1 ){
				if( nCaretLen >= nLineLen ){
					nCaretLen -= nLineLen;
				}
				else {
					pptCaret->x = nCaretLen;
					pptCaret->y = y;
					nCaretLen = -1;
				}
			}
			StringCopyW( pBuf, cchBuf, pszIndent );
			size_t cchIndent = wcslen( pszIndent );
			pBuf += cchIndent;
			cchBuf -= cchIndent;
			y++;
		}
	}
}


void Unescape( LPWSTR szOut, LPCWSTR szIn )
{
	LPWSTR pOut = szOut;
	LPWSTR p = (LPWSTR)szIn;
	while( *p ){
		if( *p == '^' ){   // escape next character
			p++;
		}
		*pOut++ = *p++;
	}
	*pOut = '\0';
}


void GetNextLine( LPWSTR szOut, int nMaxBuf, LPWSTR& p, LPCWSTR pEnd )
{
	WCHAR* pOut = szOut;
	bool bEscape = false;
	while( p < pEnd && *p != '\r' && *p != '\n' && nMaxBuf > 1 ){
		if( *p == '^' ){   // escape next character
			bEscape = true;
		}
		else if( !bEscape && *p == ';' ){
			break;  // ; comment
		}
		else {
			bEscape = false;
		}
		*pOut++ = *p++;
		nMaxBuf--;
	}
	*pOut = '\0';
	while( (*p != '\r' && *p != '\n') && p < pEnd )  p++;  // skip non-returns in too long line
	while( (*p == '\r' || *p == '\n') && p < pEnd )  p++;  // skip returns
}


LPWSTR GetAutoCompleteTo( LPWSTR& p, LPCWSTR pEnd, int& nCaret )
{
	LPWSTR pStart = p;
	bool bEscape = false;
	int nLen = 0;
	while( p < pEnd ){
		if( *p == '^' ){   // escape next character
			bEscape = true;
		}
		else if( !bEscape && *p == L'#' ){
			break;
		}
		else {
			nLen++;
			bEscape = false;
		}
		p++;
	}
	p = pStart;
	bEscape = false;
	LPWSTR pwsz = new WCHAR[nLen + 4];
	LPWSTR pOut = pwsz;
	nCaret = -1;
	while( p < pEnd ){
		if( *p == '^' ){   // escape next character
			bEscape = true;
		}
		else if( !bEscape && *p == L'#' ){
			break;  // ; comment
		}
		else if( !bEscape && *p == L'!' ){
			nCaret = (int)(pOut - pwsz);
		}
		else {
			*pOut++ = *p;
			bEscape = false;
		}
		p++;
	}
	*pOut = '\0';
	return pwsz;
}

// szArg buffer is 256 characters long
BOOL GetCommandToken( LPWSTR szCommand, LPWSTR szArg, LPCWSTR szLine )
{
	LPWSTR p = (LPWSTR)szLine;
	LPWSTR pCmd = szCommand;
	while( IS_ALPHA_NUM( *p ) ){
		*pCmd++ = *p++;
	}
	*pCmd = L'\0';
	if( !szCommand[0] )  return FALSE;
	while( IS_SPACE( *p ) )  p++;
	if( *p == L'=' ){
		p++;
		StringCopyW( szArg, 256, p );
		return TRUE;
	}
	return FALSE;
}


int GetCommand( LPWSTR szArg, LPCWSTR szLine )
{
	if( szLine[0] != L'#' )  return -1;
	WCHAR szCmd[256];
	WCHAR szArgOrg[256];
	if( !GetCommandToken( szCmd, szArgOrg, szLine + 1 ) ) {
		return -1;
	}
	for( int i = 0; i < MAX_ESY_COMMAND; i++ ){
		if( _wcsicmp( szCmd, aszCmd[i] ) == 0 ){
			Unescape( szArg, szArgOrg );
			return i;
		}
	}
	return -1;
}


void QuoteString( LPWSTR szOut, LPCWSTR szIn, int nAutoCompleteCaret )
{
	LPWSTR pIn = (LPWSTR)(LPCWSTR)szIn;
	LPWSTR pOut = szOut;
	while( *pIn ){
		if( nAutoCompleteCaret != NOT_AUTO_COMPLETE ){
			if( pIn - szIn == nAutoCompleteCaret ){
				*pOut++ = L'!';
			}
		}
		if( *pIn == L'#' || *pIn == L'^' || *pIn == L';' || (nAutoCompleteCaret != NOT_AUTO_COMPLETE && *pIn == L'!') ){
			*pOut++ = L'^';
		}
		*pOut++ = *pIn++;
	}
	*pOut = L'\0';
}


void WriteFlagString( HANDLE hFile, LPCWSTR pszFlag, LPCWSTR pszValue )
{
	WCHAR wsz[256];
	wsz[0] = L'#';
	StringCopyW( &wsz[1], _countof( wsz ) - 1, pszFlag );
	StringCatW( wsz, _countof( wsz ), L"=" );
	DWORD dwWritten;
	WriteFile( hFile, wsz, (DWORD)wcslen( wsz ) * sizeof( WCHAR ), &dwWritten, NULL );
	QuoteString( wsz, pszValue, NOT_AUTO_COMPLETE );
	StringCatW( wsz, _countof( wsz ), L"\r\n" );
	WriteFile( hFile, wsz, (DWORD)wcslen( wsz ) * sizeof( WCHAR ), &dwWritten, NULL );
}


void WriteKeyword( HANDLE hFile, LPCWSTR pszWord, int nAutoCompleteCaret )
{
	DWORD dwWritten;
	INT_PTR nLen = wcslen( pszWord );
	INT_PTR cchBuf = nLen * 2 + 8;
	LPWSTR pwsz = new WCHAR[cchBuf];
	QuoteString( pwsz, pszWord, nAutoCompleteCaret );
	if( nAutoCompleteCaret == NOT_AUTO_COMPLETE ){
		StringCatW( pwsz, cchBuf, L"\r\n" );
	}
	else {
		StringCatW( pwsz, cchBuf, L"#\r\n" );
	}
	WriteFile( hFile, pwsz, (DWORD)wcslen( pwsz ) * sizeof( WCHAR ), &dwWritten, NULL );
	delete [] pwsz;
}


namespace _filedlgEac
{
	TCHAR szPath[MAX_PATH];
	OPENFILENAME ofn;
	TCHAR szFilter[80];

	static void filedlgprepare(HWND hwnd)
	{
		using namespace _filedlgEac;

		szPath[0] = '\0';
		ZeroMemory( &ofn, sizeof( ofn ) );
		ofn.lStructSize = sizeof( ofn );
		ofn.hwndOwner = hwnd;
		LoadString( EEGetInstanceHandle(), IDS_FILTER_EAC, szFilter, _countof( szFilter ) );
		for( TCHAR* p = szFilter; *p != '\0'; p++ ){
			if( *p == '|' )  *p = '\0';
		}
		ofn.lpstrFilter = szFilter;
		ofn.nFilterIndex = 1;
		ofn.lpstrFile = szPath;
		ofn.nMaxFile = _countof( szPath );
		ofn.Flags = OFN_OVERWRITEPROMPT | OFN_EXPLORER | OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
		ofn.lpstrDefExt = _T("eac");
	}
}


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 7010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 7000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	HWND g_hwndTip;
	TCHAR  g_szAltChar[2];
	TCHAR  g_szConfigName[MAX_CONFIG_NAME];
	bool g_bLoaded;
	bool g_bModified;
	bool g_bIndent;
	bool g_bTip;
	bool g_bUseConfig;
	bool g_bSameConfig;
	bool g_bConfigChanged;
	CAutoCompleteArray g_AutoCompleteArray;
	TCHAR g_szTip[80];

	CMyFrame()
	{
		g_hwndTip = NULL;
		g_bModified = false;
		g_bLoaded = false;
		g_bIndent = true;
		g_bTip = true;
		g_bUseConfig = false;
		g_bConfigChanged = true;
		g_szAltChar[0] = _T('\0');
		g_szConfigName[0] = _T('\0');
		g_szTip[0] = _T('\0');
	}

	~CMyFrame()
	{
		DeleteAutoCompleteArray( g_AutoCompleteArray );
		if( g_hwndTip != NULL ){
			DestroyWindow( g_hwndTip );
			g_hwndTip = NULL;
		}
	}

	void OnCommand( HWND hwndView )
	{
		LPWSTR pszString = NULL;
		POINT_PTR ptCaret;
		CAutoComplete* pAC = GetAutoComplete( hwndView, pszString, &ptCaret );
		if( (!g_bUseConfig || g_bSameConfig) && (!g_bTip || g_szTip[0] != '\0') && pAC != NULL ){
			Editor_ExecCommand( hwndView, EEID_ESCAPE );
			INT_PTR nLen = pAC->m_sWord.length();
			ptCaret.x -= nLen;
			for( ; nLen != 0; nLen-- ){
				Editor_ExecCommand( hwndView, EEID_BACK );
			}

			LPWSTR pIndent = pszString;
			if( g_bIndent ){
				while( *pIndent && IS_SPACE( *pIndent ) ){
					pIndent++;
				}
			}
			*pIndent = L'\0';
			INT_PTR nIndentLen = pIndent - pszString;
			int nLines = GetLines( pAC->m_sTo.c_str() );
			INT_PTR nBufLen = nLines * nIndentLen + pAC->m_sTo.length() + 1;
			WCHAR* pTo = new WCHAR[ nBufLen ];
			if( pTo != NULL ){
				POINT_PTR ptIndentCaret;
				ptIndentCaret.x = ptIndentCaret.y = 0;
				AddIndent( pAC->m_sTo.c_str(), pszString, pTo, nBufLen, pAC->m_nCaret, &ptIndentCaret );
				Editor_InsertStringW( hwndView, pTo );
				delete [] pTo;
				if( pAC->m_nCaret != -1 ){
					if( ptIndentCaret.y == 0 ){
						ptIndentCaret.x += ptCaret.x;
					}
					else {
						ptIndentCaret.x += nIndentLen;
					}
					ptIndentCaret.y += ptCaret.y;
					Editor_SetCaretPos( hwndView, POS_LOGICAL_W, &ptIndentCaret );
				}
			}
		}
		else if( g_szAltChar[0] ) {
			Editor_InsertStringW( hwndView, g_szAltChar );
		}
		if( pszString != NULL ){
			delete [] pszString;
		}
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		return TRUE;
	}

	void OnEvents( HWND hwndView, UINT nEvent, LPARAM /*lParam*/ )
	{
		if( nEvent & EVENT_CREATE_FRAME ){
			LoadProfile();
		}

		if( !g_bTip )  return;
		if( g_bUseConfig ){
			if( g_bConfigChanged || (nEvent & EVENT_CONFIG_CHANGED) ){
				QueryConfig( hwndView );
				EraseTip();
				g_bConfigChanged = false;
				return;
			}
		}
		if( g_bUseConfig && !g_bSameConfig )  return;
		if( nEvent & EVENT_CHANGE ){
			LPWSTR pszString = NULL;
			POINT_PTR ptCaret;
			CAutoComplete* pAC = GetAutoComplete( hwndView, pszString, &ptCaret );
			if( pAC != NULL ){
				ShowTip( hwndView, pAC->m_sTo.c_str() );
			}
			else {
				EraseTip();
			}
			if( pszString != NULL ){
				delete [] pszString;
			}
		}
		else if( nEvent & (EVENT_CARET_MOVED | EVENT_KILL_FOCUS | EVENT_CONFIG_CHANGED | EVENT_SCROLL | EVENT_CLOSE) ){
			EraseTip();
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg, LPTSTR /*pszUninstallCommand*/, LPTSTR /*pszUninstallParam*/ )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		TCHAR sz[260];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
		if( Editor_GetVersion( m_hWnd ) < 7000 ){
			LoadString( EEGetInstanceHandle(), IDS_INVALID_VERSION, sz, _countof( sz ) );
			MessageBox( m_hWnd, sz, szAppName, MB_OK | MB_ICONSTOP );
			return FALSE;
		}

		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_AUTO_COMPLETE ), hDlg, AutoCompleteDlg );
		return TRUE;
	}

	BOOL PreTranslateMessage( HWND /*hwndView*/, MSG* /*pMsg*/ )
	{
		return FALSE;
	}

	// user-defined methods below.
	void DeleteAutoCompleteArray( CAutoCompleteArray& AutoCompleteArray )
	{
		CAutoCompleteArray::iterator it = AutoCompleteArray.begin();
		while( it != AutoCompleteArray.end() ){
			delete *it++;
		}
		AutoCompleteArray.clear();
	}

	BOOL SaveAutoCompleteArray( CAutoCompleteArray& AutoCompleteArray )
	{
		int nLen;
		BOOL bSuccess = FALSE;
		DWORD dwCount = sizeof( int );
		dwCount += sizeof(DWORD);
		CAutoCompleteArray::iterator it = AutoCompleteArray.begin();
		int nMax = 0;
		while( it != AutoCompleteArray.end() ){
			CAutoComplete* pAutoComplete = *it++;
			dwCount += (DWORD)(pAutoComplete->m_sWord.length()*sizeof(WCHAR)) + (DWORD)(pAutoComplete->m_sTo.length()*sizeof(WCHAR)) + sizeof( bool ) * 2 + sizeof( int ) * 3;
			nMax++;
		}
		char *pBuf;
		pBuf = new char[dwCount];
		if( pBuf != NULL ){
			char* p = pBuf;
			*((DWORD*)p) = SIGNATURE_AUTO_COMPLETE_LIST;
			p += sizeof( DWORD );
			*((int*)p) = nMax;
			p += sizeof( int );
			it = AutoCompleteArray.begin();
			while( it != AutoCompleteArray.end() ){
				CAutoComplete* pAutoComplete = *it++;
				*((int*)p) = pAutoComplete->m_nCaret;
				p += sizeof( int );
				*p++ = pAutoComplete->m_bEnable;
				*p++ = pAutoComplete->m_bCase;
				nLen = (int)pAutoComplete->m_sWord.length();
				*((int*)p) = nLen;
				p += sizeof( int );
				memcpy( p, pAutoComplete->m_sWord.c_str(), nLen * sizeof(WCHAR) );
				p += nLen * sizeof(WCHAR);
				nLen = (int)pAutoComplete->m_sTo.length();
				*((int*)p) = nLen;
				p += sizeof( int );
				memcpy( p, pAutoComplete->m_sTo.c_str(), nLen * sizeof(WCHAR) );
				p += nLen * sizeof(WCHAR);
			}
			_ASSERTE( p == pBuf + dwCount );
			bSuccess = ( p == pBuf + dwCount );
			WriteProfileBinary( szAC, (LPBYTE)pBuf, dwCount, true );
			delete [] pBuf;
		}
		return bSuccess;
	}

	void LoadAutoCompleteArray( /*HKEY hKey,*/ CAutoCompleteArray& AutoCompleteArray )
	{
		DWORD dwCount = GetProfileBinary( szAC, (LPBYTE)NULL, 0 );
		if( dwCount > 0 ){
			char* pBuf = new char[dwCount];
			if( pBuf != NULL ){
				if( GetProfileBinary( szAC, (LPBYTE)pBuf, dwCount ) ){
					int nMax, nLen, nCaret;
					bool bEnable;
					bool bCase;
					char* p = pBuf;
					DWORD dwSign = *((DWORD*)p);
					p += sizeof( DWORD );
					if( dwSign == SIGNATURE_AUTO_COMPLETE_LIST )	{
						nMax = *((int*)p);
						p += sizeof( int );
						for( int i = 0; i < nMax; i ++ ){
							nCaret = *((int*)p);
							p += sizeof( int );
							bEnable = (bool)!!*p++;
							bCase = (bool)!!*p++;
							nLen = *((int*)p);
							p += sizeof( int );
							wstring sWord( (LPCWSTR)p, nLen );
							p += nLen * sizeof(WCHAR);
							nLen = *((int*)p);
							p += sizeof( int );
							wstring sTo( (LPCWSTR)p, nLen );
							p += nLen * sizeof(WCHAR);
							CAutoComplete* pAutoComplete = new CAutoComplete( sWord, sTo, nCaret, bEnable, bCase );
							AutoCompleteArray.push_back( pAutoComplete );
						}
						_ASSERTE( p == pBuf + dwCount );
					}
				}
				delete [] pBuf;
			}
		}
	}

	void LoadProp()
	{
		GetProfileString( szAltChar, g_szAltChar, _countof( g_szAltChar ), _T(" ") );
		GetProfileString( szConfigNameKey, g_szConfigName, _countof( g_szConfigName ), _T("") );
		g_bIndent = (bool)!!GetProfileInt( szIndent, TRUE );
		g_bTip = (bool)!!GetProfileInt( szTip, TRUE );
		g_bUseConfig = (bool)!!GetProfileInt( szUseConfig, FALSE );
	}

	BOOL LoadProfile()
	{
		if( g_bLoaded )  return TRUE;
		LoadAutoCompleteArray( /*hKey,*/ g_AutoCompleteArray );
		LoadProp();
		g_bLoaded = true;
		g_bModified = false;
		return TRUE;
	}

	CAutoComplete* IsAutoCompleteString( LPCWSTR pszString, INT_PTR xCaret )
	{
		for( CAutoCompleteArray::iterator it = g_AutoCompleteArray.begin(); it != g_AutoCompleteArray.end(); it++ ){
			CAutoComplete* pAutoComplete = *it;
			INT_PTR nLen = pAutoComplete->m_sWord.length();
			if( nLen <= xCaret ){
				if( nLen == xCaret || IsWordSpaceCase( pszString[xCaret - nLen - 1] ) ){
					if( wcsncmp( pszString + xCaret - nLen, pAutoComplete->m_sWord.c_str(), nLen ) == 0 ){
						return pAutoComplete;
					}
				}
			}
		}
		return NULL;
	}

	CAutoComplete* GetAutoComplete( HWND hwnd, LPWSTR& pszString, POINT_PTR* pptCaret )
	{
		Editor_GetCaretPos( hwnd, POS_LOGICAL_W, pptCaret );
		GET_LINE_INFO gli;
		gli.cch = 0;
		gli.flags = FLAG_LOGICAL;
		gli.yLine = pptCaret->y;
		UINT_PTR nSize = Editor_GetLineW( hwnd, &gli, NULL );
		pszString = new WCHAR[ nSize ];
		CAutoComplete* pAC = NULL;
		if( pszString != NULL ){
			gli.cch = nSize;
			Editor_GetLineW( hwnd, &gli, pszString );
			pAC = IsAutoCompleteString( pszString, pptCaret->x );
		}
		return pAC;
	}

	HWND CreateTip( HWND hwnd )
	{
		if( g_hwndTip == NULL ){
			g_hwndTip = CreateWindowEx(WS_EX_TOPMOST,
				TOOLTIPS_CLASS, NULL, WS_POPUP | TTS_NOPREFIX | TTS_ALWAYSTIP,		
				CW_USEDEFAULT, CW_USEDEFAULT,
				CW_USEDEFAULT, CW_USEDEFAULT,
				hwnd, NULL, EEGetInstanceHandle(), NULL );
			if( g_hwndTip != NULL ){
				SendMessage( g_hwndTip, TTM_SETMAXTIPWIDTH, 0, 400 );
			}
		}
		return g_hwndTip;
	}

	void EraseTip()
	{
		g_szTip[0] = '\0';
		if( g_hwndTip == NULL )  return;
		SendMessage( g_hwndTip, TTM_ACTIVATE, FALSE, 0 );
	}

	void ShowTip( HWND hwnd, LPCWSTR szTip )
	{
		g_szTip[0] = '\0';
		lstrcpyn( g_szTip, szTip, _countof( g_szTip ) );
		POINT ptPos;
		TOOLINFO ti;
		ZeroMemory( &ti, sizeof( ti ) );
		ti.cbSize = TTTOOLINFO_V1_SIZE;
		ti.uFlags = TTF_IDISHWND | TTF_TRACK | TTF_ABSOLUTE;
		ti.hwnd   = hwnd;
		ti.uId    = (UINT_PTR)hwnd;
		ti.hinst  = EEGetInstanceHandle();
		ti.lpszText  = g_szTip;
		if( !GetCaretPos( &ptPos ) )  return;
		ClientToScreen( hwnd, &ptPos );
		ptPos.y += 20;
		if( g_hwndTip != NULL ) {
			SendMessage( g_hwndTip, TTM_ACTIVATE, TRUE, 0 );
			SendMessage(g_hwndTip, TTM_UPDATETIPTEXT, 0, (LPARAM)&ti);
		}
		else {
			if( !CreateTip( hwnd ) )  return;
			SendMessage(g_hwndTip, TTM_ADDTOOL, 0, (LPARAM)&ti);
		}
		SendMessage( g_hwndTip,TTM_TRACKPOSITION, (WPARAM)TRUE,(LPARAM)MAKELONG( ptPos.x, ptPos.y ) );
		SendMessage( g_hwndTip,TTM_TRACKACTIVATE,(WPARAM)TRUE,(LPARAM)&ti );
	}


	void QueryConfig( HWND hwnd )
	{
		TCHAR szConfigName[MAX_CONFIG_NAME];
		Editor_GetConfigW( hwnd, szConfigName );
		g_bSameConfig = (lstrcmpi( szConfigName, g_szConfigName ) == 0);
	}

	void UpdateData( HWND hwnd )
	{
		CheckDlgButton( hwnd, IDC_AUTO_INDENT, g_bIndent );
		CheckDlgButton( hwnd, IDC_TIP, g_bTip );
		CheckDlgButton( hwnd, IDC_USE_CONFIG, g_bUseConfig );
		SetDlgItemText( hwnd, IDC_ALTERNATE_CHAR, g_szAltChar );
	}

	void OnImport( HWND hwnd )
	{
		using namespace _filedlgEac;
		filedlgprepare( hwnd );

		if( GetOpenFileName( &ofn ) )
		{
			HANDLE hFile = CreateFile( szPath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
			if( hFile != INVALID_HANDLE_VALUE )
			{
				DWORD dwFileSize = GetFileSize( hFile, NULL );
				if( dwFileSize > 0 && dwFileSize != 0xFFFFFFFF )
				{
					HANDLE hFileMap = CreateFileMapping( hFile, NULL, PAGE_READONLY, 0, dwFileSize, NULL );
					if( hFileMap != NULL )
					{
						char* lpvFile = (char*)MapViewOfFile( hFileMap, FILE_MAP_READ, 0, 0, 0 );

						if( lpvFile != NULL )
						{
							int i = IS_TEXT_UNICODE_UNICODE_MASK;
							char* lpvUnicode;
							DWORD dwUnicodeSize;
							IsTextUnicodeE((void*)lpvFile, dwFileSize, &i);

							if(i & IS_TEXT_UNICODE_SIGNATURE) {
								lpvFile += 2;
								dwFileSize -= 2;
							}

							if( i & IS_TEXT_UNICODE_UNICODE_MASK ) {
								dwUnicodeSize = dwFileSize;
								lpvUnicode = new CHAR[dwUnicodeSize];
								memcpy(lpvUnicode, lpvFile, dwFileSize);
							}
							else {
								dwUnicodeSize = 2*MultiByteToWideChar(CP_ACP, 0, (CHAR*)lpvFile, dwFileSize, NULL, 0);
								lpvUnicode = new CHAR[dwUnicodeSize];
								MultiByteToWideChar(CP_ACP, 0, lpvFile, dwFileSize, (WCHAR*)lpvUnicode, dwUnicodeSize);
							}

							WCHAR* pEnd = (WCHAR*)(lpvUnicode+ dwUnicodeSize);
							{
								WCHAR* p = (WCHAR*)lpvUnicode;
								DeleteAutoCompleteArray( g_AutoCompleteArray );
								p = (WCHAR*)lpvUnicode;
								while( p < pEnd ){
									WCHAR szLine[256];
									GetNextLine( szLine, _countof( szLine ), p, pEnd );
									WCHAR szArg[256];
									int nCmd = GetCommand( szArg, szLine );
									switch( nCmd ){
									case CMD_T:
										if( szArg[0] != '\0' ){
											int nCaret;
											LPWSTR pwszTo = GetAutoCompleteTo( p, pEnd, nCaret );
											if( pwszTo != NULL ){
												CAutoComplete* pAutoComplete = new CAutoComplete( szArg, pwszTo, nCaret, true, true );
												g_AutoCompleteArray.push_back( pAutoComplete );
											}
											delete [] pwszTo;
										}
										break;
									default:
										break;
									}
								}
								delete [] lpvUnicode;
								UnmapViewOfFile( lpvFile );
								g_bModified = true;
								g_bLoaded = true;
							}
							CloseHandle( hFileMap );
						}
					}
				}
				CloseHandle( hFile );
			}
		}
	}

	void OnExport( HWND hwnd )
	{
		using namespace _filedlgEac;
		filedlgprepare( hwnd );
		ofn.Flags |= OFN_NOREADONLYRETURN;
		if( GetSaveFileName( &ofn ) )
		{
			HANDLE hFile = CreateFile( szPath, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL );
			if( hFile != INVALID_HANDLE_VALUE )
			{
				DWORD dwWritten;
				BYTE head[2] = {0xFF, 0xFE };
				WriteFile( hFile, head, sizeof(head), &dwWritten, NULL );
				WriteFile( hFile, szDirection, (DWORD)wcslen( szDirection ) * sizeof( WCHAR ), &dwWritten, NULL );

				for( CAutoCompleteArray::iterator it = g_AutoCompleteArray.begin() ; it < g_AutoCompleteArray.end() ; it++ ){
					CAutoComplete* pAutoComplete = *it;
					WriteFlagString( hFile, aszCmd[CMD_T], pAutoComplete->m_sWord.c_str() );
					WriteKeyword( hFile, pAutoComplete->m_sTo.c_str(), pAutoComplete->m_nCaret );
				}
				CloseHandle( hFile );
			}
		}
	}

	void FillConfigCombo( HWND hwnd )
	{
		size_t cchBuf = Editor_EnumConfig( m_hWnd, NULL, 0 );
		if( !cchBuf )  return;

		LPWSTR pszBuf = new WCHAR[ cchBuf ];
		if( !pszBuf )  return;
		
		if( !Editor_EnumConfig( m_hWnd, pszBuf, cchBuf ) )  return;

		int nSel = -1;
		int i = 0;
		LPWSTR p = pszBuf;
		while( *p ){
			SendMessage( hwnd, CB_ADDSTRING, 0, (LPARAM)p );
			if( lstrcmpi( g_szConfigName, p ) == 0 ){
				nSel = i;
			}
			p += wcslen( p ) + 1;
			i++;
		}
		if( nSel != -1 ){
			SendMessage( hwnd, CB_SETCURSEL, nSel, 0 );
		}

		delete [] pszBuf;
	}

	void ShowHide( HWND hwnd )
	{
		BOOL bUseConfig = IsDlgButtonChecked( hwnd, IDC_USE_CONFIG );
		EnableWindow( GetDlgItem( hwnd, IDC_COMBO_CONFIG ), bUseConfig );
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		SendDlgItemMessage( hwnd, IDC_ALTERNATE_CHAR, EM_LIMITTEXT, 1, 0 );
		UpdateData( hwnd );
		FillConfigCombo( GetDlgItem( hwnd, IDC_COMBO_CONFIG ) );
		ShowHide( hwnd );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WORD wCmdID )
	{
		switch( wCmdID ){
		case IDOK:
			{
				g_bIndent = !!IsDlgButtonChecked( hwnd, IDC_AUTO_INDENT );
				g_bTip = !!IsDlgButtonChecked( hwnd, IDC_TIP );
				g_bUseConfig = !!IsDlgButtonChecked( hwnd, IDC_USE_CONFIG );
				WriteProfileInt( szIndent, g_bIndent );
				WriteProfileInt( szTip, g_bTip );
				WriteProfileInt( szUseConfig, g_bUseConfig );
				GetDlgItemText( hwnd, IDC_ALTERNATE_CHAR, g_szAltChar, 2 );
				WriteProfileString( szAltChar, g_szAltChar );
				INT_PTR nSel = SendDlgItemMessage( hwnd, IDC_COMBO_CONFIG, CB_GETCURSEL, 0, 0 );
				if( nSel != -1 ){
					SendDlgItemMessage( hwnd, IDC_COMBO_CONFIG, CB_GETLBTEXT, nSel, (LPARAM)g_szConfigName );
					WriteProfileString( szConfigNameKey, g_szConfigName );
				}
				if( g_bModified && g_bLoaded ){
					SaveAutoCompleteArray( g_AutoCompleteArray );
					g_bModified = false;
				}
				if( g_bUseConfig ){
					g_bConfigChanged = true;
				}
				EndDialog( hwnd, IDOK );
			}
			break;
		case IDCANCEL:
			if( g_bModified && g_bLoaded ){
				DeleteAutoCompleteArray( g_AutoCompleteArray );
				g_bModified = false;
				g_bLoaded = false;
			}
			EndDialog( hwnd, IDCANCEL );
			break;
		case IDC_IMPORT:
			OnImport( hwnd );
			break;
		case IDC_EXPORT:
			OnExport( hwnd );
			break;
		case IDC_USE_CONFIG:
			ShowHide( hwnd );
			break;
		}
		return;
	}
};

INT_PTR CALLBACK AutoCompleteDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnInitDialog( hwnd );
			bResult = TRUE;
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	}
	return bResult;
}

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT
