#include "config.h"
#include <windows.h>
#include "tools.h"
#include "option.h"
#include "plugin.h"
#include "resource.h"

namespace CaretImeColor
{
	//	LbgTCYݒ_CAO
	namespace CaretSize
	{
		const ::DWORD caret_size_error		= 0xfffffffe;
		const ::DWORD caret_size_default	= 0xffffffff;
		const ::DWORD caret_size_font		= 0;

		//	R{{bNXɕƒlݒ
		::LRESULT	AddComboBoxValue( ::HWND combo, wchar_t const* str, ::LPARAM data )
		{
			auto index( ::SendMessage( combo, CB_ADDSTRING, 0, reinterpret_cast<::LPARAM>( str ) ) );
			if( index != CB_ERR ){
				if( ::SendMessage( combo, CB_SETITEMDATA, index, data ) != CB_ERR )
					return index;
				::SendMessage( combo, CB_DELETESTRING, index, 0 );
			}
			return	CB_ERR;
		}
		inline ::LRESULT	AddComboBoxValue( ::HWND dlg, ::UINT combo_id, wchar_t const* str, ::LPARAM data )
		{
			return	AddComboBoxValue( ::GetDlgItem( dlg, combo_id ), str, data );
		}

		//	R{{bNXڂ̒lɌ
		::LRESULT	FindComboItemData( ::HWND combo, ::LPARAM data )
		{
			auto const count( ::SendMessage( combo, CB_GETCOUNT, 0, 0 ) );
			if( count != CB_ERR ){
				for( LRESULT i(0) ; i < count ; ++i ){
					if( ::SendMessage( combo, CB_GETITEMDATA, i, 0 ) == data ){
						return	i;
					}
				}
			}
			return CB_ERR;
		}

		//	R{{bNXڂ̒lɑI
		bool	SelectComboItemData( ::HWND combo, ::LPARAM data )
		{
			auto const index( FindComboItemData( combo, data ) );
			return	index != CB_ERR && ::SendMessage( combo, CB_SETCURSEL, index, 0 ) != CB_ERR;
		}
		inline bool	SelectComboItemData( ::HWND dlg, ::UINT combo_id, ::LPARAM data )
		{
			return	SelectComboItemData( GetDlgItem( dlg, combo_id ), data );
		}

		//	R{{bNX̑Iڂ̒l擾
		inline ::LRESULT	GetComboItemData( ::HWND combo, ::LRESULT default_data )
		{
			auto const index( ::SendMessage( combo, CB_GETCURSEL, 0, 0 ) );
			return	(index != CB_ERR) ? ::SendMessage( combo, CB_GETITEMDATA, index, 0 ) : default_data;
		}
		inline ::LRESULT GetComboItemData( ::HWND dlg, ::UINT combo_id, ::LRESULT default_data )
		{
			return	GetComboItemData( GetDlgItem( dlg, combo_id ), default_data );
		}

		//	J[\TCYݒpR{{bNX
		void	InitCaretSize( ::HWND dlg, ::UINT combo_id )
		{
			auto const combo( ::GetDlgItem( dlg, combo_id ) );
			::SendMessage( combo, CB_RESETCONTENT, 0, 0 );
			for( auto i(1) ; i <= 10 ; ++i ){
				wchar_t str[32];
				::swprintf_s( str, L"%d", i );
				AddComboBoxValue( combo, str, i );
			}
			AddComboBoxValue( combo, tools::GetString( IDS_FONT_SIZE ).c_str(), caret_size_font );
		}

		//	J[\TCYvpeB_CAOvV[W
		::INT_PTR CALLBACK Procedure( ::HWND dlg, ::UINT msg, ::WPARAM wParam, ::LPARAM lParam )
		{
			switch( msg ){

				//	
			case WM_INITDIALOG:
				{
					::SetWindowLongPtr(	dlg, GWLP_USERDATA, lParam );

					InitCaretSize(	  dlg, IDC_CARET_WIDTH  );
					InitCaretSize(	  dlg, IDC_CARET_HEIGHT );
					AddComboBoxValue( dlg, IDC_CARET_WIDTH, tools::GetString(IDS_DEFAULT).c_str(), caret_size_default );
					option::Reader reader( reinterpret_cast<::HWND>(::GetWindowLongPtr(dlg, GWLP_USERDATA )), EEREG_COMMON );
					SelectComboItemData( dlg, IDC_CARET_WIDTH,  reader.UInt32( L"CaretWidth",  caret_size_default ) );
					SelectComboItemData( dlg, IDC_CARET_HEIGHT, reader.UInt32( L"CaretHeight", caret_size_font	  ) );
				}
				break;

			case WM_COMMAND:
				switch( HIWORD(wParam) ){
				case BN_CLICKED:
					switch( LOWORD(wParam) ){

					//	VȃJ[\TCYۑ
					case IDOK:
						{
							auto const width(  static_cast<::UINT32>( GetComboItemData( dlg, IDC_CARET_WIDTH,  caret_size_error ) ) );
							auto const height( static_cast<::UINT32>( GetComboItemData( dlg, IDC_CARET_HEIGHT, caret_size_error ) ) );
							if( width != caret_size_error || height != caret_size_error ){
								option::Writer writer( reinterpret_cast<::HWND>(::GetWindowLongPtr(dlg, GWLP_USERDATA )), EEREG_COMMON );
								if( width  != caret_size_error ) writer.UInt32( L"CaretWidth",  width  );
								if( height != caret_size_error ) writer.UInt32( L"CaretHeight", height );
							}
						}
						::EndDialog( dlg, IDOK );
						return	true;
					//	ύXɕ
					case IDCANCEL:
						::EndDialog( dlg, IDCANCEL );
						return	true;
					}
					break;
				}
				break;

			}
			return	false;
		}
	}

	//	LbgTCYݒ_CAO\
	bool	ShowChangeCaretSize( ::HWND editor, ::HWND parent )
	{
		return	::DialogBoxParam( tools::Instance(), MAKEINTRESOURCE(IDD_CARET_SIZE), parent, CaretSize::Procedure, reinterpret_cast<::LPARAM>(editor) ) != -1;
	}
}