#pragma once

#include "config.h"
#include <windows.h>

namespace tools
{
	//	rIuWFNg^
	class Mutex {
	private:
		::CRITICAL_SECTION	cs_;
		Mutex(			  Mutex const& );
		Mutex& operator=( Mutex const& );
	public:
		Mutex(){  ::InitializeCriticalSection(&cs_); }
		~Mutex(){ ::DeleteCriticalSection(	  &cs_); }

		//	bN
		class Lock {
		public:
			Lock( Mutex& mutex ): cs_(mutex.cs_) {	::EnterCriticalSection(&cs_); }
			~Lock(){								::LeaveCriticalSection(&cs_); }
		private:
			::CRITICAL_SECTION&	cs_;
			Lock(			 Lock const& );
			Lock& operator=( Lock const& );
		};
	};

}
