#pragma once

#include "config.h"
#include <windows.h>
#include <string>

namespace option
{
	namespace detail
	{
		class Base {
		public:
			operator bool () const { return !hwnd_; }
			bool operator!() const { return  hwnd_ == nullptr; }
		protected:
			Base( ::HWND hwnd );
			Base( ::HWND hwnd, ::DWORD key );
			Base( ::HWND hwnd, ::DWORD key, std::wstring const& config );
			Base( ::HWND hwnd, ::DWORD key, std::wstring&&		config );
			::HWND		 const	hwnd_;
			::DWORD		 const	key_;
			std::wstring const	config_;
		private:
			Base(			 Base const& );
			Base& operator=( Base const& );
		};
	}

//----------------------------------------------------------------------------//////////////////////////////////

	//	IvV[_[
	class Reader: public detail::Base {
	public:
		Reader( ::HWND hwnd ): detail::Base(hwnd) {}
		Reader( ::HWND hwnd, ::DWORD key ):								detail::Base(hwnd,key) {}
		Reader( ::HWND hwnd, ::DWORD key, std::wstring const& config ): detail::Base(hwnd,key,config) {}
		Reader( ::HWND hwnd, ::DWORD key, std::wstring&&	  config ): detail::Base(hwnd,key,std::move(config)) {}

		//	ǂݎ
		bool			Bool(	wchar_t const* name, bool			defaultValue = false	) const;	//	_l
		::UINT32		UInt32(	wchar_t const* name, ::UINT32		defaultValue = 0u		) const;	//	32bitȂ
		::INT32			Int32(	wchar_t const* name, ::INT32		defaultValue = 0		) const;	//	32bitt
		float			Float(	wchar_t const* name, float			defaultValue = 0.f		) const;	//	Px_
		std::wstring	String(	wchar_t const* name, wchar_t const*	defaultValue = nullptr	) const;	//	
	public:
		//	f[^ǂݎ
		::LONG	QueryValue( wchar_t const* name, ::DWORD type, void* data, ::DWORD& size ) const;
	};

//----------------------------------------------------------------------------//////////////////////////////////

	//	IvVC^[
	class Writer: public detail::Base {
	public:
		Writer( ::HWND hwnd ): detail::Base(hwnd) {}
		Writer( ::HWND hwnd, ::DWORD key ):								detail::Base(hwnd,key) {}
		Writer( ::HWND hwnd, ::DWORD key, std::wstring const& config ): detail::Base(hwnd,key,config) {}
		Writer( ::HWND hwnd, ::DWORD key, std::wstring&&	  config ): detail::Base(hwnd,key,std::move(config)) {}

		//	
		bool	Bool(	wchar_t const* name, bool			value );	//	_l
		bool	UInt32(	wchar_t const* name, ::UINT32		value );	//	32bitȂ
		bool	Int32(	wchar_t const* name, ::INT32		value );	//	32bitt
		bool	Float(	wchar_t const* name, float			value );	//	Px_
		bool	String(	wchar_t const* name, wchar_t const*	value );	//	
	public:
		//	f[^
		::LONG	SetValue( wchar_t const* name, ::DWORD type, const void* data, ::DWORD size );
	};

}
