#include "config.h"
#include <cstring>
#include "option.h"
#include "tools.h"
#include "plugin.h"
#include "resource.h"

#undef min
#undef max

static_assert( sizeof(::UINT32) == sizeof(float), "float size mismatch." );

namespace option
{
	namespace detail
	{
		Base::Base( ::HWND hwnd ):											hwnd_(tools::FindMostParentWindow(hwnd)), key_(EEREG_EMEDITORPLUGIN), config_(tools::GetString(IDS_SYSNAME)) {}
		Base::Base( ::HWND hwnd, ::DWORD key ):								hwnd_(tools::FindMostParentWindow(hwnd)), key_(key) {}
		Base::Base( ::HWND hwnd, ::DWORD key, std::wstring const& config ):	hwnd_(tools::FindMostParentWindow(hwnd)), key_(key), config_(config) {}
		Base::Base( ::HWND hwnd, ::DWORD key, std::wstring&&	  config ):	hwnd_(tools::FindMostParentWindow(hwnd)), key_(key), config_(std::move(config)) {}
	}

//----------------------------------------------------------------------------//////////////////////////////////

	//	f[^ǂݎ
	::LONG	Reader::QueryValue( wchar_t const* name, ::DWORD type, void* data, ::DWORD& size ) const
	{
		return	Editor_RegQueryValue( hwnd_, key_, config_.empty() ? nullptr : config_.c_str(), name, type, reinterpret_cast<::BYTE*>(data), &size, 0 );
	}

	//	32bitȂǂݎ
	::UINT32	Reader::UInt32( wchar_t const* name, ::UINT32 defaultValue ) const
	{
		::DWORD	value( defaultValue  );
		::DWORD	size(  sizeof(value) );
		return	(QueryValue( name, REG_DWORD, &value, size ) == ERROR_SUCCESS && size == sizeof(value)) ? value : defaultValue;
	}

	//	32bittǂݎ
	::INT32	Reader::Int32( wchar_t const* name, ::INT32 defaultValue ) const
	{
		::DWORD	value( defaultValue  );
		::DWORD	size(  sizeof(value) );
		return	(QueryValue( name, REG_DWORD, &value, size ) == ERROR_SUCCESS && size == sizeof(value)) ? static_cast<::INT32>(value) : defaultValue;
	}

	//	_lǂݎ
	bool	Reader::Bool( wchar_t const* name, bool defaultValue ) const
	{
		return	UInt32( name, defaultValue ? 1u : 0u ) != 0u;
	}

	//	Px_ǂݎ
	float	Reader::Float( wchar_t const* name, float defaultValue ) const
	{
		::INT32 value( UInt32( name, *reinterpret_cast<::UINT32*>(&defaultValue) ) );
		return	*reinterpret_cast<float*>(&value);
	}

	//	ǂݎ
	std::wstring	Reader::String( wchar_t const* name, wchar_t const*	defaultValue ) const
	{
		wchar_t	buf[4096];
		::DWORD	size( sizeof(buf) - sizeof(wchar_t) );
		if( QueryValue( name, REG_SZ, buf, size ) == ERROR_SUCCESS ){
			buf[std::extent<decltype(buf)>::value - 1] = L'\0';
			return	buf;
		}
		return	defaultValue ? defaultValue : L"";
	}

//----------------------------------------------------------------------------//////////////////////////////////

	//	f[^
	::LONG	Writer::SetValue( wchar_t const* name, ::DWORD type, const void* data, ::DWORD size )
	{
		return	Editor_RegSetValue(	hwnd_, key_, config_.empty() ? nullptr : config_.c_str(), name, type, reinterpret_cast<::BYTE const*>(data), size, 0 );
	}

	//	32bitȂ
	bool	Writer::UInt32( wchar_t const* name, ::UINT32 value )
	{
		return	SetValue( name, REG_DWORD, &value, sizeof(::UINT32) ) != ERROR_SUCCESS;
	}

	//	32bitt
	bool	Writer::Int32( wchar_t const* name, ::INT32 value )
	{
		return	SetValue( name, REG_DWORD, &value, sizeof(::INT32) ) != ERROR_SUCCESS;
	}

	//	_l
	bool	Writer::Bool( wchar_t const* name, bool value )
	{
		return	UInt32( name, value ? 1u : 0u );
	}

	//	Px_
	bool	Writer::Float( wchar_t const* name, float value )
	{
		return	UInt32( name, *reinterpret_cast<::UINT32*>(&value) );
	}

	//	񏑂
	bool	Writer::String( wchar_t const* name, wchar_t const* value )
	{
		return	SetValue( name, REG_SZ, value ? value : L"", static_cast<::DWORD>((value ? (std::wcslen(value) + 1) : 1) * sizeof(wchar_t)) ) != ERROR_SUCCESS;
	}

//----------------------------------------------------------------------------//////////////////////////////////
}
