#include "config.h"
#include "smart_color.h"

namespace tools
{
	SmartColor::SmartColor( ::HWND editor ): max_colors_(0)
	{
		//	FL[Ɛ̃e[u	V̏ɂ邱
		static const struct {
			wchar_t const*	name;
			::DWORD			max_colors;
		} colors_info[] = {
			L"Clr14_3",	MAX_SMART_COLOR_V14_3,
			L"Clr14_2",	MAX_SMART_COLOR_V14_2,
			L"Clr14",	MAX_SMART_COLOR_V14,
			L"Clr12",	MAX_SMART_COLOR_V12,
			L"Clr11",	MAX_SMART_COLOR_V11,
			L"Clr3",	MAX_SMART_COLOR_V10,
			L"Clr",		MAX_SMART_COLOR_V9,	
		};

		//	݂̂TA擾
		wchar_t	config_name[MAX_CONFIG_NAME] = {};
		Editor_GetConfigW( editor, config_name );
		for( auto const& inf : colors_info ){
			::DWORD	size(0);
			if( Editor_RegQueryValue( editor, EEREG_CONFIG, config_name, inf.name, REG_BINARY, nullptr, &size, 0 ) == ERROR_SUCCESS && size > 0 ){
				colors_.resize( size / sizeof(::COLORREF) + 1 );
				if( Editor_RegQueryValue( editor, EEREG_CONFIG, config_name, inf.name, REG_BINARY, reinterpret_cast<BYTE*>(&colors_[0]), &size, 0 ) == ERROR_SUCCESS ){
					colors_.resize( size / sizeof(::COLORREF) );
					max_colors_ = inf.max_colors;
					return;
				}
			}
		}
		colors_.clear();
	}

	//	F擾
	::COLORREF	SmartColor::GetForeground( std::size_t smart_color_index ) const
	{
		if( smart_color_index < max_colors_ ){
			if( smart_color_index < colors_.size() ){
				return	colors_[smart_color_index];
			}
		}
		return	DEFAULT_COLOR;
	}

	//	wiF擾
	::COLORREF	SmartColor::GetBackground( std::size_t smart_color_index ) const
	{
		if( smart_color_index < max_colors_ ){
			auto const index( max_colors_ + smart_color_index );
			if( index < colors_.size() ){
				return	colors_[index];
			}
		}
		return	DEFAULT_COLOR;
	}

	//	擾
	int	SmartColor::GetAttribute( std::size_t smart_color_index, int default_attribute ) const
	{
		if( smart_color_index < max_colors_ ){
			auto const index( max_colors_ * 2 + smart_color_index );
			if( index < colors_.size() ){
				return	static_cast<int>(colors_[index]);
			}
		}
		return	default_attribute;
	}

	//	L
	void	OptionalSmartColor::Activate( ::HWND hwnd )
	{
		if(!body_ )
			body_ = new(buffer_) SmartColor( hwnd );
	}

	//	
	void	OptionalSmartColor::Inactivate()
	{
		if( body_ ){
			body_->~SmartColor();
			body_ = nullptr;
		}
	}

}