#pragma once

#include "config.h"
#include <windows.h>
#include <crtdbg.h>
#include <vector>
#include <string>
#include "plugin.h"

namespace tools
{
	//	ݒ肩F擾
	class SmartColor {
	public:
		SmartColor( ::HWND editor );

		//	F擾
		::COLORREF	GetForeground(	std::size_t smart_color_index ) const;
		//	wiF擾
		::COLORREF	GetBackground(	std::size_t smart_color_index ) const;
		//	擾
		int			GetAttribute(	std::size_t smart_color_index, int default_attribute = SMART_COLOR_FONT_NORMAL ) const;

	private:
		std::vector<::COLORREF>	colors_;
		std::size_t				max_colors_;
	};

	//	ݒ肩F擾(xL)
	struct OptionalSmartColor {
	public:
		OptionalSmartColor(): body_(nullptr) {}
		~OptionalSmartColor(){ Inactivate(); }

		//	L
		void	Activate( ::HWND hwnd );
		//	
		void	Inactivate();

		//	L
		operator bool () const { return body_ != 0; }
		//	
		bool operator!() const { return !body_; }

		//	ANZX
		SmartColor const*	operator->() const { return  body_; }
		SmartColor*			operator->()	   { return  body_; }
		SmartColor const&	operator* () const { return *body_; }
		SmartColor&			operator* ()	   { return *body_; }
	private:
		::UINT8		buffer_[sizeof(SmartColor)];
		SmartColor*	body_;
		OptionalSmartColor( OptionalSmartColor&& );
		OptionalSmartColor( OptionalSmartColor const& );
		OptionalSmartColor& operator=( OptionalSmartColor&& );
		OptionalSmartColor& operator=( OptionalSmartColor const& );
	};
}
