#include "config.h"
#include "thread_hook.h"

namespace tools
{
	//	tbNnh
	::HHOOK	ThreadHook::Get() const
	{
		Mutex::Lock lock( mutex_ );
		auto it( hooks_.find( ::GetCurrentThreadId() ) );
		return	(it != hooks_.end()) ? it->second.get() : nullptr;
	}

	//	(tbNȂ)tbN
	int	ThreadHook::Hook( int type, ::LRESULT (CALLBACK *callback)( int code, ::WPARAM wParam, ::LPARAM lParam ) )
	{
		if( callback ){
			Mutex::Lock lock( mutex_ );
			auto const thread_id( ::GetCurrentThreadId() );
			auto it( hooks_.find( thread_id ) );
			if( it != hooks_.end() && it->second ) return -1;

			HookPtr hook( ::SetWindowsHookEx( type, callback, 0, thread_id ) );
			if( hook ){
				hooks_[thread_id] = std::move(hook);
				return	1;
			}
		}
		return	0;
	}

	//	tbNO
	void	ThreadHook::Unhook()
	{
		Mutex::Lock lock( mutex_ );
		auto it( hooks_.find( ::GetCurrentThreadId() ) );
		if( it != hooks_.end() )
			hooks_.erase( it );
	}

	//	ׂẴtbNO
	void	ThreadHook::AllUnhook()
	{
		Mutex::Lock lock( mutex_ );
		hooks_.clear();
	}

}