#pragma once

#include "config.h"
#include "mutex.h"
#include <windows.h>
#include <map>
#include <memory>
#include <type_traits>

namespace tools
{
	//	XbhɃtbN
	class ThreadHook {
	public:
		explicit ThreadHook( Mutex& mutex ): mutex_(mutex) {}
		~ThreadHook(){ AllUnhook(); }

		//	tbNnh
		::HHOOK	Get() const;

		//	(tbNȂ)tbN
		//	result: 1:tbN 0:G[ -1:łɃtbNĂ
		int		Hook( int type, ::LRESULT (CALLBACK *callback)( int code, ::WPARAM wParam, ::LPARAM lParam ) );

		//	tbNO
		void	Unhook();
		//	ׂẴtbNO
		void	AllUnhook();
	private:
		//	tbN폜q
		struct Unhooker {
			void	operator()( ::HHOOK hook ) const
			{
				if( hook ){
					::UnhookWindowsHookEx( hook );
				}
			}
		};
		//	tbN^
		typedef std::unique_ptr<std::remove_pointer<::HHOOK>::type,Unhooker> HookPtr;

		//	rIuWFNgւ̎Q
		Mutex& mutex_;
		//	eXbhւ̃tbNnh
		std::map<::DWORD,HookPtr> hooks_;
	};

}
