#include "config.h"
#include "choice_color.h"
#include <crtdbg.h>
#include "plugin.h"
#include <vector>

namespace tools
{
	//	FI_CAO\
	bool ShowChoiceColor( ::HWND editor, ::HWND parent, ::COLORREF& color )
	{
		//	JX^pbg[h
		::COLORREF	custColors[16];
		::DWORD		size( sizeof(custColors) );
		if( Editor_RegQueryValue( editor, EEREG_COMMON, nullptr, L"CustColors", REG_BINARY, reinterpret_cast<::BYTE*>(&custColors[0]), &size, 0 ) == ERROR_SUCCESS ){
			auto const num( size / sizeof(::COLORREF) );
			if( num < std::extent<decltype(custColors)>::value )
				std::fill( &custColors[num],   std::end(custColors), RGB(255,255,255) );
		}else{
			std::fill( std::begin(custColors), std::end(custColors), RGB(255,255,255) );
		}

		//	FI_CAOJ
		::CHOOSECOLOR cc = {};
		cc.lStructSize	= sizeof(cc);
		cc.hwndOwner	= parent;
		cc.rgbResult	= color;
		cc.lpCustColors	= custColors;
		cc.Flags		= CC_RGBINIT;
		if( ::ChooseColor( &cc ) ){
			color = cc.rgbResult;

			//	JX^pbgZ[u
			Editor_RegSetValue( editor, EEREG_COMMON, nullptr, L"CustColors", REG_BINARY, reinterpret_cast<::BYTE const*>(&custColors[0]), sizeof(custColors), 0 );
			return	true;
		}
		return	false;
	}

}