; Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>

;    -- POINTS OF INTEREST --
;    * Installs either ANSI or UNICODE version depending on OS
;    * Handles deletion errors
;    * Quick and easy to modify for your own plugin

;    -- REQUIREMENTS --
;    * NSIS 2.0 or later
;    * Detect Windows Version NSIS Plugin 0.1 (version.dll) by Denis Gorbunov
;      --> http://nsis.sourceforge.net/archive/nsisweb.php?page=615


!define PLUGIN_NAME              "ColorPicker EmEditor Plugin"
!define PLUGIN_VERSION           "1.1"
!define PLUGIN_SETUP             "..\colorpicker_emeditor_11_setup.exe"
!define PLUGIN_UNINST            "ColorPicker Uninstall.exe"
!define PLUGIN_UNINST_ICON       "$INSTDIR\..\EmEditor.exe"

!define PLUGIN_DIR_DEF           "$PROGRAMFILES\EmEditor\Plugins"
!define PLUGIN_DIR_KEY_ROOT      "HKCU"
!define PLUGIN_DIR_KEY_SUB       "Software\EmSoft\EmEditor v3\Common"
!define PLUGIN_DIR_KEY_NAME      "PlugInsFolder"

!define PLUGIN_PUBLISHER         "HARTWORK PROJECT"
!define PLUGIN_WEBSITE           "http://www.hartwork.org"
!define PLUGIN_UNINST_KEY        "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PLUGIN_NAME}"

SetCompressor lzma


!include "MUI.nsh"

!define MUI_ICON "${NSISDIR}\Source\exehead\nsis.ico"
!define MUI_UNICON "${NSISDIR}\Source\exehead\uninst.ico"

!define MUI_INSTFILESPAGE_PROGRESSBAR  ; Old-school progressbar



; **********************************************************************************
; **  Directory page
; **********************************************************************************

!insertmacro MUI_PAGE_DIRECTORY



; **********************************************************************************
; **  Instfiles page
; **********************************************************************************

!insertmacro MUI_PAGE_INSTFILES



; **********************************************************************************
; **  UNINST Instfile page
; **********************************************************************************

!insertmacro MUI_UNPAGE_INSTFILES


; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS



; **********************************************************************************
; **  General
; **********************************************************************************

Name "${PLUGIN_NAME} ${PLUGIN_VERSION}"
OutFile "${PLUGIN_SETUP}"
InstallDir "${PLUGIN_DIR_DEF}"
BrandingText "${PLUGIN_WEBSITE}  "

InstallDirRegKey "${PLUGIN_DIR_KEY_ROOT}" "${PLUGIN_DIR_KEY_SUB}" "${PLUGIN_DIR_KEY_NAME}"
ShowInstDetails show
ShowUnInstDetails show



; **********************************************************************************
; **  INSTALL
; **********************************************************************************

var SysResult

Section -INSTALL
  SetOutPath "$INSTDIR"

  Version::IsWindowsPlatformNT
  Pop $SysResult
  StrCmp $SysResult "1" SYSTEM_UNICODE
    File "..\Release_ANSI\ColorPicker.dll"
    Goto SYSTEM_DONE

  SYSTEM_UNICODE:
    File "..\Release_UNICODE\ColorPicker.dll"

  SYSTEM_DONE:

  File "ColorPicker Readme.txt"
  WriteUninstaller "$INSTDIR\${PLUGIN_UNINST}"

  WriteRegStr HKLM "${PLUGIN_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr HKLM "${PLUGIN_UNINST_KEY}" "UninstallString" "$INSTDIR\${PLUGIN_UNINST}"
  WriteRegStr HKLM "${PLUGIN_UNINST_KEY}" "DisplayIcon" "${PLUGIN_UNINST_ICON}"
  WriteRegStr HKLM "${PLUGIN_UNINST_KEY}" "DisplayVersion" "${PLUGIN_VERSION}"
  WriteRegStr HKLM "${PLUGIN_UNINST_KEY}" "URLInfoAbout" "${PLUGIN_WEBSITE}"
  WriteRegStr HKLM "${PLUGIN_UNINST_KEY}" "Publisher" "${PLUGIN_PUBLISHER}"

SectionEnd



; **********************************************************************************
; **  UNINST
; **********************************************************************************

Section Uninstall

  TRY_1:
    ClearErrors
    Delete "$INSTDIR\ColorPicker.dll"
    IfErrors 0 +2
      MessageBox MB_ICONEXCLAMATION|MB_RETRYCANCEL|MB_DEFBUTTON1 'Error deleting file:$\n$\t"$INSTDIR\ColorPicker.dll"$\nHit retry to retry deleting this file or$\ncancel to skip this file' IDRETRY TRY_1

  TRY_2:
    ClearErrors
    Delete "$INSTDIR\ColorPicker.ini"
    IfErrors 0 +2
      MessageBox MB_ICONEXCLAMATION|MB_RETRYCANCEL|MB_DEFBUTTON1 'Error deleting file:$\n$\t"$INSTDIR\ColorPicker.ini"$\nHit retry to retry deleting this file or$\ncancel to skip this file' IDRETRY TRY_2

  TRY_3:
    ClearErrors
    Delete "$INSTDIR\ColorPicker Readme.txt"
    IfErrors 0 +2
      MessageBox MB_ICONEXCLAMATION|MB_RETRYCANCEL|MB_DEFBUTTON1 'Error deleting file:$\n$\t"$INSTDIR\ColorPicker Readme.txt"$\nHit retry to retry deleting this file or$\ncancel to skip this file' IDRETRY TRY_3

  TRY_4:
    ClearErrors
    Delete "$INSTDIR\${PLUGIN_UNINST}"
    IfErrors 0 +2
      MessageBox MB_ICONEXCLAMATION|MB_RETRYCANCEL|MB_DEFBUTTON1 'Error deleting file:$\n$\t"$INSTDIR\${PLUGIN_UNINST}"$\nHit retry to retry deleting this file or$\ncancel to skip this file' IDRETRY TRY_4
 
  DeleteRegKey HKLM "${PLUGIN_UNINST_KEY}"

SectionEnd



; **********************************************************************************
; **  UNINST Callbacks
; **********************************************************************************

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
    Abort

FunctionEnd
