

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   ColorPicker EmEditor Plugin 1.01                              *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                        2004-09-28   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#include "stdafx.h"

#include "resource.h"


#define EMEDITOR_API extern "C"


#ifdef _UNICODE
#define Editor_GetSelText( a, b, c ) Editor_GetSelTextW( a, b, c )
#define Editor_InsertString( a, b ) Editor_InsertStringW( a, b )
#else
#define Editor_GetSelText( a, b, c ) Editor_GetSelTextA( a, b, c )
#define Editor_InsertString( a, b ) Editor_InsertStringA( a, b )
#endif



HINSTANCE g_hInstance = NULL;
UINT g_nCmdID = 0;

DEVIL_CONFIG * g_CONFIG = NULL;

UINT g_bActive = true;



/******************************************************************************************************
**  DllMain                                                                                          **
******************************************************************************************************/

bool g_bFirst = true;

BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD dwReason, LPVOID lpReserved )
{
	// Deny running the "other" version
	if( g_bFirst )
	{
		g_bFirst = false;

		// ANSI code that runs on both
		OSVERSIONINFOA osvi;
		osvi.dwOSVersionInfoSize = sizeof( OSVERSIONINFOA );
		GetVersionExA( &osvi );

		if(
			( sizeof( TCHAR ) == sizeof( wchar_t ) ) ^				// UNICODE compile?
			( osvi.dwPlatformId == VER_PLATFORM_WIN32_NT )			// UNICODE system?
		)
		{
			// Mismatch -> Deny loading
			return FALSE;
		}
	}

    if( dwReason == DLL_PROCESS_ATTACH )
	{
		g_hInstance = hModule;
	}

	return TRUE;
}


/******************************************************************************************************
**  OnCommand                                                                                    @1  **
******************************************************************************************************/

EMEDITOR_API void OnCommand( HWND hwnd )
{
	static COLORREF custom[ 16 ];
	static COLORREF custom_OLD[ 16 ];
	COLORREF last;

	COLORREF incol = 0;
	bool bIncolValid = false;



	// Custom colors
	UINT u = 16;
	while( u-- )
	{
		TCHAR sz[ 9 ];
		wsprintf( sz, _T( "Color_%u" ), u );
		g_CONFIG->Read( sz, ( int * )( custom + u ), GetSysColor( COLOR_3DFACE ) );
	}
	memcpy( custom_OLD, custom, 16 * sizeof( COLORREF ) );

	// Last color
	g_CONFIG->Read( _T( "Color_Last" ), ( int * )&last, RGB( 255, 0, 0 ) );


	UINT uLen = Editor_GetSelText( hwnd, 0, NULL );
	if( uLen == 7 )		// 6 hex plus \0
	{
		TCHAR * in = new TCHAR[ uLen ];
		Editor_GetSelText( hwnd, uLen, in );


		// Valid color?
		bIncolValid = true;
		for( UINT u = 0; u < 6; u++ )
		{
			TCHAR ch = *( in + u );

			if(
				( ch >= _T( '0' ) ) &&
				( ch <= _T( '9' ) )
			)
			{
				incol +=	( ch - _T( '0' ) +  0 )
								<< ( ( ( ( u >> 1 ) << 1 ) + ( ( u + 1 ) & 1 ) ) << 2 );
			}
			else if(
				( ch >= _T( 'A' ) ) &&
				( ch <= _T( 'F' ) )
			)
			{
				incol +=	( ch - _T( 'A' ) + 10 )
								<< ( ( ( ( u >> 1 ) << 1 ) + ( ( u + 1 ) & 1 ) ) << 2 );
			}
			else if(
				( ch >= _T( 'a' ) ) &&
				( ch <= _T( 'f' ) )
			)
			{
				incol +=	( ch - _T( 'a' ) + 10 )
								<< ( ( ( ( u >> 1 ) << 1 ) + ( ( u + 1 ) & 1 ) ) << 2 );
			}
			else
			{
				bIncolValid = false;

				break;
			}
		}
	}



	CHOOSECOLOR cc;
	cc.lStructSize		= sizeof( CHOOSECOLOR );
	cc.hwndOwner		= GetParent( hwnd );
	cc.hInstance		= NULL;
	cc.rgbResult		= ( bIncolValid ? incol : last );
	cc.lpCustColors		= custom;
	cc.Flags			= CC_ANYCOLOR | CC_FULLOPEN | CC_RGBINIT;
	cc.lCustData		= NULL;
	cc.lpfnHook			= NULL;
	cc.lpTemplateName	= NULL;

	if( ChooseColor( &cc ) )
	{
		// 0x00bbggrr
		TCHAR out[ 7 ];
		TCHAR red[ 3 ];
		TCHAR green[ 3 ];
		TCHAR blue[ 3 ];

		_itot( GetRValue( cc.rgbResult ), red, 16 );
		_itot( GetGValue( cc.rgbResult ), green, 16 );
		_itot( GetBValue( cc.rgbResult ), blue, 16 );


		// RED
		if( red[ 1 ] == _T( '\0' ) )
		{
			out[ 0 ] = _T( '0' );
			out[ 1 ] = red[ 0 ];
		}
		else
		{
			out[ 0 ] = red[ 0 ];
			out[ 1 ] = red[ 1 ];
		}


		// GREEN
		if( green[ 1 ] == _T( '\0' ) )
		{
			out[ 2 ] = _T( '0' );
			out[ 3 ] = green[ 0 ];
		}
		else
		{
			out[ 2 ] = green[ 0 ];
			out[ 3 ] = green[ 1 ];
		}


		// BLUE
		if( blue[ 1 ] == _T( '\0' ) )
		{
			out[ 4 ] = _T( '0' );
			out[ 5 ] = blue[ 0 ];
		}
		else
		{
			out[ 4 ] = blue[ 0 ];
			out[ 5 ] = blue[ 1 ];
		}


		out[ 6 ] = _T( '\0' );


		// Custom colors
		UINT u = 16;
		TCHAR sz[ 9 ];
		while( u-- )
		{
			if( custom[ u ] != custom_OLD[ u ] )
			{
				wsprintf( sz, _T( "Color_%u" ), u );
				g_CONFIG->Write( sz, ( int )custom[ u ] );
			}
		}

		// Last color
		if( cc.rgbResult != last )
		{
			g_CONFIG->Write( _T( "Color_Last" ), ( int )cc.rgbResult );
		}


		// Process text
		UINT uLen = Editor_GetSelText( hwnd, 0, NULL );
		if( uLen > 1 )
		{
			// Replace selection
			SendMessage( hwnd, EM_REPLACESEL, TRUE, ( LPARAM )out );
		}
		else
		{
			// Insert at caret
			Editor_InsertString( hwnd, out );
		}
	}
}


/******************************************************************************************************
**  QueryStatus                                                                                  @2  **
******************************************************************************************************/

EMEDITOR_API BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	*pbChecked = FALSE;
	BOOL bReadOnly;
	Editor_QueryStatus( hwnd, EEID_READ_ONLY, &bReadOnly );
	return !bReadOnly;
}


/******************************************************************************************************
**  OnEvents                                                                                     @3  **
******************************************************************************************************/

EMEDITOR_API void OnEvents( HWND hwnd, UINT uEvent, LPARAM lp )
{
	if( uEvent & EVENT_CREATE )
	{
		g_nCmdID = ( UINT )LOWORD( lp );
	}
}


/******************************************************************************************************
**  GetMenuTextID                                                                                @4  **
******************************************************************************************************/

EMEDITOR_API UINT GetMenuTextID()
{
	return IDS_MENU_TEXT;
}


/******************************************************************************************************
**  GetStatusMessageID                                                                           @5  **
******************************************************************************************************/

EMEDITOR_API UINT GetStatusMessageID()
{
	return IDS_STATUS_MESSAGE;
}


/******************************************************************************************************
**  GetBitmapID                                                                                  @6  **
******************************************************************************************************/

EMEDITOR_API UINT GetBitmapID()
{
	return IDB_16164_DEFAULT;
}


/******************************************************************************************************
**  PlugInProc                                                                                   @7  **
******************************************************************************************************/

bool g_bDoInit = true;

EMEDITOR_API LRESULT PlugInProc( HWND hwnd, UINT message, WPARAM wp, LPARAM lp )
{
	if( g_bDoInit )
	{
		g_CONFIG = new DEVIL_CONFIG( _T( "ColorPicker" ), g_hInstance );

		g_bDoInit = false;
	}

	LRESULT res = 0;

	switch( message )
	{
		case EP_QUERY_PROPERTIES:
		{
			res = FALSE;
		
			break;
		}
/*
		case EP_SET_PROPERTIES:
		{
			res = FALSE;

			break;
		}
*/
		case EP_GET_NAME:
		{
			TCHAR szAppName[ 80 ];
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			res = lstrlen( szAppName ) + 1;
			if( lp != NULL )
			{
				lstrcpyn( ( TCHAR * )lp, szAppName, wp );
			}
		
			break;
		}
		case EP_GET_VERSION:
		{

			TCHAR sz[ 80 ];
			LoadString( g_hInstance, IDS_VERSION, sz, sizeof( sz ) / sizeof( TCHAR ) );
			res = lstrlen( sz ) + 1;
			if( lp != NULL )
			{
				lstrcpyn( ( TCHAR * )lp, sz, wp );
			}

			break;
		}
		case EP_GET_BITMAP:
		{
			if( wp & BITMAP_LARGE )
			{
				if( wp & ( BITMAP_256_COLOR | BITMAP_24BIT_COLOR ) )
				{
					if( wp & BITMAP_DISABLED )
					{
						res = IDB_24248_GRAY;
					}
					else
					{
						res = IDB_24248_DEFAULT;
					}
				}
				else
				{
					res = IDB_24244_DEFAULT;
				}
			}
			else
			{
				if( wp & ( BITMAP_256_COLOR | BITMAP_24BIT_COLOR ) )
				{
					if( wp & BITMAP_DISABLED )
					{
						res = IDB_16168_GRAY;
					}
					else
					{
						res = IDB_16168_DEFAULT;
					}
				}
				else
				{
					res = IDB_16164_DEFAULT;
				}
			}

			break;
		}
		case EP_GET_MASK:
		{
			res = RGB( 192, 192, 192 );
		
			break;
		}
		case EP_QUERY_UNINSTALL:
		{
			res = TRUE;		// TRUE to allow
			
			break;
		}
		case EP_SET_UNINSTALL:
		{
			TCHAR sz[ 160 ];
			TCHAR szFormat[ 80 ];
			TCHAR szAppName[ 80 ];
			LoadString( g_hInstance, IDS_SURE_TO_UNINSTALL, szFormat, sizeof( szFormat ) / sizeof( TCHAR ) );
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			wsprintf( sz, szFormat, szAppName );
			if( MessageBox( hwnd, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES )
			{
				res = TRUE;
			}
		
			break;
		}
	}

	return res;
}
