#pragma once


#ifdef SIMP
#define IDS_MENU_TEXT IDS_MENU_TEXT_S
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_S
#define LCMAP_FLAG LCMAP_SIMPLIFIED_CHINESE
#else
#define IDS_MENU_TEXT IDS_MENU_TEXT_T
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_T
#define LCMAP_FLAG LCMAP_TRADITIONAL_CHINESE
#endif

class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	int g_nMode;
	int g_nCmdID;

	CMyFrame()
	{
		g_nMode = 0;
		g_nCmdID = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
#ifndef _WIN64
		OSVERSIONINFO osvi;
		ZeroMemory( &osvi, sizeof( osvi ) );
		osvi.dwOSVersionInfoSize = sizeof( osvi );
		GetVersionEx( &osvi );
		bool bUnicode = (osvi.dwPlatformId == VER_PLATFORM_WIN32_NT);
		if( !bUnicode ){
			TCHAR sz[256], szAppName[80];
			LoadString( EEGetInstanceHandle(), IDS_NT_ONLY, sz, _countof( sz ) );
			LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			MessageBox( hwndView, sz, szAppName, MB_OK | MB_ICONSTOP );
			return;
		}
#endif

		UINT_PTR nSize = (UINT_PTR)Editor_GetSelTextW( hwndView, 0, NULL );
		if( nSize <= 1 )  return;
		LPWSTR pszText = new WCHAR [ nSize ];
		if( pszText == NULL )  return;
		Editor_GetSelTextW( hwndView, nSize, pszText );
		int nDestSize = LCMapStringW( 0, LCMAP_FLAG, pszText, -1, NULL, 0 );
		if( nDestSize > 0 ){
			LPWSTR pszDestText = new WCHAR [nDestSize];
			if( pszDestText != NULL ){
				if( LCMapStringW( 0, LCMAP_FLAG, pszText, -1, pszDestText, nDestSize ) ){
					Editor_ExecCommand( hwndView, EEID_DELETE );
					Editor_InsertStringW( hwndView, pszDestText );
				}
				delete [] pszDestText;
			}
		}
		delete pszText;
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_CREATE ){
			g_nCmdID = (UINT)nEvent;
		}
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, g_nCmdID );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	BOOL SetProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	// user defined methods below.

};


// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT


