

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   CopyOnSelect EmEditor Plugin 1.12                             *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                        2004-09-28   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#include "stdafx.h"

#include "resource.h"


#define EMEDITOR_API extern "C"


#ifdef _UNICODE
#define Editor_GetSelText( a, b, c ) Editor_GetSelTextW( a, b, c )
#else
#define Editor_GetSelText( a, b, c ) Editor_GetSelTextA( a, b, c )
#endif



HINSTANCE g_hInstance = NULL;
UINT g_nCmdID = 0;

DEVIL_CONFIG * g_CONFIG = NULL;

UINT g_bActive = true;



/******************************************************************************************************
**  DllMain                                                                                          **
******************************************************************************************************/

bool g_bFirst = true;

BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD dwReason, LPVOID lpReserved )
{
	// Deny running the "other" version
	if( g_bFirst )
	{
		g_bFirst = false;

		// ANSI code that runs on both
		OSVERSIONINFOA osvi;
		osvi.dwOSVersionInfoSize = sizeof( OSVERSIONINFOA );
		GetVersionExA( &osvi );

		if(
			( sizeof( TCHAR ) == sizeof( wchar_t ) ) ^				// UNICODE compile?
			( osvi.dwPlatformId == VER_PLATFORM_WIN32_NT )			// UNICODE system?
		)
		{
			// Mismatch -> Deny loading
			return FALSE;
		}
	}

    if( dwReason == DLL_PROCESS_ATTACH )
	{
		g_hInstance = hModule;
	}

	return TRUE;
}


/******************************************************************************************************
**  OnCommand                                                                                    @1  **
******************************************************************************************************/

EMEDITOR_API void OnCommand( HWND hwnd )
{
	g_bActive = !g_bActive;
	g_CONFIG->Write( _T( "Active" ), ( int )g_bActive );

	Editor_UpdateToolbar( hwnd, g_nCmdID );
}


/******************************************************************************************************
**  QueryStatus                                                                                  @2  **
******************************************************************************************************/

EMEDITOR_API BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	*pbChecked = ( g_bActive ? TRUE : FALSE );
	return TRUE;
}


/******************************************************************************************************
**  OnEvents                                                                                     @3  **
******************************************************************************************************/

EMEDITOR_API void OnEvents( HWND hwnd, UINT uEvent, LPARAM lp )
{
	if( uEvent & EVENT_CREATE )
	{
		g_nCmdID = ( UINT )LOWORD( lp );
	}

	if( g_bActive && ( uEvent & EVENT_SEL_CHANGED ) )
	{
		UINT uLen = Editor_GetSelText( hwnd, 0, NULL );
		if( uLen > 1 )
		{
			SendMessage( hwnd, WM_COPY, 0, 0 );	
		}
	}
}


/******************************************************************************************************
**  GetMenuTextID                                                                                @4  **
******************************************************************************************************/

EMEDITOR_API UINT GetMenuTextID()
{
	return IDS_MENU_TEXT;
}


/******************************************************************************************************
**  GetStatusMessageID                                                                           @5  **
******************************************************************************************************/

EMEDITOR_API UINT GetStatusMessageID()
{
	return IDS_STATUS_MESSAGE;
}


/******************************************************************************************************
**  GetBitmapID                                                                                  @6  **
******************************************************************************************************/

EMEDITOR_API UINT GetBitmapID()
{
	return IDB_16164_DEFAULT;
}


/******************************************************************************************************
**  PlugInProc                                                                                   @7  **
******************************************************************************************************/

bool g_bDoInit = true;

EMEDITOR_API LRESULT PlugInProc( HWND hwnd, UINT message, WPARAM wp, LPARAM lp )
{
	if( g_bDoInit )
	{
		g_CONFIG = new DEVIL_CONFIG( _T( "CopyOnSelect" ), g_hInstance );
		g_CONFIG->Read( _T( "Active" ), ( int * )&g_bActive, 1 );

		g_bDoInit = false;
	}

	LRESULT res = 0;

	switch( message )
	{
		case EP_QUERY_PROPERTIES:
		{
			res = FALSE;
		
			break;
		}
/*
		case EP_SET_PROPERTIES:
		{
			res = FALSE;

			break;
		}
*/
		case EP_GET_NAME:
		{
			TCHAR szAppName[ 80 ];
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			res = lstrlen( szAppName ) + 1;
			if( lp != NULL )
			{
				lstrcpyn( ( TCHAR * )lp, szAppName, wp );
			}
		
			break;
		}
		case EP_GET_VERSION:
		{

			TCHAR sz[ 80 ];
			LoadString( g_hInstance, IDS_VERSION, sz, sizeof( sz ) / sizeof( TCHAR ) );
			res = lstrlen( sz ) + 1;
			if( lp != NULL )
			{
				lstrcpyn( ( TCHAR * )lp, sz, wp );
			}

			break;
		}
		case EP_GET_BITMAP:
		{
			if( wp & BITMAP_LARGE )
			{
				if( wp & ( BITMAP_256_COLOR | BITMAP_24BIT_COLOR ) )
				{
					res = IDB_24248_DEFAULT;
				}
				else
				{
					res = IDB_24244_DEFAULT;
				}
			}
			else
			{
				if( wp & ( BITMAP_256_COLOR | BITMAP_24BIT_COLOR ) )
				{
					res = IDB_16168_DEFAULT;
				}
				else
				{
					res = IDB_16164_DEFAULT;
				}
			}
			break;
		}
		case EP_GET_MASK:
		{
			res = RGB( 255, 0, 255 );
		
			break;
		}
		case EP_QUERY_UNINSTALL:
		{
			res = TRUE;		// TRUE to allow
			
			break;
		}
		case EP_SET_UNINSTALL:
		{
			TCHAR sz[ 160 ];
			TCHAR szFormat[ 80 ];
			TCHAR szAppName[ 80 ];
			LoadString( g_hInstance, IDS_SURE_TO_UNINSTALL, szFormat, sizeof( szFormat ) / sizeof( TCHAR ) );
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			wsprintf( sz, szFormat, szAppName );
			if( MessageBox( hwnd, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES )
			{
				res = TRUE;
			}
		
			break;
		}
	}

	return res;
}
