

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   DEVIL Screensaver System 1.012                                *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                                     *
    *                                                                 *
    *   Contact me for custom licenses.                  2004-09-22   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#ifndef __DEVIL_CONFIG_H__
#define __DEVIL_CONFIG_H__



#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <tchar.h>



class DEVIL_CONFIG
{
private:
	TCHAR * szInipath;
	TCHAR * szSection;
	Init( const TCHAR * szCopySection, HMODULE hMod );

public:
	DEVIL_CONFIG( HMODULE hMod = NULL );
	DEVIL_CONFIG( const TCHAR * szCopySection, HMODULE hMod = NULL );
	~DEVIL_CONFIG();

	bool Write( const TCHAR * szKey, const double fValue );
	bool Write( const TCHAR * szKey, const int iValue );
	bool Write( const TCHAR * szKey, const TCHAR * szText );

	bool Read( const TCHAR * szKey, double * fOut, const double fDefault );
	bool Read( const TCHAR * szKey, int * iOut, const int iDefault );
	bool Read( const TCHAR * szKey, TCHAR * szOut, const TCHAR * szDefault, UINT uSize = 256 );

	void get_inipath( TCHAR * szOut, UINT uSize = 256 );
};



#endif // __DEVIL_CONFIG_H__