// EmEditor Plug-In definition file
// v3.08 (6 Jan 2001)   CCustomizeInfo::m_bIgnoreColorPrint, CCustomizeInfo::m_bNoFullPathIfNotActive added.
// v3.12 (16 Jan 2001)  EEID_ALL_PROP added.
//                      CCustomizeInfo::m_abUrlChar is now BYTE, not bool.  =2 means not permitted at end of URL.
// v3.13 (15 Mar 2001)  EEID_NEW_PASTE_PREFIX, EEID_NEW_PASTE_PREFIX_RETURN, EEID_CUSTOMIZE_TRAY,
//                      EEID_INSERT_CR_LF, EEID_MRU_FONT1 added.
//                      CCustomizeInfo::m_bSaveOverwrite, CCustomizeInfo::m_bNoChangeCrLf,
//                      CCustomizeInfo::m_bShowSpace, CCustomizeInfo::m_bWordWrapMark added.
//                      EI_IS_PROPORTIONAL_FONT added.
// v3.14 (23 Apr 2001)  CCustomizeInfo::m_bPrintSeparatingLines, CCustomizeInfo::m_bSameFontPrint,
//                      CCustomizeInfo::m_bHiliteCorresParen added.
//                      EEID_DELETE_RIGHT_WORD, EEID_NEXT_PAREN, EEID_SHIFT_NEXT_PAREN added.
//                      CHECK_FILE_CHANGED_EXCLUSIVE added.
// v3.15 (22 May 2001)  CCustomizeInfo::m_bDetectUTF8, CCustomizeInfo::m_bDetectCharset,
//                      CCustomizeInfo::m_bDetectAll, CCustomizeInfo::m_bDeleteSpaceEnd,
//                      CCustomizeInfo::m_bSaveAsEntity, CCustomizeInfo::m_bShowControl added.
//                      Changed LOAD_FILE_INFO structure.
//                      CHARSET_OEM added.
//                      EEID_CHARSET_OEM, EEID_TRIM_RIGHT added.
//                      CODEPAGE_DETECT_UTF8, CODEPAGE_DETECT_CHARSET, CODEPAGE_DETECT_ALL added.
// v3.16 (21 Jun 2001)  EEID_FILE_RELOAD_DETECT_ALL added.
//                      SMART_COLOR_ constants redefined.
//                      CColorInfo class redefined.
//                      CCustomizeInfo::m_nHiliteTag, m_nHiliteMultiComment removed.
//                      CCustomizeInfo::m_nSpecialSyntax, m_chEscape, m_bPasteAnsi, m_bQuoteType,
//                      m_szScriptBegin, m_szScriptEnd, m_szLineComment1, m_szLineComment2 added.
// v3.17 (25 Jul 2001)  EEID_DELETE_LEFT_WORD, EEID_FILE_NEW_CONFIG,
//                      EEID_NEW_CONFIG_POPUP, EEID_FONT_POPUP added.
//                      CCustomizeInfo::m_bSaveAsNameEntity, m_chIndentBegin, m_bNewTemplate,
//                      m_chIndentEnd, m_chEndOfStatement added.
// v3.18 (29 Aug 2001)  EEID_RELOAD_POPUP, EEID_DELETE_PANES added.
//                      MAX_RECENT_FILE defined.
// v3.19 (1 Oct 2001)   EVENT_CHAR added.
//                      EEID_SHOW_PLUGINS_BAR added.
//                      SIGNATURE_PIB_LIST is superseded by SIGNATURE_PIB_LIST_2.
// v3.20 (21 Nov 2001)  EP_GET_BITMAP, EP_GET_MASK added.
// v3.22 (2 Jan 2002)   EEID_PRINT_PREVIEW, EEID_WINDOW_TOP, EEID_WINDOW_BOTTOM,
//                      EEID_WINDOW_RIGHT, EEID_WINDOW_LEFT, EEID_HOME_TEXT, EEID_SHIFT_HOME_TEXT,
//                      EEID_KEYBOARD_MAP added.
// v3.23 (31 Jan 2002)  EEID_WINDOW_SPLIT_HORZ, EEID_WINDOW_SPLIT_VERT
//                      EEID_CONTEXT_MENU, EEID_DELETE_LEFT_LINE,
//                      EEID_INSERT_GRAVE, EEID_INSERT_ACUTE, EEID_INSERT_CIRCUMFLEX, EEID_INSERT_TILDE,
//                      EEID_INSERT_DIAERESIS, EEID_INSERT_RING_ABOVE, EEID_INSERT_LIGATURE, EEID_INSERT_CEDILLA,
//                      EEID_INSERT_STROKE, EEID_INSERT_INVERTED_QUESTION, EEID_INSERT_INVERTED_EXCLAMATION, 
//                      EEID_INSERT_COPYRIGHT, EEID_INSERT_REGISTERED, EEID_INSERT_TRADEMARK, EEID_INSERT_EURO added.
// v3.24 (10 Feb 2002)  EVENT_FILE_OPENED event added. EEID_WRAP_BY_PAPER added.
// v3.28 ( 1 Oct 2002)  FLAG_FIND_REG_EXP and FLAG_FIND_CLOSE added.
// v3.29 ( 6 Nov 2002)  EEID_SHOW_TOOLS_BAR, EEID_BOOKMARK_TOGGLE, EEID_BOOKMARK_NEXT, EEID_BOOKMARK_PREV,
//                      EEID_BOOKMARK_CLEAR, EEID_CUSTOMIZE_TOOLS, EEID_TOOL1 added.
// v3.31 (17 Dec 2002)  EEID_RETRIEVE_FIND_TEXT, EEID_COPY_FILE_PATH, EEID_COPY_FILE_DIR, EEID_DUPLICATE_LINE,
//                      EEID_LOAD_WORKSPACE, EEID_SAVE_WORKSPACE, EEID_SAVE_WORKSPACE_EXIT_ALL, EEID_SAVE_WORKSPACE_QUIT_ALL,
//                      EEID_LOGICAL_HOME_TEXT, EEID_SHIFT_LOGICAL_HOME_TEXT, EEID_WINDOW_SPLIT_HORZ_FIX, EEID_WINDOW_SPLIT_VERT_FIX,
//                      EEID_SHOW_WINDOWS_BAR added.
//                      CCustomizeInfo::m_bShowScrollOnlyActive, CCustomizeInfo::m_bWrapPagePrint added.
//                      EI_GET_NEXT_BOOKMARK added.
// v3.32 (25 Jan 2003)  CCustomizeInfo::m_nMaxFindHilite added. CColorInfo structure removed.
//
// v4.00 (18 Dec 2003)  EE_SET_SEL_TYPE, EE_GET_STATUSA, EE_GET_STATUSW, EE_INSERT_FILEA, EE_INSERT_FILEW added.
//                      EE_INSERT_STRINGA, EE_INSERT_STRINGW extended to use lParam.
//                      EE_GET_VERSION extended to use wParam.
//                      Editor_GetVersionEx, VERSION_PRO, VERSION_STD added.
//                      EI_GET_HILITE_FIND, EI_SET_HILITE_FIND, EI_GET_APP_VERSIONA, EI_GET_APP_VERSIONW, EI_GET_READ_ONLY, 
//                      EI_IS_WINDOW_COMBINED, EI_WINDOW_COMBINE added.
//                      EEID_SHOW_BAR_TITLE, EEID_LOCK_TOOLBARS, EEID_WINDOW_COMBINE, EEID_WINDOW_ALWAYS_TOP_ON, EEID_WINDOW_ALWAYS_TOP_OFF, EEID_MOVE_LAST_EDIT,
//                      EEID_MACRO_SAVE, EEID_MACRO_SELECT, EEID_MACRO_EDIT, EEID_MACRO_SELECT_THIS, EEID_CUSTOMIZE_MACRO, EEID_BOOKMARK_NEXT_WITHIN, 
//                      EEID_BOOKMARK_PREV_WITHIN, EEID_BOOKMARK_SET, EEID_BOOKMARK_RESET, EEID_SPACE_TO_TAB, EEID_TABIFY, EEID_UNTABIFY, EEID_INDENT,
//                      EEID_UNINDENT, EEID_MACRO_HELP, EEID_MACRO_HELP_WORD, EEID_REPLACE_IN_FILES, EEID_QUIT_ALL, EEID_MACRO_RUN_OPTIONS, EEID_INSERT_CARON,
//                      EEID_VIEW_MARKS, EEID_EDIT_COMMENT, EEID_EDIT_UNCOMMENT, EEID_INCREASE_FONT_SIZE, EEID_DECREASE_FONT_SIZE added.
// v4.01 (27 Dec 2003)  EI_IS_UNDO_COMBINED added.
//                      EEID_FIND_NEXT_UNICODE, EEID_FIND_PREV_UNICODE, EEID_ERASE_UNICODE_HILITE added.
// v4.02 (30 Jan 2004)  EE_FIND_IN_FILES, EE_REPLACE_IN_FILES added.
// v4.03 (25 Feb 2004)  EE_GET_ANCHOR_POS, EE_SET_ANCHOR_POS added.  EE_SET_CARET_POS extended.

#pragma once

#ifndef CLR_NONE
#define CLR_NONE                0xFFFFFFFFL
#endif

#define REG_VERSION             3

#define SPECIAL_SYNTAX_NONE 0
#define SPECIAL_SYNTAX_HTML 1
#define SPECIAL_SYNTAX_HTML_EMBEDDED 2

#define MAX_FIND_HISTORY 32
#define MIN_RECENT_FILE 0
#define MAX_RECENT_FILE 64
#define DEF_RECENT_FILE 8

#define DEFAULT_COLOR   (ULONG_MAX-1)

#define SIGNATURE_FACE_LIST         0x00FF0000
#define SIGNATURE_HILITE_LIST       0x00FF0100
#define SIGNATURE_FIND_LIST         0x00FF0200
#define SIGNATURE_PIK_LIST          0x00FF0300
#define SIGNATURE_PIB_LIST_2        0x00FF0401
#define SIGNATURE_ASSOCIATE_LIST    0x00FF0500
#define SIGNATURE_CODEPAGE_LIST_2   0x00FF0601
#define SIGNATURE_MENU_LIST         0x00FF0700
#define SIGNATURE_TOOL_LIST         0x00FF0800
#define SIGNATURE_PIK_T_LIST        0x00FF0900
#define SIGNATURE_WORKSPACE_LISTW   0x00FF0A00
#define SIGNATURE_WORKSPACE_LISTA   0x00FF0A01
#define SIGNATURE_WORKSPACE_LISTW_2 0x00FF0A02
#define SIGNATURE_WORKSPACE_LISTA_2 0x00FF0A03
#define SIGNATURE_PIK_M_LIST        0x00FF0B00

#define MAX_CODEPAGE_NAME 80

#define CHARSET_DEFAULT             0
#define CHARSET_ARABIC              1
#define CHARSET_BALTIC              2
#define CHARSET_CENTRAL_EUROPE      3
#define CHARSET_CHINESE_SIMPLIFIED  4
#define CHARSET_CHINESE_TRADITIONAL 5
#define CHARSET_CYRILLIC            6
#define CHARSET_GREEK               7
#define CHARSET_HEBREW              8
#define CHARSET_JAPANESE            9
#define CHARSET_KOREAN              10
#define CHARSET_THAI                11
#define CHARSET_TURKISH             12
#define CHARSET_VIETNAMESE          13
#define CHARSET_WESTERN_EUROPE      14
#define CHARSET_OEM                 15
#define CHARSET_RESERVED_4          16
#define CHARSET_RESERVED_3          17
#define CHARSET_RESERVED_2          18
#define CHARSET_RESERVED_1          19
#define MAX_CHARSET                 20
#define MAX_USED_CHARSET            16

#define CODEPAGE_ANSI               65536
#define CODEPAGE_UNICODE            65537
#define CODEPAGE_UNICODE_BIGENDIAN  65538
#define CODEPAGE_UTF8               65001
#define CODEPAGE_UTF7               65000

#define CODEPAGE_ANSI_FIRST         4
#define CODEPAGE_ANSI_LAST          64999

#define CODEPAGE_932                932     // Japanese Shift-JIS
#define CODEPAGE_JIS                65616   // Japanese JIS
#define CODEPAGE_EUC                65617   // Japanese EUC

#define CODEPAGE_DETECT_UNICODE     0x00020000
#define CODEPAGE_DETECT_UTF8        0x00040000  // v3.15
#define CODEPAGE_DETECT_CHARSET     0x00080000  // v3.15
#define CODEPAGE_DETECT_ALL         0x00100000  // v3.15
#define CODEPAGE_MASK               0x0001ffff

#define CODEPAGE_AUTO_SJIS_JIS      66049  // (default read for Japanese version)
#define CODEPAGE_AUTO_SJIS_JIS_EUC  66050  // read only

#define CODEPAGE_UNKNOWN            66304  // internal use only
#define CODEPAGE_MAYBE_EUC          66305  // internal use only
#define CODEPAGE_CONFIG             66307  // internal use only

#define DEF_UNDO_BUFFER_SIZE    100000
#define MIN_UNDO_BUFFER_SIZE    10
#define MAX_UNDO_BUFFER_SIZE    0x0aaaaaa9
#define MAX_PLUG_IN_NAME        80
#define MAX_FILTER_LENGTH       256
#define MAX_CONFIG_NAME         260
#define MAX_ASSOCIATE_LENGTH    16

#define MAX_HEADER              116  // was 128 before v3.16
#define MAX_FOOTER              116  // was 128 before v3.16
#define MAX_KINSOKU_BEGIN       128
#define MAX_KINSOKU_END         128
#define MAX_MULTI_COMMENT_BEGIN 16
#define MAX_MULTI_COMMENT_END   16
#define MAX_LINE_COMMENT        4  // v3.16
#define MAX_SCRIPT_BEGIN        8  // v3.16
#define MAX_SCRIPT_END          8  // v3.16
#define MAX_PREFIX_LENGTH       80
#define MAX_FILE_FILTER         128
#define MAX_DEF_EXT             128
#define MAX_PREFIX_LIST         40


#define SMART_COLOR_NONE      (-1)
#define SMART_COLOR_NORMAL      0
#define SMART_COLOR_SEL         1
#define SMART_COLOR_CURLINE     2
#define SMART_COLOR_QUOTE       3
#define SMART_COLOR_FIND        4
#define SMART_COLOR_LINK_URL    5
#define SMART_COLOR_LINK_ID     6
#define SMART_COLOR_LINK_TAG    7
#define SMART_COLOR_SINGLE_QUOTES   8
#define SMART_COLOR_DOUBLE_QUOTES   9
#define SMART_COLOR_COMMENT     10
#define SMART_COLOR_SCRIPT      11
#define SMART_COLOR_BRACES      12
#define SMART_COLOR_IN_TAG      13
#define SMART_COLOR_HILITE_1    14
#define SMART_COLOR_HILITE_2    15
#define SMART_COLOR_HILITE_3    16
#define SMART_COLOR_HILITE_4    17
#define SMART_COLOR_HILITE_5    18
#define SMART_COLOR_HILITE_6    19
#define SMART_COLOR_HILITE_7    20
#define SMART_COLOR_HILITE_8    21
#define SMART_COLOR_HILITE_9    22
#define SMART_COLOR_HILITE_10   23
#define SMART_COLOR_RETURN      24
#define SMART_COLOR_LINE        25
#define SMART_COLOR_PAGE_LINE   26
#define SMART_COLOR_LINE_NUMBER 27
#define SMART_COLOR_RULER       28
#define SMART_COLOR_OUTSIDE     29
#define MAX_SMART_COLOR         30
#ifndef UNICODE
#define SMART_COLOR_NON_UNICODE 0x40
#define SMART_COLOR_MASK        0x3f
#endif

#define SMART_COLOR_FONT_NORMAL     0
#define SMART_COLOR_FONT_UNDERLINE  1
#define SMART_COLOR_FONT_BOLD       2
#define SMART_COLOR_FONT_ITALIC     3

#define QUOTE_NONE              0
#define QUOTE_SINGLE            1
#define QUOTE_DOUBLE            2
#define QUOTE_BOTH              3
#define QUOTE_CONTINUE          4

#define EVENT_SEL_CHANGED       0x00000010
#define EVENT_CARET_MOVED       0x00000020
#define EVENT_MODIFIED          0x00000040
#define EVENT_SCROLL            0x00000080
#define EVENT_CONFIG_CHANGED    0x00000100
#define EVENT_CHANGE            0x00000200
#define EVENT_CREATE            0x00000400
#define EVENT_CLOSE             0x00000800
#define EVENT_KILL_FOCUS        0x00001000
#define EVENT_SET_FOCUS         0x00002000
#define EVENT_CHAR              0x00004000
#define EVENT_FILE_OPENED       0x00008000

#define EE_FIRST                (WM_USER+0x400)
#define EE_GET_CMD_ID           (EE_FIRST+0)
  // (HINSTANCE)lParam = hInstance
  // returns (UINT)nCmdID

#define Editor_GetCmdID( hwnd, hInstance ) \
    (UINT)SNDMSG( (hwnd), EE_GET_CMD_ID, 0, (LPARAM)(HINSTANCE)(hInstance) )

#define EE_QUERY_STATUS         (EE_FIRST+1)
  // (UINT)wParam = nCmdID, (BOOL*)lParam = &amp;bChecked
  // returns (BOOL)bEnabled

#define Editor_QueryStatus( hwnd, nCmdID, pbChecked ) \
    (BOOL)SNDMSG( (hwnd), EE_QUERY_STATUS, (WPARAM)(UINT)(nCmdID), (LPARAM)(BOOL*)pbChecked )

#define EE_UPDATE_TOOLBAR       (EE_FIRST+2)
  // (UINT)wParam = nCmdID

#define Editor_UpdateToolbar( hwnd, nCmdID ) \
    (void)SNDMSG( (hwnd), EE_UPDATE_TOOLBAR, (WPARAM)(UINT)(nCmdID), (LPARAM)0 )

#define EE_GET_SEL_TEXTA        (EE_FIRST+3)
  // (UINT)wParam = nBufferSize, (LPSTR)lParam = szBuffer
  // returns (UINT)nRequiredBufferSize

#define Editor_GetSelTextA( hwnd, nBufferSize, szBuffer ) \
    (UINT)SNDMSG( (hwnd), EE_GET_SEL_TEXTA, (WPARAM)(UINT)(nBufferSize), (LPARAM)(LPSTR)(szBuffer) )

#define EE_GET_SEL_TEXTW        (EE_FIRST+46)
  // (UINT)wParam = nBufferSize, (LPWSTR)lParam = szBuffer
  // returns (UINT)nRequiredBufferSize

#define Editor_GetSelTextW( hwnd, nBufferSize, szBuffer ) \
    (UINT)SNDMSG( (hwnd), EE_GET_SEL_TEXTW, (WPARAM)(UINT)(nBufferSize), (LPARAM)(LPWSTR)(szBuffer) )

#define EE_GET_LINES            (EE_FIRST+4)
  // (int)wParam = nLogical
  // returns (UINT)nTotalLines

#define Editor_GetLines( hwnd, nLogical ) \
    (UINT)SNDMSG( (hwnd), EE_GET_LINES, (WPARAM)(int)(nLogical), (LPARAM)0 )

#define EE_GET_LINEA            (EE_FIRST+5)
  // (GET_LINE_INFO*)wParam = pGetLineInfo, (LPSTR)lParam = szString
  // returns (UINT)nRequiredBufferSize

#define Editor_GetLineA( hwnd, pGetLineInfo, szString ) \
    (UINT)SNDMSG( (hwnd), EE_GET_LINEA, (WPARAM)(GET_LINE_INFO*)(pGetLineInfo), (LPARAM)(LPSTR)(szString) )

#define EE_GET_LINEW            (EE_FIRST+47)
  // (GET_LINE_INFO*)wParam = pGetLineInfo, (LPWSTR)lParam = szString
  // returns (UINT)nRequiredBufferSize

#define Editor_GetLineW( hwnd, pGetLineInfo, szString ) \
    (UINT)SNDMSG( (hwnd), EE_GET_LINEW, (WPARAM)(GET_LINE_INFO*)(pGetLineInfo), (LPARAM)(LPWSTR)(szString) )

#define EE_GET_CARET_POS        (EE_FIRST+6)
  // (int)wParam = nLogical, (POINT*)lParam = pptPos

#define Editor_GetCaretPos( hwnd, nLogical, pptPos ) \
    (void)SNDMSG( (hwnd), EE_GET_CARET_POS, (WPARAM)(int)(nLogical), (LPARAM)(POINT*)(pptPos) )

#define EE_DEV_TO_VIEW          (EE_FIRST+7)
  // (POINT*)wParam = pptDev, (POINT*)lParam = pptView

#define Editor_DevToView( hwnd, pptDev, pptView ) \
    (void)SNDMSG( (hwnd), EE_DEV_TO_VIEW, (WPARAM)(POINT*)(pptDev), (LPARAM)(POINT*)(pptView) )

#define EE_GET_PAGE_SIZE        (EE_FIRST+8)
  // (SIZE*)lParam = psizePage

#define Editor_GetPageSize( hwnd, psizePage ) \
    (void)SNDMSG( (hwnd), EE_GET_PAGE_SIZE, (WPARAM)0, (LPARAM)(SIZE*)(psizePage) )

#define EE_GET_SCROLL_POS       (EE_FIRST+9)
  // (POINT*)lParam = pptPos

#define Editor_GetScrollPos( hwnd, pptPos ) \
    (void)SNDMSG( (hwnd), EE_GET_SCROLL_POS, (WPARAM)0, (LPARAM)(POINT*)(pptPos) )

#define EE_LINE_FROM_CHAR       (EE_FIRST+10)
  // (int)wParam = nLogical, (UINT)lParam = nSerialIndex
  // returns (UINT)yLine

#define Editor_LineFromChar( hwnd, nLogical, nSerialIndex ) \
    (UINT)SNDMSG( (hwnd), EE_LINE_FROM_CHAR, (WPARAM)(int)(nLogical), (LPARAM)(UINT)(nSerialIndex) )

#define EE_LINE_INDEX           (EE_FIRST+11)
  // (BOOL)wParam = bLogical, (int)lParam = yLine
  // returns (UINT)nSerialIndex

#define Editor_LineIndex( hwnd, bLogical, yLine ) \
    (UINT)SNDMSG( (hwnd), EE_LINE_INDEX, (WPARAM)(BOOL)(bLogical), (LPARAM)(UINT)(yLine) )

#define EE_LOAD_FILEA           (EE_FIRST+12)
  // (LOAD_FILE_INFO*)wParam = plfi
  // (LPSTR)lParam = szFileName
  // returns non-zero if success, 0 if failed

#define Editor_LoadFileA( hwnd, plfi, szFileName ) \
    (BOOL)SNDMSG( (hwnd), EE_LOAD_FILEA, (WPARAM)plfi, (LPARAM)(LPSTR)(szFileName) )

#define EE_LOAD_FILEW           (EE_FIRST+48)
  // (LOAD_FILE_INFO*)wParam = plfi
  // (LPWSTR)lParam = szFileName
  // returns non-zero if success, 0 if failed

#define Editor_LoadFileW( hwnd, plfi, szFileName ) \
    (BOOL)SNDMSG( (hwnd), EE_LOAD_FILEW, (WPARAM)plfi, (LPARAM)(LPWSTR)(szFileName) )

#define EE_LOGICAL_TO_SERIAL    (EE_FIRST+13)
  // (POINT*)lParam = pptLogical
  // returns (UINT)nSerialIndex

#define Editor_LogicalToSerial( hwnd, pptLogical ) \
    (UINT)SNDMSG( (hwnd), EE_LOGICAL_TO_SERIAL, (WPARAM)0, (LPARAM)(POINT*)(pptLogical) )

#define EE_LOGICAL_TO_VIEW      (EE_FIRST+14)
  // (POINT*)wParam = pptLogical, (POINT*)lParam = pptView

#define Editor_LogicalToView( hwnd, pptLogical, pptView ) \
    (void)SNDMSG( (hwnd), EE_LOGICAL_TO_VIEW, (WPARAM)(POINT*)(pptLogical), (LPARAM)(POINT*)(pptView) )

#define EE_SAVE_FILEA           (EE_FIRST+16)
  // (BOOL)wParam = bReplace, (LPSTR)lParam = szFileName
  // returns non-zero if success, 0 if failed

#define Editor_SaveFileA( hwnd, bReplace, szFileName ) \
    (BOOL)SNDMSG( (hwnd), EE_SAVE_FILEA, (WPARAM)(BOOL)(bReplace), (LPARAM)(LPSTR)(szFileName) )

#define EE_SAVE_FILEW           (EE_FIRST+49)
  // (BOOL)wParam = bReplace, (LPWSTR)lParam = szFileName
  // returns non-zero if success, 0 if failed

#define Editor_SaveFileW( hwnd, bReplace, szFileName ) \
    (BOOL)SNDMSG( (hwnd), EE_SAVE_FILEW, (WPARAM)(BOOL)(bReplace), (LPARAM)(LPWSTR)(szFileName) )

#define EE_SERIAL_TO_LOGICAL    (EE_FIRST+17)
  // (UINT)wParam = nSerial, (POINT*)lParam = pptLogical

#define Editor_SerialToLogical( hwnd, nSerial, pptLogical ) \
    (void)SNDMSG( (hwnd), EE_SERIAL_TO_LOGICAL, (WPARAM)(UINT)(nSerial), (LPARAM)(POINT*)(pptLogical) )

#define EE_SET_CARET_POS        (EE_FIRST+18)
  // wParam = MAKEWPARAM( nLogical, bExtend )
  // (POINT*)lParam = pptPos

#define Editor_SetCaretPos( hwnd, nLogical, pptPos ) \
    (void)SNDMSG( (hwnd), EE_SET_CARET_POS, (WPARAM)(int)(nLogical), (LPARAM)(POINT*)(pptPos) )

#define Editor_SetCaretPosEx( hwnd, nLogical, pptPos, bExtend ) \
    (void)SNDMSG( (hwnd), EE_SET_CARET_POS, MAKEWPARAM(nLogical, bExtend), (LPARAM)(POINT*)(pptPos) )

#define EE_SET_SCROLL_POS       (EE_FIRST+19)
  // (POINT*)lParam = pptPos

#define Editor_SetScrollPos( hwnd, pptPos ) \
    (void)SNDMSG( (hwnd), EE_SET_SCROLL_POS, (WPARAM)0, (LPARAM)(POINT*)(pptPos) )

#define EE_VIEW_TO_DEV          (EE_FIRST+20)
  // (POINT*)wParam = pptView, (POINT*)lParam = pptDev

#define Editor_ViewToDev( hwnd, pptView, pptDev ) \
    (void)SNDMSG( (hwnd), EE_VIEW_TO_DEV, (WPARAM)(POINT*)(pptView), (LPARAM)(POINT*)(pptDev) )

#define EE_VIEW_TO_LOGICAL      (EE_FIRST+21)
  // (POINT*)wParam = pptView, (POINT*)lParam = pptLogical

#define Editor_ViewToLogical( hwnd, pptView, pptLogical ) \
    (void)SNDMSG( (hwnd), EE_VIEW_TO_LOGICAL, (WPARAM)(POINT*)(pptView), (LPARAM)(POINT*)(pptLogical ) )

#define EE_EXEC_COMMAND         (EE_FIRST+22)
  // (UINT)wParam = nCmdID

#define Editor_ExecCommand( hwnd, nCmdID ) \
    (BOOL)SNDMSG( (hwnd), EE_EXEC_COMMAND, (WPARAM)(UINT)(nCmdID), (LPARAM)0 )

#define EE_GET_MODIFIED         (EE_FIRST+23)
  // returns (BOOL)m_bModified

#define Editor_GetModified( hwnd ) \
    (BOOL)SNDMSG( (hwnd), EE_GET_MODIFIED, (WPARAM)0, (LPARAM)0 )

#define EE_SET_MODIFIED         (EE_FIRST+24)
  // (BOOL)wParam = bModified

#define Editor_SetModified( hwnd, bModified ) \
    (void)SNDMSG( (hwnd), EE_SET_MODIFIED, (WPARAM)(BOOL)(bModified), (LPARAM)0 )

#define EE_GET_SEL_START        (EE_FIRST+26)
  // (int)wParam = nLogical
  // (POINT*)lParam = pptPos

#define Editor_GetSelStart( hwnd, nLogical, pptPos ) \
    (void)SNDMSG( (hwnd), EE_GET_SEL_START, (WPARAM)(int)(nLogical), (LPARAM)(POINT*)(pptPos) )

#define EE_GET_SEL_END          (EE_FIRST+27)
  // (int)wParam = nLogical
  // (POINT*)lParam = pptPos

#define Editor_GetSelEnd( hwnd, nLogical, pptPos ) \
    (void)SNDMSG( (hwnd), EE_GET_SEL_END, (WPARAM)(int)(nLogical), (LPARAM)(POINT*)(pptPos) )

#define EE_SET_SEL_LENGTH       (EE_FIRST+28)
  // (UINT)wParam = nLen

#define Editor_SetSelLength( hwnd, nLen ) \
    (void)SNDMSG( (hwnd), EE_SET_SEL_LENGTH, (WPARAM)(UINT)(nLen), (LPARAM)0 )

#define EE_GET_CONFIGA          (EE_FIRST+29)
  // (LPSTR)lParam = szConfigName

#define Editor_GetConfigA( hwnd, szConfigName ) \
    (void)SNDMSG( (hwnd), EE_GET_CONFIGA, (WPARAM)0, (LPARAM)(LPSTR)(szConfigName) )

#define EE_GET_CONFIGW          (EE_FIRST+50)
  // (LPWSTR)lParam = szConfigName

#define Editor_GetConfigW( hwnd, szConfigName ) \
    (void)SNDMSG( (hwnd), EE_GET_CONFIGW, (WPARAM)0, (LPARAM)(LPWSTR)(szConfigName) )

#define EE_SET_CONFIGA          (EE_FIRST+30)
  // (LPCSTR)lParam = szConfigName

#define Editor_SetConfigA( hwnd, szConfigName ) \
    (BOOL)SNDMSG( (hwnd), EE_SET_CONFIGA, (WPARAM)0, (LPARAM)(LPSTR)(szConfigName) )

#define EE_SET_CONFIGW          (EE_FIRST+51)
  // (LPCWSTR)lParam = szConfigName

#define Editor_SetConfigW( hwnd, szConfigName ) \
    (BOOL)SNDMSG( (hwnd), EE_SET_CONFIGW, (WPARAM)0, (LPARAM)(LPWSTR)(szConfigName) )

#define EE_EMPTY_UNDO_BUFFER    (EE_FIRST+31)

#define Editor_EmptyUndoBuffer( hwnd ) \
    (void)SNDMSG( (hwnd), EE_EMPTY_UNDO_BUFFER, (WPARAM)0, (LPARAM)0 )

#define OVERWRITE_PER_PROP  0
#define OVERWRITE_INSERT    1
#define OVERWRITE_OVERWRITE 2

#define EE_INSERT_STRINGA       (EE_FIRST+32)
  // (int)wParam = nInsertType
  // (LPCSTR)lParam = szString

#define Editor_InsertStringA( hwnd, szString ) \
    (void)SNDMSG( (hwnd), EE_INSERT_STRINGA, (WPARAM)OVERWRITE_PER_PROP, (LPARAM)(LPCSTR)(szString) )

#define Editor_InsertA( hwnd, szString ) \
    (void)SNDMSG( (hwnd), EE_INSERT_STRINGA, (WPARAM)OVERWRITE_INSERT, (LPARAM)(LPCSTR)(szString) )

#define Editor_OverwriteA( hwnd, szString ) \
    (void)SNDMSG( (hwnd), EE_INSERT_STRINGA, (WPARAM)OVERWRITE_OVERWRITE, (LPARAM)(LPCSTR)(szString) )

#define EE_INSERT_STRINGW       (EE_FIRST+52)
  // (int)wParam = nInsertType
  // (LPCWSTR)lParam = szString

#define Editor_InsertStringW( hwnd, szString ) \
    (void)SNDMSG( (hwnd), EE_INSERT_STRINGW, (WPARAM)OVERWRITE_PER_PROP, (LPARAM)(LPCWSTR)(szString) )

#define Editor_InsertW( hwnd, szString ) \
    (void)SNDMSG( (hwnd), EE_INSERT_STRINGW, (WPARAM)OVERWRITE_INSERT, (LPARAM)(LPCWSTR)(szString) )

#define Editor_OverwriteW( hwnd, szString ) \
    (void)SNDMSG( (hwnd), EE_INSERT_STRINGW, (WPARAM)OVERWRITE_OVERWRITE, (LPARAM)(LPCWSTR)(szString) )

#define EE_SET_SEL_VIEW         (EE_FIRST+33)
  // (POINT*)wParam = pptSelStart, (POINT*)lParam = pptSelEnd

#define Editor_SetSelView( hwnd, pptSelStart, pptSelEnd ) \
    (void)SNDMSG( (hwnd), EE_SET_SEL_VIEW, (WPARAM)(POINT*)(pptSelStart), (LPARAM)(POINT*)(pptSelEnd) )

#define EE_FINDA                (EE_FIRST+34)
  // (UINT)wParam = nFlags, (LPCSTR)lParam = szFind
  // returns (BOOL)bSuccess

#define Editor_FindA( hwnd, nFlags, szFind ) \
    (BOOL)SNDMSG( (hwnd), EE_FINDA, (WPARAM)(UINT)(nFlags), (LPARAM)(LPCSTR)(szFind) )

#define EE_FINDW                (EE_FIRST+53)
  // (UINT)wParam = nFlags, (LPCWSTR)lParam = szFind
  // returns (BOOL)bSuccess

#define Editor_FindW( hwnd, nFlags, szFind ) \
    (BOOL)SNDMSG( (hwnd), EE_FINDW, (WPARAM)(UINT)(nFlags), (LPARAM)(LPCWSTR)(szFind) )

#define EE_REPLACEA             (EE_FIRST+35)
  // (UINT)wParam = nFlags, (LPCWSTR)lParam = szFindReplace
  // returns (BOOL)bSuccess

#define Editor_ReplaceA( hwnd, nFlags, szFindReplace ) \
    (BOOL)SNDMSG( (hwnd), EE_REPLACEA, (WPARAM)(UINT)(nFlags), (LPARAM)(LPCWSTR)(szFindReplace) )

#define EE_REPLACEW             (EE_FIRST+54)
  // (UINT)wParam = nFlags, (LPCWSTR)lParam = szFindReplace
  // returns (BOOL)bSuccess

#define Editor_ReplaceW( hwnd, nFlags, szFindReplace ) \
    (BOOL)SNDMSG( (hwnd), EE_REPLACEW, (WPARAM)(UINT)(nFlags), (LPARAM)(LPCWSTR)(szFindReplace) )

#define EE_LOAD_CONFIGA         (EE_FIRST+36)
  // (LPCSTR)lParam = szConfigName

#define Editor_LoadConfigA( hwnd, szConfigName ) \
    (BOOL)SNDMSG( (hwnd), EE_LOAD_CONFIGA, (WPARAM)0, (LPARAM)(LPCSTR)(szConfigName) )

#define EE_LOAD_CONFIGW         (EE_FIRST+55)
  // (LPCWSTR)lParam = szConfigName

#define Editor_LoadConfigW( hwnd, szConfigName ) \
    (BOOL)SNDMSG( (hwnd), EE_LOAD_CONFIGW, (WPARAM)0, (LPARAM)(LPCWSTR)(szConfigName) )

#define EE_SET_STATUSA          (EE_FIRST+37)
  // (LPCSTR)lParam = szStatus

#define Editor_SetStatusA( hwnd, szStatus ) \
    (void)SNDMSG( (hwnd), EE_SET_STATUSA, (WPARAM)0, (LPARAM)(LPCSTR)(szStatus) )

#define EE_SET_STATUSW          (EE_FIRST+56)
  // (LPCWSTR)lParam = szStatus

#define Editor_SetStatusW( hwnd, szStatus ) \
    (void)SNDMSG( (hwnd), EE_SET_STATUSW, (WPARAM)0, (LPARAM)(LPCWSTR)(szStatus) )

#define EE_CONVERT              (EE_FIRST+38)
  // (UINT)wParam = nFlags

#define Editor_Convert( hwnd, nFlags ) \
    (BOOL)SNDMSG( (hwnd), EE_CONVERT, (WPARAM)(UINT)(nFlags), (LPARAM)0 )

#define EE_GET_MARGIN           (EE_FIRST+39)
  // returns (UINT)nMaxMargin

#define Editor_GetMargin( hwnd ) \
    (UINT)SNDMSG( (hwnd), EE_GET_MARGIN, (WPARAM)0, (LPARAM)0 )

#define EE_GET_VERSION          (EE_FIRST+40)
  // returns (UINT)nVersion

#define Editor_GetVersion( hwnd ) \
    (UINT)SNDMSG( (hwnd), EE_GET_VERSION, (WPARAM)0, (LPARAM)0 )

#define Editor_GetVersionEx( hwnd, pnProductType ) \
    (UINT)SNDMSG( (hwnd), EE_GET_VERSION, (WPARAM)pnProductType, (LPARAM)0 )

#define VERSION_PRO             2
#define VERSION_STD             1

#define EE_GET_REF              (EE_FIRST+41)
  // (ATOM)lParam = atom
  // return (int)nRef

#define Editor_GetRef( hwnd, atom ) \
    (int)SNDMSG( (hwnd), EE_GET_REF, (WPARAM)0, (LPARAM)(ATOM)atom )

#define EE_ADD_REF              (EE_FIRST+42)
  // (HINSTANCE)lParam = hInstance
  // return (int)nRef

#define Editor_AddRef( hwnd, hInstance ) \
    (int)SNDMSG( (hwnd), EE_ADD_REF, (WPARAM)0, (LPARAM)(HINSTANCE)hInstance )
 
#define EE_RELEASE              (EE_FIRST+43)
  // (HINSTANCE)lParam = hInstance
  // return (int)nRef
 
#define Editor_Release( hwnd, hInstance ) \
    (int)SNDMSG( (hwnd), EE_RELEASE, (WPARAM)0, (LPARAM)(HINSTANCE)hInstance )

#define EE_REDRAW               (EE_FIRST+44)
  // (BOOL)wParam = bRedraw

#define Editor_Redraw( hwnd, bRedraw ) \
    (void)SNDMSG( (hwnd), EE_REDRAW, (WPARAM)bRedraw, (LPARAM)0 )

#define EE_GET_SEL_TYPE         (EE_FIRST+45)
  // return (int)nSelType

#define Editor_GetSelType( hwnd ) \
    (int)SNDMSG( (hwnd), EE_GET_SEL_TYPE, (WPARAM)0, (LPARAM)0 )

#define EE_IS_CHAR_HALF_OR_FULL (EE_FIRST+57)
  // (WCHAR)wParam = ch
  // return (int)nWidth

#define Editor_IsCharHalfOrFull( hwnd, ch ) \
    (int)SNDMSG( (hwnd), EE_IS_CHAR_HALF_OR_FULL, (WPARAM)ch, (LPARAM)0 )

#define EE_INFO                 (EE_FIRST+58)
  // (int)wParam = nCmd
  // lParam = lParam
  // return lResult

#define Editor_Info( hwnd, nCmd, lParam ) \
    (int)SNDMSG( (hwnd), EE_INFO, (WPARAM)nCmd, (LPARAM)lParam )

#define EE_FREE                 (EE_FIRST+59)
  // (ATOM)lParam = atom
  // return (BOOL)bSuccess

#define Editor_Free( hwnd, atom ) \
    (BOOL)SNDMSG( (hwnd), EE_FREE, (WPARAM)0, (LPARAM)(ATOM)atom )

#define EE_SET_SEL_TYPE         (EE_FIRST+60)

#define Editor_SetSelType( hwnd, nSelType ) \
    (int)SNDMSG( (hwnd), EE_SET_SEL_TYPE, (WPARAM)0, (LPARAM)nSelType )

#define EE_GET_STATUSA          (EE_FIRST+61)
  // (UINT)wParam = nBufSize
  // (LPSTR)lParam = szStatus

#define Editor_GetStatusA( hwnd, szStatus, nBufSize ) \
    (UINT)SNDMSG( (hwnd), EE_GET_STATUSA, (WPARAM)nBufSize, (LPARAM)(LPCWSTR)(szStatus) )

#define EE_GET_STATUSW          (EE_FIRST+62)
  // (UINT)wParam = nBufSize
  // (LPWSTR)lParam = szStatus

#define Editor_GetStatusW( hwnd, szStatus, nBufSize ) \
    (UINT)SNDMSG( (hwnd), EE_GET_STATUSW, (WPARAM)nBufSize, (LPARAM)(LPCWSTR)(szStatus) )

#define EE_INSERT_FILEA         (EE_FIRST+63)
  // (LOAD_FILE_INFO*)wParam = plfi
  // (LPCSTR)lParam = szFileName
  // returns non-zero if success, 0 if failed

#define Editor_InsertFileA( hwnd, plfi, szFileName ) \
    (BOOL)SNDMSG( (hwnd), EE_INSERT_FILEA, (WPARAM)plfi, (LPARAM)(LPCSTR)(szFileName) )

#define EE_INSERT_FILEW         (EE_FIRST+64)
  // (LOAD_FILE_INFO*)wParam = plfi
  // (LPCWSTR)lParam = szFileName
  // returns non-zero if success, 0 if failed

#define Editor_InsertFileW( hwnd, plfi, szFileName ) \
    (BOOL)SNDMSG( (hwnd), EE_INSERT_FILEW, (WPARAM)plfi, (LPARAM)(LPCWSTR)(szFileName) )

#define EE_FIND_IN_FILESA		(EE_FIRST+65)
  // wParam = 0
  // (GREP_INFOA*)lParam = pGrepInfo

#define Editor_FindInFilesA( hwnd, pGrepInfo ) \
    (BOOL)SNDMSG( (hwnd), EE_FIND_IN_FILESA, (WPARAM)0, (LPARAM)pGrepInfo )

#define EE_FIND_IN_FILESW		(EE_FIRST+66)
  // wParam = 0
  // (GREP_INFOW*)lParam = pGrepInfo

#define Editor_FindInFilesW( hwnd, pGrepInfo ) \
    (BOOL)SNDMSG( (hwnd), EE_FIND_IN_FILESW, (WPARAM)0, (LPARAM)pGrepInfo )

#define EE_REPLACE_IN_FILESA		(EE_FIRST+67)
  // wParam = 0
  // (GREP_INFOA*)lParam = pGrepInfo

#define Editor_ReplaceInFilesA( hwnd, pGrepInfo ) \
    (BOOL)SNDMSG( (hwnd), EE_REPLACE_IN_FILESA, (WPARAM)0, (LPARAM)pGrepInfo )

#define EE_REPLACE_IN_FILESW		(EE_FIRST+68)
  // wParam = 0
  // (GREP_INFOW*)lParam = pGrepInfo

#define Editor_ReplaceInFilesW( hwnd, pGrepInfo ) \
    (BOOL)SNDMSG( (hwnd), EE_REPLACE_IN_FILESW, (WPARAM)0, (LPARAM)pGrepInfo )

#define EE_GET_ANCHOR_POS			(EE_FIRST+69)
  // (int)wParam = nLogical
  // (POINT*)lParam = pptPos

#define Editor_GetAnchorPos( hwnd, nLogical, pptPos ) \
    (void)SNDMSG( (hwnd), EE_GET_ANCHOR_POS, (WPARAM)(int)(nLogical), (LPARAM)(POINT*)(pptPos) )

#define EE_SET_ANCHOR_POS			(EE_FIRST+70)
  // (int)wParam = nLogical
  // (POINT*)lParam = pptPos

#define Editor_SetAnchorPos( hwnd, nLogical, pptPos ) \
    (void)SNDMSG( (hwnd), EE_SET_ANCHOR_POS, (WPARAM)(int)(nLogical), (LPARAM)(POINT*)(pptPos) )

//
#define EE_LAST                 (EE_FIRST+255)


#define EI_GET_ENCODE           256
#define EI_SET_ENCODE           257
#define EI_GET_SIGNATURE        268
#define EI_SET_SIGNATURE        269
#define EI_GET_FONT_CHARSET     270
#define EI_SET_FONT_CHARSET     271
#define EI_GET_FONT_CP          272
#define EI_GET_INPUT_CP         274
#define EI_GET_SHOW_TAG         276
#define EI_SET_SHOW_TAG         277
#define EI_GET_FILE_NAMEA       278
#define EI_GET_FILE_NAMEW       280
#define EI_IS_PROPORTIONAL_FONT 282
#define EI_GET_NEXT_BOOKMARK    284
#define EI_GET_HILITE_FIND      286
#define EI_SET_HILITE_FIND      287
#define EI_GET_APP_VERSIONA     288
#define EI_GET_APP_VERSIONW     290
#define EI_GET_READ_ONLY        296
#define EI_IS_WINDOW_COMBINED   298
#define EI_WINDOW_COMBINE       299
#define EI_IS_UNDO_COMBINED     300

#define POS_VIEW                    0
#define POS_LOGICAL_A               1
#define POS_LOGICAL_W               2
#define POS_TAB_A                   3

#define POS_WANT_X                  0x00010000
#define POS_WANT_Y                  0x00020000

#define SEL_TYPE_NONE               0
#define SEL_TYPE_CHAR               1
#define SEL_TYPE_LINE               2
#define SEL_TYPE_BOX                3
#define SEL_TYPE_MASK               0x000f
#define SEL_TYPE_KEYBOARD           0x0010

// EE_SAVE_FILE
#define DO_SAVE_NONE                0
#define DO_SAVE_REPLACE             1
#define DO_SAVE_RENAME              2

// EE_CONVERT
#define FLAG_MAKE_LOWER             0
#define FLAG_MAKE_UPPER             1
#define FLAG_HAN_TO_ZEN             2
#define FLAG_ZEN_TO_HAN             3
#define FLAG_CONVERT_MASK           3
#define FLAG_CONVERT_SELECT_ALL     0x0100
#define FLAG_CONVERT_KATA           0x0400
#define FLAG_CONVERT_ALPHANUMERIC   0x0800
#define FLAG_CONVERT_MARK           0x1000
#define FLAG_CONVERT_SPACE          0x2000
#define FLAG_CONVERT_KANA_MARK      0x4000
#define FLAG_CONVERT_ALL_TYPES      0xfe00

// EE_FIND, EE_REPLACE, EE_FIND_IN_FILES, EE_REPLACE_IN_FILES
#define FLAG_FIND_NEXT              0x0001  // EE_FIND only
#define FLAG_FIND_CASE              0x0002  // EE_FIND and EE_REPLACE
#define FLAG_FIND_ESCAPE            0x0004  // EE_FIND and EE_REPLACE
#define FLAG_REPLACE_SEL_ONLY       0x0008  // EE_REPLACE only
#define FLAG_REPLACE_ALL            0x0010  // EE_REPLACE only
#define FLAG_FIND_NO_PROMPT         0x0020  // EE_FIND and EE_REPLACE
#define FLAG_FIND_ONLY_WORD         0x0040  // EE_FIND and EE_REPLACE
#define FLAG_FIND_AROUND            0x0080  // EE_FIND only
#define FLAG_FIND_REG_EXP           0x0100  // EE_FIND and EE_REPLACE
#define FLAG_FIND_CLOSE             0x0200  // EE_FIND and EE_REPLACE
#define FLAG_FIND_RECURSIVE         0x0400  // EE_FIND_IN_FILES and EE_REPLACE_IN_FILES
#define FLAG_FIND_FILENAMES_ONLY    0x0800  // EE_FIND_IN_FILES only
#define FLAG_REPLACE_KEEP_OPEN		0x1000  // EE_REPLACE_IN_FILES only
#define FLAG_REPLACE_BACKUP			0x2000  // EE_REPLACE_IN_FILES only
#define FLAG_FIND_IGNORE_FILES      0x4000  // EE_FIND_IN_FILES and EE_REPLACE_IN_FILES
#define FLAG_GREP_MASK				0x7c00
#define FLAG_FIND_MASK				0x7fff

// EE_LOAD_FILE
typedef struct _LOAD_FILE_INFO {
    UINT nSize;          // sizeof( LOAD_FILE_INFO )
    UINT nCP;
    BOOL bDetectUnicode;
    BOOL bDetectAll;
    BOOL bDetectCharset;
    BOOL bDetectUTF8;
} LOAD_FILE_INFO;

// EE_LOAD_FILE_EX
typedef struct _LOAD_FILE_INFO_EX {
    UINT nSize;          // sizeof( LOAD_FILE_INFO_EX )
    UINT nCP;
    BOOL bDetectUnicode;
    BOOL bDetectAll;
    BOOL bDetectCharset;
    BOOL bDetectUTF8;
    UINT nFlags;
} LOAD_FILE_INFO_EX;

#define LFI_ALLOW_NEW_WINDOW    1

typedef struct _GET_LINE_INFO {
    UINT cb;
    UINT flags;
    UINT yLine;
} GET_LINE_INFO;

typedef struct _GREP_INFOW {
	UINT    nSize;         // sizeof( GREP_INFOW )
	UINT    nCP;
	UINT    nFlags;
	LPCWSTR pszFind;
	LPCWSTR pszReplace;
	LPCWSTR pszPath;
	LPCWSTR pszBackupPath;
	LPCWSTR pszFilesToIgnore;
} GREP_INFOW;

typedef struct _GREP_INFOA {
	UINT    nSize;         // sizeof( GREP_INFOA )
	UINT    nCP;
	UINT    nFlags;
	LPCSTR  pszFind;
	LPCSTR  pszReplace;
	LPCSTR  pszPath;
	LPCSTR  pszBackupPath;
	LPCSTR  pszFilesToIgnore;
} GREP_INFOA;


// GET_LINE_INFO
#define FLAG_LOGICAL    1
#define FLAG_WITH_CRLF  2



#define EP_FIRST                (WM_USER+0x500)

#define EP_QUERY_PROPERTIES     (EP_FIRST+0)
#define EP_SET_PROPERTIES       (EP_FIRST+1)
#define EP_GET_NAMEA            (EP_FIRST+2)
#define EP_GET_NAMEW            (EP_FIRST+3)
#define EP_GET_VERSIONA         (EP_FIRST+4)
#define EP_GET_VERSIONW         (EP_FIRST+5)
#define EP_QUERY_UNINSTALL      (EP_FIRST+6)
#define EP_SET_UNINSTALL        (EP_FIRST+7)
#define EP_GET_BITMAP           (EP_FIRST+8)
#define EP_GET_MASK             (EP_FIRST+9)

#define EP_LAST                 (EP_FIRST+50)

#ifdef _UNICODE
#define EP_GET_NAME             EP_GET_NAMEW
#define EP_GET_VERSION          EP_GET_VERSIONW
#else
#define EP_GET_NAME             EP_GET_NAMEA
#define EP_GET_VERSION          EP_GET_VERSIONA
#endif

// EP_GET_BITMAP
#define BITMAP_SMALL            0x00000000
#define BITMAP_LARGE            0x00000001
#define BITMAP_SIZE_MASK        0x0000000f
#define BITMAP_16_COLOR         0x00000000
#define BITMAP_256_COLOR        0x00000010
#define BITMAP_24BIT_COLOR      0x00000020
#define BITMAP_COLOR_MASK       0x000000f0
#define BITMAP_DEFAULT          0x00000000
#define BITMAP_DISABLED         0x00000100
#define BITMAP_HOT              0x00000200
#define BITMAP_STATUS_MASK      0x00000f00

#define CHECK_FILE_CHANGED_NONE         0
#define CHECK_FILE_CHANGED_PROMPT       1
#define CHECK_FILE_CHANGED_AUTO         2
#define CHECK_FILE_CHANGED_EXCLUSIVE    3

#define SIZE_OF_CUSTOMIZE_INFO  6660


class CCustomizeInfo
{
public:
    LOGFONTW    m_alfScreen[MAX_CHARSET];   // screen fonts
    LOGFONTW    m_alfPrint[MAX_CHARSET];    // printer fonts
    POINT       m_ptShowScrollBar;      // scroll bars (x: horizontal and y: vertical) 0: no display, 1: display only when necessary, 2: display always
    int         m_nPrinterMarginTop;    // printer top margin
    int         m_nPrinterMarginBottom; // printer bottom margin
    int         m_nPrinterMarginLeft;   // printer left margin
    int         m_nWrapMode;        // wrap mode
    int         m_nMarginNormal;    // normal line margin
    int         m_nMarginQuote;     // quoted line margin
    int         m_nTabSpace;        // tab columns 
    int         m_nKanjiRead;       // opening character code 
    int         m_nLineSpace;       // line space
    int         m_nLineSpacePrint;  // space between lines
    int         m_nReserved15;      //  was m_nHiliteTag before v3.16
    int         m_nReserved14;      //  was m_nHiliteMultiComment before v3.16
    UINT        m_nAutoSaveTime;    // auto save time
    int         m_nCheckFileChanged; // v3: changed by another program
    UINT        m_nUndoBufferSize;  // undo max number
    int         m_nEncodeNew;       // v3: encode method for new files
    int         m_nCrLfNew;         // v3: how to return for new files
    int         m_nCharsetNew;      // v3: font charset for new files
    int         m_nEncodeWrite;     // v3: encode method for saving
    int         m_nCrLfWrite;       // v3: how to return for saving
    int         m_nSpecialSyntax;   // v3.16: Special Syntax
    WCHAR       m_chEscape;         // v3.16: Escape character
    bool        m_bPasteAnsi;       // v3.16: Always Paste as ANSI
    bool        m_bNewTemplate;     // v3.17: Use template for a new file
    bool        m_bSaveAsNameEntity; // v3.17: Use Named Entity Reference
    bool        m_bInsertSpacesTab; // v3.19: Insert spaces for Tab
    WCHAR       m_chIndentBegin;    // v3.17: Begin Indent
    WCHAR       m_chIndentEnd;      // v3.17: End Indent
    WCHAR       m_chEndOfStatement; // v3.17: End of Statement
    int         m_nIndentSpace;     // v3.19: Indent columns
    bool        m_bNoSpaceEdge;     // v3.19: No space at left edge of Window
    bool        m_bAnsiFont;        // v3.28: Non-Unicode Font
    bool        m_bShowScrollOnlyActive; // v3.31: Show scroll bars only when current pane is active
    bool        m_bWrapPagePrint;   // v3.31: Wrap by Page when printing
    int         m_nPrinterMarginRight;  // v3.24: printer right margin
    int         m_nMaxFindHilite;       // v3.32: (Depth of searched string to highlight) - 1
    bool        m_bPromptInvalidChar; // v4.01: Prompt if invalid characters found
    bool        m_bReserved3;        // v4.03: Synchronize Read-Only attribute
    bool        m_bReserved2;       // reserved
    bool        m_bReserved1;       // reserved
    int         m_nReserved6;       // reserved
    int         m_nReserved5;       // reserved
    int         m_nReserved4;       // reserved
    int         m_nReserved3;       // reserved
    int         m_nReserved2;       // reserved
    int         m_nReserved1;       // reserved
    BYTE        m_abUrlChar[128];   // =1: URL char, =2: URL char byte not at end.
    bool        m_bNotepadDiary;    // notepad compatible diary
    bool        m_bPrintLineNum;    // print line numbers
    bool        m_bPromptNullFile;  // prompt if Null character found
    bool        m_bPromptCrLf;      // prompt at inconsistent returns
    bool        m_bShowEOF;         // show EOF
    bool        m_bShowCR;          // show returns
    bool        m_bShowTab;         // show tab
    bool        m_bShowLineNum;     // show line numbers
    BYTE        m_bShowLogicalLine; // show logical line numbers
    bool        m_bWordWrap;        // word wrap
    bool        m_bFaceWrap;        // enable non-wrap words
    bool        m_bKinsokuWrap;     // wrap these characters
    bool        m_bSaveTabToSpace;  // save tabs as spaces
    bool        m_bSaveInsertCR;    // insert returns when saving
    bool        m_bUseRecycleBin;   // use recylce bin to buckup
    bool        m_bAutoIndent;      // auto indent
    bool        m_bOverwrite;       // overwrite mode or insert mode
    bool        m_bHilite;          // highlight these words
    bool        m_bURL;             // link to URLs
    bool        m_bMailTo;          // clicking mail address sends mail
    bool        m_bLinkDblclick;    // enable double clicking only
    bool        m_bFullPath;        // show file name with full path
    bool        m_b7BitKanji;       // 7 bit kanji
    bool        m_bCrLfSeparateMark;    // show CR and LF with different marks 
    bool        m_bShowRuler;       // show ruler
    bool        m_bAutoSave;        // auto save
    bool        m_bDeleteEmpty;     // delete empty files when saving
    bool        m_bSaveNotModified; // always enable saving
    bool        m_bBackupFolder;            // save backups to backup folder
    bool        m_bFolderIfRecycleFailed;   // save to backup folder if recycle bin not available
    bool        m_bAutoSaveFolder;          // save to auto save folder
    bool        m_bRenameBackup;            // rename if same file name exists
    bool        m_bControlIME;              // run input method editor
    bool        m_bRenameAutoSave;          // rename if same file name exists
    bool        m_bBackupSame;              // save backups to same folder
    bool        m_bShowDbSpace;             // show double-byte spaces
    bool        m_bSelLinkContextMenu;      // v3: not implemented
    bool        m_bPageVScroll;             // v3: always enable 1page vertical scroll
    bool        m_bPageHScroll;             // v3: always enable 1page horizontal scroll
    bool        m_bHalfPageScroll;          // v3: scroll half page
    bool        m_bDetectUnicode;           // v3: detect Unicode
    bool        m_bAllowCtrlChars;          // v3: allow insert control character
    bool        m_bMoveCursorScroll;        // v3: move cursor by scrolling
    bool        m_bHorzLine;                // v3: horizontal line
    bool        m_bVertLine;                // v3: vertical line
    bool        m_bScroll2Lines;            // v3: double line scroll
    bool        m_bFastKeyRepeat;           // v3: faster cursor movement
    bool        m_bDBCharUrl;               // v3: recognize double-byte characters as URLs
    bool        m_bKanaUrl;                 // v3: recognize single-byte kana and kana marks as URLs
    bool        m_bShowPage;                // v3: display page number
    bool        m_bUsePrinterFont;          // v3: choose font for default printer
    bool        m_bSignatureNew;            // v3: Unicode, UTF-8 signature for new files
    bool        m_bPromptNotAnsi;           // v3: prompt on saving if unicode characters cannot convert to ANSI
    bool        m_bSignatureWrite;          // v3: Unicode, UTF-8 signature for saving
    bool        m_bIgnoreColorPrint;        // v3.08: Ignore Color and Underlines (Print)
    bool        m_bNoFullPathIfNotActive;   // v3.08: Display file name without full path if the window is not active
    bool        m_bSaveOverwrite;           // v3.13: Save insert/overwrite mode.
    bool        m_bNoChangeCrLf;            // v3.13: Do not change how to return at copy and paste.
    bool        m_bShowSpace;               // v3.13: show single-byte spaces
    bool        m_bWordWrapMark;            // v3.13: allows word wrap after marks
    bool        m_bPrintSeparatingLines;    // v3.14: Draw separating lines
    bool        m_bSameFontPrint;           // v3.14: Use Display Font as Printer Font
    bool        m_bHiliteCorresParen;       // v3.14: Highlight Corresponding Parentheses
    bool        m_bSelectInQuotes;          // v3.14: Highlight and easily select in "quotes".
    bool        m_bDetectUTF8;              // v3.15: Detect UTF-8
    bool        m_bDetectCharset;           // v3.15: Detect Charset (HTML)
    bool        m_bDetectAll;               // v3.15: Detect All
    bool        m_bDeleteSpaceEnd;          // v3.15: Delete Space at End of Lines
    bool        m_bSaveAsEntity;            // v3.15: Encode Unicode as HTML Entity
    bool        m_bShowControl;             // v3.15: Highlight Control Characters
    BYTE        m_bQuoteType;               // v3.16: Quote type, combination of QUOTE_SINGLE, QUOTE_DOUBLE and QUOTE_CONTINUE
    WCHAR       m_chKanjiInChar;            // transitional character to kanji
    WCHAR       m_chKanjiOutChar;           // transitional character to single-bytes 
    WCHAR       m_chTagLeft;                // begin tag
    WCHAR       m_chTagRight;               // end tag
    WCHAR       m_szHeader[MAX_HEADER];             // header
    WCHAR       m_szLineComment1[MAX_LINE_COMMENT]; // v3.16: Line Comment
    WCHAR       m_szScriptBegin[MAX_SCRIPT_BEGIN];  // v3.16: Script Begin
    WCHAR       m_szFooter[MAX_FOOTER];             // footer
    WCHAR       m_szLineComment2[MAX_LINE_COMMENT]; // v3.16: Line Comment
    WCHAR       m_szScriptEnd[MAX_SCRIPT_END];      // v3.16: Script End
    WCHAR       m_szPrefix[MAX_PREFIX_LENGTH];      // default quote mark 
    WCHAR       m_szKinsokuBegin[MAX_KINSOKU_BEGIN]; // not allowed at line head
    WCHAR       m_szKinsokuEnd[MAX_KINSOKU_END];    //  not allowed at line end
    WCHAR       m_szDefExt[MAX_DEF_EXT];            // default extension
    WCHAR       m_szPrefixList[MAX_PREFIX_LIST];    // quote mark 
    WCHAR       m_szBackupPath[MAX_PATH];           // backup folder
    WCHAR       m_szAutoSavePath[MAX_PATH];         // auto save folder
    WCHAR       m_szMultiCommentBegin[MAX_MULTI_COMMENT_BEGIN];  // Multi-line comment begin
    WCHAR       m_szMultiCommentEnd[MAX_MULTI_COMMENT_END];      // Multi-line comment end
public:
    void Initialize();
};

// Command IDs
//

#define EEID_FILE_NEW                     4096
#define EEID_FILE_OPEN                    4097
#define EEID_FILE_CLOSE_OPEN              4098
#define EEID_FILE_SAVE                    4099
#define EEID_FILE_SAVE_AS                 4100
#define EEID_FILE_SAVE_ALL                4101
#define EEID_FILE_SAVE_ANSI               4102
#define EEID_FILE_SAVE_JIS                4103
#define EEID_FILE_SAVE_EUC                4104
#define EEID_SAVE_AS_CRLF                 4105
#define EEID_SAVE_AS_CR                   4106
#define EEID_SAVE_AS_LF                   4107
#define EEID_FILE_INSERT                  4108
#define EEID_FILE_RELOAD                  4109
#define EEID_FILE_RELOAD_ANSI             4110
#define EEID_FILE_RELOAD_JIS              4111
#define EEID_FILE_RELOAD_EUC              4112
#define EEID_READ_ONLY                    4113
#define EEID_FILE_PRINT                   4114
#define EEID_FILE_PRINT_DIRECT            4115
#define EEID_FILE_SAVE_EXIT               4116
#define EEID_APP_EXIT                     4117
#define EEID_SAVE_EXIT_ALL                4118
#define EEID_EXIT_ALL                     4119
#define EEID_APP_QUIT                     4120
#define EEID_NEW_TRAY_ICON                4121
#define EEID_TRAY_ICON_EXIT               4122
#define EEID_FILE_NEW_PASTE               4123
#define EEID_EDIT_UNDO                    4124
#define EEID_EDIT_REDO                    4125
#define EEID_EDIT_CUT                     4126
#define EEID_EDIT_COPY                    4127
#define EEID_EDIT_COPY_DESELECT           4128
#define EEID_EDIT_PASTE                   4129
#define EEID_EDIT_COPY_PREFIX             4130
#define EEID_EDIT_COPY_PREFIX_DESELECT    4131
#define EEID_PASTE_PREFIX                 4132
#define EEID_PASTE_RETURN                 4133
#define EEID_PASTE_PREFIX_RETURN          4134
#define EEID_DELETE                       4135
#define EEID_EDIT_SELECT_ALL              4136
#define EEID_INSERT_DATE                  4137
#define EEID_INSERT_DATE_TIME             4138
#define EEID_JUMP                         4139
#define EEID_EDIT_COPY_LINK               4140
#define EEID_LINK_OPEN                    4141
#define EEID_INSERT                       4142
#define EEID_INSERT_CR_WRAP               4143
#define EEID_DELETE_CR_WRAP               4144
#define EEID_INSERT_CR                    4145
#define EEID_INSERT_LF                    4146
#define EEID_TAG_JUMP                     4147
#define EEID_CONVERT                      4148
#define EEID_MAKE_UPPER                   4149
#define EEID_MAKE_LOWER                   4150
#define EEID_ZEN_TO_HAN                   4151
#define EEID_HAN_TO_ZEN                   4152
#define EEID_SELECT_CHAR                  4153
#define EEID_SELECT_LINE                  4154
#define EEID_SELECT_BOX                   4155
#define EEID_RIGHT                        4156
#define EEID_LEFT                         4157
#define EEID_RIGHT_WORD                   4158
#define EEID_LEFT_WORD                    4159
#define EEID_UP                           4160
#define EEID_DOWN                         4161
#define EEID_PAGEUP                       4162
#define EEID_PAGEDOWN                     4163
#define EEID_HOME                         4164
#define EEID_LOGICAL_HOME                 4165
#define EEID_END                          4166
#define EEID_LOGICAL_END                  4167
#define EEID_TOP                          4168
#define EEID_BOTTOM                       4169
#define EEID_SCROLL_UP                    4170
#define EEID_SCROLL_DOWN                  4171
#define EEID_SHIFT_RIGHT                  4172
#define EEID_SHIFT_LEFT                   4173
#define EEID_SHIFT_RIGHT_WORD             4174
#define EEID_SHIFT_LEFT_WORD              4175
#define EEID_SHIFT_UP                     4176
#define EEID_SHIFT_DOWN                   4177
#define EEID_SHIFT_PAGEUP                 4178
#define EEID_SHIFT_PAGEDOWN               4179
#define EEID_SHIFT_HOME                   4180
#define EEID_SHIFT_LOGICAL_HOME           4181
#define EEID_SHIFT_END                    4182
#define EEID_SHIFT_LOGICAL_END            4183
#define EEID_SHIFT_TOP                    4184
#define EEID_SHIFT_BOTTOM                 4185
#define EEID_BACK                         4186
#define EEID_ESCAPE                       4187
#define EEID_TAB                          4188
#define EEID_SHIFT_TAB                    4189
#define EEID_DELETE_LINE                  4190
#define EEID_DELETE_RIGHT_LINE            4191
#define EEID_EDIT_COPY_LINE               4192
#define EEID_EDIT_CUT_LINE                4193
#define EEID_DELETE_WORD                  4194
#define EEID_LINE_OPEN_ABOVE              4195
#define EEID_LINE_OPEN_BELOW              4196
#define EEID_INSERT_CONTROL               4197
#define EEID_TOGGLE_IME                   4198
#define EEID_RECONVERT                    4199
#define EEID_EDIT_FIND                    4200
#define EEID_EDIT_REPLACE                 4201
#define EEID_EDIT_REPEAT                  4202
#define EEID_EDIT_REPEAT_BACK             4203
#define EEID_FIND_NEXT_WORD               4204
#define EEID_FIND_PREV_WORD               4205
#define EEID_ERASE_FIND_HILITE            4206
#define EEID_GREP                         4207
#define EEID_WRAP_NONE                    4208
#define EEID_WRAP_BY_CHAR                 4209
#define EEID_WRAP_BY_WINDOW               4210
#define EEID_VIEW_TOOLBAR                 4211
#define EEID_VIEW_STATUS_BAR              4212
#define EEID_WATCH_CHAR_CODE              4213
#define EEID_NEXT_PANE                    4214
#define EEID_PREV_PANE                    4215
#define EEID_QUICK_MACRO_RECORD           4216
#define EEID_QUICK_MACRO_RUN              4217
#define EEID_FONT                         4218
#define EEID_CUSTOMIZE                    4219
#define EEID_CONFIG_POPUP                 4220
#define EEID_CONFIG                       4221
#define EEID_COMMON_SETTINGS              4222
#define EEID_FILE_ASSOCIATE               4223
#define EEID_CUSTOMIZE_TOOLBAR            4224
#define EEID_CUSTOMIZE_PLUG_INS           4238
#define EEID_WINDOW_ALWAYS_TOP            4239
#define EEID_WINDOW_SPLIT                 4240
#define EEID_WINDOW_CASCADE               4241
#define EEID_WINDOW_TILE_HORZ             4242
#define EEID_WINDOW_TILE_VERT             4243
#define EEID_WINDOW_MINIMIZE_ALL          4244
#define EEID_NEXT_WINDOW                  4245
#define EEID_PREV_WINDOW                  4246
#define EEID_HELP_FINDER                  4247
#define EEID_HELP_REGIST                  4248
#define EEID_WEB_HOME                     4249
#define EEID_APP_ABOUT                    4250
#define EEID_SELECT_WORD                  4251
#define EEID_FILE_SAVE_RENAME             4252
#define EEID_TAB_TO_SPACE                 4253
#define EEID_FILE_SAVE_UNICODE            4254
#define EEID_FILE_SAVE_UTF8               4255
#define EEID_FILE_SAVE_UTF7               4256
#define EEID_FILE_RELOAD_UNICODE          4257
#define EEID_FILE_RELOAD_UTF8             4258
#define EEID_FILE_RELOAD_UTF7             4259
#define EEID_FILE_SAVE_UNICODE_BIGENDIAN  4260
#define EEID_FILE_RELOAD_UNICODE_BIGENDIAN 4261
#define EEID_EDIT_PASTE_ANSI              4262
#define EEID_FILE_RELOAD_932              4263
#define EEID_DEFINE_CODE_PAGE             4264
#define EEID_FILE_SAVE_932                4265
#define EEID_CUSTOMIZE_MENU               4266
#define EEID_ALL_COMMANDS                 4267
#define EEID_NEXT_LOGICAL_LINE            4268
#define EEID_PREV_LOGICAL_LINE            4269
#define EEID_ALL_PROP                     4270
#define EEID_NEW_PASTE_PREFIX             4271
#define EEID_NEW_PASTE_PREFIX_RETURN      4272
#define EEID_CUSTOMIZE_TRAY               4273
#define EEID_INSERT_CR_LF                 4274
#define EEID_DELETE_RIGHT_WORD            4275
#define EEID_NEXT_PAREN                   4276
#define EEID_SHIFT_NEXT_PAREN             4277
#define EEID_TRIM_RIGHT                   4278
#define EEID_FILE_RELOAD_DETECT_ALL       4279
#define EEID_DELETE_LEFT_WORD             4280
#define EEID_NEW_CONFIG_POPUP             4281
#define EEID_FONT_POPUP                   4282
#define EEID_RELOAD_POPUP                 4283
#define EEID_DELETE_PANES                 4284
#define EEID_SHOW_PLUGINS_BAR             4285
#define EEID_PRINT_PREVIEW                4286
#define EEID_WINDOW_TOP                   4292
#define EEID_WINDOW_BOTTOM                4293
#define EEID_WINDOW_RIGHT                 4294
#define EEID_WINDOW_LEFT                  4295
#define EEID_HOME_TEXT                    4296
#define EEID_SHIFT_HOME_TEXT              4297
#define EEID_KEYBOARD_MAP                 4298
#define EEID_WINDOW_SPLIT_HORZ            4299
#define EEID_WINDOW_SPLIT_VERT            4300
#define EEID_CONTEXT_MENU                 4301
#define EEID_DELETE_LEFT_LINE             4302
#define EEID_INSERT_GRAVE                 4303
#define EEID_INSERT_ACUTE                 4304
#define EEID_INSERT_CIRCUMFLEX            4305
#define EEID_INSERT_TILDE                 4306
#define EEID_INSERT_DIAERESIS             4307
#define EEID_INSERT_RING_ABOVE            4308
#define EEID_INSERT_LIGATURE              4309
#define EEID_INSERT_CEDILLA               4310
#define EEID_INSERT_STROKE                4311
#define EEID_INSERT_INVERTED_QUESTION     4312
#define EEID_INSERT_INVERTED_EXCLAMATION  4313
#define EEID_INSERT_COPYRIGHT             4314
#define EEID_INSERT_REGISTERED            4315
#define EEID_INSERT_TRADEMARK             4316
#define EEID_INSERT_EURO                  4317
#define EEID_WRAP_BY_PAPER                4318
#define EEID_SHOW_TOOLS_BAR               4319
#define EEID_BOOKMARK_TOGGLE              4320
#define EEID_BOOKMARK_NEXT                4321
#define EEID_BOOKMARK_PREV                4322
#define EEID_BOOKMARK_CLEAR               4323
#define EEID_CUSTOMIZE_TOOLS              4324
#define EEID_RETRIEVE_FIND_TEXT           4325
#define EEID_COPY_FILE_PATH               4326
#define EEID_COPY_FILE_DIR                4327
#define EEID_DUPLICATE_LINE               4328
#define EEID_LOAD_WORKSPACE               4329
#define EEID_SAVE_WORKSPACE               4330
#define EEID_SAVE_WORKSPACE_EXIT_ALL      4331
#define EEID_SAVE_WORKSPACE_QUIT_ALL      4332
#define EEID_LOGICAL_HOME_TEXT            4333
#define EEID_SHIFT_LOGICAL_HOME_TEXT      4334
#define EEID_WINDOW_SPLIT_HORZ_FIX        4335
#define EEID_WINDOW_SPLIT_VERT_FIX        4336
#define EEID_SHOW_WINDOWS_BAR             4337
#define EEID_SHOW_BAR_TITLE               4340
#define EEID_LOCK_TOOLBARS                4341
#define EEID_WINDOW_COMBINE               4342
#define EEID_WINDOW_ALWAYS_TOP_ON         4343
#define EEID_WINDOW_ALWAYS_TOP_OFF        4344
#define EEID_MOVE_LAST_EDIT               4345
#define EEID_MACRO_SAVE                   4346
#define EEID_MACRO_SELECT                 4347
#define EEID_MACRO_EDIT                   4348
#define EEID_MACRO_SELECT_THIS            4349
#define EEID_CUSTOMIZE_MACRO              4350
#define EEID_BOOKMARK_NEXT_WITHIN         4351
#define EEID_BOOKMARK_PREV_WITHIN         4352
#define EEID_BOOKMARK_SET                 4353
#define EEID_BOOKMARK_RESET               4354
#define EEID_SPACE_TO_TAB                 4355
#define EEID_TABIFY                       4356
#define EEID_UNTABIFY                     4357
#define EEID_INDENT                       4358
#define EEID_UNINDENT                     4359
#define EEID_MACRO_HELP                   4360
#define EEID_MACRO_HELP_WORD              4361
#define EEID_REPLACE_IN_FILES             4362
#define EEID_QUIT_ALL                     4363
#define EEID_MACRO_RUN_OPTIONS            4364
#define EEID_INSERT_CARON                 4369
#define EEID_VIEW_MARKS                   4370
#define EEID_EDIT_COMMENT                 4371
#define EEID_EDIT_UNCOMMENT               4372
#define EEID_INCREASE_FONT_SIZE           4373
#define EEID_DECREASE_FONT_SIZE           4374
#define EEID_FIND_NEXT_UNICODE            4375
#define EEID_FIND_PREV_UNICODE            4376
#define EEID_ERASE_UNICODE_HILITE         4377

#define EEID_FILE_MRU_FILE1               4609  // to EEID_FILE_MRU_FILE1 + 63
#define EEID_MRU_FONT1                    4736  // to EEID_MRU_FONT1 + 63
#define EEID_FILE_MRU_INSERT1             4864  // to EEID_FILE_MRU_INSER1 + 63
#define EEID_FILE_MRU_FOLDER1             4992  // to EEID_FILE_MRU_FOLDER1 + 63
#define EEID_SELECT_CONFIG                5120  // to EEID_SELECT_CONFIG + 255
#define EEID_WINDOW_MENU                  5376  // to EEID_WINDOW_MENU + 255
#define EEID_PLUG_IN1                     5632  // to EEID_PLUG_IN1 + 255
#define EEID_FILE_RELOAD_DEFINED          6656  // to EEID_FILE_RELOAD_DEFINED + 255
#define EEID_FILE_NEW_CONFIG              7168  // to EEID_FILE_NEW_CONFIG + 255
#define EEID_FILE_SAVE_DEFINED            7680  // to EEID_FILE_SAVE_DEFINED + 255
#define EEID_TOOL1                        8192  // to EEID_TOOL1 + 255
#define EEID_MACRO1                       9216  // to EEID_MACRO1 + 1023

#define EEID_CHARSET_DEFAULT              8704
#define EEID_CHARSET_ARABIC               8705
#define EEID_CHARSET_BALTIC               8706
#define EEID_CHARSET_CENTRAL_EUROPE       8707
#define EEID_CHARSET_CHINESE_SIMPLIFIED   8708
#define EEID_CHARSET_CHINESE_TRADITIONAL  8709
#define EEID_CHARSET_CYRILLIC             8710
#define EEID_CHARSET_GREEK                8711
#define EEID_CHARSET_HEBREW               8712
#define EEID_CHARSET_JAPANESE             8713
#define EEID_CHARSET_KOREAN               8714
#define EEID_CHARSET_THAI                 8715
#define EEID_CHARSET_TURKISH              8716
#define EEID_CHARSET_VIETNAMESE           8717
#define EEID_CHARSET_WESTERN_EUROPE       8718
#define EEID_CHARSET_OEM                  8719

#define EEID_PROPERTY_MARGIN              8960
#define EEID_PROPERTY_SCROLL              8961
#define EEID_PROPERTY_FILE                8962
#define EEID_PROPERTY_BACKUP              8963
#define EEID_PROPERTY_AUTO_SAVE           8964
#define EEID_PROPERTY_ASSOCIATE           8965
#define EEID_PROPERTY_KINSOKU             8966
#define EEID_PROPERTY_FACE                8967
#define EEID_PROPERTY_HILITE              8968
#define EEID_PROPERTY_COMMENT             8969
#define EEID_PROPERTY_SHOW                8970
#define EEID_PROPERTY_MARK                8971
#define EEID_PROPERTY_PRINT               8972
#define EEID_PROPERTY_LINK                8973
#define EEID_PROPERTY_KEYBOARD            8974