

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
    *                                                                 *
    *   DEVIL Screensaver System 1.012                                *
    *   Copyright  2004 Sebastian Pipping <webmaster@hartwork.org>   *
    *                                                                 *
    *   --> http://www.hartwork.org                                   *
    *                                                                 *
    *                                                                 *
    *   This source code is released under LGPL.                      *
    *   See LGPL.txt for details.                                     *
    *                                                                 *
    *   Contact me for custom licenses.                  2004-09-22   *
    *                                                                 *
    \* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



#include "StdAfx.h"
// #include "devil_config.h"

#include <stdio.h>
#include <stdlib.h>



// Don't warn on int->bool
#pragma warning( disable : 4800 )



// *************************************************************************************
DEVIL_CONFIG::Init( const TCHAR * szCopySection, HMODULE hMod )
{
	// Save section name
	szSection = new TCHAR[ _tcslen( szCopySection ) + 1 ];
	_tcscpy( szSection, szCopySection );


	/*

	(1) Get the filename belonging to this process (e.g. "teston~1.scr")
	(2) We ensure we got the long filename to avoid trouble ("test one.scr")
	(3) We replace ".scr" by ".ini" ("test one.ini")

	*/


	szInipath = new TCHAR[ _MAX_PATH ];


	TCHAR szFull[ _MAX_PATH ] = TEXT( "" );
	TCHAR szDrive[ _MAX_DRIVE	] = TEXT( "" );
	TCHAR szDir[ _MAX_DIR	] = TEXT( "" );


	// Get our filename
	GetModuleFileName( hMod, szFull, _MAX_PATH );


	// Split it up
	_tsplitpath( szFull, szDrive, szDir, NULL, NULL );


	// Convert short to long path
	GetLongPathName( szDir, szDir, _MAX_DIR );


	// Convert short to long file
	WIN32_FIND_DATA fd;
	HANDLE h = FindFirstFile( szFull, &fd );


	// Search last dot
	TCHAR * szSearch = fd.cFileName + _tcslen( fd.cFileName ) - 1;
	while( ( *szSearch != TEXT( '.' ) ) && ( szSearch > fd.cFileName ) )
	{
		szSearch--;
	}


	// Replace extension
	// assert( szSearch > fd.cFileName );
	_tcscpy( szSearch, TEXT( ".ini" ) );


	// Copy full filename
	_sntprintf( szInipath, _MAX_PATH, TEXT( "%s%s%s" ), szDrive, szDir, fd.cFileName );
}



// *************************************************************************************
DEVIL_CONFIG::DEVIL_CONFIG( HMODULE hMod )
{
	Init( TEXT( "Config" ), hMod );
}



// *************************************************************************************
DEVIL_CONFIG::DEVIL_CONFIG( const TCHAR * szCopySection, HMODULE hMod )
{
	Init( szCopySection, hMod );
}



// *************************************************************************************
DEVIL_CONFIG::~DEVIL_CONFIG()
{
	if( NULL != szInipath )
	{
		delete [] szInipath;
	}
	if( NULL != szSection )
	{
		delete [] szSection;
	}
}



// *************************************************************************************
bool DEVIL_CONFIG::Write( const TCHAR * szKey, const double fValue )
{
	TCHAR szText[ 50 ] = TEXT( "" );
	_stprintf( szText, TEXT( "%.16f" ), fValue );
	return ( bool )WritePrivateProfileString( szSection, szKey, szText, szInipath );
}



// *************************************************************************************
bool DEVIL_CONFIG::Write( const TCHAR * szKey, const int iValue )
{
	TCHAR szNumber[ 12 ] = TEXT( "" );
	_stprintf( szNumber, TEXT( "%i" ), iValue );
	return ( bool )WritePrivateProfileString( szSection, szKey, szNumber, szInipath );
}



// *************************************************************************************
bool DEVIL_CONFIG::Write( const TCHAR * szKey, const TCHAR * szText )
{
	return ( bool )WritePrivateProfileString( szSection, szKey, szText, szInipath );
}



// *************************************************************************************
bool DEVIL_CONFIG::Read( const TCHAR * szKey, double * fOut, const double fDefault )
{
	TCHAR szDefault[ 50 ] = TEXT( "" );
	_stprintf( szDefault, TEXT( "%.16f" ), fDefault );

	TCHAR szOut[ 50 ] = TEXT( "" );
	bool res = ( bool )GetPrivateProfileString( szSection, szKey, szDefault, szOut, 20, szInipath );
	if( res )
	{
		*fOut = _tcstod( szOut, NULL );
	}
	return res;
}



// *************************************************************************************
bool DEVIL_CONFIG::Read( const TCHAR * szKey, int * iOut, const int iDefault )
{
	*iOut = GetPrivateProfileInt( szSection, szKey, iDefault, szInipath );
	return true;
}



// *************************************************************************************
bool DEVIL_CONFIG::Read( const TCHAR * szKey, TCHAR * szOut, const TCHAR * szDefault, UINT uSize )
{
	return ( bool )GetPrivateProfileString( szSection, szKey, szDefault, szOut, uSize, szInipath );
}



// *************************************************************************************
void DEVIL_CONFIG::get_inipath( TCHAR * szOut, UINT uSize )
{
	_tcsncpy( szOut, szInipath, uSize );
}
