#pragma once

#define  FLAG_UUENCODE  1
#define  FLAG_BASE64    2

int PASCAL WhichCharType( int xPos, const char* sz )
{
	int nDBCS = 0;
	_ASSERTE( xPos >= 0 );
	if( xPos >= lstrlen( sz ) )  return 0;
	char* psz = (char*)sz;
	for( int x=0; x<=xPos; x++ ){ 
		if( nDBCS == 1 ){
			psz++;
			nDBCS = 2;   // Second double byte char
		}
		else if( IsDBCSLeadByte( *psz++ ) )  nDBCS = 1;  // First double byte char
		else  nDBCS = 0;   // Not double byte char
	}
	return nDBCS;
}


char* PathToFile( const char* szPath )
{
	const char* p1 = _tcsrchr( szPath, '\\' );
	const char* p2 = _tcsrchr( szPath, '/' );
	const char* p3 = _tcsrchr( szPath, ':' );
	if( !p1 && !p2 && !p3 )  return (char*)szPath;
	return( (char*)max( p1, max( p2, p3 ) ) );
}

int dec64( char ch )
{
	if( ch >= 'A' && ch <= 'Z' )   return ch - 'A';
	if( ch >= 'a' && ch <= 'z' )   return ch - 'a' + 26;
	if( ch >= '0' && ch <= '9' )   return ch - '0' + 52;
	if( ch == '+' )  return 62;
	if( ch == '/' )  return 63;
	if( ch == '=' )  return 0;
	return -1;
}

int DecodeBase64(const char *ibuf, char *obuf)
{
	char *ip, *op;
	ip = (char*)ibuf;
	int nLen = lstrlen( ibuf ) + 1;
	char* strTemp = new char[ nLen ];
	op = strTemp;
	while( *ip != '\0' ){
		if( *ip == ' ' || *ip == '\t' || *ip == '\r' || *ip == '\n' ){
		}
		else if( *ip == '-' ){
			break;
		}
		else {
			if( dec64( *ip )  == -1 ){
				delete [] strTemp;
				return 0;  // illegal char
			}
			*op++ = *ip;
		}
		ip++;
	}
	ZeroMemory( op, nLen - (op - strTemp) );

	ip = strTemp;
	op = obuf;

	/* FOUR input characters go into each THREE output charcters */
	int j;
	while (*ip != '\0' && *(ip+1) != '\0' && *(ip+2) != '\0' && *(ip+3) != '\0') {
		j = dec64(ip[0]) << 2 | dec64(ip[1]) >> 4;
		*op++ = (char) j;
		j = dec64(ip[1]) << 4 | dec64(ip[2]) >> 2;
		*op++ = (char) j;
		j = dec64(ip[2]) << 6 | dec64(ip[3]) >> 0;
		*op++ = (char) j;
		if( ip[3] == '=' ){
			if( ip[2] == '=' ){
				op -= 2;
			}
			else {
				op--;
			}
			break;
		}
		ip += 4;
	}
	delete [] strTemp;
	*op = '\0';
	return (int)(op - obuf);
}

void JIStoSJIS( char* szOutput, const char* szInput )
{
	BOOL bKanji = FALSE;
	BOOL bHankakuKana = FALSE;
	char* pi = (char*)szInput;
	char* po = szOutput;
	char chLead = 0;
	int  nEscape = 0;
	while( *pi != '\0' ){
		if( nEscape == 1 ){
			if( *pi == '$' )  nEscape = 2;
			else if( *pi == '(' )  nEscape = 3;
			else nEscape = 0;
		}
		else if( nEscape == 2 ){
			if( *pi == 'B' || *pi == '@' ){
				bKanji = TRUE;
			}
			nEscape = 0;
		}
		else if( nEscape == 3 ){
			if( *pi == 'B' || *pi == 'J' || *pi == 'H' ){
				bKanji = FALSE;
			}
			nEscape = 0;
		}
		else if( nEscape == 0 ){
			if( *pi == '\x1b' ){
				nEscape = 1;
				chLead = 0;
			}
			else if( *pi == '\x0e' ){
				bHankakuKana = TRUE;
			}
			else if( *pi == '\x0f' ){
				bHankakuKana = FALSE;
			}
			else if( chLead != 0 ){
				WORD w = (WORD)_mbcjistojms( MAKEWORD( *pi, chLead ) );
				if( w != 0 ){
					*po++ = HIBYTE( w );
					*po++ = LOBYTE( w );
				}
				chLead = 0;
			}
			else {
				if( !bKanji ){
					if( bHankakuKana )  *po++ = (char)(BYTE)((BYTE)*pi | (BYTE)0x80);
					else  *po++ = *pi;
				}
				else {
					chLead = *pi;
				}
			}
		}
		pi++;
	}
	*po = '\0';
}

void DecodeHeader( char* szDest, size_t cchDest, const char* szSrc )
{
	char* pDest = szDest;
	char* pSrc = (char*)szSrc;
	char* p1;
	while( (p1 = strstr( pSrc, "=?" )) != NULL ){
		if( p1 != pSrc ){
			memcpy( pDest, pSrc, p1 - pSrc );
			pDest += (p1 - pSrc);
		}
		BOOL bSuccess = FALSE;
		if( _strnicmp( p1 + 2, "ISO-2022-JP?B?", 14 ) == 0 ){
			char* p3 = strstr( p1 + 16, "?=" );
			if( p3 != NULL ){
				char szTemp[MAX_PATH + 256];
				memcpy( szTemp, p1 + 16, p3 - (p1 + 16) );
				szTemp[p3 - (p1 + 16)] = '\0';
				char szTemp2[MAX_PATH + 256];
//				ZeroMemory( szTemp2, sizeof( szTemp2 ) );
				int nLen = DecodeBase64( szTemp, szTemp2 );
				if( nLen > 0 ){
					JIStoSJIS( szTemp, szTemp2 );
					memcpy( pDest, szTemp, lstrlen( szTemp ) );
					pDest += lstrlen( szTemp );
					bSuccess = TRUE;
					pSrc = p3 + 2;
				}
			}
		}
		if( !bSuccess ){
			pSrc = p1 + 2;
		}
	}
	StringCopy( pDest, cchDest, pSrc );
}

const char* szValidChar = " .$%'-_@~`!(){}^#&+,;=[]";

void GetValidFilename( char* szResult, const char* psz )
{
	char* pszResult = szResult;
	while( *psz != '\0' ){
		if( IsDBCSLeadByte( *psz ) ){
			*pszResult++ = *psz++;
			*pszResult++ = *psz++;
		}
		else if( IsCharAlphaNumeric( *psz ) || (BYTE)*psz > 128 || strchr( szValidChar, *psz ) != NULL ){
			*pszResult++ = *psz++;
		}
		else {
			*pszResult++ = ' ';
			psz++;
		}
	}
	*pszResult = '\0';
}

void MIMELinesToWord( char* szBuffer, const char* pszLines )
{
	char szTemp[MAX_PATH];
	char* pDest = szTemp;
	char* pSrc = (char*)pszLines;
	int i = sizeof( szTemp ) - 1;
	while( *pSrc ){
		while( *pSrc == ' ' || *pSrc == '\r' || *pSrc == '\n' || *pSrc == '\t' ){
			pSrc++;
		}
		*pDest++ = *pSrc++;
		if( --i == 0 )  break;
	}
	*pDest = '\0';
	char szBuffer2[MAX_PATH*4];
	DecodeHeader( szBuffer2, _countof( szBuffer2 ), szTemp );
	char* psz = PathToFile( szBuffer2 );
	if( lstrlen( psz ) >= MAX_PATH )  psz[MAX_PATH-1] = '\0';
	GetValidFilename( szBuffer, psz );
}

BOOL GetBase64File( const char* pszBlock, char* szFilename, char*& pszBegin )
{
	char* p = (char*)(const char*)pszBlock;

	char* p1 = strstr( p, "name=\"" );
	if( p1 != NULL ){
		p1 = p1 + 6;
		char* p2 = strchr( p1, '\"' );
		if( p2 != NULL ){
			char szTemp[MAX_PATH * 4];
			StringCopyN( szTemp, _countof( szTemp ), p1, p2 - p1 );
			p = strstr( p2, "\r\n\r\n" );
			if( p == NULL )  return FALSE;
			MIMELinesToWord( szFilename, szTemp );
		}
	}
	while( *p != '\0' ){
		while( *p == '\r' || *p == '\n' )  p++;
		if( *p == '\0' )  return FALSE;
		pszBegin = p;
		while( dec64( *p ) != -1 )  p++;
		if( *p == '\0' )  return FALSE;
		if( *p == '\r' && p > pszBegin + 16 ){
			return TRUE;
		}
		while( *p != '\r' && *p != '\0' )  p++;
	}
	return FALSE;
}

BOOL GetUuencodedFile( const char* pszCurrent, char* szFilename, char*& pszBegin )
{
	char* p;
	if( strncmp( pszCurrent, "begin ", 6 ) == 0 ){
		p = (char*)(const char*)pszCurrent;
	}
	else {
		p = (char*)strstr( pszCurrent, "\r\nbegin " );
	}
	if( p != NULL ){
		p += 8;
		while( *p == ' ' )  p++;
		if( *p >= '0' && *p <= '7') {
			while (*p >= '0' && *p <= '7') {
				p++;
			}
			if (*p == ' ') {
				p++;
				while (*p == ' ')  p++;
				if (*p != '\0') {
					char* p1 = strchr( p, '\r' );
					if( p1 != NULL ){
						StringCopyN( szFilename, MAX_PATH, p, p1 - p );
						pszBegin = p1 + 2;
						char* p2 = strstr( p1, "\r\nend" );
						if( p2 != NULL ){
							return TRUE;
						}
					}
				}
			}
		}
	}
	szFilename[0] = '\0';
	return FALSE;
}

int GetDecodeFile( const char* pszBlock, char*& pszBegin, char* szFilename )
{
	if( GetUuencodedFile( pszBlock, szFilename, pszBegin ) ){
		return FLAG_UUENCODE;
	}
	if( GetBase64File( pszBlock, szFilename, pszBegin ) ){
		return FLAG_BASE64;
	}
	return 0;
}

#define	SUMSIZE		64
#define	DEC(c)		(dec[c])
#define	VALID(c)	(isascii(c) && valid[c])
#define	uu_DEC(c)	(((c) - ' ') & 077)
#define	uu_VALID(c)	((' ' <= (c) && (c) <= '`') || (c) == 'f')
static char uu_dec[128];
static char uu_valid[128];
static char xx_dec[128];
static char xx_valid[128];
static int code_type;
static int checksum_type;
static int	no_check = 0;

void InitializeUudecode()
{
	int i;
	for (i = 0; i < 128; i++) {
		uu_dec[i] = (char) uu_DEC(i);
		uu_valid[i] = (char) uu_VALID(i);
		xx_dec[i] = 0;
		xx_valid[i] = 0;
	}

	xx_dec['+'] = 0;
	xx_valid['+'] = 1;
	xx_dec['-'] = 1;
	xx_valid['-'] = 1;
	for (i = 0; i < 10; i++) {
		xx_dec['0' + i] = (char) (i + 2);
		xx_valid['0' + i] = 1;
	}
	for (i = 0; i < 26; i++) {
		xx_dec['A' + i] = (char) (i + 12);
		xx_valid['A' + i] = 1;
		xx_dec['a' + i] = (char) (i + 38);
		xx_valid['a' + i] = 1;
	}
	code_type = -1;
	checksum_type = -1;
}

char* GetNextLineString( char*& pBuf, int& nLen )
{
	nLen = 0;
	if( pBuf == NULL || *pBuf == '\0' )  return NULL;
	char* pStart = pBuf;
	while( *pBuf != '\r' && *pBuf != '\0' ){
		pBuf++;
	}
	nLen = (int)(pBuf - pStart);
	if( *pBuf != '\0' ){
		*pBuf++ = '\0';
		if( *pBuf == '\n' ){
			pBuf++;
		}
	}
	return pStart;
}

int decode(char *valid, char *dec, char *ibuf, char *obuf)
{
	int len, n, j, cst, l;
	int checksum1, checksum2;
	char *ip, *op;

	if (!no_check && !VALID(ibuf[0])) {
		return -1;
	}
	if (no_check && !(ibuf[0] >= ' ' && ibuf[0] < 0x7f)) {
		return -1;
	}
	len = DEC(ibuf[0]);
	n = (len + 2) / 3;
	if (no_check) {
		l = (int)strlen(ibuf);
		while (ibuf[l - 1] == '\n' || ibuf[l - 1] == '\r') {
			l--;
		}
		if (l > n * 4 + 2) {
			return -1;
		}
		if (l < n * 4 + 1) {
			while (l < n * 4 + 1) {
				ibuf[l++] = ' ';
			}
			ibuf[l] = '\0';
		}
	}
	ip = ibuf + 1;
	op = obuf;
	checksum1 = 0;
	checksum2 = 0;

	/* FOUR input characters go into each THREE output charcters */
	while (n > 0) {
		if (!no_check
			&& !(VALID(ip[0]) && VALID(ip[1])
				 && VALID(ip[2]) && VALID(ip[3]))) {
			return -1;
		}
		j = DEC(ip[0]) << 2 | DEC(ip[1]) >> 4;
		*op++ = (char) j;
		checksum1 += j;
		j = DEC(ip[1]) << 4 | DEC(ip[2]) >> 2;
		*op++ = (char) j;
		checksum1 += j;
		j = DEC(ip[2]) << 6 | DEC(ip[3]) >> 0;
		*op++ = (char) j;
		checksum1 += j;
		checksum1 %= SUMSIZE;
		checksum2 += (ip[0] + ip[1] + ip[2] + ip [3]) & 0x3f;
		checksum2 %= SUMSIZE;
		ip += 4;
		n--;
	}

	if (!no_check) {
		cst = -1;
		if (checksum_type == -1) {
			cst = 0;
			if (VALID(*ip)) {
				if (!(checksum1 == DEC(*ip) || checksum2 == DEC(*ip))) {
					return -1;
				}
				ip++;
				cst = 1;
			} else if (isascii(*ip) && islower(*ip)) {
				ip++;
				cst = 2;
			}
		} else if (checksum_type == 1) {
			if (!VALID(*ip)
				|| !(checksum1 == DEC(*ip) || checksum2 == DEC(*ip))) {
				return -1;
			}
			ip++;
		} else if (checksum_type == 2) {
			if (!(isascii(*ip) && islower(*ip))) {
				return -1;
			}
			ip++;
		}
		if (*ip != '\0' && *ip != '\n' && *ip != '\r') {
			return -1;
		}
		if (cst != -1) {
			checksum_type = cst;
		}
	}
	return len;
}

int xdecode(char *ibuf, char *obuf)
{
	int n;

	n = 0;
	if (code_type == -1) {
		if ((n = decode(uu_valid, uu_dec, ibuf, obuf)) > 0) {
			code_type = 1;
		} else if ((n = decode(xx_valid, xx_dec, ibuf, obuf)) > 0) {
			code_type = 2;
		}
	} else if (code_type == 1) {
		n = decode(uu_valid, uu_dec, ibuf, obuf);
	} else if (code_type == 2) {
		n = decode(xx_valid, xx_dec, ibuf, obuf);
	}
	return n;
}

BOOL DecodeEnclosure( const char* szDestPath, const char* szText, int nKind )
{
	CWaitCursor cursor;
	BOOL bSuccess = FALSE;
	HANDLE hFile = CreateFile( szDestPath, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, 0, NULL );
	if( hFile == INVALID_HANDLE_VALUE )  return FALSE;
	char* buf = new char[strlen( szText ) + 256];
	if( nKind == FLAG_BASE64 ){
		int nLen = DecodeBase64( szText, buf );
		if( nLen > 0 ){
			DWORD dwWritten;
			WriteFile( hFile, buf, nLen, &dwWritten, NULL );
			bSuccess = (nLen == (int)dwWritten);
		}
	}
	else if( nKind == FLAG_UUENCODE ) {
		InitializeUudecode();
		int nLen0;
		int n;
		char* pOutBuf = buf;
		char* pBuf = new char[strlen( szText ) + 1];
		char* pBuf0 = pBuf;
		if( pBuf != NULL ) {
			StringCopy( pBuf, strlen( szText ) + 1, szText );
			char* szLine = GetNextLineString( pBuf, nLen0 );
			while( szLine != NULL ){
				if( nLen0 == 3 && lstrcmp( szLine, "end" ) == 0 ){
					bSuccess = TRUE;
					break;
				}
				n = xdecode(szLine, pOutBuf);
				if( n < 0 )  break;
				pOutBuf += n;
				szLine = GetNextLineString( pBuf, nLen0 );
			}
		}
		delete [] pBuf0;
		if( bSuccess ){
			DWORD dwWritten;
			WriteFile( hFile, buf, (DWORD)(pOutBuf - buf), &dwWritten, NULL );
			bSuccess = (pOutBuf - buf == (int)dwWritten);
		}

	}
	delete [] buf;
	CloseHandle( hFile );
	return bSuccess;
}

BOOL DecodeText( HWND hwnd, const char* pszBlock, const char* pszFilename, int nKind )
{
	TCHAR szFile[MAX_PATH];
	StringCopy( szFile, _countof( szFile ), pszFilename );
	OPENFILENAME ofn;
	ZeroMemory( &ofn, sizeof( ofn ) );
	ofn.lStructSize = sizeof( ofn );
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = _countof( szFile );
	ofn.Flags = OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;

	if( !GetSaveFileName( &ofn ) )  return FALSE;

	if( DecodeEnclosure( szFile, pszBlock, nKind ) ){
		TCHAR sz[256];
		LoadString( EEGetInstanceHandle(), IDS_COMPLETE, sz, _countof( sz ) );
		TCHAR szTitle[256];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szTitle, _countof( szTitle ) );
		MessageBox( hwnd, sz, szTitle, MB_OK | MB_ICONINFORMATION );
	}
	else {
		TCHAR sz[256];
		LoadString( EEGetInstanceHandle(), IDS_NOT_DECODABLE_TEXT, sz, _countof( sz ) );
		TCHAR szTitle[256];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szTitle, _countof( szTitle ) );
		MessageBox( hwnd, sz, szTitle, MB_OK | MB_ICONEXCLAMATION );
	}
	return TRUE;
}

void GetFilenameAndDecodeText( HWND hwnd, const char* pszBlock )
{
	char* pszBegin;
	char szFilename[MAX_PATH];
	int nKind = GetDecodeFile( pszBlock, pszBegin, szFilename );
	if( nKind == 0 ){
		TCHAR sz[256];
		LoadString( EEGetInstanceHandle(), IDS_NOT_DECODABLE_TEXT, sz, _countof( sz ) );
		TCHAR szTitle[256];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szTitle, _countof( szTitle ) );
		MessageBox( hwnd, sz, szTitle, MB_OK | MB_ICONEXCLAMATION );
	}
	else {
		if( szFilename[0] == '\0' )  LoadString( EEGetInstanceHandle(), IDS_NO_NAME, szFilename, _countof( szFilename ) );
		DecodeText( hwnd, pszBegin, szFilename, nKind );
	}
}


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	int g_nMode;

	CMyFrame()
	{
		g_nMode = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
		UINT_PTR pnBufLen = Editor_GetSelTextA( hwndView, 0, NULL);
		char* pBuf = new char[pnBufLen];
		Editor_GetSelTextA( hwndView, pnBufLen, pBuf );
		GetFilenameAndDecodeText( hwndView, pBuf );
		delete [] pBuf;
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	BOOL SetProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	// user defined methods below.

};


// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

