#pragma once

// forward declaration
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

#define MODE_HTML	0
#define MODE_UCN	1
#define MAX_MODE	2

LPCTSTR szMode = _T("Mode");
LPCWSTR aszPrefix[MAX_MODE] = {L"&#", L"\\u"};

WCHAR HexToChar( LPWSTR& p )
{
	WCHAR sz[5];
	WCHAR* po = sz;
	*po++ = *p++;
	if( *p != '\0' ){
		*po++ = *p++;
		if( *p != '\0' ){
			*po++ = *p++;
			if( *p != '\0' ){
				*po++ = *p++;
			}
		}
	}
	*po++ = '\0';
	return (WCHAR)wcstoul( sz, NULL, 16 );
}

WCHAR DecToChar( LPWSTR& p )
{
	WCHAR sz[6];
	WCHAR* po = sz;
	*po++ = *p++;
	if( *p != '\0' && *p != ';' ){
		*po++ = *p++;
		if( *p != '\0' && *p != ';' ){
			*po++ = *p++;
			if( *p != '\0' && *p != ';' ){
				*po++ = *p++;
				if( *p != '\0' && *p != ';' ){
					*po++ = *p++;
				}
			}
		}
	}
	if( *p++ != ';' ) {
		return 0;
	}
	*po++ = '\0';
	return (WCHAR)wcstoul( sz, NULL, 10 );
}


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	int g_nMode;

	CMyFrame()
	{
		g_nMode = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
		LoadProfile();
		if( g_nMode < 0 || g_nMode > MAX_MODE )  return;
		UINT_PTR nBufLen = Editor_GetSelTextW( hwndView, 0, NULL);
		LPWSTR pBuf = new WCHAR[nBufLen];
		if( !pBuf )  return;
		Editor_GetSelTextW( hwndView, nBufLen, pBuf );
		LPCWSTR szPrefix = aszPrefix[g_nMode];
		size_t nPrefixLen = wcslen( szPrefix );
		bool bHex = g_nMode == MODE_UCN ? true : false;

		LPWSTR p = pBuf;
		while( *p ){
			p = wcsstr( p, szPrefix );
			if( p == NULL )  break;
			LPWSTR p0 = p;
			p += nPrefixLen;
			WCHAR c;
			if( bHex ){
				c = HexToChar( p );
			}
			else {
				c = DecToChar( p );
			}
			if( c != 0 ){
				*p0++ = c;
				memmove( p0, p, (wcslen( p ) + 1) * sizeof(WCHAR) );
				p = p0;
			}
		}

		Editor_InsertStringW( hwndView, pBuf );

		delete [] pBuf;
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			TCHAR szKey[MAX_PATH];
			if( GetRootKeyName( szKey ) ){
				RegDeleteKey( HKEY_CURRENT_USER, szKey );
			}
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	// user defined methods below.
	void LoadProp( HKEY hKey )
	{
		g_nMode = GetProfileIntReg( hKey, szMode, MODE_HTML );
	}

	BOOL LoadProfile()
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			LoadProp( hKey );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	void SaveProp( HKEY hKey )
	{
		WriteProfileIntReg( hKey, szMode, g_nMode );
	}

	BOOL SaveProfile()
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			SaveProp( hKey );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		LoadProfile();
		CheckRadioButton( hwnd, IDC_HTML, IDC_UCN, IDC_HTML + g_nMode );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WORD wCmdID )
	{
		switch( wCmdID ){
		case IDOK:
			{
				g_nMode = IsDlgButtonChecked( hwnd, IDC_UCN ) ? MODE_UCN : MODE_HTML;
				SaveProfile();
				EndDialog( hwnd, IDOK );
			}
			break;
		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
	}

};

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	}
	return bResult;
}

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT


