#include "optionsDlg.h"
#include "tools.h"
#include <algorithm>
#include <map>
#include <tchar.h>
#include "plugin.h"
#include "resource.h"

using namespace std;

//////////////////////////////////////////////////////////////////////////////

namespace {


//	󔒕Q	SpXy[X܂ނۂ
const wchar_t* const	spacesWithIdeographicSpace(		L"\x0009\x000B\x000C\x0020\x0085\x00A0\x1680\x2000\x2001\x2002\x2003\x2004\x2005\x2006\x2007\x2008\x2009\x200A\x200B\x2028\x2029\x3000\xFEFF" );
const wchar_t* const	spacesWithoutIdeographicSpace(	L"\x0009\x000B\x000C\x0020\x0085\x00A0\x1680\x2000\x2001\x2002\x2003\x2004\x2005\x2006\x2007\x2008\x2009\x200A\x200B\x2028\x2029\xFEFF" );

};


//////////////////////////////////////////////////////////////////////////////

//	r
namespace {

struct DINF {
	static HWND				hwnd;
	static LONG_PTR			active;
	static const wchar_t*	spaces;

	LONG_PTR		tab;		//	^uCfbNX
	LONG_PTR		lines;		//	s
	POINT_PTR		scroll;		//	XN[ʒu
	POINT_PTR		first;		//	ŏ̃Lbgʒu
	POINT_PTR		caret;		//	ƒʒu
	vector<wchar_t>	text;		//	ƒ
	const wchar_t*	begin;		//	ƍs̐[
	const wchar_t*	end;		//	ƍs̏I[
	LONG_PTR		length;		//	ƍs̒

	//	RXgN^
	DINF( LONG_PTR tab_ ): tab(tab_) {
		ShiftActive();
		//	s擾
		lines = Editor_DocGetLines( hwnd, (int)tab, POS_LOGICAL_W );
		//	XN[ʒu擾
		Editor_GetScrollPos( hwnd, &scroll );
		//	Lbgʒu擾
		Editor_GetCaretPos( hwnd, POS_VIEW,		 &first );
		Editor_GetCaretPos( hwnd, POS_LOGICAL_W, &caret );
		//	Lbgs̕擾
		GetText();
	}
	
	//	^uANeBułȂ悤ȂANeBuɂ
	void	ShiftActive( void ){
		if( active != tab ){
			active  = tab;
			Editor_DocInfo( hwnd, (int)active, EI_SET_ACTIVE_INDEX, 0 );
		}
	}
	
	//	Lbgʒu߂
	void	RestoreCaretPos( void ){
		ShiftActive();
		Editor_SetCaretPos(  hwnd, POS_VIEW, &first );
		Editor_SetScrollPos( hwnd, &scroll );
	}
	
	//	ƈʒuɃLbgړ
	void	MoveCaret( const wchar_t* it ){
		if( it ){
			ShiftActive();
			caret.x = it - &text[0];
			Editor_SetCaretPos( hwnd, POS_LOGICAL_W | POS_SCROLL_CENTER, &caret );
		}
	}
	
	//	ƍs̕擾
	void	GetText( void ){
		GET_LINE_INFO	inf = { 0, MAKELONG( FLAG_LOGICAL, tab + 1 ), caret.y };
		LONG_PTR len( Editor_GetLineW( hwnd, &inf, NULL ) + 2 );
		if( (LONG_PTR)text.size() < len ){
			text.erase( text.begin(), text.end() );
			text.resize( len + 128 );
		}
		inf.cch = text.size();
		Editor_GetLineW( hwnd, &inf, &text[0] );
		end		= &text[wcslen(&text[0])];
		begin	= min( &text[caret.x], end );
		length	= end - begin;
	}

	//	ƍsύX
	void	NextLine( void ){
		caret.x = 0;
		++caret.y;
		GetText();
	}

	//	󔒂XLbv
	const wchar_t*	SkipSpace( const wchar_t* ptr ){
		if( *ptr && wcschr( spaces, *ptr ) ){
			const wchar_t* p( _wcsspnp( &ptr[1], spaces ) );
			ptr = p ? p : (ptr + wcslen(ptr));
		}
		return	ptr;
	}

	//	sXLbv
	bool	SkipNullLine( void ){
		if( !text[0] ){
			NextLine();
			return	true;
		}
		return	false;
	}
};
HWND			DINF::hwnd;
LONG_PTR		DINF::active = -1;
const wchar_t*	DINF::spaces;

//	r
void	Compare( HWND hwnd, LONG_PTR current_, LONG_PTR target_ )
{
	bool	ignoreSpace(	GetRegBool( hwnd, keyIgnoreSpace		 ) );	//	󔒂𖳎
	bool	ignoreNullLine(	GetRegBool( hwnd, keyIgnoreNullLine		 ) );	//	s𖳎
	bool	caseSensitive(	GetRegBool( hwnd, keyCaseSensitive, true ) );	//	啶ʂ

	//	󔒏ǂݍ
	vector<wchar_t>	spaces;
	LoadSpaces( hwnd, spaces );

	DINF::hwnd	 = hwnd;
	DINF::active = -1;
	DINF::spaces = &spaces[0];
	DINF	current( current_ );
	DINF	target(	 target_  );
	while( current.caret.y < current.lines && target.caret.y < target.lines ){

		//	s̈
		if( !ignoreNullLine || ignoreSpace || !(current.SkipNullLine() || target.SkipNullLine()) ){

			const wchar_t *pCur( current.begin ), *pTgt( target.begin );
			do{
				if( ignoreSpace ){
					//	󔒂𖳎
					pCur = current.SkipSpace( pCur );
					pTgt = target .SkipSpace( pTgt );
					if( ignoreNullLine ){
						//	s𖳎
						bool ret( false );
						if( !*pCur && (current.caret.y < current.lines - 1) ){	current.NextLine();	pCur = current.begin;	ret = true;	}
						if( !*pTgt && (target .caret.y < target .lines - 1) ){	target .NextLine();	pTgt = target .begin;	ret = true;	}
						if( ret ) continue;
					}
				}

				bool	discrepancy;
				if( caseSensitive ){
					//	啶ʂ
					discrepancy = *pCur != *pTgt;
				}else{
					//	啶rȂiɕϊĂrj
					discrepancy = towlower(*pCur) != towlower(*pTgt);
				}

				if( discrepancy ){
					//	_𔭌AɃLbgړrI
					target .MoveCaret( pTgt );
					current.MoveCaret( pCur );
					MessageBox( GetTopParent( hwnd ), GetStringFromTable(IDS_DISCREPANCY).c_str(), GetStringFromTable(IDS_NAME).c_str(), MB_OK | MB_ICONINFORMATION );
					return;
				}
				++pCur;
				++pTgt;
			}while( pCur <= current.end && pTgt <= target.end );

			//	s
			current.NextLine();
			target .NextLine();
		}
	}
	//	rE_
	current.ShiftActive();
	MessageBox( GetTopParent( hwnd ), GetStringFromTable(IDS_COMPLATE).c_str(), GetStringFromTable(IDS_NAME).c_str(), MB_OK );
}

};

//	j[c[o[vOCIƂɌĂяo܂ 
EXTERN_C void	WINAPI OnCommand( HWND hwnd )
{
	//	ANeBuȃhLg
	LONG_PTR active( Editor_Info( hwnd, EI_GET_ACTIVE_INDEX, 0 ) );

	//	hLgXg
	LONG_PTR	count( Editor_Info( hwnd, EI_GET_DOC_COUNT, 0 ) );
	map<LONG_PTR,LONG_PTR>	docs;
	for( LONG_PTR index(0) ; index < count ; ++index ){
		HEEDOC doc( (HEEDOC)Editor_Info( hwnd, EI_INDEX_TO_DOC, (LPARAM)index ) );
		if( doc ){
			LONG_PTR z( Editor_Info( hwnd, EI_DOC_TO_ZORDER, (LPARAM)doc ) );
			docs[z] = index;
		}
	}
	vector<DITEM>	files;
	for( map<LONG_PTR,LONG_PTR>::iterator it(docs.begin()), e(docs.end()) ; it != e ; ++it ){
		if( it->second != active )
			files.push_back( DITEM( hwnd, it->second ) );
	}
	if( files.empty() ){
		MessageBeep( MB_ICONEXCLAMATION );
		return;
	}

	//	r
	if( files.size() >= 2 || GetRegBool( hwnd, keyAlwaysSelector ) ){
		//	^[QbgIAr
		size_t	index( ChoiceTargetFile( hwnd, files ) );
		if( index < files.size() ){
			Compare( hwnd, active, files[index].index );
		}
	}else{
		//	rJn
		Compare( hwnd, active, files.front().index );
	}
}


//////////////////////////////////////////////////////////////////////////////

//	ԂύXꂽƂɃCxgw肳ČĂяo܂ 
EXTERN_C void	WINAPI OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam ) 
{
}


//////////////////////////////////////////////////////////////////////////////

//	vOCs\A܂̓`FbNꂽԂ𒲂ׂ܂ 
EXTERN_C BOOL	WINAPI QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	if( pbChecked ) *pbChecked = false;
	return	true;
}

//	vOC̏擾
namespace {
LRESULT	GetInfo( UINT_PTR flag )
{
	switch( flag ){
	case EPGI_ALLOW_OPEN_SAME_GROUP:	return	true;		//	t@C𓯂O[vŊJƂꍇ TRUE Ԃ܂B 
	case EPGI_ALLOW_MULTIPLE_INSTANCES:	return	true;		//	vOCCX^XT|[gꍇ TRUE Ԃ܂BvOC 2 ȏ̃t[œɓ삷邱Ƃꍇɂ́ÃbZ[W TRUE ԂKv܂BCX^XsĂԁAO[oϐ͋L邱ƂɒӂĂB 
	case EPGI_MAX_EE_VERSION:			return	99 * 1000;	//	ΉƂV EmEditor ̃o[Wԍ * 1000 Ԃ܂B	Ƃ肠EEE
	case EPGI_MIN_EE_VERSION:			return	 7 * 1000;	//	ΉƂÂ EmEditor ̃o[Wԍ * 1000 Ԃ܂B 
	case EPGI_SUPPORT_EE_PRO:			return	true;		//	EmEditor Professional T|[gꍇ TRUE Ԃ܂B 
	case EPGI_SUPPORT_EE_STD:			return	true;		//	EmEditor Standard T|[gꍇ TRUE Ԃ܂B 
	}
	return	0;
}
};

//	vOCւ̃bZ[WgāA܂܂Ȑݒ擾s܂B 
EXTERN_C LRESULT	WINAPI PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam ) 
{
	switch( nMsg ){
	case EP_GET_BITMAP:			return	0;																//	c[o[ɕ\lXȃTCYƐF̃vOC {^̃rbg}bṽ\[XID擾܂B
	case EP_GET_INFO:			return	GetInfo( wParam );												//	vOCɊւ邳܂܂ȏ擾܂B(Version 5.00 ȏőΉ)
	case EP_GET_MASK:			return	RGB(255,0,255);													//	c[o[ɕ\vOC {^̃}XN J[擾܂
	case EP_GET_NAME:			return	GetStringFromTable( IDS_NAME,	 wParam, (wchar_t*)lParam );	//	vOC̖O擾܂B
	case EP_GET_VERSION:		return	GetStringFromTable( IDS_VERSION, wParam, (wchar_t*)lParam );	//	vOC̃o[W擾܂B
	case EP_QUERY_PROPERTIES:	return	true;															//	vpeBp\ǂ𒲂ׂ܂B
	case EP_SET_PROPERTIES:		return	ShowProperty( hwnd );											//	vpeB̕\w܂B
	case EP_QUERY_UNINSTALL:	return	true;															//	ACXg[p\ǂ𒲂ׂ܂B
	case EP_SET_UNINSTALL:		return	UNINSTALL_SIMPLE_DELETE;										//	ACXg[s܂B
	case EP_PRE_TRANSLATE_MSG:	return	false;															//	Windows bZ[WϊOɌĂяo܂B
	}
	return	0;
}

//	\[XID擾
EXTERN_C UINT	WINAPI GetMenuTextID(){			return	IDS_MENUTEXT;		}	//	vOC̃j[ACeeLXg̃\[XID擾܂ 
EXTERN_C UINT	WINAPI GetStatusMessageID(){	return	IDS_STATUSMESSAGE;	}	//	Xe[^Xo[eLXgƃc[o[̃c[`bvpeLXg \n Ō̃\[XID擾܂B 
EXTERN_C UINT	WINAPI GetBitmapID(){			return	IDB_BUTTON;			}	//	c[o[ɕ\vOC {^̃rbg}bṽ\[XID擾܂ 


//////////////////////////////////////////////////////////////////////////////

//	C
EXTERN_C BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved )
{
	switch( dwReason ){
	case DLL_PROCESS_ATTACH:	instance = hinstDLL;	break;	//	vZXɃA^b`Ƃ
	case DLL_PROCESS_DETACH:							break;	//	vZXf^b`Ƃ
	}
	return	true;
}

//////////////////////////////////////////////////////////////////////////////
