#include "tools.h"
#include "plugin.h"
#include "resource.h"

using namespace std;

//	CX^Xnh
HINSTANCE	instance;

//	XgOe[u當擾
wstring	GetStringFromTable( UINT id )
{
	wchar_t	name[4096];
	return	LoadStringW( instance, id, name, (int)GetArraySize(name) ) ? name : std::wstring();
}


//	XgOe[u當擾
LONG_PTR	GetStringFromTable( UINT id, UINT_PTR cb, wchar_t* buf )
{
	//	XgOe[u烍[h
	wchar_t	name[4096];
	if( !LoadStringW( instance, id, name, (int)GetArraySize(name) ) ) *name = NULL;

	//	vĂ΃Rs[
	if( buf && cb > 0 )
		wcscpy_s( buf, cb, name );

	//	+1Ԃ
	return	wcslen(name) + 1;
}

//	łẽEBhET
HWND	GetTopParent( HWND hwnd )
{
	HWND	hw;
	while(	hw = GetParent(hwnd) ) hwnd = hw;
	return	hwnd;
};

//	IvV擾	TCY
DWORD	GetRegSize( HWND wnd, const wchar_t* key )
{
	DWORD	size(0);
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_BINARY, NULL, &size, 0 ) == ERROR_SUCCESS) ? size : 0;
}

//	IvV擾	_l
bool	GetRegBool( HWND wnd, const wchar_t* key, bool defaultValue )
{
	DWORD	value( defaultValue  );
	DWORD	size(  sizeof(value) );
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, (BYTE*)&value, &size, 0 ) == ERROR_SUCCESS && size == sizeof(value)) ? (value != 0) : defaultValue;
}

//	IvVݒ	_l
void	SetRegBool( HWND wnd, const wchar_t* key, bool newValue )
{
	DWORD	value( newValue ? 1 : 0 );
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, (BYTE*)&value, sizeof(value), 0 );
}

//	IvV擾	32bit
INT32	GetRegInt32( HWND wnd, const wchar_t* key, INT32 defaultValue )
{
	DWORD	value( defaultValue  );
	DWORD	size(  sizeof(value) );
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, (BYTE*)&value, &size, 0 ) == ERROR_SUCCESS && size == sizeof(value)) ? value : defaultValue;
}

//	IvVݒ	32bit
void	SetRegInt32( HWND wnd, const wchar_t* key, INT32 newValue )
{
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, (BYTE*)&newValue, sizeof(newValue), 0 );
}

//	IvV擾	
wstring	GetRegString( HWND wnd, const wchar_t* key, const wchar_t* defaultValue )
{
	wchar_t	buf[4096];
	DWORD	size( sizeof(buf) - sizeof(wchar_t) );
	if( Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_SZ, (BYTE*)buf, &size, 0 ) == ERROR_SUCCESS ){
		buf[GetArraySize(buf) - 1] = L'\0';
		return	buf;
	}
	return	defaultValue ? defaultValue : L"";
}

//	IvVݒ	
void	SetRegString( HWND wnd, const wchar_t* key, const wchar_t* newValue )
{
	if( !newValue ) newValue = L"";
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_SZ, (BYTE*)&newValue, ((DWORD)wcslen(newValue) + 1) * sizeof(wchar_t), 0 );
}

//	IvV擾	oCi
bool	GetRegBinary( HWND wnd, const wchar_t* key,	DWORD& size, void* buffer )
{
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_BINARY, (BYTE*)buffer, &size, 0 ) == ERROR_SUCCESS);
}

//	IvVݒ	oCi
void	SetRegBinary( HWND wnd, const wchar_t* key,	DWORD size, const void* buffer )
{
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_BINARY, (BYTE*)buffer, size, 0 );
}
