#include "optionsDlg.h"
#include "tools.h"
#include "plugin.h"
#include "resource.h"

using namespace std;

namespace {

const wchar_t* const	keySelectWidth(		L"SELECT_WIDTH"			);
const wchar_t* const	keySelectHeight(	L"SELECT_HEIGHT"		);
const wchar_t* const	keyAdvanceOption(	L"SpacesAdvanceOption"	);
const wchar_t* const	keySpaces(			L"Spaces"				);

};

//	󔒕̑I  //////////////////////////////////////////////////////////

/*	 .NET framework  Char::IsWhiteSpace  ^Ԃ
SpaceSeparator JeS
White_Space # Zs
	0020 SPACE						pXy[X
	00A0 NO-BREAK SPACE
	1680 OGHAM SPACE MARK
	180E MONGOLIAN VOWEL SEPARATOR
	2000 EN QUAD 
	2001 EM QUAD
	2002 EN SPACE
	2003 EM SPACE
	2004 THREE-PER-EM SPACE
	2005 FOUR-PER-EM SPACE
	2006 SIX-PER-EM SPACE
	2007 FIGURE SPACE
	2008 PUNCTUATION SPACE
	2009 THIN SPACE
	200A HAIR SPACE
	202F NARROW NO-BREAK SPACE
	205F MEDIUM MATHEMATICAL SPACE
	3000 IDEOGRAPHIC SPACE			SpXy[X

LineSeparator JeS
Pattern_White_Space # Zl
	2028 LINE SEPARATOR

ParagraphSeparator JeS
Pattern_White_Space # Zp
	2029 PARAGRAPH SEPARATOR

Control JeS
White_Space # Cc
	0009 CHARACTER TABULATION	^u
	000A LINE FEED				LF MaxOS s
	000B LINE TABULATION
	000C FORM FEED
	000D CARRIAGE RETURN		CR Unix s
	0085 NEXT LINE
*/

//	󔒕Q擾
bool	LoadSpaces( HWND em, vector<wchar_t>& spaces )
{
	DWORD	size( GetRegSize( em, keySpaces ) );
	if( size > 0 ){
		spaces.erase( spaces.begin(), spaces.end() );
		spaces.reserve( size / sizeof(wchar_t) + 1 );
		spaces.resize(  size / sizeof(wchar_t) );
		size = (DWORD)spaces.size() * sizeof(wchar_t);
		if( GetRegBinary( em, keySpaces, size, &spaces[0] ) ){
			spaces.push_back( L'\0' );
			return	true;
		}
	}

	spaces.erase( spaces.begin(), spaces.end() );
	spaces.reserve( 3 );
	spaces.push_back( L'\x0020' );	//	pSpace
	spaces.push_back( L'\x0009' );	//	^u
	spaces.push_back( L'\0' );
	return	false;
}

namespace {

//	󔒕̑I_CAOvV[W
INT_PTR CALLBACK SelectSpacesDlgProc( HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	static HWND	em;
	static RECT	originalRect;

	switch( msg ){
	case WM_INITDIALOG:{	//	IvV_CAO
			em = (HWND)lParam;

			//	TCY擾
			GetWindowRect( dlg, &originalRect );

			//	󔒕Q
			vector<wchar_t>	spaces;
			LoadSpaces( em, spaces );
			for( vector<wchar_t>::iterator it(spaces.begin()), e(spaces.end()) ; it != e ; ++it ){
				switch( *it ){
				case L'\x0020':	CheckDlgButton( dlg, IDC_SPACE,						true	);	break;
				case L'\x3000':	CheckDlgButton( dlg, IDC_IDEOGRAPHIC_SPACE,			true	);	break;
				case L'\x0009':	CheckDlgButton( dlg, IDC_CHARACTER_TABULATION,		true	);	break;
				case L'\x00A0':	CheckDlgButton( dlg, IDC_NO_BREAK_SPACE,			true	);	break;
				case L'\x1680':	CheckDlgButton( dlg, IDC_OGHAM_SPACE_MARK,			true	);	break;
				case L'\x180E':	CheckDlgButton( dlg, IDC_MONGOLIAN_VOWEL_SEPARATOR,	true	);	break;
				case L'\x2000':	CheckDlgButton( dlg, IDC_EN_QUAD,					true	);	break;
				case L'\x2001':	CheckDlgButton( dlg, IDC_EM_QUAD,					true	);	break;
				case L'\x2002':	CheckDlgButton( dlg, IDC_EN_SPACE,					true	);	break;
				case L'\x2003':	CheckDlgButton( dlg, IDC_EM_SPACE,					true	);	break;
				case L'\x2004':	CheckDlgButton( dlg, IDC_THREE_PER_EM_SPACE,		true	);	break;
				case L'\x2005':	CheckDlgButton( dlg, IDC_FOUR_PER_EM_SPACE,			true	);	break;
				case L'\x2006':	CheckDlgButton( dlg, IDC_SIX_PER_EM_SPACE,			true	);	break;
				case L'\x2007':	CheckDlgButton( dlg, IDC_FIGURE_SPACE,				true	);	break;
				case L'\x2008':	CheckDlgButton( dlg, IDC_PUNCTUATION_SPACE,			true	);	break;
				case L'\x2009':	CheckDlgButton( dlg, IDC_THIN_SPACE,				true	);	break;
				case L'\x200A':	CheckDlgButton( dlg, IDC_HAIR_SPACE,				true	);	break;
				case L'\x202F':	CheckDlgButton( dlg, IDC_NARROW_NO_BREAK_SPACE,		true	);	break;
				case L'\x205F':	CheckDlgButton( dlg, IDC_MEDIUM_MATHEMATICAL_SPACE,	true	);	break;
				case L'\x2028':	CheckDlgButton( dlg, IDC_LINE_SEPARATOR,			true	);	break;
				case L'\x2029':	CheckDlgButton( dlg, IDC_PARAGRAPH_SEPARATOR,		true	);	break;
				case L'\x000A':	CheckDlgButton( dlg, IDC_LINE_FEED,					true	);	break;
				case L'\x000B':	CheckDlgButton( dlg, IDC_LINE_TABULATION,			true	);	break;
				case L'\x000C':	CheckDlgButton( dlg, IDC_FORM_FEED,					true	);	break;
				case L'\x000D':	CheckDlgButton( dlg, IDC_CARRIAGE_RETURN,			true	);	break;
				case L'\x0085':	CheckDlgButton( dlg, IDC_NEXT_LINE,					true	);	break;
				}
			}

			//	ڍ׃IvV\XV
			CheckDlgButton( dlg, IDC_ADVANCE_OPTION, GetRegBool( em, keyAdvanceOption ) );
			SendMessage( dlg, WM_COMMAND, MAKELONG(IDC_ADVANCE_OPTION,BN_CLICKED), 0 );
		}
		return	true;
	case WM_COMMAND:
		switch( LOWORD(wParam) ){
		case IDOK:{			//	VȐݒۑ
				//	󔒕Q
				vector<wchar_t>	spaces;
				if( IsDlgButtonChecked( dlg, IDC_SPACE						) ) spaces.push_back( L'\x0020' );
				if( IsDlgButtonChecked( dlg, IDC_IDEOGRAPHIC_SPACE			) ) spaces.push_back( L'\x3000' );
				if( IsDlgButtonChecked( dlg, IDC_CHARACTER_TABULATION		) ) spaces.push_back( L'\x0009' );
				if( IsDlgButtonChecked( dlg, IDC_NO_BREAK_SPACE				) ) spaces.push_back( L'\x00A0' );
				if( IsDlgButtonChecked( dlg, IDC_OGHAM_SPACE_MARK			) ) spaces.push_back( L'\x1680' );
				if( IsDlgButtonChecked( dlg, IDC_MONGOLIAN_VOWEL_SEPARATOR	) ) spaces.push_back( L'\x180E' );
				if( IsDlgButtonChecked( dlg, IDC_EN_QUAD					) ) spaces.push_back( L'\x2000' );
				if( IsDlgButtonChecked( dlg, IDC_EM_QUAD					) ) spaces.push_back( L'\x2001' );
				if( IsDlgButtonChecked( dlg, IDC_EN_SPACE					) ) spaces.push_back( L'\x2002' );
				if( IsDlgButtonChecked( dlg, IDC_EM_SPACE					) ) spaces.push_back( L'\x2003' );
				if( IsDlgButtonChecked( dlg, IDC_THREE_PER_EM_SPACE			) ) spaces.push_back( L'\x2004' );
				if( IsDlgButtonChecked( dlg, IDC_FOUR_PER_EM_SPACE			) ) spaces.push_back( L'\x2005' );
				if( IsDlgButtonChecked( dlg, IDC_SIX_PER_EM_SPACE			) ) spaces.push_back( L'\x2006' );
				if( IsDlgButtonChecked( dlg, IDC_FIGURE_SPACE				) ) spaces.push_back( L'\x2007' );
				if( IsDlgButtonChecked( dlg, IDC_PUNCTUATION_SPACE			) ) spaces.push_back( L'\x2008' );
				if( IsDlgButtonChecked( dlg, IDC_THIN_SPACE					) ) spaces.push_back( L'\x2009' );
				if( IsDlgButtonChecked( dlg, IDC_HAIR_SPACE					) ) spaces.push_back( L'\x200A' );
				if( IsDlgButtonChecked( dlg, IDC_NARROW_NO_BREAK_SPACE		) ) spaces.push_back( L'\x202F' );
				if( IsDlgButtonChecked( dlg, IDC_MEDIUM_MATHEMATICAL_SPACE	) ) spaces.push_back( L'\x205F' );
				if( IsDlgButtonChecked( dlg, IDC_LINE_SEPARATOR				) ) spaces.push_back( L'\x2028' );
				if( IsDlgButtonChecked( dlg, IDC_PARAGRAPH_SEPARATOR		) ) spaces.push_back( L'\x2029' );
				if( IsDlgButtonChecked( dlg, IDC_LINE_FEED					) ) spaces.push_back( L'\x000A' );
				if( IsDlgButtonChecked( dlg, IDC_LINE_TABULATION			) ) spaces.push_back( L'\x000B' );
				if( IsDlgButtonChecked( dlg, IDC_FORM_FEED					) ) spaces.push_back( L'\x000C' );
				if( IsDlgButtonChecked( dlg, IDC_CARRIAGE_RETURN			) ) spaces.push_back( L'\x000D' );
				if( IsDlgButtonChecked( dlg, IDC_NEXT_LINE					) ) spaces.push_back( L'\x0085' );
				spaces.push_back( L'\0' );
				SetRegBinary( em, keySpaces, (DWORD)spaces.size() * sizeof(wchar_t), &spaces[0] );

				//	ڍ׃IvV
				SetRegBool( em, keyAdvanceOption, IsDlgButtonChecked( dlg, IDC_ADVANCE_OPTION ) != 0 );

				EndDialog( dlg, 1 );
			}
			return	true;
		case IDCANCEL:		//	LZ
			EndDialog( dlg, 0 );
			return	true;
		case IDC_ADVANCE_OPTION:	//	ڍאݒ
			{
				//	ڍ׃IvV\؂ւ
				int	value( IsDlgButtonChecked( dlg, IDC_ADVANCE_OPTION ) ? SW_SHOW : SW_HIDE );
				ShowWindow( GetDlgItem( dlg, IDC_GROUP_JP					), value );
				ShowWindow( GetDlgItem( dlg, IDC_GROUP_OTHER				), value );
				ShowWindow( GetDlgItem( dlg, IDC_GROUP_ZS					), value );
				ShowWindow( GetDlgItem( dlg, IDC_NO_BREAK_SPACE				), value );
				ShowWindow( GetDlgItem( dlg, IDC_OGHAM_SPACE_MARK			), value );
				ShowWindow( GetDlgItem( dlg, IDC_MONGOLIAN_VOWEL_SEPARATOR	), value );
				ShowWindow( GetDlgItem( dlg, IDC_EN_QUAD					), value );
				ShowWindow( GetDlgItem( dlg, IDC_EM_QUAD					), value );
				ShowWindow( GetDlgItem( dlg, IDC_EN_SPACE					), value );
				ShowWindow( GetDlgItem( dlg, IDC_EM_SPACE					), value );
				ShowWindow( GetDlgItem( dlg, IDC_THREE_PER_EM_SPACE			), value );
				ShowWindow( GetDlgItem( dlg, IDC_FOUR_PER_EM_SPACE			), value );
				ShowWindow( GetDlgItem( dlg, IDC_SIX_PER_EM_SPACE			), value );
				ShowWindow( GetDlgItem( dlg, IDC_FIGURE_SPACE				), value );
				ShowWindow( GetDlgItem( dlg, IDC_PUNCTUATION_SPACE			), value );
				ShowWindow( GetDlgItem( dlg, IDC_THIN_SPACE					), value );
				ShowWindow( GetDlgItem( dlg, IDC_HAIR_SPACE					), value );
				ShowWindow( GetDlgItem( dlg, IDC_NARROW_NO_BREAK_SPACE		), value );
				ShowWindow( GetDlgItem( dlg, IDC_MEDIUM_MATHEMATICAL_SPACE	), value );
				ShowWindow( GetDlgItem( dlg, IDC_GROUP_ZL					), value );
				ShowWindow( GetDlgItem( dlg, IDC_LINE_SEPARATOR				), value );
				ShowWindow( GetDlgItem( dlg, IDC_GROUP_ZP					), value );
				ShowWindow( GetDlgItem( dlg, IDC_PARAGRAPH_SEPARATOR		), value );
				ShowWindow( GetDlgItem( dlg, IDC_GROUP_CC					), value );
				ShowWindow( GetDlgItem( dlg, IDC_LINE_FEED					), value );
				ShowWindow( GetDlgItem( dlg, IDC_LINE_TABULATION			), value );
				ShowWindow( GetDlgItem( dlg, IDC_FORM_FEED					), value );
				ShowWindow( GetDlgItem( dlg, IDC_CARRIAGE_RETURN			), value );
				ShowWindow( GetDlgItem( dlg, IDC_NEXT_LINE					), value );

				//	_CAÕTCY؂ւ
				if( value == SW_SHOW ){
					SetWindowPos( dlg, NULL, 0, 0, originalRect.right - originalRect.left, originalRect.bottom - originalRect.top, SWP_NOMOVE | SWP_NOZORDER | SWP_SHOWWINDOW );
				}else{
					RECT	area;
					GetWindowRect( GetDlgItem( dlg, IDC_GROUP_OTHER ), &area );
					POINT	pt = { area.left, area.top };
					ScreenToClient( dlg, &pt );
					GetClientRect( dlg, &area );
					SetWindowPos( dlg, NULL, 0, 0, originalRect.right - originalRect.left, (originalRect.bottom - originalRect.top) - (area.bottom - area.top) + pt.y, SWP_NOMOVE | SWP_NOZORDER | SWP_SHOWWINDOW );
				}
			}
			break;
		}
		break;
	}
	return	false;
}

//	IvV_CAO\
bool	SelectSpacesDlg( HWND parent, HWND em )
{
	return	DialogBoxParam( instance, MAKEINTRESOURCE(IDD_SPACES), parent, SelectSpacesDlgProc, (LPARAM)em ) != 0;
}

};

//	DocComp̃vpeB  /////////////////////////////////////////////////////

namespace {

//	vpeB_CAOvV[W
INT_PTR CALLBACK PropertyProc( HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	static HWND	em;
	bool	ignoreSpace;

	switch( msg ){
	case WM_INITDIALOG:{	//	IvV_CAO
			em = (HWND)lParam;
			ignoreSpace = GetRegBool( em, keyIgnoreSpace );
			EnableWindow( GetDlgItem( dlg, IDC_SPACES ), ignoreSpace );
			CheckDlgButton( dlg, IDC_IGNORE_SPACE,		 ignoreSpace );
			CheckDlgButton( dlg, IDC_ALWAYS_SELECTOR,	 GetRegBool( em, keyAlwaysSelector		) );
			CheckDlgButton( dlg, IDC_IGNORE_NULLLINE,	 GetRegBool( em, keyIgnoreNullLine		) );
			CheckDlgButton( dlg, IDC_CASE_SENSITIVE,	 GetRegBool( em, keyCaseSensitive, true	) );
			SetWindowText(  dlg, GetStringFromTable(IDS_NAME).c_str() );
		}
		return	true;
	case WM_COMMAND:
		switch( LOWORD(wParam) ){
		case IDOK:			//	VȐݒۑ
			SetRegBool( em, keyAlwaysSelector,	IsDlgButtonChecked( dlg, IDC_ALWAYS_SELECTOR ) != 0 );
			SetRegBool( em, keyIgnoreSpace,		IsDlgButtonChecked( dlg, IDC_IGNORE_SPACE	 ) != 0 );
			SetRegBool( em, keyIgnoreNullLine,	IsDlgButtonChecked( dlg, IDC_IGNORE_NULLLINE ) != 0 );
			SetRegBool( em, keyCaseSensitive,	IsDlgButtonChecked( dlg, IDC_CASE_SENSITIVE	 ) != 0 );
			EndDialog( dlg, 1 );
			return	true;
		case IDCANCEL:		//	LZ
			EndDialog( dlg, 0 );
			return	true;
		case IDC_SPACES:	//	󔒕̑I
			SelectSpacesDlg( dlg, em );
			return	true;
		case IDC_IGNORE_SPACE:	//	󔒕𖳎
			ignoreSpace = IsDlgButtonChecked( dlg, IDC_IGNORE_SPACE ) != 0;
			EnableWindow( GetDlgItem( dlg, IDC_SPACES ), ignoreSpace );
			break;
		}
		break;
	}
	return	false;
}

};

//	IvV_CAO\
bool	ShowProperty( HWND parent )
{
	DialogBoxParam( instance, MAKEINTRESOURCE(IDD_OPTION), GetTopParent(parent), PropertyProc, (LPARAM)GetTopParent(parent) );
	return	true;
}


//	rhLgI  ////////////////////////////////////////////////////

//	rhLgIpf[^
DITEM::DITEM( HWND hwnd, LONG_PTR index_ ): index(index_)
{
	wchar_t	sTitle[4096], fTitle[4096];
	Editor_DocInfo( hwnd, (int)index, EI_GET_SHORT_TITLEW, (LPARAM)sTitle );
	Editor_DocInfo( hwnd, (int)index, EI_GET_FULL_TITLEW,  (LPARAM)fTitle );
	shortTitle = *sTitle ? sTitle : (*fTitle ? fTitle : GetStringFromTable(IDS_NONAME)).c_str();
	 fullTitle = *fTitle ? fTitle : (*sTitle ? sTitle : GetStringFromTable(IDS_NONAME)).c_str();
}

namespace {

INT_PTR CALLBACK ChoiceTargetFileProc( HWND dlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	static HWND	em;
	static const vector<DITEM>* items;
	static long	dlgWidth, dlgHeight;
	static long lstHorizontalGap, lstVerticalGap;
	static long ispTop, spcTop, inlTop, cstTop, bokTop, cslTop;
	bool	ignoreSpace;

	switch( msg ){
	case WM_INITDIALOG:{
			em	  = ((pair<HWND,const vector<DITEM>*>*)lParam)->first;
			items = ((pair<HWND,const vector<DITEM>*>*)lParam)->second;

			//	JñTCYƂL^
			RECT	area;
			GetWindowRect( dlg, &area );
			int	x( area.left ), w( area.right  - area.left ), sx( GetSystemMetrics( SM_CXSCREEN ) );
			int	y( area.top  ), h( area.bottom - area.top  ), sy( GetSystemMetrics( SM_CYSCREEN ) );
			dlgWidth  = w;	dlgHeight = h;
			GetWindowRect( GetDlgItem( dlg, IDC_DOCLIST ), &area );
			lstHorizontalGap = w - (area.right  - area.left);
			lstVerticalGap	 = h - (area.bottom - area.top);
			GetWindowRect( GetDlgItem( dlg, IDC_IGNORE_SPACE	), &area );	ScreenToClient( dlg, (POINT*)&area.left );	ispTop = h - area.top;
			GetWindowRect( GetDlgItem( dlg, IDC_SPACES			), &area );	ScreenToClient( dlg, (POINT*)&area.left );	spcTop = h - area.top;
			GetWindowRect( GetDlgItem( dlg, IDC_IGNORE_NULLLINE	), &area );	ScreenToClient( dlg, (POINT*)&area.left );	inlTop = h - area.top;
			GetWindowRect( GetDlgItem( dlg, IDC_CASE_SENSITIVE	), &area );	ScreenToClient( dlg, (POINT*)&area.left );	cstTop = h - area.top;
			GetWindowRect( GetDlgItem( dlg, IDOK				), &area );	ScreenToClient( dlg, (POINT*)&area.left );	bokTop = h - area.top;
			GetWindowRect( GetDlgItem( dlg, IDCANCEL			), &area );	ScreenToClient( dlg, (POINT*)&area.left );	cslTop = h - area.top;

			//	TCY
			w = max( GetRegInt32( em, keySelectWidth,  w ), w );
			h = max( GetRegInt32( em, keySelectHeight, h ), h );
			//	ʒu
			x = (sx - w) / 2;
			y = (sy - h) / 2;
			SetWindowPos( dlg, 0, x, y, w, h, SWP_NOZORDER | SWP_FRAMECHANGED | SWP_SHOWWINDOW );

			//	IvV
			ignoreSpace = GetRegBool( em, keyIgnoreSpace );
			EnableWindow( GetDlgItem( dlg, IDC_SPACES ), ignoreSpace );
			CheckDlgButton( dlg, IDC_IGNORE_SPACE,		 ignoreSpace );
			CheckDlgButton( dlg, IDC_IGNORE_NULLLINE,	 GetRegBool( em, keyIgnoreNullLine		) );
			CheckDlgButton( dlg, IDC_CASE_SENSITIVE,	 GetRegBool( em, keyCaseSensitive, true	) );

			//	Z^Cg\邽߂̕𒲂ׁAXg{bNXɐݒ
			HWND	lb( GetDlgItem( dlg, IDC_DOCLIST ) );
			HDC		hDC( GetDC( lb ) );
			SIZE	size;
			int		tabStop[1] = { 0 };
			for( const DITEM* p(&(*items)[0]), *e(p + items->size()) ; p < e ; ++p ){
				GetTextExtentPoint32( hDC, p->shortTitle.c_str(), (int)p->shortTitle.length(), &size );
				*tabStop = max( *tabStop, size.cx );
			}
			*tabStop = ((*tabStop + 3) * 4) / LOWORD(GetDialogBaseUnits()) + 4;
			ReleaseDC( lb, hDC );
			SendMessage( lb, LB_SETTABSTOPS, 1, (LPARAM)tabStop );

			//	Xg{bNXɃhLgXgo^
			wchar_t		title[4096];
			LONG_PTR	index(0);
			for( const DITEM* p(&(*items)[0]), *e(p + items->size()) ; p < e ; ++p, ++index ){
				swprintf_s( title, L"%s\t%s", p->shortTitle.c_str(), p->fullTitle.c_str() );
				LONG_PTR lbIndex( SendMessage( lb, LB_ADDSTRING, 0, (LPARAM)title ) );
				if( lbIndex != LB_ERR )
					SendMessage( lb, LB_SETITEMDATA, lbIndex, index );
			}

			//	ŏ̍ڂI
			if( SendMessage( lb, LB_GETCOUNT,  0, 0 ) > 0 )
				SendMessage( lb, LB_SETCURSEL, 0, 0 );
		}
		break;
	case WM_COMMAND:
		switch( LOWORD(wParam) ){
		case IDOK:{
				//	肳ꂽ

				//	ݒ荀ڕۑ
				SetRegBool( em, keyIgnoreSpace,		IsDlgButtonChecked( dlg, IDC_IGNORE_SPACE	 ) != 0 );
				SetRegBool( em, keyIgnoreNullLine,	IsDlgButtonChecked( dlg, IDC_IGNORE_NULLLINE ) != 0 );
				SetRegBool( em, keyCaseSensitive,	IsDlgButtonChecked( dlg, IDC_CASE_SENSITIVE	 ) != 0 );

				//	IꂽhLgCfbNX𒲂ׁAԂ
				HWND lb( GetDlgItem( dlg, IDC_DOCLIST ) );
				LONG_PTR lbIndex( SendMessage( lb, LB_GETCURSEL,	0,		 0 ) );
				LONG_PTR index(	  SendMessage( lb, LB_GETITEMDATA,	lbIndex, 0 ) );
				if( index == LB_ERR ){
					MessageBeep( MB_ICONEXCLAMATION );
				}else{
					EndDialog( dlg, index );
				}
			}
			return	true;
		case IDCANCEL:
			//	LZꂽ
			EndDialog( dlg, -1 );
			return	true;
		case IDC_SPACES:
			//	󔒕̑I
			SelectSpacesDlg( dlg, em );
			return	true;
		case IDC_IGNORE_SPACE:
			//	󔒕𖳎
			ignoreSpace = IsDlgButtonChecked( dlg, IDC_IGNORE_SPACE ) != 0;
			EnableWindow( GetDlgItem( dlg, IDC_SPACES ), ignoreSpace );
			break;
		}
		break;
	case WM_WINDOWPOSCHANGING:
		//	EBhETCYύX̂ŁARg[̈ʒuƃTCY𒲐
		if( lParam ){
			WINDOWPOS*	pos( (WINDOWPOS*)lParam );
			if( !(pos->flags & SWP_NOSIZE) ){
				int	right(  pos->x + pos->cx );
				int	bottom( pos->y + pos->cy );
				pos->cx = max( pos->cx, dlgWidth  );
				pos->cy = max( pos->cy, dlgHeight );

				RECT	area;
				HWND	wnd;
				GetWindowRect( wnd = GetDlgItem( dlg, IDC_DOCLIST		  ), &area );	SetWindowPos(	wnd, 0, 0, 0, pos->cx - lstHorizontalGap, pos->cy - lstVerticalGap, SWP_NOZORDER | SWP_NOMOVE );
				GetWindowRect( wnd = GetDlgItem( dlg, IDC_IGNORE_SPACE	  ), &area );	ScreenToClient( dlg, (POINT*)&area.left );	SetWindowPos( wnd, 0, area.left, pos->cy - ispTop, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
				GetWindowRect( wnd = GetDlgItem( dlg, IDC_SPACES		  ), &area );	ScreenToClient( dlg, (POINT*)&area.left );	SetWindowPos( wnd, 0, area.left, pos->cy - spcTop, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
				GetWindowRect( wnd = GetDlgItem( dlg, IDC_IGNORE_NULLLINE ), &area );	ScreenToClient( dlg, (POINT*)&area.left );	SetWindowPos( wnd, 0, area.left, pos->cy - inlTop, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
				GetWindowRect( wnd = GetDlgItem( dlg, IDC_CASE_SENSITIVE  ), &area );	ScreenToClient( dlg, (POINT*)&area.left );	SetWindowPos( wnd, 0, area.left, pos->cy - cstTop, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
				GetWindowRect( wnd = GetDlgItem( dlg, IDOK				  ), &area );	ScreenToClient( dlg, (POINT*)&area.left );	SetWindowPos( wnd, 0, area.left, pos->cy - bokTop, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
				GetWindowRect( wnd = GetDlgItem( dlg, IDCANCEL			  ), &area );	ScreenToClient( dlg, (POINT*)&area.left );	SetWindowPos( wnd, 0, area.left, pos->cy - cslTop, 0, 0, SWP_NOZORDER | SWP_NOSIZE );
			}
		}
		break;
	case WM_SIZE:
		//	EBhETCYύXꂽ̂ŁAL^
		switch( wParam ){
		case SIZE_RESTORED:{
				RECT	area;
				GetWindowRect( dlg, &area );
				SetRegInt32( em, keySelectWidth,  area.right  - area.left );
				SetRegInt32( em, keySelectHeight, area.bottom - area.top  );
			}
			//	ꕔŕ\̂ŁA኱xōXVv
			PostMessage( dlg, WM_USER, 0, 0 );
			break;
		}
		break;
	case WM_USER:{
			//	ꕔŕ\̂ŁAXVv
			MSG	msg;
			if( !PeekMessage( &msg, dlg, WM_USER, WM_USER, PM_NOREMOVE ) ){
				InvalidateRect(	dlg, NULL, false );
				UpdateWindow(	dlg );
			}
		}
		return	true;
	}
	return	false;
}

};

//	rhLgI
size_t	ChoiceTargetFile( HWND parent, const vector<DITEM>& items )
{
	return	DialogBoxParam( instance, MAKEINTRESOURCE(IDD_SELECT), GetTopParent(parent), ChoiceTargetFileProc, (LPARAM)&make_pair( parent, &items ) );
}


//////////////////////////////////////////////////////////////////////////////