#pragma once

#include <windows.h>
#include <string>

namespace option
{
	namespace detail
	{
		class Base {
		public:
			operator bool () const { return !hwnd_; }
			bool operator!() const { return  hwnd_ == nullptr; }
		protected:
			Base( HWND hwnd );
			HWND		 const	hwnd_;
			std::wstring const	config_;
		private:
			Base(			 Base const& );
			Base& operator=( Base const& );
		};
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//	IvV[_[
	class Reader: public detail::Base {
	public:
		Reader( HWND hwnd ): detail::Base(hwnd) {}

		//	ǂݎ
		bool			Bool(	wchar_t const* name, bool			defaultValue = false	) const;	//	_l
		INT32			Int32(	wchar_t const* name, INT32			defaultValue = 0		) const;	//	32bit
		float			Float(	wchar_t const* name, float			defaultValue = 0.f		) const;	//	Px_
		std::wstring	String(	wchar_t const* name, wchar_t const*	defaultValue = nullptr	) const;	//	
	public:
		//	f[^ǂݎ
		LONG	QueryValue( wchar_t const* name, DWORD type, void* data, DWORD& size ) const;
	};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//	IvVC^[
	class Writer: public detail::Base {
	public:
		Writer( HWND hwnd ): detail::Base(hwnd) {}

		//	
		bool	Bool(	wchar_t const* name, bool			value );	//	_l
		bool	Int32(	wchar_t const* name, INT32			value );	//	32bit
		bool	Float(	wchar_t const* name, float			value );	//	Px_
		bool	String(	wchar_t const* name, wchar_t const*	value );	//	
	public:
		//	f[^
		LONG	SetValue( wchar_t const* name, DWORD type, const void* data, DWORD size );
	};

}
