﻿#include <windows.h>
#include <commctrl.h>
#include "tools.h"
#include "plugin.h"
#include "docNavi.h"
#include "resource.h"

using namespace std;

//////////////////////////////////////////////////////////////////////////////

//	メニューかツールバーからプラグインを選択したときに呼び出されます 
EXTERN_C void	WINAPI OnCommand( HWND hwnd )
{
	docNavi::ShowDocumentList( hwnd );
}


//	状態が変更されたときにイベントが指定されて呼び出されます 
EXTERN_C void	WINAPI OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam ) 
{
}

//	プラグインが実行可能か、またはチェックされた状態かを調べます 
EXTERN_C BOOL	WINAPI QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	if( pbChecked ) *pbChecked = false;
	return	true;
}

namespace {

	//	プラグインの情報取得
	LRESULT	GetInfo( UINT_PTR flag )
	{
		switch( flag ){
		case EPGI_ALLOW_OPEN_SAME_GROUP:	return	true;		//	ファイルを同じグループ内で開くことを許す場合に TRUE を返します。 
		case EPGI_ALLOW_MULTIPLE_INSTANCES:	return	true;		//	プラグインが複数インスタンスをサポートする場合に TRUE を返します。プラグインが 2 個以上のフレームで同時に動作することが許される場合には、このメッセージは TRUE を返す必要があります。複数インスタンスが実行している間、グローバル変数は共有されることに注意してください。 
		case EPGI_MAX_EE_VERSION:			return	99 * 1000;	//	対応するもっとも新しい EmEditor のバージョン番号 * 1000 を返します。	とりあえず・・・
		case EPGI_MIN_EE_VERSION:			return	 7 * 1000;	//	対応するもっとも古い EmEditor のバージョン番号 * 1000 を返します。 
		case EPGI_SUPPORT_EE_PRO:			return	true;		//	EmEditor Professional をサポートする場合に TRUE を返します。 
		case EPGI_SUPPORT_EE_STD:			return	false;		//	EmEditor Standard をサポートする場合に TRUE を返します。 
		}
		return	0;
	}

}; // unnamed namsespace 

//	プラグインへのメッセージを使って、さまざまな設定や取得を行います。 
EXTERN_C LRESULT	WINAPI PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam ) 
{
	switch( nMsg ){
	case EP_GET_BITMAP:			return	0;																				//	ツールバーに表示される様々なサイズと色数のプラグイン ボタンのビットマップのリソースIDを取得します。 
	case EP_GET_INFO:			return	GetInfo( wParam );																//	プラグインに関するさまざまな情報を取得します。(Version 5.00 以上で対応) 
	case EP_GET_MASK:			return	RGB(255,255,255);																//	ツールバーに表示されるプラグイン ボタンのマスク カラーを取得します 
	case EP_GET_NAME:			return	tools::GetString( IDS_NAME,	wParam, reinterpret_cast<wchar_t*>(lParam) );	//	プラグインの名前を取得します。 
	case EP_GET_VERSION:		return	tools::GetString( IDS_VERSION,	wParam, reinterpret_cast<wchar_t*>(lParam) );	//	プラグインのバージョンを取得します。 
	case EP_QUERY_PROPERTIES:	return	true;																			//	プロパティが利用可能かどうかを調べます。 
	case EP_SET_PROPERTIES:		return	docNavi::ShowProperty( hwnd );													//	プロパティの表示を指示します。 
	case EP_QUERY_UNINSTALL:	return	true;																			//	アンインストールが利用可能かどうかを調べます。 
	case EP_SET_UNINSTALL:		return	UNINSTALL_SIMPLE_DELETE;														//	アンインストールを実行します。 
	case EP_PRE_TRANSLATE_MSG:	return	false;																			//	Windows メッセージを変換する前に呼び出されます。 
	}
	return	0;
}

//	リソースID取得
EXTERN_C UINT	WINAPI GetMenuTextID(){			return	IDS_MENUTEXT;		}	//	プラグインのメニューアイテムテキストのリソースIDを取得します 
EXTERN_C UINT	WINAPI GetStatusMessageID(){	return	IDS_STATUSMESSAGE;	}	//	ステータスバーテキストとツールバーのツールチップ用テキストを \n で結合した文字列のリソースIDを取得します。 
EXTERN_C UINT	WINAPI GetBitmapID(){			return	IDB_BUTTON;			}	//	ツールバーに表示されるプラグイン ボタンのビットマップのリソースIDを取得します 


//////////////////////////////////////////////////////////////////////////////

//	メイン
EXTERN_C BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved )
{
	InitCommonControls();
	switch( dwReason ){
	case DLL_PROCESS_ATTACH:	tools::Initialize(hinstDLL);	break;	//	プロセスにアタッチするとき
	case DLL_PROCESS_DETACH:									break;	//	プロセスからデタッチするとき
	}
	return	true;
}

//////////////////////////////////////////////////////////////////////////////
