#pragma once

#include <windows.h>
#include <string>

namespace registry
{
	namespace detail
	{
		class Base {
		public:
			~Base(){ RegCloseKey( key_ ); }
			operator bool () const { return !key_; }
			bool operator!() const { return  key_ == nullptr; }
		protected:
			Base( HKEY key ): key_(key) {}
			HKEY const key_;
		private:
			Base(			 Base const& );
			Base& operator=( Base const& );
		};
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//	WXg[_[
	class Reader: public detail::Base {
	public:
		Reader( HKEY key, wchar_t const* subkey ): detail::Base( Open(key,subkey) ) {}

		//	ǂݎ
		bool			Bool(	wchar_t const* name, bool			defaultValue = false	) const;	//	_l
		INT32			Int32(	wchar_t const* name, INT32			defaultValue = 0		) const;	//	32bit
		INT64			Int64(	wchar_t const* name, INT64			defaultValue = 0LL		) const;	//	64bit
		float			Float(	wchar_t const* name, float			defaultValue = 0.f		) const;	//	Px_
		double			Double(	wchar_t const* name, double			defaultValue = 0.		) const;	//	{x_
		std::wstring	String(	wchar_t const* name, wchar_t const*	defaultValue = nullptr	) const;	//	
	public:
		//	
		struct Info {
			LONG	result;	//	
			DWORD	type;	//	
			DWORD	size;	//	f[^TCY

			Info(): result(!ERROR_SUCCESS), type(0), size(0) {}
			Info( DWORD s, DWORD t = 0 ): result(!ERROR_SUCCESS), type(t), size(s) {}
			operator bool () const { return result == ERROR_SUCCESS; }
			bool operator!() const { return result != ERROR_SUCCESS; }
		};

		//	擾
		Info	GetInfo( wchar_t const* name ) const;
		//	f[^ǂݎ
		LONG	QueryValue(	wchar_t const* name, DWORD type, void* data, DWORD& size ) const;
	private:
		//	J
		static HKEY Open( HKEY key, wchar_t const* subkey );
	};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//	WXgC^[
	class Writer: public detail::Base {
	public:
		Writer( HKEY key, wchar_t const* subkey ): detail::Base( Open(key,subkey) ) {}

		//	
		bool	Bool(	wchar_t const* name, bool			value );	//	_l
		bool	Int32(	wchar_t const* name, INT32			value );	//	32bit
		bool	Int64(	wchar_t const* name, INT64			value );	//	64bit
		bool	Float(	wchar_t const* name, float			value );	//	Px_
		bool	Double(	wchar_t const* name, double			value );	//	{x_
		bool	String(	wchar_t const* name, wchar_t const*	value );	//	

		//	폜
		bool	Erase(		wchar_t const* name );	//	l
		bool	EraseKey(	wchar_t const* name );	//	TuL[
	public:
		//	f[^
		LONG	SetValue( wchar_t const* name, DWORD type, void const* data, DWORD size );
	private:
		//	J
		static HKEY Open( HKEY key, wchar_t const* subkey );
	};

}
