#pragma once

LPCTSTR szRootKey = _T("Software\\EmSoft\\EmEditorPlugIns\\");
LPCTSTR szConfigRootKey = _T("Software\\EmSoft\\EmEditor v3\\Config");

int GetProfileIntReg( HKEY hSecKey, LPCTSTR lpszEntry, int nDefault )
{
	_ASSERTE( lpszEntry != NULL );
	if( hSecKey == NULL )  return nDefault;
	DWORD dwValue;
	DWORD dwType;
	DWORD dwCount = sizeof(DWORD);
	LONG lResult = RegQueryValueEx(hSecKey, lpszEntry, NULL, &dwType, (LPBYTE)&dwValue, &dwCount);
	if (lResult == ERROR_SUCCESS){
		_ASSERTE(dwType == REG_DWORD);
		_ASSERTE(dwCount == sizeof(dwValue));
		return (int)dwValue;
	}
	return nDefault;
}

void WriteProfileIntReg( HKEY hSecKey, LPCTSTR lpszEntry, int nValue )
{
	_ASSERTE( hSecKey != NULL );
	_ASSERTE( lpszEntry != NULL );
	if( hSecKey == NULL )  return;
	RegSetValueEx( hSecKey, lpszEntry, NULL, REG_DWORD, (LPBYTE)&nValue, sizeof(nValue) );
}

void GetProfileStringReg( HKEY hKey, LPCTSTR lpszEntry, LPTSTR lpszBuf, DWORD cchBufSize, LPCTSTR lpszDefault )
{
	DWORD dwType, dwCount;
	dwCount = cchBufSize * sizeof( TCHAR );
	if( hKey == NULL 
	  || RegQueryValueEx( hKey, lpszEntry, NULL, &dwType, (LPBYTE)lpszBuf, &dwCount) != ERROR_SUCCESS ){
		StringCopy( lpszBuf, cchBufSize, lpszDefault );
	}
}

void WriteProfileStringReg( HKEY hSecKey, LPCTSTR lpszEntry, LPCTSTR lpszValue)
{
	_ASSERTE( lpszEntry != NULL );
	_ASSERTE( lpszValue != NULL );
	if (hSecKey == NULL)  return;
	RegSetValueEx(hSecKey, lpszEntry, NULL, REG_SZ, (LPBYTE)lpszValue, (lstrlen(lpszValue)+1)*sizeof(TCHAR));
}

// buffer must be MAX_PATH character long.
BOOL GetRootKeyName( LPTSTR szKey )
{
	TCHAR szFileName[MAX_PATH];
	if( !GetModuleFile( szFileName ) )  return FALSE;
	StringCopy( szKey, MAX_PATH, szRootKey );
	StringCat( szKey, MAX_PATH, szFileName );
	return TRUE;
}


HKEY GetRootKey()
{
	TCHAR szKey[MAX_PATH];
	if( !GetRootKeyName( szKey ) )  return NULL;
	HKEY hKey = NULL;
	DWORD dw;
	RegCreateKeyEx( HKEY_CURRENT_USER, szKey, 0, REG_NONE, REG_OPTION_NON_VOLATILE, KEY_WRITE | KEY_READ, NULL, &hKey, &dw);
	return hKey;
}


HKEY GetConfigRootKey()
{
	HKEY hKey = NULL;
	RegOpenKeyEx( HKEY_CURRENT_USER, szConfigRootKey, 0, KEY_READ, &hKey );
	return hKey;
}


