#pragma once

// forward declaration
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

#define MODE_HTML	0
#define MODE_UCN	1
#define MAX_MODE	2

#define CHAR_CODE_PAGE		0
#define CHAR_US_ASCII		1

int g_nMode = 0;
int g_nCharToConvert = CHAR_CODE_PAGE;


LPCTSTR szMode = _T("Mode");
LPCTSTR szCharToConvert = _T("CharToConvert");


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	int g_nMode;

	CMyFrame()
	{
		g_nMode = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
		OSVERSIONINFO osvi;
		osvi.dwOSVersionInfoSize = sizeof( osvi );
		GetVersionEx( &osvi );
		DWORD dwOSMajorVersion = osvi.dwMajorVersion;

		LoadProfile();
		if( g_nMode < 0 || g_nMode > MAX_MODE )  return;
		UINT_PTR nBufLen = Editor_GetSelTextW( hwndView, 0, NULL);
		nBufLen *= 8;
		LPWSTR pBuf = new WCHAR[nBufLen];
		if( !pBuf )  return;
		Editor_GetSelTextW( hwndView, nBufLen, pBuf );

		int nCP = 0;
		if( g_nCharToConvert == CHAR_CODE_PAGE ){
			nCP = (int)Editor_Info( hwndView, EI_GET_FONT_CP, 0 );
			_ASSERTE( nCP == 0 || (nCP >= CODEPAGE_ANSI_FIRST && nCP <= CODEPAGE_ANSI_LAST) );
		}
		LPWSTR p = pBuf;

		while( *p ){
			bool bConvert = false;
			if( g_nCharToConvert == CHAR_US_ASCII ){
				if( *p > 0x007e ){
					bConvert = true;
				}
			}
			else if( nCP >= CODEPAGE_ANSI_FIRST && nCP <= CODEPAGE_ANSI_LAST ) {
				char szBuf[8];
				DWORD dwFlags = dwOSMajorVersion < 5 ? 0 : WC_NO_BEST_FIT_CHARS;
				BOOL bDefaultUsed;
				int cchMultiByte = WideCharToMultiByte( nCP, dwFlags, p, 1, szBuf, sizeof(szBuf), NULL, &bDefaultUsed );
				if( bDefaultUsed || cchMultiByte == 0 ){
					bConvert = true;
				}
				else if( dwOSMajorVersion < 5 ) {
					WCHAR wch;
					if( MultiByteToWideChar( nCP, 0, szBuf, cchMultiByte, &wch, 1 ) ) {
						if( wch != *p )  bConvert = true;
					}
				}
			}

			if( bConvert ){
				WCHAR szNew[32];
				if( g_nMode == MODE_UCN ){
					StringPrintfW( szNew, _countof( szNew ), L"\\u%04x", *p );
				}
				else {
					StringPrintfW( szNew, _countof( szNew ), L"&#%u;", *p );
				}
				size_t nLen = wcslen( szNew );
				memmove( p + nLen, p + 1, (wcslen( p + 1 ) + 1) * sizeof(WCHAR) );
				memcpy( p, szNew, nLen * sizeof(WCHAR) );
				p += nLen;
			}
			else {
				p++;
			}
		}

		Editor_InsertStringW( hwndView, pBuf );

		delete [] pBuf;
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			TCHAR szKey[MAX_PATH];
			if( GetRootKeyName( szKey ) ){
				RegDeleteKey( HKEY_CURRENT_USER, szKey );
			}
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	// user defined methods below.
	void LoadProp( HKEY hKey )
	{
		g_nMode = GetProfileIntReg( hKey, szMode, MODE_HTML );
		g_nCharToConvert = GetProfileIntReg( hKey, szCharToConvert, CHAR_CODE_PAGE );
	}

	BOOL LoadProfile()
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			LoadProp( hKey );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	void SaveProp( HKEY hKey )
	{
		WriteProfileIntReg( hKey, szMode, g_nMode );
		WriteProfileIntReg( hKey, szCharToConvert, g_nCharToConvert );
	}

	BOOL SaveProfile()
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			SaveProp( hKey );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		LoadProfile();
		CheckRadioButton( hwnd, IDC_HTML, IDC_UCN, IDC_HTML + g_nMode );
		CheckRadioButton( hwnd, IDC_CODE_PAGE, IDC_US_ASCII, IDC_CODE_PAGE + g_nCharToConvert );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WORD wCmdID )
	{
		switch( wCmdID ){
		case IDOK:
			{
				g_nMode = IsDlgButtonChecked( hwnd, IDC_UCN ) ? MODE_UCN : MODE_HTML;
				g_nCharToConvert = IsDlgButtonChecked( hwnd, IDC_CODE_PAGE ) ? CHAR_CODE_PAGE : CHAR_US_ASCII;
				SaveProfile();
				EndDialog( hwnd, IDOK );
			}
			break;
		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
	}

};

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	}
	return bResult;
}

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT


