// implementatin of this specific plug-in is here:
//

#define BUTTON_SIZE_SMALL   22
#define BUTTON_SIZE_LARGE   30

#define MAX_RECENT_FONT		8

#define ZERO_INIT_FIRST_MEM(classname, firstmem)  ZeroMemory( &firstmem, sizeof( classname ) - ((char*)&firstmem - (char*)this) );

INT_PTR CALLBACK NewProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
INT_PTR CALLBACK TableDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );


struct CTBInfo
{
	WORD nID;
	BYTE iBitmap;
	BYTE fStyle;
};

static CTBInfo buttons[] = 
{
	{ ID_HEADER,			0, BTNS_WHOLEDROPDOWN },
	{ ID_PARAGRAPH,			1, 0 },
	{ ID_BREAK,				2, 0 },
	{ ID_BOLD,				3, 0 },
	{ ID_ITALIC,			4, 0 },
	{ ID_UNDERLINE,			5, 0 },
	{ ID_FONT,				6, BTNS_DROPDOWN },
	{ ID_COLOR,				7, 0 },
	{ ID_PICTURE,			8, 0 },
	{ ID_HYPERLINK,			9, 0 },
	{ ID_TABLE,				10, 0 },
	{ ID_HORZ_LINE,			11, 0 },
	{ ID_COMMENT,			12, 0 },
	{ ID_ALIGN_LEFT,		13, 0 },
	{ ID_CENTER,			14, 0 },
	{ ID_ALIGN_RIGHT,		15, 0 },
	{ ID_JUSTIFY,			16, 0 },
	{ ID_NUMBERING,			17, 0 },
	{ ID_BULLETS,			18, 0 },
	{ ID_UNINDENT,			19, 0 },
	{ ID_INDENT,			20, 0 },
	{ ID_HIGHLIGHT,			21, 0 },
	{ ID_FONT_COLOR,		22, 0 },
	{ ID_FORM,				23, BTNS_WHOLEDROPDOWN },
};


static BYTE anDefToolbarIndex[] = 
{
	0, 1, 2, (BYTE)(-1), 3, 4, 5, (BYTE)(-1), 6, 7, 8, 9, (BYTE)(-1), 10, 11, 12, (BYTE)(-1), 13, 14, 15, 16, (BYTE)(-1), 17, 18, 19, 20, (BYTE)(-1), 21, 22, 23, (BYTE)(-2)
};


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_TRUE_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= CLR_NONE				};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 7010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 7000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= FALSE					};

	// user-defined members
	vector<tstring> m_RecentFontArray;
	vector<tstring> m_AutoConfigArray;

	// data that can be set zeros below
	HWND m_hwndToolbar;
	HIMAGELIST m_himageToolbar;
	HWND m_hDlg;
	TCHAR m_szOldConfig[MAX_CONFIG_NAME];
	DWORD m_dwFindFlags;
	UINT m_nClientID;
	UINT m_cx;
	UINT m_fStyle;
	UINT m_nBand;
	DWORD m_dwDefColor;
	DWORD m_crCustClr[16];
	WORD  m_wRows;
	WORD  m_wColumns;
	bool m_bProfileLoaded;
	bool m_bAutoDisplay;
	bool m_bVisible;
	bool m_bUninstalling;

	void AddButtons( HWND hwndToolbar )
	{
		TBBUTTON atb[_countof( anDefToolbarIndex )];
		ZeroMemory( atb, sizeof( atb ) );
		BYTE* pnIndex = anDefToolbarIndex;
		int i = 0;
		while( *pnIndex != (BYTE)-2 ){
			BYTE nIndex = *pnIndex++;
			if( nIndex != (BYTE)-1 ){
				atb[i].iBitmap = buttons[nIndex].iBitmap;
				atb[i].idCommand = buttons[nIndex].nID;
				atb[i].fsStyle = buttons[nIndex].fStyle;
			}
			else {  // separator
				atb[i].fsStyle = TBSTYLE_SEP;
			}
			atb[i].fsState = TBSTATE_ENABLED;
			i++;
		}
		SendMessage( hwndToolbar, TB_ADDBUTTONSA, i, (LPARAM)atb );
	}

	bool IsVisible()
	{
		return m_hwndToolbar && m_bVisible;
	}

	void DisplayBar( bool bVisible )
	{
		if( m_hwndToolbar ){
			_ASSERT( m_nClientID );
			Editor_ToolbarShow( m_hWnd, m_nClientID, bVisible );
			m_bVisible = bVisible;
		}
		else {
			m_bVisible = false;
			TCHAR sz[260];
			TCHAR szAppName[80];
			LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
			if( Editor_GetVersion( m_hWnd ) < 7000 ){
				LoadString( EEGetInstanceHandle(), IDS_INVALID_VERSION, sz, _countof( sz ) );
				MessageBox( m_hWnd, sz, szAppName, MB_OK | MB_ICONSTOP );
				return;
			}

			HWND hDlg = CreateDialog( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_DIALOGBAR ), m_hWnd, NewProc );
			_ASSERT( hDlg );
			if( !hDlg ){
				return;
			}
			m_hDlg = hDlg;

			DWORD dwStyle = TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT | WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | CCS_NODIVIDER | CCS_NORESIZE | WS_VISIBLE | TBSTYLE_FLAT | CCS_NOPARENTALIGN | CCS_NOMOVEY;
			DWORD dwExStyle = TBSTYLE_EX_HIDECLIPPEDBUTTONS | TBSTYLE_EX_DRAWDDARROWS;
			HWND hwndToolbar = CreateWindowEx( 0, TOOLBARCLASSNAME, NULL, dwStyle,
				0, 0, 0, BUTTON_SIZE_SMALL, m_hDlg, (HMENU)(INT_PTR)100, NULL, NULL );
			m_hwndToolbar = hwndToolbar;
			SendMessage( hwndToolbar, TB_BUTTONSTRUCTSIZE, (WPARAM) sizeof(TBBUTTON), 0 ); 
			SendMessage( hwndToolbar, TB_SETBUTTONSIZE, 0, MAKELONG( 22, 22 ) );
			SendMessage( hwndToolbar, TB_SETEXTENDEDSTYLE, 0, dwExStyle );
			_ASSERT( m_himageToolbar == NULL );
			m_himageToolbar = ImageList_LoadImage( EEGetInstanceHandle(), MAKEINTRESOURCE( IDB_TOOLBAR ), 16, 0, RGB( 255, 0, 255 ), IMAGE_BITMAP, LR_CREATEDIBSECTION );
			_ASSERT( m_himageToolbar );
			SendMessage( hwndToolbar, TB_SETIMAGELIST, 0, (LPARAM)m_himageToolbar );
			AddButtons( hwndToolbar );

			if( hwndToolbar ){
				TCHAR szTitle[80];
				LoadString( EEGetInstanceHandle(), IDS_TITLE, szTitle, _countof( szTitle ) );
				RECT rcClient = { 0 };
				GetClientRect( hwndToolbar, &rcClient );
				TOOLBAR_INFO cri;
				ZeroMemory( &cri, sizeof( cri ) );
				cri.cbSize = sizeof( cri );
				cri.nMask = TIM_CLIENT | TIM_TITLE | TIM_FLAGS | TIM_STYLE | TIM_MINCHILD | TIM_CX | TIM_CXIDEAL | TIM_BAND | TIM_PLUG_IN_CMD_ID;
				cri.wPlugInCmdID = EEGetCmdID();
				cri.pszTitle = szTitle;
				cri.hwndClient = hwndToolbar;
				cri.cxMinChild = 0;
				cri.cyMinChild = rcClient.bottom - rcClient.top;
				cri.cxIdeal = rcClient.right - rcClient.left;
				cri.cx = m_cx;
				if( bVisible ){
					m_fStyle &= ~RBBS_HIDDEN;
				}
				else {
					m_fStyle |= RBBS_HIDDEN;
				}
				cri.fStyle = m_fStyle;
				cri.nBand = m_nBand;

				m_nClientID = Editor_ToolbarOpen( m_hWnd, &cri );

				if( !m_nClientID ){
					CustomBarClosed();
				}
				else {
					m_bVisible = bVisible;
				}

				ShowWindow( hwndToolbar, m_bVisible );
			}
		}
	}

	void OnCommand( HWND /*hwndView*/ )
	{
		DisplayBar( !IsVisible() );
	}

	void CustomBarClosed()
	{
		if( m_hwndToolbar ){
			if( IsWindow( m_hwndToolbar ) ){
				DestroyWindow( m_hwndToolbar );
			}
			if( m_himageToolbar ){
				VERIFY( ImageList_Destroy( m_himageToolbar ) );
				m_himageToolbar = NULL;
			}
			_ASSERT( !IsWindow( m_hwndToolbar ) );
			m_hwndToolbar = NULL;
			m_nClientID = 0;
		}
		if( m_hDlg ){
			DestroyWindow( m_hDlg );
			m_hDlg = NULL;
		}
	}

	BOOL QueryStatus( HWND /*hwndView*/, LPBOOL pbChecked )
	{		
		*pbChecked = IsVisible();
		return TRUE;
	}

	void OnEvents( HWND /*hwndView*/, UINT nEvent, LPARAM lParam )
	{
		if( nEvent & EVENT_CREATE_FRAME ){
			LoadProfile();
			TCHAR szConfigName[ MAX_CONFIG_NAME ] = { 0 };
			Editor_GetConfigW( m_hWnd, szConfigName );
			StringCopy( m_szOldConfig, _countof( m_szOldConfig ), szConfigName );
			DisplayBar( m_bAutoDisplay && ConfigExist( szConfigName ) );
		}
		if( nEvent & EVENT_CLOSE_FRAME ){
			if( m_hwndToolbar ){
				_ASSERTE( m_nClientID );
				Editor_ToolbarClose( m_hWnd, m_nClientID );
				CustomBarClosed();
			}
		}
		if( nEvent & EVENT_TOOLBAR_CLOSED ){
			// this message arrives even if plug-in does not own this custom bar, so make sure it is mine.
			TOOLBAR_INFO* pTI = (TOOLBAR_INFO*)lParam;
			if( (pTI->nMask & TIM_ID) && pTI->nID == m_nClientID ){
				_ASSERT( m_hwndToolbar != NULL );
				CustomBarClosed();
				// if the frame closed while Custom Bar is open, save the status for next startup.
				if( pTI->nMask & TIM_CX ){
					m_cx = pTI->cx;
				}
				if( pTI->nMask & TIM_STYLE ){
					m_fStyle = pTI->fStyle;
				}
				if( pTI->nMask & TIM_BAND ){
					m_nBand = pTI->nBand;
				}
				SaveProfile();
			}
		}
		if( nEvent & EVENT_TOOLBAR_SHOW ){
			TOOLBAR_INFO* pTI = (TOOLBAR_INFO*)lParam;
			if( (pTI->nMask & TIM_ID) && pTI->nID == m_nClientID ){
				_ASSERT( m_hwndToolbar != NULL );
				if( pTI->nMask & TIM_STYLE ){
					m_bVisible = !(pTI->fStyle & RBBS_HIDDEN);
				}
			}
		}
		if( nEvent & (EVENT_CONFIG_CHANGED | EVENT_FILE_OPENED ) ) {
			if( m_bAutoDisplay ){
				TCHAR szConfigName[ MAX_CONFIG_NAME ] = { 0 };
				Editor_GetConfigW( m_hWnd, szConfigName );
				if( lstrcmpi( szConfigName, m_szOldConfig ) != 0 ){
					if( ConfigExist( szConfigName ) ){
						if( !IsVisible() ){
							DisplayBar( true );
						}
					}
					else {
						if( IsVisible() ){
							DisplayBar( false );
						}
					}
					StringCopy( m_szOldConfig, _countof( m_szOldConfig ), szConfigName );
				}
			}
		}
		if( nEvent & (EVENT_FILE_OPENED | EVENT_DOC_SEL_CHANGED) ){
		}
		if( nEvent & EVENT_CHANGE ){
		}
		if( nEvent & EVENT_CARET_MOVED ){
		}
		if( nEvent & EVENT_IDLE ){
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam )
	{
		TCHAR szProductCode[80] = { 0 };
		HKEY hKey = NULL;
		if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, _T("Software\\EmSoft\\EmEditorPlugIns\\HTMLBar"), 0, KEY_READ, &hKey ) == ERROR_SUCCESS && hKey ){
			GetProfileStringReg( hKey, _T("ProductCode"), szProductCode, _countof( szProductCode ), _T("") );
			if( szProductCode[0] ){
				GetSystemDirectory( pszUninstallCommand, MAX_PATH );
				PathAppend( pszUninstallCommand, _T("msiexec.exe") );

				StringPrintf( pszUninstallParam, MAX_PATH, _T("/X%s"), szProductCode );
				RegCloseKey( hKey );
				m_bUninstalling = true;
				return UNINSTALL_RUN_COMMAND;
			}
		}
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			// Delete the registry/INI key.
			EraseProfile();
			m_bUninstalling = true;
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	BOOL PreTranslateMessage( HWND /*hwndView*/, MSG* pMsg )
	{
		HWND hwndFocus = GetFocus();
		if( hwndFocus ){
			if( IsVisible() && IsChild( m_hwndToolbar, hwndFocus ) ){
				if( pMsg->message == WM_KEYDOWN ){
					bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
					bool bShift = GetKeyState( VK_SHIFT ) < 0;
					if( !bCtrl ){
						if( pMsg->wParam == VK_ESCAPE ){
							if( !bShift ){
								Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
								return TRUE;
							}
						}
					}
				}
				if( IsDialogMessage( m_hwndToolbar, pMsg ) ){
					return TRUE;
				}
			}
		}
		return FALSE;
	}

	CMyFrame()
	{
		ZERO_INIT_FIRST_MEM( CMyFrame, m_hwndToolbar );
		m_nBand = (UINT)-1;
	}

	~CMyFrame()
	{
		CustomBarClosed();
	}

	bool ConfigExist( LPCTSTR pszConfig )
	{
		for( vector<tstring>::iterator it = m_AutoConfigArray.begin(); it != m_AutoConfigArray.end(); it++ ){
			if( !lstrcmpi( it->c_str(), pszConfig ) ){
				return true;
			}
		}
		return false;
	}

	void OnPropInitDialog( HWND hDlg )
	{
		CheckDlgButton( hDlg, IDC_AUTO_DISPLAY, m_bAutoDisplay );

		TCHAR szText[40];
		LoadString( EEGetInstanceHandle(), IDS_CONFIGS, szText, _countof( szText ) );

		HWND hwndList = GetDlgItem( hDlg, IDC_LIST );
		ListView_SetExtendedListViewStyleEx( hwndList, LVS_EX_CHECKBOXES, LVS_EX_CHECKBOXES );

		LV_COLUMN lvC;
		ZeroMemory( &lvC, sizeof(lvC) );
		lvC.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		lvC.fmt = LVCFMT_LEFT;
		lvC.pszText = szText;
		RECT rc;
		GetWindowRect( hwndList, &rc );
		lvC.cx = rc.right - rc.left - GetSystemMetrics( SM_CXVSCROLL ) - GetSystemMetrics( SM_CXEDGE ) * 2;
		VERIFY( ListView_InsertColumn( hwndList, 0, &lvC ) != -1 );

		_ASSERT( hwndList );
		ListView_DeleteAllItems( hwndList );
		LV_ITEM item;
		ZeroMemory( &item, sizeof(item) );
		item.mask = LVIF_TEXT;

		size_t cchBuf = Editor_EnumConfig( m_hWnd, NULL, 0 );
		if( !cchBuf )  return;

		LPWSTR pszBuf = new WCHAR[ cchBuf ];
		if( !pszBuf )  return;
		
		if( !Editor_EnumConfig( m_hWnd, pszBuf, cchBuf ) )  return;

		int i = 0;
		LPWSTR p = pszBuf;
		while( *p ){
			item.iItem = i+1;
			item.pszText = p;
			i = ListView_InsertItem( hwndList, &item );
			if( ConfigExist( p ) ){
				ListView_SetCheckState( hwndList, i, TRUE );
			}
			p += wcslen( p ) + 1;
		}

		delete [] pszBuf;

		EnableWindow( GetDlgItem( hDlg, IDC_LIST ), m_bAutoDisplay );
	}

	void OnPropCommand( HWND hDlg, WPARAM wParam )
	{
		if( wParam == IDOK ){
			m_bAutoDisplay = !!IsDlgButtonChecked( hDlg, IDC_AUTO_DISPLAY );

			m_AutoConfigArray.clear();
			HWND hwndList = GetDlgItem( hDlg, IDC_LIST );
			int nCount = ListView_GetItemCount( hwndList );
			for( int i = 0; i < nCount; i++ ){
				if( ListView_GetCheckState( hwndList, i ) ){
					TCHAR szName[ MAX_CONFIG_NAME ];
					szName[0] = 0;
					ListView_GetItemText( hwndList, i, 0, szName, _countof( szName ) );
					m_AutoConfigArray.push_back( szName );
				}
			}
			SaveProfile();
			EndDialog( hDlg, IDOK );
		}
		else if( wParam == IDCANCEL ){
			EndDialog( hDlg, IDCANCEL );
		}
		else if( wParam == IDC_AUTO_DISPLAY ){
			BOOL bEnabled = IsDlgButtonChecked( hDlg, IDC_AUTO_DISPLAY );
			EnableWindow( GetDlgItem( hDlg, IDC_LIST ), bEnabled );
		}
	}

	void LoadProfile()
	{
		if( !m_bProfileLoaded ){
			m_bProfileLoaded = true;
			m_bAutoDisplay = !!GetProfileInt( _T("AutoDisplay"), FALSE );
			m_cx = GetProfileInt( _T("cx"), 0 );
			m_fStyle = GetProfileInt( _T("Style"), 0 );
			m_nBand = GetProfileInt( _T("Band"), -1 );
			m_wRows = (WORD)GetProfileInt( _T("Rows"), 3 );
			m_wColumns = (WORD)GetProfileInt( _T("Columns"), 2 );
			
			bool bSuccess = false;
			m_AutoConfigArray.clear();

			int cchSize = GetProfileInt( _T("Configs-Size"), 0 );
			if( cchSize > 2 ){
				LPTSTR pBuf = new TCHAR[ cchSize ];
				if( pBuf ){
					*pBuf = 0;
					GetProfileString( _T("Configs"), pBuf, cchSize, _T("") );
					if( *pBuf ){
						LPTSTR p = pBuf;
						for( ; ; ){
							LPTSTR p0 = p;
							p = _tcschr( p, '\\' );
							if( !p )  break;
							*p = 0;
							if( !*p0 )  break;
							m_AutoConfigArray.push_back( p0 );
							p++;
						}
						bSuccess = true;
					}
					delete [] pBuf;
				}
			}
			if( !bSuccess ){
				m_AutoConfigArray.push_back( _T("HTML") );
			}
		}
	}

	void SaveProfile()
	{
		if( m_bUninstalling )  return;
		WriteProfileInt( _T("AutoDisplay"), !!m_bAutoDisplay );
		WriteProfileInt( _T("cx"), m_cx );
		WriteProfileInt( _T("Style"), m_fStyle );
		WriteProfileInt( _T("Band"), m_nBand );

		int cchBuf = 2;
		for( vector<tstring>::iterator it = m_AutoConfigArray.begin(); it != m_AutoConfigArray.end(); it++ ){
			cchBuf += (int)it->length() + 1;
		}
		LPTSTR pBuf = new TCHAR[ cchBuf ];
		LPTSTR p = pBuf;
		int cch = cchBuf;
		for( vector<tstring>::iterator it = m_AutoConfigArray.begin(); it != m_AutoConfigArray.end(); it++ ){
			StringCopy( p, cch, it->c_str() );
			p += it->length();
			*p++ = _T('\\');
			cch -= (int)it->length() + 1;
		}
		*p++ = _T('\\');
		*p = 0;
		_ASSERT( lstrlen( pBuf ) + 1 == cchBuf );
		WriteProfileString( _T("Configs"), pBuf );
		delete [] pBuf;
		WriteProfileInt( _T("Configs-Size"), cchBuf );
	}

	int PopupMenuSub( UINT nIDCommand, UINT nIDMenu )
	{
		_ASSERT( m_hwndToolbar != NULL );
		if( m_hwndToolbar == NULL )  return 0;
		RECT rect = { 0 };
		int nIndex = (int)SendMessage( m_hwndToolbar, TB_COMMANDTOINDEX, nIDCommand, 0L );
		_ASSERT( nIndex >= 0 );
		if( nIndex != -1 ){
			SendMessage( m_hwndToolbar, TB_GETITEMRECT, nIndex, (LPARAM)&rect );
			rect.top = rect.bottom;
			::ClientToScreen( m_hwndToolbar, (LPPOINT)&rect );
		}
		if( nIndex == -1 ){
			::ClientToScreen( m_hwndToolbar, (LPPOINT)&rect );
		}

		HMENU hMainMenu = LoadMenu( EEGetInstanceHandle(), MAKEINTRESOURCE(nIDMenu) );
		HMENU hMenu = GetSubMenu( hMainMenu, 0 );

		if( nIDMenu == IDR_POPUP_FONT ){
			int i = 1;
			for( vector<tstring>::iterator it = m_RecentFontArray.begin(); it != m_RecentFontArray.end(); it++ ){
				InsertMenu( hMenu, 0, MF_BYPOSITION, i++, it->c_str() );
			}
		}

		TPMPARAMS tpmp;
		ZeroMemory( &tpmp, sizeof( tpmp ) );
		tpmp.cbSize = sizeof( tpmp );
		tpmp.rcExclude.right = rect.left;
		tpmp.rcExclude.left = INT_MIN;
		tpmp.rcExclude.top = INT_MIN;
		tpmp.rcExclude.bottom = INT_MAX;
		int nResult = TrackPopupMenuEx( hMenu, TPM_CENTERALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD, rect.left, rect.top, m_hDlg, &tpmp );
		DestroyMenu( hMainMenu );
		return nResult;
	}



	void InsertTag( LPCTSTR pszTagBegin, LPCTSTR pszTagEnd )
	{
		int nSelType = Editor_GetSelTypeEx( m_hWnd, TRUE );
		int nTagBeginLen = (int)_tcslen( pszTagBegin );
		int nTagEndLen = (int)_tcslen( pszTagEnd );
		if( nSelType & SEL_TYPE_SELECTED ){
			UINT_PTR nBufSize = Editor_GetSelTextW( m_hWnd, 0, NULL );
			nBufSize += nTagBeginLen + nTagEndLen + 8;
			LPWSTR pBuf = new WCHAR[ nBufSize ];
			if( pBuf ){
				POINT_PTR ptSelStart;
				POINT_PTR ptSelEnd;
				Editor_GetSelStart( m_hWnd, POS_LOGICAL_W, &ptSelStart );
				Editor_GetSelEnd( m_hWnd, POS_LOGICAL_W, &ptSelEnd );
				if( ptSelStart.y > ptSelEnd.y || (ptSelStart.y == ptSelEnd.y && ptSelStart.x > ptSelEnd.x) ){
					POINT_PTR pt;
					pt.x = ptSelStart.x;
					pt.y = ptSelStart.y;
					ptSelStart.x = ptSelEnd.x;
					ptSelStart.y = ptSelEnd.y;
					ptSelEnd.x = pt.x;
					ptSelEnd.y = pt.y;
				}
				StringCopy( pBuf, nBufSize, pszTagBegin );
				Editor_GetSelTextW( m_hWnd, nBufSize - nTagBeginLen, pBuf + nTagBeginLen );
				StringCat( pBuf, nBufSize, pszTagEnd );

				bool bNL = _tcschr( pBuf, '\r' ) || _tcschr( pBuf, '\n' );

				Editor_InsertW( m_hWnd, pBuf, true );
				Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptSelStart, FALSE );
				ptSelEnd.x += nTagEndLen;
				if( !bNL ) {
					ptSelEnd.x += nTagBeginLen;
				}
				Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptSelEnd, TRUE );
				delete [] pBuf;
			}
		}
		else {
			if( pszTagBegin[0] ){
				Editor_InsertW( m_hWnd, pszTagBegin, true );
			}
			if( pszTagEnd[0] ){
				Editor_InsertW( m_hWnd, pszTagEnd, true );
			}
			for( int i = 0; i < nTagEndLen; i++ ){
				Editor_ExecCommand( m_hWnd, EEID_LEFT );
			}
		}
	}

	void InsertTagFont( LPCTSTR szFaceName )
	{
		TCHAR szTagBegin[80];
		StringPrintf( szTagBegin, _countof( szTagBegin ), _T("<font face=\"%s\">"), szFaceName );
		InsertTag( szTagBegin, _T("</font>") );

		for( vector<tstring>::iterator it = m_RecentFontArray.begin(); it != m_RecentFontArray.end(); it++ ){
			if( lstrcmp( it->c_str(), szFaceName ) == 0 ){
				m_RecentFontArray.erase( it );
				break;
			}
		}
		m_RecentFontArray.push_back( szFaceName );
		if( m_RecentFontArray.size() >= MAX_RECENT_FONT ){
			m_RecentFontArray.erase( m_RecentFontArray.begin() );
		}
	}

	BOOL ChooseFile( LPTSTR pszRelative, int nTitleID, int nFilterID )
	{
		*pszRelative = 0;
		TCHAR szFile[MAX_PATH] = { 0 };
		TCHAR szFolder[MAX_PATH] = { 0 };
		Editor_DocInfo( m_hWnd, -1, EI_GET_FILE_NAMEW, (LPARAM)szFolder );
		if( szFolder[0] ){
			PathRemoveFileSpec( szFolder );
		}

		OPENFILENAME ofn = { 0 };
		ofn.lStructSize = sizeof( ofn );
		ofn.hwndOwner = m_hDlg;

		TCHAR szFilter[200];
		LoadString( EEGetInstanceHandle(), nFilterID, szFilter, _countof( szFilter ) );
		LPTSTR p = szFilter;
		while( *p ){
			if( *p == _T('|') )  *p = 0;
			p++;
		}
		ofn.lpstrFilter = szFilter;
		ofn.lpstrFile = szFile;
		ofn.nMaxFile = _countof( szFile );
		ofn.lpstrInitialDir = szFolder;

		TCHAR szTitle[80];
		LoadString( EEGetInstanceHandle(), nTitleID, szTitle, _countof( szTitle ) );
		ofn.lpstrTitle = szTitle;
		ofn.Flags = /*OFN_FILEMUSTEXIST | */ OFN_HIDEREADONLY;

		if( GetOpenFileName( &ofn ) ){
			TCHAR szRelativePath[MAX_PATH] = { 0 };
			LPTSTR pRelative = szRelativePath;
			if( !PathRelativePathTo( szRelativePath, szFolder, FILE_ATTRIBUTE_DIRECTORY, szFile, 0 ) ){
				pRelative = szFile;
			}
			else if( _tcsncmp( pRelative, _T(".\\"), 2 ) == 0 ){
				pRelative += 2;
			}

			if( PathIsRelative( pRelative ) ) {
				StringCopy( pszRelative, MAX_PATH, pRelative );
			}
			else {
				StringCopy( pszRelative, MAX_PATH, _T("file:///") );
				StringCat( pszRelative, MAX_PATH, pRelative );
			}
			LPTSTR p = pszRelative;
			while( *p ){
				if( *p == '\\' )  *p = '/';
				p++;
			}
			return TRUE;
		}
		return FALSE;
	}

	void Unindent()
	{
		int nSelType = Editor_GetSelTypeEx( m_hWnd, TRUE );
		if( nSelType & SEL_TYPE_SELECTED ){
			UINT_PTR nBufSize = Editor_GetSelTextW( m_hWnd, 0, NULL );

			LPWSTR pBuf = new WCHAR[ nBufSize ];
			if( pBuf ){
				Editor_GetSelTextW( m_hWnd, nBufSize, pBuf );
				LPCTSTR pszBegin = _T("<blockquote>");
				int nBeginLen = lstrlen( pszBegin );
				LPCTSTR pszEnd = _T("</blockquote>");
				int nEndLen = lstrlen( pszEnd );
				LPTSTR p1 = StrStrI( pBuf, pszBegin );
				if( p1 ){
					wmemmove( p1, p1 + nBeginLen, lstrlen( p1 + nBeginLen ) + 1 );
					LPTSTR p2 = StrStrI( p1, pszEnd );
					if( p2 ){
						wmemmove( p2, p2 + nEndLen, lstrlen( p2 + nEndLen ) + 1 );
						Editor_InsertW( m_hWnd, pBuf, false );
					}
				}
				delete [] pBuf;
			}
		}
	}

	void OnDlgCommand( WPARAM wParam )
	{
		switch( wParam ){
		case ID_PARAGRAPH:
			InsertTag( L"<p>", L"</p>" );
			break;
		case ID_BREAK:
			InsertTag( L"<br />", L"" );
			break;
		case ID_BOLD:
			InsertTag( L"<strong>", L"</strong>" );
			break;
		case ID_ITALIC:
			InsertTag( L"<em>", L"</em>" );
			break;
		case ID_UNDERLINE:
			InsertTag( L"<u>", L"</u>" );
			break;
		case ID_FONT:
			{
				LOGFONT lf = { 0 };
				HFONT hFont = (HFONT)GetStockObject( DEFAULT_GUI_FONT );
				if( hFont ){
					GetObject( hFont, sizeof( lf ), &lf );
				}
				CHOOSEFONT cf = { 0 };
				cf.lStructSize = sizeof( cf );
				cf.hwndOwner = m_hDlg;
				cf.lpLogFont = &lf;
				cf.hInstance = EEGetInstanceHandle();
				cf.lpTemplateName = MAKEINTRESOURCE( IDD_FONT );
				cf.Flags = CF_SCREENFONTS | CF_NOVERTFONTS | CF_ENABLETEMPLATE | CF_INITTOLOGFONTSTRUCT;
				if( ChooseFont( &cf ) ) {
					InsertTagFont( lf.lfFaceName );
				}
			}
			break;
		case ID_COLOR:
			{
				CHOOSECOLOR cc = { 0 };
				cc.lStructSize = sizeof( cc );
				cc.hwndOwner = m_hDlg;
				cc.lpCustColors = m_crCustClr;
				if( ChooseColor( &cc ) ){
					m_dwDefColor = cc.rgbResult;
					TCHAR sz[16];
					StringPrintf( sz, _countof( sz ), _T("#%02x%02x%02x"), GetRValue( cc.rgbResult ), GetGValue( cc.rgbResult ), GetBValue( cc.rgbResult ) );
					InsertTag( sz, _T("") );
				}
			}
			break;
		case ID_PICTURE:
			{
				TCHAR szRelativePath[MAX_PATH];
				if( ChooseFile( szRelativePath, IDS_PICTURE, IDS_FILTER_IMAGE ) ){
					TCHAR szTag[MAX_PATH+40];
					StringPrintf( szTag, _countof( szTag ), _T("<img src=\"%s\" width=\"\" height=\"\" alt=\"\" />"), szRelativePath );
					InsertTag( szTag, _T("") );
				}
			}
			break;
		case ID_HYPERLINK:
			{
				TCHAR szRelativePath[MAX_PATH];
				if( ChooseFile( szRelativePath, IDS_HYPERLINK, IDS_FILTER_HYPERLINK ) ){
					TCHAR szTag[MAX_PATH+40];
					StringPrintf( szTag, _countof( szTag ), _T("<a href=\"%s\">"), szRelativePath );
					InsertTag( szTag, _T("</a>") );
				}
			}
			break;
		case ID_TABLE:
			{
				if( DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_TABLE ), m_hDlg, TableDlg ) == IDOK ){
					Editor_InsertW( m_hWnd, _T("<table>\n"), true );
					for( WORD i = 0; i < m_wRows; i++ ){
						Editor_InsertW( m_hWnd, _T("\t<tr>\n"), true );
						for( WORD j = 0; j < m_wColumns; j++ ){
							Editor_InsertW( m_hWnd, _T("\t\t<td></td>\n"), true );
						}
						Editor_InsertW( m_hWnd, _T("\t</tr>\n"), true );
					}
					Editor_InsertW( m_hWnd, _T("</table>\n"), true );
				}
			}
			break;
		case ID_HORZ_LINE:
			{
				InsertTag( _T("<hr />"), _T("") );
			}
			break;
		case ID_COMMENT:
			{
				InsertTag( _T("<!-- "), _T(" -->") );
			}
			break;
		case ID_ALIGN_LEFT:
			{
				InsertTag( _T("<p align=\"left\">"), _T("</p>") );
			}
			break;
		case ID_CENTER:
			{
				InsertTag( _T("<p align=\"center\">"), _T("</p>") );
			}
			break;
		case ID_ALIGN_RIGHT:
			{
				InsertTag( _T("<p align=\"right\">"), _T("</p>") );
			}
			break;
		case ID_JUSTIFY:
			{
				InsertTag( _T("<p align=\"justify\">"), _T("</p>") );
			}
			break;
		case ID_NUMBERING:
			{
				InsertTag( _T("<ol>\n\t<li>"), _T("</li>\n</ol>") );
			}
			break;
		case ID_BULLETS:
			{
				InsertTag( _T("<ul>\n\t<li>"), _T("</li>\n</ul>") );
			}
			break;
		case ID_UNINDENT:
			{
				Unindent();
			}
			break;
		case ID_INDENT:
			{
				InsertTag( _T("<blockquote>"), _T("</blockquote>") );
			}
			break;
		case ID_HIGHLIGHT:
			{
				TCHAR sz[260];
				StringPrintf( sz, _countof( sz ), _T("<span style=\"background-color: #%02x%02x%02x\">"), GetRValue( m_dwDefColor ), GetGValue( m_dwDefColor ), GetBValue( m_dwDefColor ) );
				InsertTag( sz, _T("</span>") );
			}
			break;
		case ID_FONT_COLOR:
			{
				TCHAR sz[260];
				StringPrintf( sz, _countof( sz ), _T("<font color=\"#%02x%02x%02x\">"), GetRValue( m_dwDefColor ), GetGValue( m_dwDefColor ), GetBValue( m_dwDefColor ) );
				InsertTag( sz, _T("</font>") );
			}
			break;
		}
	}

	void OnDlgNotify( NMHDR* pnmh )
	{
		switch( pnmh->code ){
		case TTN_GETDISPINFO:
			{
				NMTTDISPINFO* pDispInfo = (NMTTDISPINFO*)pnmh;
				LoadString( EEGetInstanceHandle(), (UINT)pDispInfo->hdr.idFrom, pDispInfo->szText, _countof( pDispInfo->szText ) );
			}
			break;
		case TBN_DROPDOWN:
			{
				NMTOOLBAR* pToolbar = (NMTOOLBAR*)pnmh;
				switch( pToolbar->iItem ){
				case ID_HEADER:
					{
						int n = PopupMenuSub( ID_HEADER, IDR_POPUP_HEADER );
						if( n > 0 ){
							TCHAR szTagBegin[8], szTagEnd[8];
							StringPrintf( szTagBegin, _countof( szTagBegin ), _T("<h%d>"), n );
							StringPrintf( szTagEnd, _countof( szTagEnd ), _T("</h%d>"), n );
							InsertTag( szTagBegin, szTagEnd );
						}
					}
					break;

				case ID_FONT:
					{
						int n = PopupMenuSub( ID_FONT, IDR_POPUP_FONT );
						if( n == 999 ){
							OnDlgCommand( ID_FONT );
						}
						else if( n > 0 ){
							_ASSERT( n - 1 < (int)m_RecentFontArray.size() );
							TCHAR sz[LF_FACESIZE];
							StringCopy( sz, _countof( sz ), m_RecentFontArray[n - 1].c_str() );
							InsertTagFont( sz );
						}
					}
					break;

				case ID_FORM:
					{
						int n = PopupMenuSub( ID_FORM, IDR_POPUP_FORM );
						switch( n )	{
						case 1:
							InsertTag( _T("<form method=\"post\" action=\"\">\n\t"), _T("\n<input type=\"submit\"><input type=\"reset\"></form>\n") );
							break;
						case 2:
							InsertTag( _T("<input type=\"text\" id=\"\" />"), _T("") );
							break;
						case 3:
							InsertTag( _T("<textarea id=\"\" rows=\"3\" cols=\"30\">"), _T("</textarea>") );
							break;
						case 4:
							InsertTag( _T("<input type=\"checkbox\" id=\"\" />"), _T("") );
							break;
						case 5:
							InsertTag( _T("<input type=\"radio\" id=\"\" />"), _T("") );
							break;
						case 6:
							InsertTag( _T("<fieldset style=\"padding: 2\">\n<legend>Group Box"), _T("</legend></fieldset>") );
							break;
						case 7:
							InsertTag( _T("<select size=\"1\" id=\"\">"), _T("</select>") );
							break;
						case 8:
							InsertTag( _T("<input type=\"button\" value=\"Button\" id=\"\">"), _T("") );
							break;
						case 9:
							InsertTag( _T("<button id=\"\">Type Here"), _T("</button>") );
							break;
						}
					}
					break;

				}
			}
			break;
		}
	}

	void OnTableInitDialog( HWND hDlg )
	{
		SetDlgItemInt( hDlg, IDC_ROWS, (UINT)m_wRows, FALSE );
		SetDlgItemInt( hDlg, IDC_COLUMNS, (UINT)m_wColumns, FALSE );
	}

	void OnTableCommand( HWND hDlg, WPARAM wParam )
	{
		if( wParam == IDOK ){
			BOOL bTranslated = FALSE;
			WORD w = (WORD)GetDlgItemInt( hDlg, IDC_ROWS, &bTranslated, FALSE );
			if( bTranslated ){
				m_wRows = w;
			}
			w = (WORD)GetDlgItemInt( hDlg, IDC_COLUMNS, &bTranslated, FALSE );
			if( bTranslated ){
				m_wColumns = w;
			}
			EndDialog( hDlg, IDOK );
		}
		else if( wParam == IDCANCEL ){
			EndDialog( hDlg, IDCANCEL );
		}
	}

};

INT_PTR CALLBACK NewProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	LRESULT nResult = 0;
	switch( msg ){
	case WM_COMMAND:
		{
			TRACE( _T("WM_COMMAND: wParam = %x, lParam = %x.\n"), wParam, lParam );
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			pFrame->OnDlgCommand( wParam );
		}
		break;

	case WM_NOTIFY:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			pFrame->OnDlgNotify( (NMHDR*)lParam );
		}
		break;

	}
	return (BOOL)nResult;
}


INT_PTR CALLBACK TableDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	LRESULT nResult = 0;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			if( pFrame ){
				pFrame->OnTableInitDialog( hwnd );
			}
		}
		break;

	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			pFrame->OnTableCommand( hwnd, wParam );
		}
		break;
	}
	return (BOOL)nResult;
}

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	LRESULT nResult = 0;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			if( pFrame ){
				pFrame->OnPropInitDialog( hwnd );
			}
		}
		break;

	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			pFrame->OnPropCommand( hwnd, wParam );
		}
		break;
	}
	return (BOOL)nResult;
}




// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

