﻿#include <windows.h>
#include <memory.h>
#include <tchar.h>
#include <imm.h>
#include <map>
#include "plugin.h"
#include "resource.h"

using namespace std;

//////////////////////////////////////////////////////////////////////////////

namespace {

//	インスタンスハンドル
HINSTANCE	instance;

//	配列サイズ取得
template <typename T,size_t N> size_t GetArraySize( T(&)[N] ){ return N; }

//	ストリングテーブルから文字列取得
LRESULT	GetStringFromTable( UINT id, UINT_PTR cb, wchar_t* buf )
{
	wchar_t	name[4096];
	if( !LoadStringW( instance, id, name, (int)GetArraySize(name) ) ) *name = NULL;

	if( buf && cb > 0 )
		wcscpy_s( buf, cb, name );
	return	_tcslen(name) + 1;
}

};


//////////////////////////////////////////////////////////////////////////////

namespace {

HWND	FindEmEditorView( HWND hwnd, HWND exclusion = NULL );

struct FINDEMEDITORVIEW {
	HWND result;
	HWND exclusion;
	FINDEMEDITORVIEW( HWND exclusion_ ): result(NULL), exclusion(exclusion_) {}
};

BOOL CALLBACK EnumEmEditorViewProc( HWND hwnd, LPARAM param )
{
	FINDEMEDITORVIEW*	dat( (FINDEMEDITORVIEW*)param );
	if( hwnd != dat->exclusion ){
		dat->result = FindEmEditorView( hwnd );
		return	!dat->result;
	}
	return	false;
}

//	EmEditorViewを探す
HWND	FindEmEditorView( HWND hwnd, HWND exclusion )
{
	if( hwnd ){
		//	自分自身をチェック
		wchar_t	name[256];
		if( GetClassName( hwnd, name, 255 ) ){
			if( wcscmp( name, L"EmEditorView" ) == 0 ){
				return	hwnd;
			}
		}

		//	子をチェック
		FINDEMEDITORVIEW	rsl( exclusion );
		EnumChildWindows( hwnd, EnumEmEditorViewProc, (LPARAM)&rsl );
		if( rsl.result ) return rsl.result;

		//	一個親をチェック
		if( !exclusion ){
			HWND parent( GetWindow( hwnd, GW_OWNER ) );
			if( parent ) return FindEmEditorView( parent, hwnd );
		}
	}
	return	NULL;
}

//	フック済みウィンドウ群
map<HWND,WNDPROC>	hookedWindows;

//	フック済みウィンドウプロシージャ
LRESULT CALLBACK HookProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	map<HWND,WNDPROC>::iterator it( hookedWindows.find( hwnd ) );
	WNDPROC	prevProc( (it == hookedWindows.end()) ? NULL : it->second );

	switch( msg ){

	//	IME関係
	case WM_IME_REQUEST:
		if( wParam == IMR_DOCUMENTFEED ){
			//	キャレット行を取得
			POINT_PTR	pos;
			Editor_GetCaretPos( hwnd, POS_LOGICAL_W, &pos );
			GET_LINE_INFO inf;
			inf.cch	  = 0;
			inf.flags = FLAG_LOGICAL;
			inf.yLine = pos.y;
			UINT_PTR size( Editor_GetLineW( hwnd, &inf, NULL ) );
			inf.cch = size + 32;
			wchar_t* buf( (wchar_t*)_alloca( inf.cch * sizeof(wchar_t) ) );
			if( buf ){
				Editor_GetLineW( hwnd, &inf, buf );
				size_t	len( wcslen(buf) );
/*				wchar_t str[30];
				swprintf_s( str, L" %d", lParam );
				wcscat_s( buf, inf.cch, str );
				MessageBox( hwnd, buf, L"", MB_OK );/**/

				if( lParam ){
					RECONVERTSTRING* rcs( (RECONVERTSTRING*)lParam );
					memset( rcs, 0, sizeof(RECONVERTSTRING) );
					rcs->dwSize				= sizeof(RECONVERTSTRING);
					rcs->dwStrOffset		= sizeof(RECONVERTSTRING);
					rcs->dwStrLen			= (DWORD)len;
					rcs->dwTargetStrOffset	= (DWORD)(min( (size_t)max( pos.x, 0 ), len ) * sizeof(wchar_t));
					wcscpy_s( (wchar_t*)(rcs + 1), len + 1, buf );
				}
				return	sizeof(RECONVERTSTRING) + (len + 1) * sizeof(wchar_t);
			}
		}
		break;

	//	ウィンドウ破棄
	case WM_DESTROY:
		//	フック解除
		if( it != hookedWindows.end() )
			hookedWindows.erase( it );
		if( prevProc )
			SetWindowLongPtr( hwnd, GWLP_WNDPROC, (LONG_PTR)prevProc );
		break;
	}
	return  CallWindowProc( prevProc, hwnd, msg, wParam, lParam );
}

};

//	メニューかツールバーからプラグインを選択したときに呼び出されます 
EXTERN_C void	WINAPI OnCommand( HWND hwnd )
{
}

//	状態が変更されたときにイベントが指定されて呼び出されます 
EXTERN_C void	WINAPI OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam ) 
{
	//	EmEditorViewをフックする
	if( nEvent & (EVENT_CREATE | EVENT_FILE_OPENED) ){
		HWND view( FindEmEditorView( hwnd ) );
		if( view && hookedWindows.find( view ) == hookedWindows.end() ){
			if( WNDPROC proc = (WNDPROC)SetWindowLongPtr( hwnd, GWLP_WNDPROC, (LONG_PTR)HookProc ) ){
				hookedWindows[view] = proc;
			}
		}
	}
	//	EmEditorViewのフック解除
	if( nEvent & EVENT_CLOSE ){
		while( !hookedWindows.empty() ){
			HWND	wnd(  hookedWindows.begin()->first  );
			WNDPROC	proc( hookedWindows.begin()->second );
			hookedWindows.erase( hookedWindows.begin() );
			if( proc )
				SetWindowLongPtr( hwnd, GWLP_WNDPROC, (LONG_PTR)proc );
		}
	}
}


//////////////////////////////////////////////////////////////////////////////

//	プラグインが実行可能か、またはチェックされた状態かを調べます 
EXTERN_C BOOL	WINAPI QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	if( pbChecked ) *pbChecked = false;
	return	false;
}

//	プラグインの情報取得
namespace {
LRESULT	GetInfo( UINT_PTR flag )
{
	switch( flag ){
	case EPGI_ALLOW_OPEN_SAME_GROUP:	return	true;			//	ファイルを同じグループ内で開くことを許す場合に TRUE を返します。 
	case EPGI_ALLOW_MULTIPLE_INSTANCES:	return	true;			//	プラグインが複数インスタンスをサポートする場合に TRUE を返します。プラグインが 2 個以上のフレームで同時に動作することが許される場合には、このメッセージは TRUE を返す必要があります。複数インスタンスが実行している間、グローバル変数は共有されることに注意してください。 
	case EPGI_MAX_EE_VERSION:			return	 9 * 1000 - 1;	//	対応するもっとも新しい EmEditor のバージョン番号 * 1000 を返します。 
	case EPGI_MIN_EE_VERSION:			return	 7 * 1000;		//	対応するもっとも古い EmEditor のバージョン番号 * 1000 を返します。 
	case EPGI_SUPPORT_EE_PRO:			return	true;			//	EmEditor Professional をサポートする場合に TRUE を返します。 
	case EPGI_SUPPORT_EE_STD:			return	true;			//	EmEditor Standard をサポートする場合に TRUE を返します。 
	}
	return	0;
}
};

//	プラグインへのメッセージを使って、さまざまな設定や取得を行います。 
EXTERN_C LRESULT	WINAPI PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam ) 
{
	switch( nMsg ){
	case EP_GET_BITMAP:			return	0;																//	ツールバーに表示される様々なサイズと色数のプラグイン ボタンのビットマップのリソースIDを取得します。
	case EP_GET_INFO:			return	GetInfo( wParam );												//	プラグインに関するさまざまな情報を取得します。(Version 5.00 以上で対応)
	case EP_GET_MASK:			return	RGB(255,255,255);												//	ツールバーに表示されるプラグイン ボタンのマスク カラーを取得します
	case EP_GET_NAME:			return	GetStringFromTable( IDS_NAME,	 wParam, (wchar_t*)lParam );	//	プラグインの名前を取得します。
	case EP_GET_VERSION:		return	GetStringFromTable( IDS_VERSION, wParam, (wchar_t*)lParam );	//	プラグインのバージョンを取得します。
	case EP_QUERY_PROPERTIES:	return	false;															//	プロパティが利用可能かどうかを調べます。
	case EP_SET_PROPERTIES:		return	false;															//	プロパティの表示を指示します。
	case EP_QUERY_UNINSTALL:	return	true;															//	アンインストールが利用可能かどうかを調べます。
	case EP_SET_UNINSTALL:		return	UNINSTALL_SIMPLE_DELETE;										//	アンインストールを実行します。
	case EP_PRE_TRANSLATE_MSG:	return	false;															//	Windows メッセージを変換する前に呼び出されます。
	}
	return	0;
}

//	リソースID取得
EXTERN_C UINT	WINAPI GetMenuTextID(){			return	IDS_MENUTEXT;		}	//	プラグインのメニューアイテムテキストのリソースIDを取得します 
EXTERN_C UINT	WINAPI GetStatusMessageID(){	return	IDS_STATUSMESSAGE;	}	//	ステータスバーテキストとツールバーのツールチップ用テキストを \n で結合した文字列のリソースIDを取得します。 
EXTERN_C UINT	WINAPI GetBitmapID(){			return	IDB_BUTTON;			}	//	ツールバーに表示されるプラグイン ボタンのビットマップのリソースIDを取得します 


//////////////////////////////////////////////////////////////////////////////

//	メイン
EXTERN_C BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved )
{
	switch( dwReason ){
	case DLL_PROCESS_ATTACH:	instance = hinstDLL;	break;	//	プロセスにアタッチ
	case DLL_PROCESS_DETACH:							break;	//	プロセスからデタッチ
	}
	return	true;
}

//////////////////////////////////////////////////////////////////////////////
