#pragma once

// forward declaration
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

#define MAX_SPACES	32

LPCTSTR szNumOfSpaces = _T("NumOfSpaces");

class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	int g_nMode;

	CMyFrame()
	{
		g_nMode = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
		WCHAR szSpaces[MAX_SPACES];
		int nSpaces = 1;
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			nSpaces = GetProfileIntReg( hKey, szNumOfSpaces, 1 );
			RegCloseKey( hKey );
		}
		if( nSpaces >= MAX_SPACES )  nSpaces = MAX_SPACES - 1;
		for( int i = 0; i < nSpaces; i++ ){
			szSpaces[i] = L' ';
		}
		szSpaces[nSpaces] = L'\0';
		BOOL bOverwrite;
		Editor_QueryStatus( hwndView, EEID_INSERT, &bOverwrite );
		if( bOverwrite ){
			Editor_ExecCommand( hwndView, EEID_INSERT );
		}
		POINT_PTR ptStart, ptEnd, ptOrgEnd;
		Editor_GetSelStart( hwndView, TRUE, &ptStart );
		Editor_GetSelEnd( hwndView, TRUE, &ptEnd );
		ptStart.x = 0;
		ptOrgEnd.x = ptEnd.x;
		ptOrgEnd.y = ptEnd.y;
		if( ptEnd.x != 0 ){
			ptEnd.x = 0;
			ptEnd.y++;
		}
		POINT_PTR pt;
		pt.x = 0;
		if( ptStart.y < ptEnd.y ){
			for( pt.y = ptStart.y; pt.y < ptEnd.y; pt.y++ ){
				Editor_SetCaretPos( hwndView, TRUE, &pt );
				Editor_InsertStringW( hwndView, szSpaces );
				if( ptOrgEnd.x != 0 ){
					ptOrgEnd.x += nSpaces;
				}
			}
			Editor_SetSelView( hwndView, &ptStart, &ptOrgEnd );
		}
		if( bOverwrite ){
			Editor_ExecCommand( hwndView, EEID_INSERT );
		}
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			TCHAR szKey[MAX_PATH];
			if( GetRootKeyName( szKey ) ){
				RegDeleteKey( HKEY_CURRENT_USER, szKey );
			}
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_SPACES ), hDlg, PropDlg );
		return TRUE;
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		int nSpaces = 1;
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			nSpaces = GetProfileIntReg( hKey, szNumOfSpaces, 1 );
			RegCloseKey( hKey );
		}
		if( nSpaces >= MAX_SPACES )  nSpaces = MAX_SPACES - 1;
		SetDlgItemInt( hwnd, IDC_SPACES, nSpaces, TRUE );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WORD wCmdID )
	{
		switch( wCmdID ){
		case IDOK:
			{
				int nSpaces = GetDlgItemInt( hwnd, IDC_SPACES, NULL, TRUE );
				if( nSpaces > 0 && nSpaces < MAX_SPACES ){
					HKEY hKey = GetRootKey();
					if( hKey != NULL ){
						WriteProfileIntReg( hKey, szNumOfSpaces, nSpaces );
						RegCloseKey( hKey );
					}
					EndDialog( hwnd, IDOK );
				}
			}
			break;
		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
	}

};

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	}
	return bResult;
}

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT


