﻿#include <windows.h>
#include <tchar.h>
#include "plugin.h"
#include "resource.h"

//using namespace std;

//////////////////////////////////////////////////////////////////////////////

namespace {

//	インスタンスハンドル
HINSTANCE	instance;

//	配列サイズ取得
template <typename T,size_t N> size_t GetArraySize( T(&)[N] ){ return N; }

//	ストリングテーブルから文字列取得
LRESULT	GetStringFromTable( UINT id, UINT_PTR cb, wchar_t* buf )
{
	wchar_t	name[4096];
	if( !LoadStringW( instance, id, name, (int)GetArraySize(name) ) ) *name = NULL;

	if( buf && cb > 0 )
		wcscpy_s( buf, cb, name );
	return	_tcslen(name) + 1;
}

//	キュメントが変更されてるか
bool IsChanged( HWND hwnd, int doc = -1 )
{
	wchar_t	full_title[MAX_PATH];
	wchar_t	save_as_title[MAX_PATH];
	Editor_DocInfo( hwnd, doc, EI_GET_FULL_TITLEW, (LPARAM)&full_title[0] );
	Editor_DocInfo( hwnd, doc, EI_GET_SAVE_AS_TITLEW, (LPARAM)&save_as_title[0] );
	return	wcscmp( full_title, save_as_title ) != 0;
}

};

//////////////////////////////////////////////////////////////////////////////

//	メニューかツールバーからプラグインを選択したときに呼び出されます 
EXTERN_C void	WINAPI OnCommand( HWND hwnd )
{
	const int doc( (int)Editor_Info( hwnd, EI_GET_ACTIVE_INDEX, 0 ) );

	wchar_t	title[MAX_PATH] = {0};
	Editor_DocInfo( hwnd, doc, EI_GET_SHORT_TITLEW, (LPARAM)&title[0] );

	if( IsChanged( hwnd, doc ) ){
		wchar_t buf[2048];
		swprintf_s( buf, L"\"%s\"\nこの文書を保存し、マクロとして実行しますか？", title );
		if( MessageBox( hwnd, buf, L"マクロ選択＆実行", MB_OKCANCEL | MB_ICONQUESTION ) != IDOK ) return;
		Editor_DocInfo( hwnd, doc, EI_SAVE_DOC, 0 );
		if( IsChanged( hwnd, doc ) ){
			MessageBox( hwnd, L"保存されませんでした。", L"マクロ選択＆実行", MB_OK );
			return;
		}
	}else{
		wchar_t buf[2048];
		swprintf_s( buf, L"\"%s\"\nこの文書をマクロとして実行しますか？", title );
		if( MessageBox( hwnd, buf, L"マクロ選択＆実行", MB_OKCANCEL | MB_ICONQUESTION ) != IDOK ) return;
	}

	Editor_ExecCommand( hwnd, EEID_MACRO_SELECT_THIS );
	Editor_ExecCommand( hwnd, EEID_QUICK_MACRO_RUN	 );
}

//	状態が変更されたときにイベントが指定されて呼び出されます 
EXTERN_C void	WINAPI OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam ) 
{
}


//////////////////////////////////////////////////////////////////////////////

//	プラグインが実行可能か、またはチェックされた状態かを調べます 
EXTERN_C BOOL	WINAPI QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	if( pbChecked ) *pbChecked = false;
	return	true;
}

//	プラグインの情報取得
namespace {
LRESULT	GetInfo( UINT_PTR flag )
{
	switch( flag ){
	case EPGI_ALLOW_OPEN_SAME_GROUP:	return	true;			//	ファイルを同じグループ内で開くことを許す場合に TRUE を返します。 
	case EPGI_ALLOW_MULTIPLE_INSTANCES:	return	true;			//	プラグインが複数インスタンスをサポートする場合に TRUE を返します。プラグインが 2 個以上のフレームで同時に動作することが許される場合には、このメッセージは TRUE を返す必要があります。複数インスタンスが実行している間、グローバル変数は共有されることに注意してください。 
	case EPGI_MAX_EE_VERSION:			return	99 * 1000;		//	対応するもっとも新しい EmEditor のバージョン番号 * 1000 を返します。 
	case EPGI_MIN_EE_VERSION:			return	 9 * 1000;		//	対応するもっとも古い EmEditor のバージョン番号 * 1000 を返します。 
	case EPGI_SUPPORT_EE_PRO:			return	true;			//	EmEditor Professional をサポートする場合に TRUE を返します。 
	case EPGI_SUPPORT_EE_STD:			return	true;			//	EmEditor Standard をサポートする場合に TRUE を返します。 
	}
	return	0;
}
};

//	プラグインへのメッセージを使って、さまざまな設定や取得を行います。 
EXTERN_C LRESULT	WINAPI PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam ) 
{
	switch( nMsg ){
	case EP_GET_BITMAP:			return	0;																//	ツールバーに表示される様々なサイズと色数のプラグイン ボタンのビットマップのリソースIDを取得します。
	case EP_GET_INFO:			return	GetInfo( wParam );												//	プラグインに関するさまざまな情報を取得します。(Version 5.00 以上で対応)
	case EP_GET_MASK:			return	RGB(255,255,255);												//	ツールバーに表示されるプラグイン ボタンのマスク カラーを取得します
	case EP_GET_NAME:			return	GetStringFromTable( IDS_NAME,	 wParam, (wchar_t*)lParam );	//	プラグインの名前を取得します。
	case EP_GET_VERSION:		return	GetStringFromTable( IDS_VERSION, wParam, (wchar_t*)lParam );	//	プラグインのバージョンを取得します。
	case EP_QUERY_PROPERTIES:	return	false;															//	プロパティが利用可能かどうかを調べます。
	case EP_SET_PROPERTIES:		return	false;															//	プロパティの表示を指示します。
	case EP_QUERY_UNINSTALL:	return	true;															//	アンインストールが利用可能かどうかを調べます。
	case EP_SET_UNINSTALL:		return	UNINSTALL_SIMPLE_DELETE;										//	アンインストールを実行します。
	case EP_PRE_TRANSLATE_MSG:	return	false;															//	Windows メッセージを変換する前に呼び出されます。
	}
	return	0;
}

//	リソースID取得
EXTERN_C UINT	WINAPI GetMenuTextID(){			return	IDS_MENUTEXT;		}	//	プラグインのメニューアイテムテキストのリソースIDを取得します 
EXTERN_C UINT	WINAPI GetStatusMessageID(){	return	IDS_STATUSMESSAGE;	}	//	ステータスバーテキストとツールバーのツールチップ用テキストを \n で結合した文字列のリソースIDを取得します。 
EXTERN_C UINT	WINAPI GetBitmapID(){			return	IDB_BUTTON;			}	//	ツールバーに表示されるプラグイン ボタンのビットマップのリソースIDを取得します 


//////////////////////////////////////////////////////////////////////////////

//	メイン
EXTERN_C BOOL WINAPI DllMain( HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved )
{
	switch( dwReason ){
	case DLL_PROCESS_ATTACH:	instance = hinstDLL;	break;	//	プロセスにアタッチ
	case DLL_PROCESS_DETACH:							break;	//	プロセスからデタッチ
	}
	return	true;
}

//////////////////////////////////////////////////////////////////////////////
