// implementatin of this specific plug-in is here:
//

#define MAX_MATCH_LENGTH			256
#define MAX_OUTLINE_DEPTH			6
#define UPDATE_TREE_NONE			0
#define UPDATE_OUTLINE				1
#define UPDATE_TREE_SEL				2
#define UPDATE_TREE_LINE_STRING		3
#define UPDATE_TREE_ALL				4
#define INDENT_BRACES				0
#define INDENT_SPACES				1
#define INDENT_CUSTOM				2
#define INDENT_BRACKETS				3

#define ZERO_INIT_FIRST_MEM(classname, firstmem)  ZeroMemory( &firstmem, sizeof( classname ) - ((char*)&firstmem - (char*)this) );

#define WORK_OUTLINE_ALL			1
#define WORK_TREE_SEL				2

LRESULT CALLBACK TreeProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
UINT WINAPI WorkThread(LPVOID lpData);

int WaitMessageLoop( DWORD nCount, const HANDLE* pHandles, DWORD dwMilliseconds )
{ 
	bool bQuit = false;
	int nExitCode = 0;
	DWORD dwResult = 0;
    do {
		MSG msg = { 0 }; 
        while( PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) ) { 
            if (msg.message == WM_QUIT) {
				bQuit = true;
				nExitCode = (int)msg.wParam;
				break;
			}
			else {
				DispatchMessage( &msg ); 
			}
        }
        dwResult = MsgWaitForMultipleObjects( nCount, pHandles, FALSE, dwMilliseconds, QS_ALLINPUT ); 
    } while( dwResult == WAIT_OBJECT_0 + 1 );

	if( bQuit ){
		PostQuitMessage( nExitCode );
	}
	return (int)(dwResult - WAIT_OBJECT_0);
}

void TrimLine( LPWSTR pszLine )
{
	LPWSTR p = pszLine;
	while( *p == ' ' || *p == '\t' ){
		p++;
	}
	if( p != pszLine ){
		size_t nLen = wcslen( p );
		wmemmove( pszLine, p, nLen + 1 );
	}
	// replace tabs with spaces
	p = pszLine;
	for( ;; ) {
		p = wcschr( p, '\t' );
		if( !p ){
			break;
		}
		*p++ = ' ';
	}
}


inline int ComparePath( const wchar_t * first, const wchar_t * last )
{
	DWORD lcid = MAKELCID(MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), SORT_DEFAULT);
	int nResult = CompareString(lcid, NORM_IGNORECASE, first, -1, last, -1);
	_ASSERTE( nResult != 0 );
	return (nResult - CSTR_EQUAL);
}

inline bool MyWcsncmp ( const wchar_t * first, const wchar_t * last )
{
	while( *first == *last ){
		if( *++last == 0 )  return true;   // matches whole string.
		first++;
	}
	return false;  // does not match.
}

WORD anStaticID[MAX_OUTLINE_DEPTH] = { IDC_STATIC_1, IDC_STATIC_2, IDC_STATIC_3, IDC_STATIC_4, IDC_STATIC_5, IDC_STATIC_6 };
WORD anMatchID[MAX_OUTLINE_DEPTH] = { IDC_MATCH1, IDC_MATCH2, IDC_MATCH3, IDC_MATCH4, IDC_MATCH5, IDC_MATCH6 };
WORD anRegexID[MAX_OUTLINE_DEPTH] = { IDC_REGEX1, IDC_REGEX2, IDC_REGEX3, IDC_REGEX4, IDC_REGEX5, IDC_REGEX6 };


class COutlineMatch
{
public:
	WCHAR		m_aszMatch[MAX_OUTLINE_DEPTH][MAX_MATCH_LENGTH];
	bool		m_abRegex[MAX_OUTLINE_DEPTH];

public:
	void Initialize()
	{
		for( int i = 0; i < MAX_OUTLINE_DEPTH; i++ ){
			int j;
			for( j = 0; j < i + 1; j++ ){
				m_aszMatch[i][j] = L'.';
			}
			m_aszMatch[i][j] = 0;
			m_abRegex[i] = false;
		}
	}
	
	COutlineMatch()
	{
		Initialize();
	}
};

class CProp
{
public:
	COutlineMatch m_OutlineMatch;
	WCHAR m_szConfigName[MAX_CONFIG_NAME];
	int  m_nViewLevel;
	bool m_bOutlineGuide;
	BYTE m_nIndentType;


	void Initialize()
	{
		m_OutlineMatch.Initialize();
		m_bOutlineGuide = true;
		m_nIndentType = INDENT_SPACES;
		m_nViewLevel = MAX_OUTLINE_DEPTH;
	}

	void Reset( LPCWSTR pszConfig )
	{
		_ASSERTE( *pszConfig );
		if( ComparePath( pszConfig, _T("C#") ) == 0 
			|| ComparePath( pszConfig, _T("C++") ) == 0 
			|| ComparePath( pszConfig, _T("Java") ) == 0 
			|| ComparePath( pszConfig, _T("JavaScript") ) == 0 
			|| ComparePath( pszConfig, _T("JavaScript for EmEditor") ) == 0 
			|| ComparePath( pszConfig, _T("JSP") ) == 0 
			|| ComparePath( pszConfig, _T("Perl") ) == 0 
			|| ComparePath( pszConfig, _T("PerlScript") ) == 0 
			){
			m_nIndentType = INDENT_BRACES;
			m_nViewLevel = 1;
		}
	}

	CProp()
	{
		ZeroMemory( this, sizeof( CProp ) );
		Initialize();
	}
};

typedef vector<CProp> CPropArray;


class COutlineItem
{
public:
	HTREEITEM	m_hItem;
	UINT_PTR	m_yLine;
	int			m_nLevel;
	TCHAR		m_szLine[128];

	COutlineItem( UINT_PTR yLine, int nLevel, LPCTSTR pszLine )
	{
		m_hItem = NULL;
		m_yLine = yLine;
		m_nLevel = nLevel;
		StringCopyN( m_szLine, _countof( m_szLine ), pszLine, _countof( m_szLine ) - 1 );
		TrimLine( m_szLine );
	}
};

typedef vector<COutlineItem> COutlineArray;


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_TRUE_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= CLR_NONE				};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 7010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 7000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= FALSE					};

	// user-defined members
	enum { IDW_TREE	= 100 };

	COutlineArray m_OutlineArray;
	CPropArray m_PropArray;
	CProp m_propCurr;

	// data that can be set zeros below
	HWND m_hwndTree;  // first member for data that can be set zeros
	WNDPROC m_lpOldTreeProc;
	HTREEITEM m_hTargetItem;
	HTREEITEM m_hSrcItem;
	HANDLE m_hWorkThread;
	HANDLE m_hQueEvent;
	HANDLE m_hMutex;
	INT_PTR m_yPos;
	UINT m_nClientID;
	int  m_iPos;
	int  m_iOldPos;
	int	 m_iCurrConfig;
	int  m_nWorkFlag;

	bool m_bUpdateOutline;
	bool m_bUpdateTreeSel;
	bool m_bFocusView;
	bool m_bProfileLoaded;
	bool m_bOpenStartup;
	bool m_bDragging;
	bool m_bAfterTarget;
	bool m_bUpdateOnIdle;
	bool m_bAbortThread;
	bool m_bSyncCustomBar;

	void OnCommand( HWND /*hwndView*/ )
	{
		if( m_hwndTree == NULL ){
			OpenCustomBar();
			m_bUpdateOutline = true;
		}
		else {
			CloseCustomBar();
		}
	}

	void OpenCustomBar()
	{
		if( m_hwndTree )  return;

		TCHAR sz[260];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
		if( Editor_GetVersion( m_hWnd ) < 7000 ){
			LoadString( EEGetInstanceHandle(), IDS_INVALID_VERSION, sz, _countof( sz ) );
			MessageBox( m_hWnd, sz, szAppName, MB_OK | MB_ICONSTOP );
			return;
		}

		DWORD dwStyles = WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | TVS_SHOWSELALWAYS | TVS_HASBUTTONS | TVS_LINESATROOT | TVS_HASLINES;
		// A temporary parent window is specified here.  The parent window will be substituted by the custom bar window when Editor_CustomBarOpen is called.
		m_hwndTree = CreateWindowEx( WS_EX_CLIENTEDGE, WC_TREEVIEW, NULL, dwStyles, 0, 0, 0, 0, m_hWnd, (HMENU)IDW_TREE, NULL, NULL );
		if( m_hwndTree != NULL ){
			CUSTOM_BAR_INFO cbi;
			ZeroMemory( &cbi, sizeof( cbi ) );
			cbi.cbSize = sizeof( cbi );
			cbi.hwndClient = m_hwndTree;
			cbi.iPos = m_iPos;
			cbi.pszTitle = szAppName;
			m_nClientID = Editor_CustomBarOpen( m_hWnd, &cbi );

			if( !m_nClientID ){
				CustomBarClosed();
			}
			else {
				// The parent window is set to the custom bar window.
				_ASSERTE( cbi.hwndCustomBar && GetParent( m_hwndTree ) == cbi.hwndCustomBar );
				if( m_bSyncCustomBar ){
					LoadCurrentProfile();
				}
				SubclassTree( m_hwndTree );
				m_OutlineArray.clear();
				m_bUpdateOutline = true;
			}
		}
	}

	void CloseCustomBar()
	{
		if( !m_hwndTree )  return;

		ResetThread();

		_ASSERTE( m_nClientID );
		BOOL bClosed = Editor_CustomBarClose( m_hWnd, m_nClientID );
		_ASSERTE( bClosed );
		_ASSERTE( m_lpOldTreeProc == NULL );
		_ASSERTE( m_hwndTree == NULL );
		UnsubclassTree( m_hwndTree );
		CustomBarClosed();  //  call just in case.  should not be needed since EVENT_CUSTOM_BAR_CLOSED is called.
	}

	void CustomBarClosed()
	{
		ResetThread();
		if( m_bSyncCustomBar ){
			CloseOutlineGuide();
		}

		if( m_hwndTree ){
			if( IsWindow( m_hwndTree ) ) {
				DestroyWindow( m_hwndTree );
			}
			m_hwndTree = NULL;
		}
		m_nClientID = 0;
		m_OutlineArray.clear();
	}

	void CloseOutlineGuide()
	{
		Editor_ShowOutline( m_hWnd, FALSE );
	}

	BOOL QueryStatus( HWND /* hwndView */, LPBOOL pbChecked )
	{		
		*pbChecked = (m_hwndTree != NULL);
		return TRUE;
	}

	void OnEvents( HWND hwndView, UINT nEvent, LPARAM lParam )
	{
		if( nEvent & EVENT_CREATE_FRAME ){
			//HKEY hKey = GetRootKey();
			m_bOpenStartup = !!GetProfileInt( _T("OpenStartup"), FALSE );
			m_iPos = GetProfileInt( _T("CustomBarPos"), CUSTOM_BAR_RIGHT );
			m_bSyncCustomBar = !!GetProfileInt( _T("SyncCustomBar"), TRUE );
			m_iOldPos = m_iPos;
			//if( hKey )  RegCloseKey( hKey );

			if( m_bOpenStartup ){
				OnCommand( hwndView );
			}
			else {
				if( !m_bSyncCustomBar ){
					LoadCurrentProfile();
				}
				if( m_propCurr.m_bOutlineGuide ){
					m_bUpdateOnIdle = true;
				}
			}
		}
		if( nEvent & EVENT_CLOSE_FRAME ){
			CloseCustomBar();
		}
		if( nEvent & (EVENT_CONFIG_CHANGED | EVENT_FILE_OPENED ) ) {
			if( m_hwndTree || !m_bSyncCustomBar ){
				ResetThread();
				LoadCurrentProfile();
				m_bUpdateOutline = true;
				if( !m_propCurr.m_bOutlineGuide ){
					CloseOutlineGuide();
				}
			}
		}
		if( nEvent & EVENT_CUSTOM_BAR_CLOSING ){
			// this message arrives even if plug-in does not own this custom bar, so make sure it is mine.
			if( m_hwndTree != NULL ){
				CUSTOM_BAR_CLOSE_INFO* pCBCI = (CUSTOM_BAR_CLOSE_INFO*)lParam;
				if( pCBCI->nID == m_nClientID ){
					_ASSERTE( m_hwndTree );
					_ASSERTE( GetParent( m_hwndTree ) );
					ResetThread();
					UnsubclassTree( m_hwndTree );
				}
			}
		}
		if( nEvent & EVENT_CUSTOM_BAR_CLOSED ){
			// this message arrives even if plug-in does not own this custom bar, so make sure it is mine.
			if( m_hwndTree != NULL ){  
				CUSTOM_BAR_CLOSE_INFO* pCBCI = (CUSTOM_BAR_CLOSE_INFO*)lParam;
				if( pCBCI->nID == m_nClientID ){
					_ASSERT( !IsWindow( m_hwndTree ) );
					CustomBarClosed();
					m_bOpenStartup = (pCBCI->dwFlags & CLOSED_FRAME_WINDOW);
					//HKEY hKey = GetRootKey();
					WriteProfileInt( _T("OpenStartup"), m_bOpenStartup );
					//if( hKey )  RegCloseKey( hKey );
				}
			}
		}
		if( nEvent & EVENT_DOC_SEL_CHANGED ){
			if( m_hwndTree || !m_bSyncCustomBar ){
				ResetThread();
				m_bUpdateOutline = true;
			}
		}
		if( nEvent & EVENT_CHANGE ){
			if( m_hwndTree || !m_bSyncCustomBar ){
				m_bUpdateOnIdle = true;
			}
		}
		if( nEvent & EVENT_CARET_MOVED ){
			if( m_hwndTree || !m_bSyncCustomBar ){
				POINT_PTR ptPos;
				Editor_GetCaretPos( m_hWnd, POS_LOGICAL_W, &ptPos );
				if( ptPos.y != m_yPos ){
					m_yPos = ptPos.y;
					m_bUpdateTreeSel = true;
				}
			}
		}
		if( nEvent & EVENT_IDLE ){
			OnIdle();
		}
	}

	void OnIdle()
	{
		if( m_hwndTree || !m_bSyncCustomBar ){
			if( m_bUpdateOutline || m_bUpdateOnIdle || m_bUpdateTreeSel ){
				if( !m_hWorkThread ){
					m_hWorkThread = (HANDLE)_beginthreadex( NULL, 0, WorkThread, this, 0, NULL );
					_ASSERTE( m_hWorkThread );
					if( m_hWorkThread ){
						VERIFY( SetThreadPriority( m_hWorkThread, THREAD_PRIORITY_LOWEST ) );
					}
				}
			}

			if( m_bUpdateOutline || m_bUpdateOnIdle ){
				if( m_hwndTree && m_iPos != m_iOldPos ){
					m_iOldPos = m_iPos;
					CloseCustomBar();
					OpenCustomBar();
				}
				m_nWorkFlag = WORK_OUTLINE_ALL;
				SetEvent( m_hQueEvent );
			}
			else if( m_bUpdateTreeSel ){
				m_nWorkFlag = WORK_TREE_SEL;
				SetEvent( m_hQueEvent );
			}
			if( m_bFocusView ){
				Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
			}
			m_bUpdateOnIdle = false;
			m_bUpdateOutline = false;
			m_bUpdateTreeSel = false;
			m_bFocusView = false;
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam )
	{
		TCHAR szProductCode[80] = { 0 };
		HKEY hKey = NULL;
		if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, _T("Software\\EmSoft\\EmEditorPlugIns\\OutlineText"), 0, KEY_READ, &hKey ) == ERROR_SUCCESS && hKey ){
			GetProfileStringReg( hKey, _T("ProductCode"), szProductCode, _countof( szProductCode ), _T("") );
			if( szProductCode[0] ){
				GetSystemDirectory( pszUninstallCommand, MAX_PATH );
				PathAppend( pszUninstallCommand, _T("msiexec.exe") );
				StringPrintf( pszUninstallParam, MAX_PATH, _T("/X%s"), szProductCode );
				RegCloseKey( hKey );
				return UNINSTALL_RUN_COMMAND;
			}
		}
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	BOOL PreTranslateMessage( HWND /*hwndView*/, MSG* pMsg )
	{
		if( m_hwndTree && m_hwndTree == GetFocus() ){
			if( pMsg->message == WM_KEYDOWN ){
				bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
				bool bShift = GetKeyState( VK_SHIFT ) < 0;
				if( !bCtrl ){
					if( pMsg->wParam == VK_ESCAPE ){
						if( !bShift ){
							Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
							return TRUE;
						}
					}
					//else if( pMsg->wParam == VK_F6 ){
					//	Editor_ExecCommand( m_hWnd, bShift ? EEID_PREV_PANE : EEID_NEXT_PANE );
					//	return TRUE;
					//}
				}

				if( pMsg->wParam >= VK_PRIOR && pMsg->wParam <= VK_DELETE || pMsg->wParam == VK_TAB || pMsg->wParam == VK_BACK || pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN ){
					SendMessage( GetFocus(), pMsg->message, pMsg->wParam, pMsg->lParam );
					return TRUE;
				}
			}
			if( pMsg->message == WM_SYSKEYDOWN ){
					if( m_hwndTree == GetFocus() ){
						if( pMsg->wParam == VK_UP || pMsg->wParam == VK_DOWN ){
							if( GetKeyState(VK_MENU) < 0 ){
								OnTreeMove( NULL, pMsg->wParam == VK_DOWN );
								return TRUE;
							}
						}
					}
			}
			if( IsDialogMessage( m_hwndTree, pMsg ) ){
				return TRUE;
			}
		}
		return FALSE;
	}

	CMyFrame()
	{
		ZERO_INIT_FIRST_MEM( CMyFrame, m_hwndTree );
		m_bSyncCustomBar = true;
		m_iPos = m_iOldPos = CUSTOM_BAR_RIGHT;
		m_hQueEvent = CreateEvent( NULL, TRUE, FALSE, NULL );
		m_hMutex = CreateMutex( NULL, FALSE, NULL );
		_ASSERTE( m_hMutex );
	}

	~CMyFrame()
	{
		ResetThread();
		if( m_hQueEvent ){
			CloseHandle( m_hQueEvent );
			m_hQueEvent = NULL;
		}
		if( m_hMutex ){
			CloseHandle( m_hMutex );
			m_hMutex = NULL;
		}
	}

	void ResetThread()
	{
		if( m_hWorkThread ){
			m_bAbortThread = true;
			SetEvent( m_hQueEvent );
			VERIFY( SetThreadPriority( m_hWorkThread, THREAD_PRIORITY_ABOVE_NORMAL ) );
			WaitMessageLoop( 1, &m_hWorkThread, INFINITE );  // might block
			CloseHandle( m_hWorkThread );
			m_hWorkThread = NULL;
			if( m_hwndTree && IsWindow( m_hwndTree ) ) {
				SendMessage( m_hwndTree, WM_SETREDRAW, FALSE, 0 );
				TreeView_DeleteAllItems( m_hwndTree );
				SendMessage( m_hwndTree, WM_SETREDRAW, TRUE, 0 );
			}
			m_OutlineArray.clear();
		}
	}

#pragma warning( push )
#pragma warning( disable : 4244 ) // 'argument' : conversion from 'LONG_PTR' to 'LONG', possible loss of data
#pragma warning( disable : 4312 )  // 'type cast' : conversion from 'LONG' to 'WNDPROC' of greater size

	void SubclassTree( HWND hwndTree )
	{
		_ASSERTE( m_lpOldTreeProc == NULL );
		m_lpOldTreeProc = (WNDPROC)SetWindowLongPtr( hwndTree, GWLP_WNDPROC, (LONG_PTR)TreeProc );
	}

	void UnsubclassTree( HWND hwndTree )
	{
		if( m_lpOldTreeProc != NULL ){
			SetWindowLongPtr( hwndTree, GWLP_WNDPROC, (LONG_PTR)m_lpOldTreeProc );
			m_lpOldTreeProc = NULL;
		}
	}

#pragma warning( pop )

	int CalcIndent( LPWSTR szLine, int nLevel, BOOL* pbApplyBefore, int* pnCustomBarLevel )
	{
		*pbApplyBefore = FALSE;
		*pnCustomBarLevel = 0;
		LPWSTR p = szLine;
		if( m_propCurr.m_nIndentType == INDENT_BRACES || m_propCurr.m_nIndentType == INDENT_BRACKETS ){
			WCHAR chBegin = m_propCurr.m_nIndentType == INDENT_BRACES ? '{' : '[';
			WCHAR chEnd = m_propCurr.m_nIndentType == INDENT_BRACES ? '}' : ']';
			*pbApplyBefore = TRUE;
			bool bTested = false;
			while( *p ){
				if( *p == '/' ){
					if( *(p+1) == '/' ){
						break;
					}
				}
				else if( *p == chBegin ){
					if( !bTested ){
						bTested = true;
						*pbApplyBefore = FALSE;
						for( LPWSTR pTemp = szLine; pTemp != p; pTemp++ ){
							if( *pTemp != ' ' && *pTemp != '\t' ){
								*pbApplyBefore = TRUE;
								break;
							}
						}
					}
					nLevel++;
				}
				else if( *p == chEnd ){
					nLevel--;
				}
				p++;
			}
			if( nLevel < 0 )  nLevel = 0;
		}
		else if( m_propCurr.m_nIndentType == INDENT_SPACES ){
			if( szLine[0] ){
				nLevel = 0;
				while( *p == '\t' || *p == ' ' ) {
					nLevel++;
					p++;
				}
			}
		}
		else if( m_propCurr.m_nIndentType == INDENT_CUSTOM ){
			*pnCustomBarLevel = CalcOutlineCustom( szLine, false );
			if( *pnCustomBarLevel != 0 ){
				nLevel = *pnCustomBarLevel;
			}
			*pbApplyBefore = TRUE;
		}
		return nLevel;
	}

	int CalcOutlineCustom( LPWSTR szLine, bool bStripPrefix )
	{
		for( int i = MAX_OUTLINE_DEPTH - 1; i >= 0; i-- ){
			if( m_propCurr.m_OutlineMatch.m_aszMatch[i][0] != '\0' ){
				if( m_propCurr.m_OutlineMatch.m_abRegex[i] ){
					MATCH_REGEX_INFO MatchRegexInfo;
					ZeroMemory( &MatchRegexInfo, sizeof( MatchRegexInfo ) );
					MatchRegexInfo.cbSize = sizeof( MatchRegexInfo );
					MatchRegexInfo.nFlags = FLAG_FIND_CASE;
					MatchRegexInfo.pszRegex = m_propCurr.m_OutlineMatch.m_aszMatch[i];
					MatchRegexInfo.pszText = szLine;
					if( Editor_MatchRegex( m_hWnd, &MatchRegexInfo ) ){
						return i + 1;
					}
				}
				else if( MyWcsncmp( szLine, m_propCurr.m_OutlineMatch.m_aszMatch[i] ) ){
					if( bStripPrefix ){
						size_t cchLen = wcslen( m_propCurr.m_OutlineMatch.m_aszMatch[i] );
						size_t cchLine = wcslen( szLine );
						wmemmove_s( szLine, cchLine + 1, szLine + cchLen, cchLine - cchLen + 1 );
					}
					return i + 1;
				}
			}
		}
		return 0;
	}

	void SetOutlineLevel( UINT_PTR yLine, int nLevel, LPCWSTR /*pszText*/ )
	{
		Editor_SetOutlineLevel( m_hWnd, yLine, nLevel );
	}

	void OutlineAll()
	{
		TRACE( _T("WorkThread -- OutlineAll()\n") );
		UINT_PTR nTotalLines = Editor_GetLines( m_hWnd, POS_LOGICAL_W );
		COutlineArray TempArray;
		WCHAR szText[2000];
		GET_LINE_INFO gli;
		gli.flags = FLAG_LOGICAL;
		gli.cch = _countof( szText );

// calculate indent
		UINT_PTR yOldLine = (UINT_PTR)-1;
		UINT_PTR yEmptyLine = (UINT_PTR)-1;
		int nLevel = 0;
		gli.flags = FLAG_LOGICAL;
		gli.cch = _countof( szText );

		for( gli.yLine = 0; gli.yLine != nTotalLines; gli.yLine++ ){
			if( m_bAbortThread ){
				break;
			}

			szText[0] = 0;
			Editor_GetLineW( m_hWnd, &gli, szText );
			BOOL bApplyBefore;
			int nCustomBarLevel = 0;
			int nNewLevel = CalcIndent( szText, nLevel, &bApplyBefore, &nCustomBarLevel );
			if( nNewLevel < 0 )  nNewLevel = 0;

			if( !szText[0] && yEmptyLine == (UINT_PTR)-1 ){
				yEmptyLine = gli.yLine;
			}

			if( m_propCurr.m_bOutlineGuide ){
				if( bApplyBefore || gli.yLine == 0 ){
					if( nCustomBarLevel > 0 && nLevel > 0 ){
						SetOutlineLevel( gli.yLine, (nNewLevel - 1), szText );
					}
					else {
						SetOutlineLevel( gli.yLine, nLevel, szText );
					}
				}
				else {
					if( yEmptyLine != (UINT_PTR)-1 && szText[0] ){
						for( UINT_PTR y = yEmptyLine; y < gli.yLine; y++ ){
							SetOutlineLevel( y, nNewLevel, szText );
						}
					}
					SetOutlineLevel( gli.yLine, nNewLevel, szText );
				}
			}
			
			if( m_hwndTree ){
				if( m_propCurr.m_nIndentType == INDENT_BRACES || m_propCurr.m_nIndentType == INDENT_BRACKETS || m_propCurr.m_nIndentType == INDENT_SPACES ){
					if( nNewLevel <= m_propCurr.m_nViewLevel ){
						if( nNewLevel > nLevel && nNewLevel > 0 ){
							UINT_PTR yLine;
							if( !bApplyBefore && gli.yLine > 0 && yOldLine != gli.yLine - 1 ){
								if( yEmptyLine != (UINT_PTR)-1 && yEmptyLine > 0 && szText[0] ){
									yLine = yEmptyLine - 1;
								}
								else {
									yLine = gli.yLine - 1;
								}
								szText[0] = 0;
								UINT_PTR yTemp = gli.yLine;
								gli.yLine = yLine;
								Editor_GetLineW( m_hWnd, &gli, szText );
								gli.yLine = yTemp;
							}
							else {
								yLine = gli.yLine;
							}
							TempArray.insert( TempArray.end(), COutlineItem( yLine, min( nNewLevel, MAX_OUTLINE_DEPTH ), szText ) );
							yOldLine = yLine;
						}
					}
				}
				else if( nCustomBarLevel > 0 ){
					if( nCustomBarLevel <= m_propCurr.m_nViewLevel ){
						TempArray.insert( TempArray.end(), COutlineItem( gli.yLine, min( nCustomBarLevel, MAX_OUTLINE_DEPTH ), szText ) );
					}
				}
			}
			nLevel = nNewLevel;

			if( szText[0] ){
				yEmptyLine = (UINT_PTR)-1;
			}
		}

		if( m_bAbortThread ){
			return;
		}

		if( m_propCurr.m_bOutlineGuide ){
			Editor_ShowOutline( m_hWnd, TRUE );
		}

		if( m_bAbortThread ){
			return;
		}

		if( m_hwndTree ){
			bool bUpdateAll = false;

			COutlineArray::iterator itFirstUpdate = m_OutlineArray.end();
			// compare TempArray with the previous array
			COutlineArray::iterator itTemp = TempArray.begin();
			COutlineArray::iterator it = m_OutlineArray.begin();
			if( m_OutlineArray.size() == 0 /* || TempArray.size() != m_OutlineArray.size() */ ){
				// not same size, need to update the whole tree
				itFirstUpdate = m_OutlineArray.begin();
				bUpdateAll = true;
				TreeView_DeleteAllItems( m_hwndTree );
			}
			else { 
				for( ; it != m_OutlineArray.end() && itTemp != TempArray.end(); it++, itTemp++ ){
					if( m_bAbortThread ){
						return;
					}

					if( it->m_nLevel != itTemp->m_nLevel ){
						if( !bUpdateAll ){
							itFirstUpdate = it;
							// not same, need to update the whole tree
							bUpdateAll = true;
						}
					}
					if( bUpdateAll ){
						for( ;; ){
							HTREEITEM hItem = TreeView_GetNextVisible( m_hwndTree, it->m_hItem );
							if( !hItem )  break;
							VERIFY( TreeView_DeleteItem( m_hwndTree, hItem ) );
						}
						TreeView_DeleteItem( m_hwndTree, it->m_hItem );
						break;
					}
				}
			}

			COutlineArray::iterator itSrc = TempArray.begin();
			COutlineArray::iterator itDest = m_OutlineArray.begin();
			for( ; itDest != itFirstUpdate && itSrc != TempArray.end(); itDest++, itSrc++ ){
				HTREEITEM hItem = itDest->m_hItem;
				*itDest = *itSrc;
				itDest->m_hItem = hItem;
			}
			if( itDest != m_OutlineArray.end() ){
				if( !bUpdateAll ){
					bUpdateAll = true;
				}
				_ASSERTE( itDest->m_hItem );
				for( ;; ){
					HTREEITEM hItem = TreeView_GetNextVisible( m_hwndTree, itDest->m_hItem );
					if( !hItem )  break;
					VERIFY( TreeView_DeleteItem( m_hwndTree, hItem ) );
				}
				TreeView_DeleteItem( m_hwndTree, itDest->m_hItem );
				m_OutlineArray.erase( itDest, m_OutlineArray.end() );
			}

			INT_PTR nIncrement = TempArray.end() - itSrc;

			size_t nSize = m_OutlineArray.size() + nIncrement;

			m_OutlineArray.reserve( nSize );

			for( ; itSrc != TempArray.end(); itSrc++ ){
				if( !bUpdateAll ){
					bUpdateAll = true;
				}
				_ASSERTE( itSrc->m_hItem == NULL );
				m_OutlineArray.push_back( *itSrc );
			}
			ValidateOutlineArray();

			if( m_bAbortThread ){
				return;
			}

			if( m_hwndTree ){
				if( bUpdateAll ){
					UpdateTreeAll();
				}
				else {
					UpdateTreeString();
				}
			}
		}
	}

	void ValidateOutlineArray()
	{
	#ifdef _DEBUG
		INT_PTR y = -1;
		for( COutlineArray::iterator it = m_OutlineArray.begin(); it != m_OutlineArray.end(); it++ ){
			if( (INT_PTR)it->m_yLine == y ){
				TRACE( _T("ValidateOutlineArray: yLine = %d duplicate line number found.\n"), y );
				_ASSERTE( FALSE );
			}
			if( (INT_PTR)it->m_yLine < y ){
				TRACE( _T("ValidateOutlineArray: yLine = %d line number not in order.\n"), y );
				_ASSERTE( FALSE );
			}
			y = it->m_yLine;
		}
	#endif
	}

	UINT_PTR GetCurrentLine( HWND hwndView )
	{
		POINT_PTR ptCurrentPos;
		Editor_GetCaretPos( hwndView, POS_LOGICAL_W, &ptCurrentPos );
		return ptCurrentPos.y;
	}

	void UpdateTreeAll()
	{
		_ASSERTE( m_hwndTree );
		SendMessage( m_hwndTree, WM_SETREDRAW, FALSE, 0 );

		HTREEITEM ahParentItem[MAX_OUTLINE_DEPTH + 1];
		ZeroMemory( ahParentItem, sizeof( ahParentItem ) );
		for( int i = 0; i < MAX_OUTLINE_DEPTH + 1; i++ ){
			ahParentItem[ i ] = TVI_ROOT;
		}

		TVINSERTSTRUCT tvi;
		ZeroMemory( &tvi, sizeof( tvi ) );
		tvi.hParent = TVI_ROOT;
		tvi.hInsertAfter = TVI_LAST;
		tvi.item.mask = TVIF_PARAM | TVIF_TEXT;

		TVITEM item = { 0 };
		item.mask = TVIF_TEXT | TVIF_PARAM;

		HTREEITEM hItem = NULL;

		tvi.item.pszText = LPSTR_TEXTCALLBACK;

		for( COutlineArray::iterator it = m_OutlineArray.begin(); it != m_OutlineArray.end(); it++ ){
			if( m_bAbortThread ){
				return;
			}

			if( it->m_hItem ){
				item.hItem = it->m_hItem;
				item.mask = TVIF_TEXT;
				item.pszText = LPSTR_TEXTCALLBACK;
				TreeView_SetItem( m_hwndTree, &item );
			}
			else {
				item.mask = TVIF_TEXT | TVIF_PARAM;
				_ASSERTE( it->m_nLevel >= 1 && it->m_nLevel <= MAX_OUTLINE_DEPTH );
				if( ahParentItem[ it->m_nLevel - 1 ] == NULL ){
					tvi.hParent = hItem;
				}
				else {
					tvi.hParent = ahParentItem[ it->m_nLevel - 1 ];
				}

				tvi.item.lParam = (it - m_OutlineArray.begin());
				hItem = TreeView_InsertItem( m_hwndTree, &tvi );
				it->m_hItem = hItem;
			}
			for( int i = it->m_nLevel; i < MAX_OUTLINE_DEPTH + 1; i++ ){
				ahParentItem[ i ] = it->m_hItem;
			}
		}
		SendMessage( m_hwndTree, WM_SETREDRAW, TRUE, 0 );
		UpdateTreeSel();
	}


	void UpdateTreeSel()
	{
		TRACE( _T("WorkThread -- UpdateTreeSel()\n") );
		if( !m_hwndTree )  return;
		if( m_OutlineArray.empty() ){
			return;
		}
		UINT_PTR yCurrentLine = GetCurrentLine( m_hWnd );
		COutlineArray::iterator it;
		for( it = m_OutlineArray.begin(); it != m_OutlineArray.end(); it++ ){
			if( yCurrentLine == it->m_yLine ){
				break;
			}
			else if( it->m_yLine > yCurrentLine ){
				if( it != m_OutlineArray.begin() ){
					it--;
				}
				break;
			}
		}
		if( it == m_OutlineArray.end() ){
			it--;
		}

		_ASSERTE( it->m_hItem );
		if( it->m_hItem == NULL )  return;

		VERIFY( TreeView_SelectItem( m_hwndTree, it->m_hItem ) );
		EnsureVisible( it->m_hItem );
	}


	void UpdateTreeString()
	{
		_ASSERTE( m_hwndTree );
		TVITEM item = { 0 };
		item.mask = TVIF_TEXT;
		for( COutlineArray::iterator it = m_OutlineArray.begin(); it != m_OutlineArray.end(); it++ ){
			if( it->m_hItem != NULL ){
				item.hItem = it->m_hItem;
				item.pszText = LPSTR_TEXTCALLBACK;
				TreeView_SetItem( m_hwndTree, &item );
			}
		}
	}

	int GetOutline( HTREEITEM hItem )
	{
		if( !hItem )  return -1;
		TVITEM item = { 0 };
		item.hItem = hItem;
		item.mask = TVIF_PARAM;
		BOOL bRet = TreeView_GetItem( m_hwndTree, &item );
		if( !bRet )  return -1;
		int iOutline = (int)item.lParam;
		return iOutline;
	}

	void OnOutlineSelected( HTREEITEM hItem, bool bFocusView, bool bSelect )
	{
		_ASSERTE( m_hwndTree );
		int iOutline = GetOutline( hItem );
		if( iOutline < 0 || iOutline >= (int)m_OutlineArray.size() )  return;
		POINT_PTR ptPos = { 0 };
		Editor_GetCaretPos( m_hWnd, POS_LOGICAL_W, &ptPos );
		ptPos.y = m_OutlineArray[ iOutline ].m_yLine;
		Editor_SetCaretPos( m_hWnd, POS_LOGICAL_W | POS_SCROLL_TOP, &ptPos );
		if( bFocusView ){
			m_bFocusView = true;
		}
		if( bSelect ){
			POINT_PTR ptPosBottom = { 0 };
			if( iOutline < (int)m_OutlineArray.size() - 1 ){
				ptPosBottom.y = m_OutlineArray[ iOutline + 1 ].m_yLine;
			}
			else {
				ptPosBottom.y = Editor_GetLines( m_hWnd, POS_LOGICAL_W ) - 1;
			}
			Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPosBottom, FALSE );
			Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, TRUE );
		}
	}

	void LoadCurrentProfile()
	{
		WCHAR szCurrConfig[MAX_CONFIG_NAME];
		szCurrConfig[0] = 0;
		Editor_GetConfigW( m_hWnd, szCurrConfig );
		m_propCurr.Initialize();
		if( szCurrConfig[0] ){
			LoadProfile( &m_propCurr, szCurrConfig );
		}
	}

	void LoadProfile( CProp* pProp, LPCWSTR pszConfig )
	{
		if( !pszConfig[0] )  return;
		StringCopy( pProp->m_szConfigName, MAX_CONFIG_NAME, pszConfig );
		TCHAR szEntry[MAX_CONFIG_NAME + 40];
		StringCopy( szEntry, _countof( szEntry ), _T("Config-") );
		StringCat( szEntry, _countof( szEntry ), pszConfig );
		if( sizeof( CProp ) != GetProfileBinary( szEntry, (LPBYTE)pProp, sizeof( CProp ) ) ) {
			pProp->Reset( pszConfig );
		}
	}

	void SaveProfile( CProp* pProp )
	{
		if( !pProp->m_szConfigName[0] )  return;
		TCHAR szEntry[MAX_CONFIG_NAME + 40];
		StringCopy( szEntry, _countof( szEntry ), _T("Config-") );
		StringCat( szEntry, _countof( szEntry ), pProp->m_szConfigName );
		WriteProfileBinary( szEntry, (const LPBYTE)pProp, sizeof( CProp ), false );
	}

	void ShowHide( HWND hwnd )
	{
		int nIndentType = (int)SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_GETCURSEL, 0, 0 );
		BOOL bEnable = (nIndentType == INDENT_CUSTOM);
		for( int i = 0; i < MAX_OUTLINE_DEPTH; i++ ) {
			EnableWindow( GetDlgItem( hwnd, anStaticID[i] ), bEnable );
			EnableWindow( GetDlgItem( hwnd, anMatchID[i] ), bEnable );
			EnableWindow( GetDlgItem( hwnd, anRegexID[i] ), bEnable );
		}
	}

	void UpdateData( HWND hwnd, CProp* pProp )
	{
		COutlineMatch& OutlineMatch = pProp->m_OutlineMatch;
		for( int i = 0; i < MAX_OUTLINE_DEPTH; i++ ) {
			SetDlgItemText( hwnd, anMatchID[i], OutlineMatch.m_aszMatch[i] );
			CheckDlgButton( hwnd, anRegexID[i], OutlineMatch.m_abRegex[i] );
		}
		CheckDlgButton( hwnd, IDC_OUTLINE_GUIDE, pProp->m_bOutlineGuide );
		SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_SETCURSEL, pProp->m_nIndentType, 0 );
		SendDlgItemMessage( hwnd, IDC_VIEW_LEVEL, CB_SETCURSEL, pProp->m_nViewLevel - 1, 0 );
		ShowHide( hwnd );
	}

	void AddProfileArray( LPCWSTR pszConfig )
	{
		CProp prop;
		LoadProfile( &prop, pszConfig );
		m_PropArray.push_back( prop );
	}

	int FillComboConfig( HWND hwndCombo )
	{
		TCHAR szCurrConfig[MAX_CONFIG_NAME];
		szCurrConfig[0] = 0;
		Editor_GetConfigW( m_hWnd, szCurrConfig );
		size_t cchBuf = Editor_EnumConfig( m_hWnd, NULL, 0 );
		if( !cchBuf )  return 0;

		LPWSTR pszBuf = new WCHAR[ cchBuf ];
		if( !pszBuf )  return 0;
		
		if( !Editor_EnumConfig( m_hWnd, pszBuf, cchBuf ) )  return 0;

		int nSel = -1;
		int i = 0;
		LPWSTR p = pszBuf;
		while( *p ){
			SendMessage( hwndCombo, CB_ADDSTRING, 0, (LPARAM)p );
			if( ComparePath( szCurrConfig, p ) == 0 ){
				nSel = i;
			}

			AddProfileArray( p );

			p += wcslen( p ) + 1;
			i++;
		}
		if( nSel != -1 ){
			SendMessage( hwndCombo, CB_SETCURSEL, nSel, 0 );
		}

		delete [] pszBuf;
		return i;
	}

	bool SaveData( HWND hwnd )
	{
		bool bResult = true;
		if( m_iCurrConfig == -1 )  return bResult;
		CPropArray::iterator it = m_PropArray.begin() + m_iCurrConfig;
		CProp* pProp = &*it;
		for( int i = 0; i < MAX_OUTLINE_DEPTH; i++ ) {
			if( IsDlgButtonChecked( hwnd, anRegexID[i] ) ){
				TCHAR szMatch[MAX_MATCH_LENGTH];
				GetDlgItemText( hwnd, anMatchID[i], szMatch, _countof( szMatch ) );

				MATCH_REGEX_INFO MatchRegexInfo;
				ZeroMemory( &MatchRegexInfo, sizeof( MatchRegexInfo ) );
				MatchRegexInfo.cbSize = sizeof( MatchRegexInfo );
				MatchRegexInfo.nFlags = FLAG_FIND_CASE;
				MatchRegexInfo.pszRegex = szMatch;
				MatchRegexInfo.pszText = L"";
				if( Editor_MatchRegex( m_hWnd, &MatchRegexInfo ) == -1 ){
					bResult = false;
					PostMessage( hwnd, WM_NEXTDLGCTL, (WPARAM)GetDlgItem( hwnd, anMatchID[i] ), TRUE );
					break;
				}
			}
		}

		for( int i = 0; i < MAX_OUTLINE_DEPTH; i++ ) {
			GetDlgItemText( hwnd, anMatchID[i], pProp->m_OutlineMatch.m_aszMatch[i], _countof( pProp->m_OutlineMatch.m_aszMatch[i] ) );
			pProp->m_OutlineMatch.m_abRegex[i] = !!IsDlgButtonChecked( hwnd, anRegexID[i] );
		}
		pProp->m_nIndentType = (BYTE)SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_GETCURSEL, 0, 0 );
		pProp->m_nViewLevel = (int)SendDlgItemMessage( hwnd, IDC_VIEW_LEVEL, CB_GETCURSEL, 0, 0 ) + 1;
		pProp->m_bOutlineGuide = !!IsDlgButtonChecked( hwnd, IDC_OUTLINE_GUIDE );
		m_iPos = (int)SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_GETCURSEL, 0, 0 );
		m_bSyncCustomBar = !!IsDlgButtonChecked( hwnd, IDC_SYNC_CUSTOM_BAR );
		return bResult;
	}

	void OnConfigSelChange( HWND hwnd )
	{
		HWND hwndCombo = GetDlgItem( hwnd, IDC_COMBO_CONFIG );
		if( SaveData( hwnd ) ){
			TCHAR szCurrConfig[MAX_CONFIG_NAME];
			szCurrConfig[0] = 0;
			int iConfig = (int)SendMessage( hwndCombo, CB_GETCURSEL, 0, 0 );
			if( iConfig != -1 ){
				CPropArray::iterator it = m_PropArray.begin() + iConfig;
				UpdateData( hwnd, &*it );
			}
			m_iCurrConfig = iConfig;
		}
		else {
			SendMessage( hwndCombo, CB_SETCURSEL, m_iCurrConfig, 0 );
		}
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		CheckDlgButton( hwnd, IDC_SYNC_CUSTOM_BAR, m_bSyncCustomBar );

		TCHAR sz[256];
		for( int i = 0; i < MAX_OUTLINE_DEPTH; i++ ) {
			SendDlgItemMessage( hwnd, anMatchID[i], EM_LIMITTEXT, MAX_MATCH_LENGTH - 1, 0 );
		}
		SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_RESETCONTENT, 0, 0 );
		LoadString( EEGetInstanceHandle(), IDS_TYPE_BRACES, sz, _countof( sz ) );
		SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_ADDSTRING, 0, (LPARAM)sz );
		LoadString( EEGetInstanceHandle(), IDS_TYPE_SPACES, sz, _countof( sz ) );
		SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_ADDSTRING, 0, (LPARAM)sz );
		LoadString( EEGetInstanceHandle(), IDS_TYPE_CUSTOM, sz, _countof( sz ) );
		SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_ADDSTRING, 0, (LPARAM)sz );
		LoadString( EEGetInstanceHandle(), IDS_TYPE_BRACKETS, sz, _countof( sz ) );
		SendDlgItemMessage( hwnd, IDC_COMBO_TYPE, CB_ADDSTRING, 0, (LPARAM)sz );

		SendDlgItemMessage( hwnd, IDC_VIEW_LEVEL, CB_RESETCONTENT, 0, 0 );
		StringCopy( sz, _countof( sz ), _T("1") );
		for( int i = 1; i <= MAX_OUTLINE_DEPTH; i++ ){
			SendDlgItemMessage( hwnd, IDC_VIEW_LEVEL, CB_ADDSTRING, 0, (LPARAM)sz );
			sz[0]++;
		}

		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, sz, _countof( sz ) );
		SetWindowText( hwnd, sz );

		_ASSERTE( m_PropArray.empty() );
		m_PropArray.clear();
		HWND hwndCombo = GetDlgItem( hwnd, IDC_COMBO_CONFIG );
		FillComboConfig( hwndCombo );
		m_iCurrConfig = -1;
		OnConfigSelChange( hwnd );

		for( int i = 0; i < 4; i++ ){
			LoadString( EEGetInstanceHandle(), IDS_POS_LEFT + i, sz, _countof( sz ) );
			SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_ADDSTRING, 0, (LPARAM)sz );
		}
		SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_SETCURSEL, m_iPos, 0 );
		m_iOldPos = m_iPos;
		return TRUE;
	}
	
	void TreeExpand( HTREEITEM hItem, UINT nFlag )
	{
		HTREEITEM hChildItem = TreeView_GetChild( m_hwndTree, hItem );
		while( hChildItem ){
			TreeExpand( hChildItem, nFlag );
			hChildItem = TreeView_GetNextSibling( m_hwndTree, hChildItem );
		}
		TreeView_Expand( m_hwndTree, hItem, nFlag );
	}
	
	void OnTreeExpandAll( UINT nFlag )
	{
		if( WaitMessageLoop( 1, &m_hMutex, INFINITE ) != 0 ){
			return;  // error
		}

		SendMessage( m_hwndTree, WM_SETREDRAW, FALSE, 0 );
		HTREEITEM hItem = TreeView_GetRoot( m_hwndTree );
		while( hItem ){
			TreeExpand( hItem, nFlag );
			hItem = TreeView_GetNextSibling( m_hwndTree, hItem );
		}
		SendMessage( m_hwndTree, WM_SETREDRAW, TRUE, 0 );
		VERIFY( ReleaseMutex( m_hMutex ) );
	}

	void OnDlgCommand( HWND hwnd, WPARAM wParam )
	{
		switch( wParam ){
		case IDOK:
			{
				if( SaveData( hwnd ) ){
					for( CPropArray::iterator it = m_PropArray.begin(); it != m_PropArray.end(); it++ ){
						SaveProfile( &*it );
					}
					m_PropArray.clear();

					//HKEY hKey = GetRootKey();
					WriteProfileInt( _T("CustomBarPos"), m_iPos );
					WriteProfileInt( _T("SyncCustomBar"), m_bSyncCustomBar );
					//if( hKey )  RegCloseKey( hKey );

					EndDialog( hwnd, IDOK );

					LoadCurrentProfile();
					if( !m_propCurr.m_bOutlineGuide || (!m_hwndTree && m_bSyncCustomBar) ){
						CloseOutlineGuide();
					}
					m_bUpdateOutline = true;
				}
			}
			break;

		case MAKEWPARAM( IDC_COMBO_CONFIG, CBN_SELCHANGE ):
			OnConfigSelChange( hwnd );
			break;

		case MAKEWPARAM( IDC_COMBO_TYPE, CBN_SELCHANGE ):
		case MAKEWPARAM( IDC_VIEW_LEVEL, CBN_SELCHANGE ):
			ShowHide( hwnd );
			break;

		case IDCANCEL:
			m_PropArray.clear();
			EndDialog( hwnd, IDCANCEL );
			break;

		case IDC_RESET:
			{
				CProp prop;
				prop.Reset( m_PropArray[ m_iCurrConfig ].m_szConfigName );
				UpdateData( hwnd, &prop );
				CheckDlgButton( hwnd, IDC_OUTLINE_GUIDE, TRUE );
			}
			break;
		}
		return;
	}

	void OnTreeContextMenu( bool bUseCursorPos )
	{
		HMENU hMainMenu = LoadMenu( EEGetInstanceHandle(), MAKEINTRESOURCE(IDR_CONTEXT_MENU) );
		HMENU hMenu = GetSubMenu( hMainMenu, 0 );
		HTREEITEM hItem;
		SetMenuDefaultItem( hMenu, ID_GO, FALSE );
		POINT ptPos;
		if( bUseCursorPos ){
			GetCursorPos( &ptPos );
		}
		else {
			hItem = TreeView_GetSelection( m_hwndTree );
			if( hItem != NULL ){
				RECT rc;
				TreeView_GetItemRect( m_hwndTree, hItem, &rc, TRUE );
				ptPos.y = rc.bottom;
				ptPos.x = rc.left;
			}
			else {
				ptPos.y = 4;
				ptPos.x = 4;
			}
			ClientToScreen( m_hwndTree, &ptPos );
		}
		int nID = TrackPopupMenu( hMenu, TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD, ptPos.x, ptPos.y, 0, m_hwndTree, NULL );
		DestroyMenu( hMainMenu );
		if( bUseCursorPos ){
			TVHITTESTINFO ht = { 0 };
			ScreenToClient( m_hwndTree, &ptPos );
			ht.pt.x = ptPos.x;
			ht.pt.y = ptPos.y;
			hItem = TreeView_HitTest( m_hwndTree, &ht );
		}
		else {
			hItem = TreeView_GetSelection( m_hwndTree );
		}
		if( nID == ID_GO || nID == ID_SELECT ){
			if( nID == ID_GO ){
				OnOutlineSelected( hItem, true, false );
			}
			else {
				OnOutlineSelected( hItem, false, true );
			}
		}
		else if( nID == ID_MOVE_UP || nID == ID_MOVE_DOWN ){
			OnTreeMove( hItem, nID == ID_MOVE_DOWN );
		}
		else if( nID == ID_COLLAPSE_ALL ){
			OnTreeExpandAll( TVE_COLLAPSE );
		}
		else if( nID == ID_EXPAND_ALL ){
			OnTreeExpandAll( TVE_EXPAND );
		}
		else if( nID == ID_PROP ){
			SetProperties( m_hwndTree );
		}
	}

	void OnTreeKeyDown( NMTVKEYDOWN* /*ptvkd*/ )
	{
	}

	HTREEITEM GetNextCluster( HTREEITEM hItem )
	{
		HTREEITEM hNextItem;
		do {
			hNextItem = TreeView_GetNextSibling( m_hwndTree, hItem );
			if( hNextItem != NULL )  return hNextItem;
			hItem = TreeView_GetParent( m_hwndTree, hItem );
		} while( hItem );
		return NULL;
	}

	void MoveItem( HTREEITEM hItemFrom, HTREEITEM hItemTo, bool bAfter, bool bInFolder )
	{
		if( hItemFrom == hItemTo ){
			return;
		}

		COutlineArray Array;

		int iFromTop = GetOutline( hItemFrom );
		if( iFromTop < 0 || iFromTop >= (int)m_OutlineArray.size() ){
			return;
		}

		_ASSERTE( iFromTop >= 0 );
		_ASSERTE( iFromTop < (int)m_OutlineArray.size() );

		UINT_PTR yLineFromTop = m_OutlineArray[iFromTop].m_yLine;
		HTREEITEM hNextItem = GetNextCluster( hItemFrom );
		UINT_PTR yLineFromBottom;
//		UINT_PTR xLineFromBottom = 0;
		if( hNextItem != NULL ){
			int iFromBottom = GetOutline( hNextItem );
			if( iFromBottom < 0 || iFromBottom >= (int)m_OutlineArray.size() ){
				return;
			}
			_ASSERTE( iFromBottom >= 0 );
			_ASSERTE( iFromBottom < (int)m_OutlineArray.size() );
			yLineFromBottom = m_OutlineArray[iFromBottom].m_yLine;
		}
		else {
//			yLineFromBottom = Editor_GetLines( m_hWnd, POS_LOGICAL_W ) - 1;
			Editor_ExecCommand( m_hWnd, EEID_BOTTOM );
			POINT_PTR ptBottom;
			Editor_GetCaretPos( m_hWnd, POS_LOGICAL_W, &ptBottom );
			yLineFromBottom = ptBottom.y;
			if( ptBottom.x != 0 ){
				Editor_InsertW( m_hWnd, L"\r\n" );
				yLineFromBottom++;
			}
		}

		TreeView_DeleteItem( m_hwndTree, hItemFrom );

		UINT_PTR yLine;
		int iOutline = GetOutline( hItemTo );
		_ASSERTE( iOutline >= 0 );
		if( iOutline < 0 || iOutline >= (int)m_OutlineArray.size() )  return;

		if( bInFolder || bAfter ){
			iOutline++;
			if( iOutline < (int)m_OutlineArray.size() ){
				yLine = m_OutlineArray[ iOutline ].m_yLine;
			}
			else {
				yLine = Editor_GetLines( m_hWnd, POS_LOGICAL_W ) - 1;
				Editor_ExecCommand( m_hWnd, EEID_BOTTOM );
				POINT_PTR ptBottom;
				Editor_GetCaretPos( m_hWnd, POS_LOGICAL_W, &ptBottom );
				if( ptBottom.x != 0 ){
					Editor_InsertW( m_hWnd, L"\r\n" );
					yLine++;
				}
			}
		}
		else {
			yLine = m_OutlineArray[ iOutline ].m_yLine;
		}

		Editor_Redraw( m_hWnd, FALSE );
		POINT_PTR ptPos;
		ptPos.x = 0;
		ptPos.y = yLineFromBottom;
		Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, FALSE );
		ptPos.y = yLineFromTop;
		Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, TRUE );

		UINT_PTR nSize = Editor_GetSelTextW( m_hWnd, 0, NULL );
		LPWSTR pBuf = new WCHAR[ nSize ];
		if( pBuf ){
			Editor_GetSelTextW( m_hWnd, nSize, pBuf );
//			if( xLineFromBottom > 0 ){
//				StringCat( pBuf, nSize + 2, L"\r\n" );
//			}

			if( yLine < yLineFromTop ){
				Editor_ExecCommand( m_hWnd, EEID_DELETE );
			}
			ptPos.y = yLine;
			Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, FALSE );
			Editor_InsertStringW( m_hWnd, pBuf );
			if( yLine < yLineFromTop ){
				Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, FALSE );
			}
			else {
				ptPos.y = yLineFromBottom;
				Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, FALSE );
				ptPos.y = yLineFromTop;
				Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, TRUE );
				Editor_ExecCommand( m_hWnd, EEID_DELETE );
				ptPos.y = yLine - (yLineFromBottom - yLineFromTop);
				Editor_SetCaretPosEx( m_hWnd, POS_LOGICAL_W, &ptPos, FALSE );
			}
			delete [] pBuf;
		}
		Editor_Redraw( m_hWnd, TRUE );
		m_OutlineArray.clear();
		m_bUpdateOutline = true;
	}

	void TreeMoveSub( HTREEITEM hItem, bool bDown )
	{
		HTREEITEM hItemTo;
		bool bAfter = false;
		if( bDown ){
			TreeView_Expand( m_hwndTree, hItem, TVE_COLLAPSE );
			hItemTo = TreeView_GetNextVisible( m_hwndTree, hItem );
			if( hItemTo == NULL )  return;
			bAfter = true;
		}
		else {
			hItemTo = TreeView_GetPrevVisible( m_hwndTree, hItem );
			if( hItemTo == NULL )  return;
		}
		MoveItem( hItem, hItemTo, bAfter, false );
	}

	void OnTreeMove( HTREEITEM hItem, bool bDown )
	{
		if( WaitMessageLoop( 1, &m_hMutex, INFINITE ) != 0 ){
			return;  // error
		}
		TRACE( _T("** TreeMoveSub -- Mutex acquired.\n") );
		if( hItem == NULL ){
			hItem = TreeView_GetSelection( m_hwndTree );
		}
		if( hItem != NULL ){
			TreeMoveSub( hItem, bDown );
		}
		VERIFY( ReleaseMutex( m_hMutex ) );
		TRACE( _T("** TreeMoveSub -- Mutex released.\n") );
	}

	void OnTreeBeginDrag( NMTREEVIEW* lpnmtv )
	{
		HIMAGELIST himl;
		m_hSrcItem = lpnmtv->itemNew.hItem;
		himl = TreeView_CreateDragImage(m_hwndTree, lpnmtv->itemNew.hItem); 
		ImageList_BeginDrag( himl, 0, 0, 0 );
		ImageList_DragEnter( m_hwndTree, 0, 0 );
		SetCapture( m_hwndTree ); 
		m_bDragging = TRUE; 
	}

	void OnTreeMouseMove( LONG x, LONG y )
	{
		TVHITTESTINFO tvht;
		int nHeight = TreeView_GetItemHeight( m_hwndTree );
		if( m_bDragging ) { 
			ImageList_DragMove( x, y ); 
			tvht.pt.x = x; 
			tvht.pt.y = y; 
			m_bAfterTarget = false;
			m_hTargetItem = TreeView_HitTest( m_hwndTree, &tvht );
			if( m_hTargetItem ) { 
				RECT rcItem;
				if( TreeView_GetItemRect( m_hwndTree, m_hTargetItem, &rcItem, FALSE ) ){
					if( y > rcItem.top + nHeight / 2 ){
						if( !TreeView_GetChild( m_hwndTree, m_hTargetItem ) ){
							m_bAfterTarget = true;
						}
					}
				}
			} 
			else {
				tvht.pt.y -= nHeight;
				m_hTargetItem = TreeView_HitTest( m_hwndTree, &tvht );
				if( m_hTargetItem ) { 
					m_bAfterTarget = true;
				}
			}
			if( m_hTargetItem ){
				TreeView_SetInsertMark( m_hwndTree, m_hTargetItem, m_bAfterTarget );
			}
			else {
				if( y < 0 ){
					SendMessage( m_hwndTree, WM_VSCROLL, SB_LINEUP, 0 );
				}
				else {
					SendMessage( m_hwndTree, WM_VSCROLL, SB_LINEDOWN, 0 );
				}
			}
		} 
	}

	void OnTreeMouseUp()
	{
		if( m_bDragging ){ 
			ImageList_EndDrag(); 
			ReleaseCapture(); 
			m_bDragging = false; 
			TreeView_SetInsertMark( m_hwndTree, NULL, FALSE );
			if( m_hTargetItem ){
				MoveItem( m_hSrcItem, m_hTargetItem, m_bAfterTarget, false );
			}
		} 
	}

	void EnsureVisible( HTREEITEM hItem )
	{
		RECT rc;
		if( TreeView_GetItemRect( m_hwndTree, hItem, &rc, TRUE ) ){
			return;  // already visible
		}
		int iCurrent = GetOutline( hItem );
		if( iCurrent < 0 )  return;  // something wrong

		HTREEITEM hFirstVisible = TreeView_GetFirstVisible( m_hwndTree );
		_ASSERT( hFirstVisible );
		int iFirstVisible = GetOutline( hFirstVisible );
		if( iFirstVisible < 0 )  return;

		if( iFirstVisible < iCurrent ){
			for( ;; ){
				SendMessage( m_hwndTree, WM_VSCROLL, SB_LINEDOWN, NULL );
				if( TreeView_GetItemRect( m_hwndTree, hItem, &rc, TRUE ) ){
					break;  // visible
				}
			}
		}
		else {
			for( ;; ) {
				SendMessage( m_hwndTree, WM_VSCROLL, SB_LINEUP, NULL );
				if( TreeView_GetItemRect( m_hwndTree, hItem, &rc, TRUE ) ){
					break;  // visible
				}
			}
		}

	}

};

LRESULT CALLBACK TreeProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg ){
	case OCM_NOTIFY:
		{
			NMHDR* pnmh = (NMHDR*)lParam;
			switch( pnmh->code ) {
			case NM_DBLCLK:
			case NM_RETURN:
				{
					HTREEITEM hItem = TreeView_GetSelection( hwnd );
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					_ASSERTE( pFrame != NULL );
					if( pFrame != NULL && pFrame->m_lpOldTreeProc != NULL ){
						pFrame->OnOutlineSelected( hItem, true, false );
					}
				}
				break;
			case NM_RCLICK:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeContextMenu( true );
					}
				}
				break;
			case TVN_KEYDOWN:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeKeyDown( (NMTVKEYDOWN*)lParam );
					}
				}
				break;
			case TVN_BEGINDRAG:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeBeginDrag( (NMTREEVIEW*)lParam );
					}
				}
				break;
			case TVN_SELCHANGED:
				{
					NMTREEVIEW* pnmtv = (NMTREEVIEW*)lParam;
					if( pnmtv->action == TVC_BYMOUSE ){
						HTREEITEM hItem = TreeView_GetSelection( hwnd );
						CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
						if( pFrame != NULL ){
							pFrame->OnOutlineSelected( hItem, false, false );
						}
					}
				}
				break;
			case TVN_GETDISPINFO:
				{
					NMTVDISPINFO* pnmtvDispInfo = (NMTVDISPINFO*)lParam;
					if( pnmtvDispInfo->item.mask & TVIF_TEXT ){
						CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
						if( pFrame != NULL ){
							if( pnmtvDispInfo->item.lParam >= 0 && pnmtvDispInfo->item.lParam < (int)pFrame->m_OutlineArray.size() ){
								COutlineArray::iterator it = pFrame->m_OutlineArray.begin() + pnmtvDispInfo->item.lParam;
								pnmtvDispInfo->item.pszText = it->m_szLine;
							}
						}
					}
				}
				break;
			}
		}
		break;
	case WM_MOUSEMOVE:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			if( pFrame != NULL ){
				pFrame->OnTreeMouseMove( GET_X_LPARAM( lParam ), GET_Y_LPARAM( lParam ) );
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			if( pFrame != NULL ){
				pFrame->OnTreeMouseUp();
			}
		}
		break;
	case WM_CONTEXTMENU:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			if( pFrame != NULL ){
				pFrame->OnTreeContextMenu( false );
			}
		}
		break;
	}
	CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
	if( pFrame != NULL && pFrame->m_lpOldTreeProc != NULL ){
		return CallWindowProc( pFrame->m_lpOldTreeProc, hwnd, msg, wParam, lParam);
	}
	else {
		return 0;
	} 
}

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			pFrame->OnDlgCommand( hwnd, wParam );
		}
		break;
	}
	return bResult;
}

//void CALLBACK IdleProc( HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD /*dwTime*/ )
//{
//	_ASSERTE( uMsg == WM_TIMER );
//	if( idEvent == 1 ){
//		CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromFrame( hwnd ));
//		_ASSERTE( pFrame );
//		if( pFrame ){
//			pFrame->OnIdle();
//		}
//	}
//}

int ExceptionHandler( HWND hwnd )
{
	TCHAR szAppName[80];
	LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
	int nResult = MessageBox( hwnd, _T("Outline Plug-in WorkThread error! Click OK and restart EmEditor, or click Cancel to debug"), szAppName, MB_ICONSTOP | MB_OKCANCEL );
	if( nResult == IDOK ){
		return EXCEPTION_EXECUTE_HANDLER;
	}
	return EXCEPTION_CONTINUE_SEARCH;
}


UINT WINAPI WorkThread(LPVOID lpData)
{
	CMyFrame* pFrame = static_cast<CMyFrame*>(lpData);
	_ASSERTE( pFrame );
	HANDLE hQueEvent = pFrame->m_hQueEvent;
	_ASSERTE( hQueEvent );
	HANDLE hMutex = pFrame->m_hMutex;

	while( !pFrame->m_bAbortThread ){
		if( WaitForSingleObject( hQueEvent, INFINITE ) != WAIT_OBJECT_0 ) {
			break;  // error
		}
		if( WaitForSingleObject( hMutex, INFINITE ) != WAIT_OBJECT_0 ){
			break;  // error
		}
		if( pFrame->m_bAbortThread ){
			VERIFY( ReleaseMutex( hMutex ) );
			break;
		}
		TRACE( _T("WorkThread -- Mutex acquired.\n") );
		int nFlag = pFrame->m_nWorkFlag;
		pFrame->m_nWorkFlag = 0;
		ResetEvent( hQueEvent );

		__try {
			switch( nFlag ){
			case WORK_OUTLINE_ALL:
				pFrame->OutlineAll();
				break;
			case WORK_TREE_SEL:
				pFrame->UpdateTreeSel();
				break;
			}
		}
		__except( ExceptionHandler( pFrame->m_hWnd ) ){
			_resetstkoflw();
			pFrame->m_bAbortThread = true;
		}

		VERIFY( ReleaseMutex( hMutex ) );
		TRACE( _T("WorkThread -- Mutex released.\n") );
	}

	pFrame->m_bAbortThread = false;
	return 0;
}



// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

