class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// _loc.dll in MUI sub folder?
	enum { _USE_LOC_DLL			= FALSE					};

	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_MENU_TEXT			};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= 0						};
	enum { _IDB_256C_16_DEFAULT = 0						};
	enum { _IDB_256C_16_HOT		= 0						};
	enum { _IDB_256C_16_BW		= 0						};
	enum { _IDB_256C_24_DEFAULT = 0						};
	enum { _IDB_256C_24_HOT		= 0						};
	enum { _IDB_256C_24_BW		= 0						};
	enum { _IDB_TRUE_16_DEFAULT = 0						};
	enum { _IDB_TRUE_16_HOT		= 0						};
	enum { _IDB_TRUE_16_BW		= 0						};
	enum { _IDB_TRUE_24_DEFAULT = 0						};
	enum { _IDB_TRUE_24_HOT		= 0						};
	enum { _IDB_TRUE_24_BW		= 0						};

	// masks
	enum { _MASK_TRUE_COLOR		= RGB( 192, 192, 192 )	};
	enum { _MASK_256_COLOR		= RGB( 192, 192, 192 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 11000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 10000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	// Queries whether the auto complete for brackets/quotation marks feature should be disabled.
	BOOL DisableAutoComplete( HWND /* hwnd */ )
	{
		return FALSE;
	}

	// Queries whether the plug-in wants to use dropped files.
	BOOL UseDroppedFiles( HWND /* hwnd */ )
	{
		return FALSE;
	}

	// The plug-in has been selected from a menu or a toolbar. 
	void OnCommand( HWND hwndView )
	{
		// writes "Hello Worlds!!" in the text editor.  
		Editor_InsertW( hwndView, L"Hello World!!\n", true );
		//
		// TODO....
		//
	}

	// Queries the status of the plug-in, whether the command is enabled and whether the plug-in is a checked status.
	BOOL QueryStatus( HWND /*hwndView*/, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		return TRUE;
	}

	// When a status is changed, this function is called with the Events parameter.
	void OnEvents( HWND hwndView, UINT nEvent, LPARAM lParam )
	{
	}

	// Queries whether the plug-in can be uninstalled.
	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	// Uninstalls the plug-in.
	BOOL SetUninstall( HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetLocaleInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetLocaleInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}
	
	// Returns TRUE if Properties (dialog box) are supported.
	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	// Requests the plug-in to display the properties.
	BOOL SetProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	// Called before each Windows message is translated.
	BOOL PreTranslateMessage( HWND /*hwndView*/, MSG* pMsg )
	{
		return FALSE;
	}

	CMyFrame()
	{
	}

	~CMyFrame()
	{
	}

};



// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

