#pragma once

// forward declaration
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

LPCTSTR szCust = _T("Cust");

class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	int g_nMode;

	CMyFrame()
	{
		g_nMode = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
		HMENU hMenu = LoadMenu( EEGetInstanceHandle(), MAKEINTRESOURCE( IDR_MENU ) );
		HMENU hSubMenu = GetSubMenu( hMenu, 0 );
		if( hSubMenu == NULL )  return;

		TCHAR szConfigName[MAX_CONFIG_NAME];
#ifdef UNICODE
		Editor_GetConfigW( hwndView, szConfigName );
#else
		Editor_GetConfigA( hwndView, szConfigName );
#endif
		CCustomizeInfo cust;
		LoadProfile( szConfigName, cust );

		CheckMenuItem( hSubMenu, ID_SHOW_EOF, MF_BYCOMMAND | (cust.m_bShowEOF ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SHOW_CR, MF_BYCOMMAND | (cust.m_bShowCR ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SHOW_TAB, MF_BYCOMMAND | (cust.m_bShowTab ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SHOW_DBSPACE, MF_BYCOMMAND | (cust.m_bShowDbSpace ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SHOW_LINE_NUM, MF_BYCOMMAND | (cust.m_bShowLineNum ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SHOW_RULER, MF_BYCOMMAND | (cust.m_bShowRuler ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_HORZ_LINE, MF_BYCOMMAND | (cust.m_bHorzLine ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_VERT_LINE, MF_BYCOMMAND | (cust.m_bVertLine ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SCROLL_2LINES, MF_BYCOMMAND | (cust.m_bScroll2Lines ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_FAST_KEY_REPEAT, MF_BYCOMMAND | (cust.m_bFastKeyRepeat ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_AUTO_INDENT, MF_BYCOMMAND | (cust.m_bAutoIndent ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SHOW_PAGE, MF_BYCOMMAND | (cust.m_bShowPage ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_WORD_WRAP, MF_BYCOMMAND | (cust.m_bWordWrap ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_KINSOKU_WRAP, MF_BYCOMMAND | (cust.m_bKinsokuWrap ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_FACE_WRAP, MF_BYCOMMAND | (cust.m_bFaceWrap ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_HILITE, MF_BYCOMMAND | (cust.m_bHilite ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_URL, MF_BYCOMMAND | (cust.m_bURL ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_MAIL_TO, MF_BYCOMMAND | (cust.m_bMailTo ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_LINK_DBCLICK, MF_BYCOMMAND | (cust.m_bLinkDblclick ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SAVE_TAB_TO_SPACE, MF_BYCOMMAND | (cust.m_bSaveTabToSpace ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_SAVE_INSERT_CR, MF_BYCOMMAND | (cust.m_bSaveInsertCR ? MF_CHECKED : MF_UNCHECKED) );
		CheckMenuItem( hSubMenu, ID_DELETE_EMPTY, MF_BYCOMMAND | (cust.m_bDeleteEmpty ? MF_CHECKED : MF_UNCHECKED) );

		POINT point;
		GetCursorPos( &point );
		UINT nID = TrackPopupMenu( hSubMenu, TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD, point.x, point.y, 0, hwndView, NULL );
		if( nID == 0 )  return;


		switch( nID ){
		case ID_SHOW_EOF:
			cust.m_bShowEOF = !cust.m_bShowEOF;
			break;
		case ID_SHOW_CR:
			cust.m_bShowCR = !cust.m_bShowCR;
			break;
		case ID_SHOW_TAB:
			cust.m_bShowTab =! cust.m_bShowTab;
			break;
		case ID_SHOW_DBSPACE:
			cust.m_bShowDbSpace =! cust.m_bShowDbSpace;
			break;
		case ID_SHOW_LINE_NUM:
			cust.m_bShowLineNum =! cust.m_bShowLineNum;
			break;
		case ID_SHOW_RULER:
			cust.m_bShowRuler =! cust.m_bShowRuler;
			break;
		case ID_HORZ_LINE:
			cust.m_bHorzLine =! cust.m_bHorzLine;
			break;
		case ID_VERT_LINE:
			cust.m_bVertLine =! cust.m_bVertLine;
			break;
		case ID_SCROLL_2LINES:
			cust.m_bScroll2Lines =! cust.m_bScroll2Lines;
			break;
		case ID_FAST_KEY_REPEAT:
			cust.m_bFastKeyRepeat =! cust.m_bFastKeyRepeat;
			break;
		case ID_AUTO_INDENT:
			cust.m_bAutoIndent =! cust.m_bAutoIndent;
			break;
		case ID_SHOW_PAGE:
			cust.m_bShowPage =! cust.m_bShowPage;
			break;
		case ID_WORD_WRAP:
			cust.m_bWordWrap =! cust.m_bWordWrap;
			break;
		case ID_KINSOKU_WRAP:
			cust.m_bKinsokuWrap =! cust.m_bKinsokuWrap;
			break;
		case ID_FACE_WRAP:
			cust.m_bFaceWrap =! cust.m_bFaceWrap;
			break;
		case ID_HILITE:
			cust.m_bHilite =! cust.m_bHilite;
			break;
		case ID_URL:
			cust.m_bURL =! cust.m_bURL;
			break;
		case ID_MAIL_TO:
			cust.m_bMailTo =! cust.m_bMailTo;
			break;
		case ID_LINK_DBCLICK:
			cust.m_bLinkDblclick =! cust.m_bLinkDblclick;
			break;
		case ID_SAVE_TAB_TO_SPACE:
			cust.m_bSaveTabToSpace =! cust.m_bSaveTabToSpace;
			break;
		case ID_SAVE_INSERT_CR:
			cust.m_bSaveInsertCR =! cust.m_bSaveInsertCR;
			break;
		case ID_DELETE_EMPTY:
			cust.m_bDeleteEmpty =! cust.m_bDeleteEmpty;
			break;
		}

		if( SaveProfile( szConfigName, cust ) ){
#ifdef UNICODE
			Editor_LoadConfigW( hwndView, szConfigName );
#else
			Editor_LoadConfigA( hwndView, szConfigName );
#endif
		}
	}

	BOOL QueryStatus( HWND /*hwndView*/, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		return TRUE;
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			TCHAR szKey[MAX_PATH];
			if( GetRootKeyName( szKey ) ){
				RegDeleteKey( HKEY_CURRENT_USER, szKey );
			}
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	BOOL SetProperties( HWND /*hDlg*/ )
	{
		return FALSE;
	}

	// user defined methods below.
	HKEY GetConfigKey( LPCTSTR pszConfig )
	{
		HKEY hConfigKey = NULL;
		HKEY hSecKey = GetConfigRootKey();
		if( hSecKey != NULL ){
			RegOpenKeyEx(hSecKey, pszConfig, 0, KEY_WRITE|KEY_READ, &hConfigKey );
			RegCloseKey(hSecKey);
		}
		return hConfigKey;
	}

	void SaveCustomizeInfo( HKEY hKey, CCustomizeInfo& cust )
	{
		RegSetValueEx(hKey, szCust, 0, REG_BINARY, (LPBYTE)&cust, sizeof( CCustomizeInfo ) );
	}

	BOOL SaveProfile( LPCTSTR pszConfig, CCustomizeInfo& cust )
	{
		HKEY hKey = GetConfigKey( pszConfig );
		if( hKey != NULL ){
			SaveCustomizeInfo( hKey, cust );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	BOOL LoadCustomizeInfo( HKEY hKey, CCustomizeInfo& cust )
	{
		DWORD dwType;
		DWORD dwCount;
		if( RegQueryValueEx( hKey, szCust, NULL, &dwType, (LPBYTE)NULL, &dwCount) == ERROR_SUCCESS ){
			if( dwType == REG_BINARY && dwCount == sizeof( CCustomizeInfo ) ){
				return( RegQueryValueEx( hKey, szCust, NULL, &dwType, (LPBYTE)&cust, &dwCount) == ERROR_SUCCESS );
			}
		}
		return FALSE;
	}

	BOOL LoadProfile( LPCTSTR pszConfig, CCustomizeInfo& cust )
	{
		BOOL bResult = FALSE;
		HKEY hKey = GetConfigKey( pszConfig );
		if( hKey != NULL ){
			bResult = LoadCustomizeInfo( hKey, cust );
			RegCloseKey( hKey );
		}
		return bResult;
	}
};

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT


