﻿#pragma once

#include <windows.h>
#include <string>

namespace option {
#pragma region detail::Base
	namespace detail
	{
		class Base {
		public:
			operator bool () const { return !em_; }
			bool operator!() const { return  em_ == nullptr; }
		protected:
			Base( ::HWND em );
			::HWND		 const	em_;
			std::wstring const	config_;
		private:
			Base(			 Base const& );
			Base& operator=( Base const& );
		};
	}
#pragma endregion
//----------------------------------------------------------------------------

	//	オプションリーダー
	class Reader: public detail::Base {
	public:
		Reader( ::HWND em ): detail::Base(em) {}

		//	読み取り
		bool			Bool(	wchar_t const* name, bool			defaultValue = false	) const;	//	論理値
		::UINT32		UInt32(	wchar_t const* name, ::UINT32		defaultValue = 0u		) const;	//	32bit符号なし整数
		::INT32			Int32(	wchar_t const* name, ::INT32		defaultValue = 0		) const;	//	32bit符号付き整数
		float			Float(	wchar_t const* name, float			defaultValue = 0.f		) const;	//	単精度浮動小数点数
		std::wstring	String(	wchar_t const* name, wchar_t const*	defaultValue = nullptr	) const;	//	文字列
	public:
		//	データ読み取り
		::LONG	QueryValue( wchar_t const* name, ::DWORD type, void* data, ::DWORD& size ) const;
	};

//----------------------------------------------------------------------------

	//	オプションライター
	class Writer: public detail::Base {
	public:
		Writer( ::HWND em ): detail::Base(em) {}

		//	書き込み
		bool	Bool(	wchar_t const* name, bool			value );	//	論理値
		bool	UInt32(	wchar_t const* name, ::UINT32		value );	//	32bit符号なし整数
		bool	Int32(	wchar_t const* name, ::INT32		value );	//	32bit符号付き整数
		bool	Float(	wchar_t const* name, float			value );	//	単精度浮動小数点数
		bool	String(	wchar_t const* name, wchar_t const*	value );	//	文字列
	public:
		//	データ書き込み
		::LONG	SetValue( wchar_t const* name, ::DWORD type, void const* data, ::DWORD size );
	};

}
