﻿#include "stdafx.h"
#include "tools.h"
#include <type_traits>
#include <cwchar>
#include <type_traits>
#include "resource.h"

namespace tools {
//----------------------------------------------------------------------------

	//	インスタンスハンドル
	::HINSTANCE	instance_;
	
	//	コマンドID
	int command_;

	//	インスタンスハンドル
	::HINSTANCE	Instance()
	{
		return	instance_;
	}

	//	コマンドID
	int	CommandID()
	{
		return	command_;
	}

	//	プロセス初期化
	void	InitializeProcess( ::HINSTANCE const instance )
	{
		instance_ = instance;
	}

	//	プラグイン初期化
	void	InitializePlugin( ::HWND const em, ::LPARAM const lParam )
	{
		command_ = LOWORD(lParam);
	}

//----------------------------------------------------------------------------

	//	ストリングテーブルから文字列取得
	std::wstring	GetString( ::UINT const id )
	{
		wchar_t	name[4096];
		auto const len( ::LoadStringW( instance_, id, name, static_cast<int>(std::extent<decltype(name)>::value) ) );
		return	len ? std::wstring(name,len) : std::wstring();
	}

	//	ストリングテーブルから文字列取得
	::LONG_PTR GetString( ::UINT const id, ::UINT_PTR const cb, wchar_t*const buf )
	{
		//	ストリングテーブルからロード
		wchar_t	name[4096];
		if( !::LoadStringW( instance_, id, name, static_cast<int>(std::extent<decltype(name)>::value) ) ) *name = L'\0';

		//	要求されてればコピー
		if( buf && cb > 0 )
			::wcscpy_s( buf, cb, name );

		//	文字列長+1を返す
		return	std::wcslen(name) + 1;
	}

//----------------------------------------------------------------------------

	//	最も親のウィンドウを探す
	::HWND	FindMostParentWindow( ::HWND hwnd )
	{
		::HWND	hw;
		while(	hw = ::GetParent(hwnd) ) hwnd = hw;
		return	hwnd;
	};

	//	ウィンドウが、EmEditorViewか？
	bool	IsViewWindow( ::HWND const hwnd )
	{
		wchar_t	name[64];
		if( ::GetClassNameW( hwnd, name, std::extent<decltype(name)>::value ) > 0 )
			return	std::wcscmp( name, L"EmEditorView" ) == 0;
		return	false;
	}

//----------------------------------------------------------------------------

	struct pw2cw_t {
		::DWORD process_id;
		::UINT	 msg;
		::WPARAM wParam;
		::LPARAM lParam;
		pw2cw_t( ::UINT const m, ::WPARAM const w, ::LPARAM const l ): 
			process_id(::GetCurrentProcessId()), msg(m), wParam(w), lParam(l) {}
	};
	struct pw2cw_ex: public pw2cw_t {
		std::function<bool (::HWND hwnd)> const& proc;
		pw2cw_ex( ::UINT const m, ::WPARAM const w, ::LPARAM const l, std::function<bool (::HWND hwnd)> const& p ): 
			pw2cw_t(m,w,l), proc(p) {}
	};

	//	同プロセスに属するすべての子ウィンドウにメッセージを送る
	void	PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam )
	{
		struct local {
			static ::BOOL CALLBACK ChildProc( ::HWND const child, ::LPARAM const lParam ){
				auto const& dat( *reinterpret_cast<pw2cw_t const*>(lParam) );
				::PostMessage( child, dat.msg, dat.wParam, dat.lParam );
				return TRUE;
			}
			static ::BOOL CALLBACK TopLevelProc( ::HWND const hwnd, ::LPARAM const lParam ){
				::DWORD id(0);
				::GetWindowThreadProcessId(hwnd,&id);
				if( id == reinterpret_cast<pw2cw_t const*>(lParam)->process_id ){
					::EnumChildWindows( hwnd, ChildProc, lParam );
				}
				return TRUE;
			}
		};
		::EnumWindows( local::TopLevelProc, reinterpret_cast<::LPARAM>(&pw2cw_t( msg, wParam, lParam )) );
	}

	//	同プロセスに属する子ウィンドウにメッセージを送る
	void	PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, std::function<bool (::HWND hwnd)> const& proc )
	{
		struct local {
			static ::BOOL CALLBACK ChildProc( ::HWND const child, ::LPARAM const lParam ){
				auto const& dat( *reinterpret_cast<pw2cw_ex const*>(lParam) );
				if( dat.proc(child) )
					::PostMessage( child, dat.msg, dat.wParam, dat.lParam );
				return TRUE;
			}
			static ::BOOL CALLBACK TopLevelProc( ::HWND const hwnd, ::LPARAM const lParam ){
				::DWORD id(0);
				::GetWindowThreadProcessId(hwnd,&id);
				if( id == reinterpret_cast<pw2cw_ex const*>(lParam)->process_id ){
					::EnumChildWindows( hwnd, ChildProc, lParam );
				}
				return TRUE;
			}
		};
		::EnumWindows( local::TopLevelProc, reinterpret_cast<::LPARAM>(&pw2cw_ex( msg, wParam, lParam, proc )) );
	}

//----------------------------------------------------------------------------
}
