﻿#pragma once

#include <windows.h>
#include <string>
#include <functional>

namespace tools
{
	//	初期化
	extern void			InitializeProcess( ::HINSTANCE instance );
	extern void			InitializePlugin( ::HWND em, ::LPARAM lParam );

	//	インスタンスハンドル
	extern ::HINSTANCE	Instance();

	//	コマンドID
	extern int			CommandID();

	//	ストリングテーブルから文字列取得
	extern std::wstring	GetString( ::UINT id );
	extern ::LONG_PTR	GetString( ::UINT id, ::UINT_PTR cb, wchar_t* buf );

	//	最も親のウィンドウを探す
	extern ::HWND		FindMostParentWindow( ::HWND hwnd );

	//	ウィンドウが、EmEditorViewか？
	extern bool			IsViewWindow( ::HWND hwnd );

	//	同プロセスに属する子ウィンドウにメッセージを送る
	extern void			PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam );	//	※すべての子ウィンドウ
	extern void			PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, std::function<bool (::HWND hwnd)> const& proc );

	//	排他
	class Mutex {
	public:
		Mutex(){  ::InitializeCriticalSection(&cs_); }
		~Mutex(){ ::DeleteCriticalSection(	  &cs_); }

		//	ロック
		class Lock {
		public:
			Lock( Mutex& mutex ): cs_(mutex.cs_) {	::EnterCriticalSection(&cs_); }
			~Lock(){								::LeaveCriticalSection(&cs_); }
		private:
			::CRITICAL_SECTION&	cs_;
			Lock(			 Lock const& );
			Lock& operator=( Lock const& );
		};
	private:
		::CRITICAL_SECTION	cs_;
		Mutex(			  Mutex const& );
		Mutex& operator=( Mutex const& );
	};

}
