// implementatin of this specific plug-in is here:
//

#define MAX_OUTLINE_DEPTH			6
#define UPDATE_TREE_NONE			0
#define UPDATE_OUTLINE				1
#define UPDATE_TREE_SEL				2
#define UPDATE_TREE_LINE_STRING		3
#define UPDATE_TREE_ALL				4

#define ZERO_INIT_FIRST_MEM(classname, firstmem)  ZeroMemory( &firstmem, sizeof( classname ) - ((char*)&firstmem - (char*)this) );

INT_PTR CALLBACK SearchProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

void InsertColumnToListView( HWND hwndList, int nIDString, int nIDString2 )
{
	TCHAR szText[32];
	LV_COLUMN lvC;
	ZeroMemory( &lvC, sizeof(lvC) );
	lvC.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvC.fmt = LVCFMT_LEFT;   // left-align column
	lvC.pszText = szText;
	HINSTANCE hinstRes = EEGetInstanceHandle();
	LoadString( hinstRes, nIDString, szText, _countof( szText ) );
	int nIndex = 0;
	int cx = 0;
	if( nIDString2 != 0 ) {
		cx = 160;
		lvC.cx = cx;
		VERIFY( ListView_InsertColumn( hwndList, nIndex++, &lvC ) != -1 );
		LoadString( hinstRes, nIDString2, szText, _countof( szText ) );
	}
	lvC.cx = 40;
	VERIFY( ListView_InsertColumn( hwndList, nIndex, &lvC ) != -1 );
}


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_TRUE_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= CLR_NONE				};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 7010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 7000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= FALSE					};

	// user-defined members

	// data that can be set zeros below
	HWND m_hDlg;
	UINT m_nClientID;
	int  m_iPos;
	int  m_iOldPos;
	TCHAR m_szFind[MAX_PATH];
	bool m_bProfileLoaded;
	bool m_bOpenStartup;
	bool m_bCase;
	bool m_bRegex;
	bool m_bUninstalling;
	
	void OnCommand( HWND /*hwndView*/ )
	{
		if( m_hDlg == NULL ){
			TCHAR sz[260];
			TCHAR szAppName[80];
			LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
			if( Editor_GetVersion( m_hWnd ) < 7000 ){
				LoadString( EEGetInstanceHandle(), IDS_INVALID_VERSION, sz, _countof( sz ) );
				MessageBox( m_hWnd, sz, szAppName, MB_OK | MB_ICONSTOP );
				return;
			}
			m_hDlg = CreateDialog( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_SEARCH ), m_hWnd, SearchProc );

			if( m_hDlg != NULL ){
				CUSTOM_BAR_INFO cbi;
				ZeroMemory( &cbi, sizeof( cbi ) );
				cbi.cbSize = sizeof( cbi );
				cbi.hwndClient = m_hDlg;
				cbi.iPos = m_iPos;
				cbi.pszTitle = szAppName;
				m_nClientID = Editor_CustomBarOpen( m_hWnd, &cbi );

				if( !m_nClientID ){
					CustomBarClosed();
				}
				else {
					ShowWindow( m_hDlg, SW_SHOW );

					// The parent window is set to the custom bar window.
					_ASSERTE( cbi.hwndCustomBar && GetParent( m_hDlg ) == cbi.hwndCustomBar );
				}
			}
		}
		else {
			_ASSERTE( m_nClientID );
			Editor_CustomBarClose( m_hWnd, m_nClientID );
			CustomBarClosed();
		}
	}

	void CustomBarClosed()
	{
		if( m_hDlg ){
			if( IsWindow( m_hDlg ) ){
				DestroyWindow( m_hDlg );
			}
			_ASSERT( !IsWindow( m_hDlg ) );
			m_hDlg = NULL;
			m_nClientID = 0;
		}
	}

	BOOL QueryStatus( HWND /*hwndView*/, LPBOOL pbChecked )
	{		
		*pbChecked = (m_hDlg != NULL);
		return TRUE;
	}

	void OnEvents( HWND hwndView, UINT nEvent, LPARAM lParam )
	{
		if( nEvent & EVENT_CREATE_FRAME ){
			LoadProfile();
			if( m_bOpenStartup ){
				OnCommand( hwndView );
			}
		}
		if( nEvent & EVENT_CLOSE_FRAME ){
			if( m_hDlg ){
				OnCommand( hwndView );
			}
		}
		if( nEvent & EVENT_CUSTOM_BAR_CLOSED ){
			// this message arrives even if plug-in does not own this custom bar, so make sure it is mine.
			if( m_hDlg != NULL ){  
				CUSTOM_BAR_CLOSE_INFO* pCBCI = (CUSTOM_BAR_CLOSE_INFO*)lParam;
				if( pCBCI->nID == m_nClientID ){
					CustomBarClosed();
					// if the frame closed while Custom Bar is open, save the status for next startup.
					m_bOpenStartup = (pCBCI->dwFlags & CLOSED_FRAME_WINDOW);
					SaveProfile();
				}
			}
		}
		if( nEvent & (EVENT_FILE_OPENED | EVENT_DOC_SEL_CHANGED) ){
		}
		if( nEvent & EVENT_CHANGE ){
		}
		if( nEvent & EVENT_CARET_MOVED ){
		}
		if( nEvent & EVENT_IDLE ){
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam )
	{
		TCHAR szProductCode[80] = { 0 };
		HKEY hKey = NULL;
		if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, _T("Software\\EmSoft\\EmEditorPlugIns\\Search"), 0, KEY_READ, &hKey ) == ERROR_SUCCESS && hKey ){
			GetProfileStringReg( hKey, _T("ProductCode"), szProductCode, _countof( szProductCode ), _T("") );
			if( szProductCode[0] ){
				GetSystemDirectory( pszUninstallCommand, MAX_PATH );
				PathAppend( pszUninstallCommand, _T("msiexec.exe") );

				StringPrintf( pszUninstallParam, MAX_PATH, _T("/X%s"), szProductCode );
				RegCloseKey( hKey );
				return UNINSTALL_RUN_COMMAND;
			}
		}
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			EraseProfile();
			m_bUninstalling = true;
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	BOOL PreTranslateMessage( HWND /*hwndView*/, MSG* pMsg )
	{
		HWND hwndFocus = GetFocus();
		if( hwndFocus ){
			if( m_hDlg && IsChild( m_hDlg, hwndFocus ) ){
				if( pMsg->message == WM_KEYDOWN ){
					bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
					bool bShift = GetKeyState( VK_SHIFT ) < 0;
					if( !bCtrl ){
						if( pMsg->wParam == VK_ESCAPE ){
							if( !bShift ){
								Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
								return TRUE;
							}
						}
						//else if( pMsg->wParam == VK_F6 ){
						//	Editor_ExecCommand( m_hWnd, bShift ? EEID_PREV_PANE : EEID_NEXT_PANE );
						//	return TRUE;
						//}
						else if( pMsg->wParam == VK_RETURN ){
							if( !bShift ){
								HWND hwndList = GetDlgItem( m_hDlg, IDC_LIST );
								if( hwndFocus == hwndList ){
									int iItem = ListView_GetNextItem( hwndList, -1, LVNI_SELECTED );
									OnJump( iItem );
									return TRUE;
								}
							}
						}
					}
				}
				if( IsDialogMessage( m_hDlg, pMsg ) ){
					return TRUE;
				}
			}
		}
		return FALSE;
	}

	CMyFrame()
	{
		ZERO_INIT_FIRST_MEM( CMyFrame, m_hDlg );
	}

	UINT_PTR GetCurrentLine( HWND hwndView )
	{
		POINT_PTR ptCurrentPos;
		Editor_GetCaretPos( hwndView, POS_LOGICAL_W, &ptCurrentPos );
		return ptCurrentPos.y;
	}

	void LoadProfile()
	{
		if( !m_bProfileLoaded ){
			m_bProfileLoaded = true;
			m_bOpenStartup = !!GetProfileInt( _T("OpenStartup"), FALSE );
			m_iPos = GetProfileInt( _T("CustomBarPos"), CUSTOM_BAR_LEFT );
		}
	}

	void SaveProfile()
	{
		if( !m_bUninstalling ){
			WriteProfileInt( _T("OpenStartup"), m_bOpenStartup );
		}
	}

	void OnSearch( HWND hwnd )
	{
		WCHAR szFind[MAX_PATH];
		GetDlgItemText( hwnd, IDC_FIND, szFind, _countof( szFind ) );
		if( !szFind[0] )  return;
		bool bCase = !!IsDlgButtonChecked( hwnd, IDC_CASE );
		m_bCase = bCase;
		bool bRegex = !!IsDlgButtonChecked( hwnd, IDC_REGEX );
		m_bRegex = bRegex;
		if( !bCase && !bRegex ){
			CharLower( szFind );
		}
		StringCopy( m_szFind, _countof( m_szFind ), szFind );
		HWND hwndList = GetDlgItem( hwnd, IDC_LIST );
		if( !hwndList )  return;
		ListView_DeleteAllItems( hwndList );

		UINT iActiveDoc = (UINT)Editor_Info( m_hWnd, EI_GET_ACTIVE_INDEX, 0 );
		UINT nCount = (UINT)Editor_Info( m_hWnd, EI_GET_DOC_COUNT, 0 );
		if( nCount > 0 ){
			for( UINT iDoc = 0; iDoc < nCount; iDoc++ ){
				if( Editor_DocInfo( m_hWnd, iDoc, EI_SET_ACTIVE_INDEX, 0 ) ){
					UINT_PTR nLines = Editor_GetLines( m_hWnd, POS_LOGICAL_W );
					GET_LINE_INFO gli;
					gli.flags = FLAG_LOGICAL;
					WCHAR* pBuf = NULL;
					for( gli.yLine = 0; gli.yLine < nLines; gli.yLine++ ){
						int bFound = FALSE;
						gli.cch = 0;
						UINT_PTR ch = Editor_GetLineW( m_hWnd, &gli, NULL );
						if( ch <= 1 )  continue;
						if( ch > gli.cch ){
							delete [] pBuf;
							pBuf = new WCHAR[ ch ];
							gli.cch = ch;
						}
						if( pBuf == NULL )  break;
						Editor_GetLineW( m_hWnd, &gli, pBuf );

						if( bRegex ){
							LPCWSTR pszStart, pszEnd, pszNext;
							FIND_REGEX_INFO fri;
							ZeroMemory( &fri, sizeof( fri ) );
							fri.cbSize = sizeof( fri );
							fri.pszRegex = szFind;
							fri.pszText = pBuf;
							fri.ppszStart = &pszStart;
							fri.ppszEnd = &pszEnd;
							fri.ppszNext = &pszNext;
							if( bCase ){
								fri.nFlags = FLAG_FIND_CASE;
							}
							bFound = Editor_FindRegex( m_hWnd, &fri );
							if( bFound == -1 ){
								delete [] pBuf;
								return;
							}
						}
						else {
							if( !bCase ){
								CharLower( pBuf );
							}
							bFound = wcsstr( pBuf, szFind ) != NULL;
						}
						if( bFound == TRUE ){
							TCHAR szTitle[MAX_PATH];
							Editor_DocInfo( m_hWnd, iDoc, EI_GET_SAVE_AS_TITLEW, (LPARAM)szTitle );
							TCHAR szLine[32];
#ifdef _WIN64
							StringPrintf( szLine, _countof( szLine ), _T("%I64u"), gli.yLine + 1 );
#else
							StringPrintf( szLine, _countof( szLine ), _T("%u"), gli.yLine + 1 );
#endif
							LVITEM item;
							ZeroMemory( &item, sizeof( item ) );
							item.mask = LVIF_TEXT;
							item.iItem = INT_MAX;
							item.pszText = szTitle;
							int iItem = ListView_InsertItem( hwndList, &item );
							if( iItem >= 0 ){
								item.iItem = iItem;
								item.iSubItem = 1;
								item.pszText = szLine;
								ListView_SetItem( hwndList, &item );
							}
						}
					}
					delete [] pBuf;
				}
			}

			Editor_DocInfo( m_hWnd, iActiveDoc, EI_SET_ACTIVE_INDEX, 0 );
		}
	}



	BOOL OnInitDialog( HWND hwnd )
	{

		HWND hwndList = GetDlgItem( hwnd, IDC_LIST );
		if( !hwndList )  return FALSE;
		DWORD dwFlags = LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE | LVS_EX_LABELTIP | LVS_EX_ONECLICKACTIVATE | LVS_EX_UNDERLINEHOT;
		ListView_SetExtendedListViewStyleEx( hwndList, dwFlags, dwFlags );
		InsertColumnToListView( hwndList, IDS_FILE, IDS_LINE );
		SendDlgItemMessage( hwnd, IDC_FIND, EM_LIMITTEXT, MAX_PATH - 1, 0 );
		if( IsWindowVisible( m_hWnd ) ){
			return TRUE;
		}
		return FALSE;  // return FALSE to prevent focus

	}

	void OnDlgCommand( HWND hwnd, WORD wID )
	{
		switch( wID ){
		case IDC_SEARCH:
			OnSearch( hwnd );
			break;
		}


	}

	bool IsPathEqual( LPCTSTR szPath1, LPCTSTR szPath2 )
	{
		OSVERSIONINFO osvi;
		osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		VERIFY( GetVersionEx(&osvi) );
		bool bIsWindowsXPorLater = (osvi.dwMajorVersion > 5) || ( (osvi.dwMajorVersion == 5) && (osvi.dwMinorVersion >= 1) );
		DWORD lcid = bIsWindowsXPorLater ? LOCALE_INVARIANT : MAKELCID(MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), SORT_DEFAULT);
		return (CompareString(lcid, NORM_IGNORECASE, szPath1, -1, szPath2, -1) == CSTR_EQUAL);
	}

	void Jump( LPCTSTR pszPath, INT_PTR nLine )
	{
		UINT nCount = (UINT)Editor_Info( m_hWnd, EI_GET_DOC_COUNT, 0 );
		for( UINT iDoc = 0; iDoc != nCount; iDoc++ ){
			TCHAR szTitle[MAX_PATH];
			Editor_DocInfo( m_hWnd, iDoc, EI_GET_SAVE_AS_TITLEW, (LPARAM)szTitle );
			if( IsPathEqual( pszPath, szTitle ) ){
				Editor_DocInfo( m_hWnd, iDoc, EI_SET_ACTIVE_INDEX, 0 );
				POINT_PTR ptPos;
				ptPos.x = 0;
				ptPos.y = nLine;
				Editor_SetCaretPos( m_hWnd, POS_LOGICAL_W, &ptPos );
				Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );

				UINT nFlags = FLAG_FIND_NEXT;
				if( m_bCase )  nFlags |= FLAG_FIND_CASE;
				if( m_bRegex )  nFlags |= FLAG_FIND_REG_EXP;
				Editor_FindW( m_hWnd, nFlags, m_szFind );
			}
		}
	}

	void OnJump( int iItem )
	{
		HWND hwndList = GetDlgItem( m_hDlg, IDC_LIST );
		if( !hwndList )  return;
		TCHAR szPath[MAX_PATH];
		ListView_GetItemText( hwndList, iItem, 0, szPath, _countof( szPath ) );
		TCHAR szLine[100];
		ListView_GetItemText( hwndList, iItem, 1, szLine, _countof( szLine ) );
		INT_PTR nLine = (INT_PTR)_tstoi64( szLine );
		if( nLine > 0 ){
			nLine--;
			Jump( szPath, nLine );
		}
	}

	BOOL OnPropInitDialog( HWND hwnd )
	{
		TCHAR sz[80];
		for( int i = 0; i < 4; i++ ){
			LoadString( EEGetInstanceHandle(), IDS_POS_LEFT + i, sz, _countof( sz ) );
			SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_ADDSTRING, 0, (LPARAM)sz );
		}
		SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_SETCURSEL, m_iPos, 0 );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, sz, _countof( sz ) );
		SetWindowText( hwnd, sz );
		m_iOldPos = m_iPos;

		return TRUE;
	}

	void OnPropDlgCommand( HWND hwnd, WPARAM wParam )
	{
		switch( wParam ){
		case IDOK:
			{
				m_iPos = (int)SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_GETCURSEL, 0, 0 );
				WriteProfileInt( _T("CustomBarPos"), m_iPos );
				EndDialog( hwnd, IDOK );

				if( m_iPos != m_iOldPos ){
					if( m_hDlg ){
						OnCommand( NULL );
						OnCommand( NULL );
					}
				}
			}
			break;

		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
		return;
	}

};


INT_PTR CALLBACK SearchProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	case WM_SIZE:
		{
			RECT rcDlg, rcChild;
			HWND hwndChild;
			if( GetClientRect( hwnd, &rcDlg ) ){
				int cxDlg = rcDlg.right;
				int cyDlg = rcDlg.bottom;
				hwndChild = GetDlgItem( hwnd, IDC_FIND );
				GetWindowRect( hwndChild, &rcChild );
				ScreenToClient( hwnd, (POINT*)&rcChild.left );
				ScreenToClient( hwnd, (POINT*)&rcChild.right );
				int cxEdge = rcChild.left;
				SetWindowPos( hwndChild, NULL, 0, 0, cxDlg - cxEdge * 2, rcChild.bottom - rcChild.top, SWP_NOMOVE | SWP_NOZORDER );

				hwndChild = GetDlgItem( hwnd, IDC_SEARCH );
				GetWindowRect( hwndChild, &rcChild );
				ScreenToClient( hwnd, (POINT*)&rcChild.left );
				ScreenToClient( hwnd, (POINT*)&rcChild.right );
				SetWindowPos( hwndChild, NULL, cxDlg - (rcChild.right - rcChild.left) - cxEdge, rcChild.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER );

				hwndChild = GetDlgItem( hwnd, IDC_LIST );
				GetWindowRect( hwndChild, &rcChild );
				ScreenToClient( hwnd, (POINT*)&rcChild.left );
				ScreenToClient( hwnd, (POINT*)&rcChild.right );
				SetWindowPos( hwndChild, NULL, 0, 0, cxDlg - cxEdge * 2, cyDlg - rcChild.top - cxEdge, SWP_NOMOVE | SWP_NOZORDER );

			}
		}
		break;
	case WM_NOTIFY:
		{
			NMHDR* pnmh = (NMHDR*)lParam;
			switch( pnmh->code ){
//			case NM_DBLCLK:
			case NM_CLICK:
			case LVN_ITEMACTIVATE:
				{
					NMITEMACTIVATE* pNMItemActivate = (NMITEMACTIVATE*)pnmh;
					if( pNMItemActivate->iItem >= 0 ){
						CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrame( hwnd ));
						pFrame->OnJump( pNMItemActivate->iItem );
					}
				}
				break;
			}
		}
		break;
	}
	return bResult;

}

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			bResult = pFrame->OnPropInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			pFrame->OnPropDlgCommand( hwnd, wParam );
		}
		break;
	}
	return bResult;
}


// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

