// implementatin of this specific plug-in is here:
//

#define MAX_LEVEL 64
#define MAX_SNIPPET_LENGTH 260

#define IMAGE_FOLDER_CLOSE	0
#define IMAGE_FOLDER_OPEN	1
#define IMAGE_PAPER			2

#define ZERO_INIT_FIRST_MEM(classname, firstmem)  ZeroMemory( &firstmem, sizeof( classname ) - ((char*)&firstmem - (char*)this) );

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
LRESULT CALLBACK TreeProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );

#define SIGNATURE_SNIPPETS	0x00EF0F08

WCHAR HexToDec( LPWSTR& p )
{
	WCHAR sz[5];
	WCHAR* po = sz;
	*po++ = *p++;
	if( *p != '\0' ){
		*po++ = *p++;
		if( *p != '\0' ){
			*po++ = *p++;
			if( *p != '\0' ){
				*po++ = *p;
			}
		}
	}
	*po++ = '\0';
	return (WCHAR)wcstoul( sz, NULL, 16 );
}

WCHAR OctToDec( LPWSTR& p )
{
	WCHAR sz[7];
	WCHAR* po = sz;
	*po++ = *p++;
	if( *p != '\0' ){
		*po++ = *p++;
		if( *p != '\0' ){
			*po++ = *p++;
			if( *p != '\0' ){
				*po++ = *p++;
				if( *p != '\0' ){
					*po++ = *p++;
					if( *p != '\0' ){
						*po++ = *p;
					}
				}
			}
		}
	}
	*po++ = '\0';
	return (WCHAR)wcstoul( sz, NULL, 8 );
}

static unsigned char achHexChar[16] =
{ '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

wstring UnescapeString( LPCWSTR szSrc )
{
	LPWSTR szDest = new WCHAR[ wcslen(szSrc) + 1 ];
	LPWSTR po = szDest;
	LPWSTR pi = (LPWSTR)szSrc;
	while( *pi != L'\0' ){
		if( *pi == L'\\' ){
			pi++;
			switch( *pi ){
			case L'a': *po = L'\a'; break;
			case L'b': *po = L'\b'; break;
			case L'f': *po = L'\f'; break;
			case L'n': *po = L'\n'; break;
			case L'r': *po = L'\r'; break;
			case L't': *po = L'\t'; break;
			case L'v': *po = L'\v'; break;
			case L'x': case L'X':
				pi++;
				*po = HexToDec( pi );
				if( *pi == '\0' ){
					po++;
					goto unescape_exit;
				}
				break;
			default:
				if( *pi >= '0' && *pi <= '9' ){
					*po = OctToDec( pi );
					if( *pi == '\0' ){
						po++;
						goto unescape_exit;
					}
					break;
				}
				else {
					*po = *pi;
					if( *pi == '\0' ){
						pi--;
						break;
					}
				}
			}
			pi++;
			po++;
		}
		else {
			*po++ = *pi++;
		}
	}
unescape_exit:;
	*po = L'\0';

	wstring sDest = szDest;
	delete [] szDest;
	return sDest;
}


class CSnippetItem
{
public:
	wstring		m_sText;
	BYTE		m_nLevel;
	bool		m_bFolder;

	CSnippetItem( LPCWSTR pszText, BYTE nLevel, bool bFolder )
	{
		m_sText = pszText;
		m_nLevel = nLevel;
		m_bFolder = bFolder;
	}
};

typedef vector<CSnippetItem> CSnippetArray;


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_TRUE_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= CLR_NONE				};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 6010					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 6000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= FALSE					};

	// user-defined members
	enum { IDW_TREE	= 100 };
	CSnippetArray m_SnippetArray;
	wstring m_sNewText;

	// data that can be set zeros below
	HWND m_hwndTree;  // first member for data that can be set zeros
	WNDPROC m_lpOldTreeProc;
	HIMAGELIST m_himageMisc;
	CSnippetArray::iterator m_itSelected;
	HTREEITEM m_hTargetItem;
	HTREEITEM m_hSrcItem;
	UINT m_nClientID;
	int  m_iPos;
	int  m_iOldPos;
	bool m_bProfileLoaded;
	bool m_bOpenStartup;
	bool m_bFocusView;
	bool m_bSaveSnippets;
	bool m_bDragging;
	bool m_bAfterTarget;
	bool m_bInFolderTarget;
	bool m_bUninstalling;
	
	void OnCommand( HWND /*hwndView*/ )
	{
		if( m_hwndTree == NULL ){
			TCHAR sz[260];
			TCHAR szAppName[80];
			LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
			if( Editor_GetVersion( m_hWnd ) < 6000 ){
				LoadString( EEGetInstanceHandle(), IDS_INVALID_VERSION, sz, _countof( sz ) );
				MessageBox( m_hWnd, sz, szAppName, MB_OK | MB_ICONSTOP );
				return;
			}

			DWORD dwStyles = WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | TVS_SHOWSELALWAYS | TVS_HASBUTTONS | TVS_LINESATROOT | TVS_HASLINES | TVS_EDITLABELS;
			// A temporary parent window is specified here.  The parent window will be substituted by the custom bar window when Editor_CustomBarOpen is called.
			m_hwndTree = CreateWindowEx( WS_EX_CLIENTEDGE, WC_TREEVIEW, NULL, dwStyles, 0, 0, 0, 0, m_hWnd, (HMENU)IDW_TREE, NULL, NULL );
			if( m_hwndTree != NULL ){
				CUSTOM_BAR_INFO cbi;
				ZeroMemory( &cbi, sizeof( cbi ) );
				cbi.cbSize = sizeof( cbi );
				cbi.hwndClient = m_hwndTree;
				cbi.iPos = m_iPos;
				cbi.pszTitle = szAppName;
				m_nClientID = Editor_CustomBarOpen( m_hWnd, &cbi );

				if( !m_nClientID ){
					CustomBarClosed();
				}
				else {

					// The parent window is set to the custom bar window.
					_ASSERTE( cbi.hwndCustomBar && GetParent( m_hwndTree ) == cbi.hwndCustomBar );

					SubclassTree( m_hwndTree );
					if( m_himageMisc == NULL ){
						m_himageMisc = ImageList_LoadBitmap( EEGetInstanceHandle(), MAKEINTRESOURCE( IDB_IMAGE ), 16, 0, RGB(255,0,255) );
						if( m_himageMisc != NULL ){
							ImageList_SetBkColor( m_himageMisc, CLR_NONE );
						}
					}
					TreeView_SetImageList( m_hwndTree, m_himageMisc, TVSIL_NORMAL );
					LoadSnippets();
				}
			}
		}
		else {
			_ASSERTE( m_nClientID );
			BOOL bClosed = Editor_CustomBarClose( m_hWnd, m_nClientID );
			_ASSERTE( bClosed );
			CustomBarClosed();
		}
	}

	void CustomBarClosed()
	{
		if( m_hwndTree ){
			UnsubclassTree( m_hwndTree );
			if( IsWindow( m_hwndTree ) ){
				DestroyWindow( m_hwndTree );
			}
			m_hwndTree = NULL;
			m_nClientID = 0;
		}
	}

	BOOL QueryStatus( HWND /* hwndView */, LPBOOL pbChecked )
	{		
		*pbChecked = (m_hwndTree != NULL);
		return TRUE;
	}

	void OnEvents( HWND hwndView, UINT nEvent, LPARAM lParam )
	{
		if( nEvent & EVENT_CREATE_FRAME ){
			LoadProfile();
			if( m_bOpenStartup ){
				OnCommand( hwndView );
			}
		}
		if( nEvent & EVENT_CLOSE_FRAME ){
			if( m_hwndTree ){
				OnCommand( hwndView );
			}
		}
		if( nEvent & EVENT_CUSTOM_BAR_CLOSED ){
			// this message arrives even if plug-in does not own this custom bar, so make sure it is mine.
			if( m_hwndTree != NULL ){  
				CUSTOM_BAR_CLOSE_INFO* pCBCI = (CUSTOM_BAR_CLOSE_INFO*)lParam;
				if( pCBCI->nID == m_nClientID ){
					CustomBarClosed();
					// if the frame closed while Custom Bar is open, save the status for next startup.
					m_bOpenStartup = (pCBCI->dwFlags & CLOSED_FRAME_WINDOW);
					SaveProfile();
					if( m_himageMisc ){
						VERIFY( ImageList_Destroy( m_himageMisc ) );
						m_himageMisc = NULL;
					}
				}
			}
		}
		if( nEvent & EVENT_IDLE ){
			if( m_hwndTree ){
				if( m_bSaveSnippets ){
					m_bSaveSnippets = false;
					SaveSnippets();
				}
				if( m_bFocusView ){
					Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
				}
			}
			m_bFocusView = false;
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg, LPTSTR pszUninstallCommand, LPTSTR pszUninstallParam )
	{
		TCHAR szProductCode[80] = { 0 };
		HKEY hKey = NULL;
		if( RegOpenKeyEx( HKEY_LOCAL_MACHINE, _T("Software\\EmSoft\\EmEditorPlugIns\\Snippets"), 0, KEY_READ, &hKey ) == ERROR_SUCCESS && hKey ){
			GetProfileStringReg( hKey, _T("ProductCode"), szProductCode, _countof( szProductCode ), _T("") );
			if( szProductCode[0] ){
				GetSystemDirectory( pszUninstallCommand, MAX_PATH );
				PathAppend( pszUninstallCommand, _T("msiexec.exe") );

				StringPrintf( pszUninstallParam, MAX_PATH, _T("/X%s"), szProductCode );
				RegCloseKey( hKey );
				m_bUninstalling = true;
				return UNINSTALL_RUN_COMMAND;
			}
		}
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			EraseProfile();
			m_bUninstalling = true;
			return UNINSTALL_SIMPLE_DELETE;
		}
		return UNINSTALL_FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_PROP ), hDlg, PropDlg );
		return TRUE;
	}

	BOOL PreTranslateMessage( HWND /*hwndView*/, MSG* pMsg )
	{
		HWND hwndFocus = GetFocus();
		if( hwndFocus ){
			if( m_hwndTree && (hwndFocus == m_hwndTree || IsChild( m_hwndTree, hwndFocus )) ){
				if( pMsg->message == WM_KEYDOWN ){
					bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
					bool bShift = GetKeyState( VK_SHIFT ) < 0;
					if( !bCtrl ){
						if( pMsg->wParam == VK_ESCAPE ){
							if( !bShift ){
								Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
								return TRUE;
							}
						}
						//else if( pMsg->wParam == VK_F6 ){
						//	Editor_ExecCommand( m_hWnd, bShift ? EEID_PREV_PANE : EEID_NEXT_PANE );
						//	return TRUE;
						//}
						if( pMsg->wParam == VK_RETURN ){
							SendMessage( hwndFocus, pMsg->message, pMsg->wParam, pMsg->lParam );
							return TRUE;
						}
					}
				}
				if( pMsg->message == WM_SYSKEYDOWN ){
					if( m_hwndTree == hwndFocus ){
						if( pMsg->wParam == VK_UP || pMsg->wParam == VK_DOWN ){
							if( GetKeyState(VK_MENU) < 0 ){
								HTREEITEM hSelectedItem = TreeView_GetSelection( m_hwndTree );
								OnTreeMove( hSelectedItem, pMsg->wParam == VK_DOWN );
								return TRUE;
							}
						}
					}
				}
				if( IsDialogMessage( m_hwndTree, pMsg ) ){
					return TRUE;
				}
			}
		}
		return FALSE;
	}

	CMyFrame()
	{
		ZERO_INIT_FIRST_MEM( CMyFrame, m_hwndTree );
		m_iPos = m_iOldPos = CUSTOM_BAR_LEFT;
	}

#pragma warning( push )
#pragma warning( disable : 4244 ) // 'argument' : conversion from 'LONG_PTR' to 'LONG', possible loss of data
#pragma warning( disable : 4312 )  // 'type cast' : conversion from 'LONG' to 'WNDPROC' of greater size

	void SubclassTree( HWND hwndTree )
	{
		_ASSERTE( m_lpOldTreeProc == NULL );
		m_lpOldTreeProc = (WNDPROC)SetWindowLongPtr( hwndTree, GWLP_WNDPROC, (LONG_PTR)TreeProc );
	}

	void UnsubclassTree( HWND hwndTree )
	{
		if( m_lpOldTreeProc != NULL ){
			SetWindowLongPtr( hwndTree, GWLP_WNDPROC, (LONG_PTR)m_lpOldTreeProc );
			m_lpOldTreeProc = NULL;
		}
	}

#pragma warning( pop )

	UINT_PTR GetCurrentLine( HWND hwndView )
	{
		POINT_PTR ptCurrentPos;
		Editor_GetCaretPos( hwndView, POS_LOGICAL_W, &ptCurrentPos );
		return ptCurrentPos.y;
	}

	void LoadProfile()
	{
		if( !m_bProfileLoaded ){
			m_bProfileLoaded = true;
			m_bOpenStartup = !!GetProfileInt( _T("OpenStartup"), FALSE );
			m_iPos = GetProfileInt( _T("CustomBarPos"), CUSTOM_BAR_LEFT );
		}
	}

	void SaveProfile()
	{
		WriteProfileInt( _T("OpenStartup"), m_bOpenStartup );
		WriteProfileInt( _T("CustomBarPos"), m_iPos );
	}

	void LoadSnippets()
	{
		_ASSERTE( m_hwndTree != NULL );
		if( m_hwndTree == NULL )  return;
		HTREEITEM ahParentItem[ MAX_LEVEL + 1 ];
		ZeroMemory( ahParentItem, sizeof( ahParentItem ) );

		TVINSERTSTRUCT tvi;
		ZeroMemory( &tvi, sizeof( tvi ) );
		tvi.hInsertAfter = TVI_LAST;
		tvi.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;

		SendMessage( m_hwndTree, WM_SETREDRAW, FALSE, 0 );
		TreeView_DeleteAllItems( m_hwndTree );

		DWORD dwCount = GetProfileBinary( _T("SnippetArray"), NULL, 0 );
		if( dwCount > 0 ){
			char* pBuf = new char[dwCount];
			if( pBuf != NULL ){
				if( GetProfileBinary( _T("SnippetArray"), (LPBYTE)pBuf, dwCount ) ){
					int nMax, nLen;
					char* p = pBuf;
					DWORD dwSign = *((DWORD*)p);
					p += sizeof( DWORD );
					if( dwSign == SIGNATURE_SNIPPETS )	{
						nMax = *((int*)p);
						p += sizeof( int );
						for( int i = 0; i < nMax; i ++ ){
							nLen = *((int*)p);
							p += sizeof( int );
							wstring sText( (LPWSTR)p, nLen );
							p += nLen * sizeof(WCHAR);
							BYTE nLevel = *((BYTE*)p);
							p += sizeof( BYTE );
							BYTE bFolder = *((BYTE*)p);
							p += sizeof( BYTE );
							p += sizeof( BYTE );
							p += sizeof( BYTE );

							tvi.item.pszText = (LPWSTR)(LPCWSTR)sText.c_str();
							tvi.item.iImage = tvi.item.iSelectedImage = bFolder ? IMAGE_FOLDER_CLOSE : IMAGE_PAPER;
							_ASSERTE( nLevel > 0 );
							if( nLevel == 0 )  break;
							tvi.hParent = ahParentItem[ nLevel - 1 ];

							HTREEITEM hItem = TreeView_InsertItem( m_hwndTree, &tvi );
							if( hItem != NULL ){
								TreeView_Expand( m_hwndTree, tvi.hParent, TVE_EXPAND );
								for( int i = nLevel; i < MAX_LEVEL + 1; i++ ){
									ahParentItem[ i ] = hItem;
								}
							}
						}
						_ASSERTE( p == pBuf + dwCount );
					}
				}
				delete [] pBuf;
			}
		}

		SendMessage( m_hwndTree, WM_SETREDRAW, TRUE, 0 );

	}

	bool IsFolder( HTREEITEM hItem )
	{
		bool bFolder = false;
		TVITEM item = { 0 };
		item.mask = TVIF_IMAGE;
		item.hItem = hItem;
		BOOL bRet = TreeView_GetItem( m_hwndTree, &item );
		_ASSERTE( bRet );
		if( bRet ){
			bFolder = item.iImage != IMAGE_PAPER;
		}
		return bFolder;
	}

	void SerializeTree( HTREEITEM hRootItem, CSnippetArray& Array, int& nLevel )
	{
		WCHAR szText[MAX_SNIPPET_LENGTH];
		TVITEM item = { 0 };
		item.mask = TVIF_IMAGE | TVIF_TEXT;
		item.hItem = hRootItem;
		item.pszText = szText;
		item.cchTextMax = _countof( szText );
		BOOL bRet = TreeView_GetItem( m_hwndTree, &item );
		_ASSERTE( bRet );
		if( bRet ){
			bool bFolder = item.iImage != IMAGE_PAPER;
			Array.push_back( CSnippetItem( szText, (BYTE)nLevel, bFolder ) );
		}
		nLevel++;
		HTREEITEM hItem = TreeView_GetChild( m_hwndTree, hRootItem );
		while( hItem ){
			SerializeTree( hItem, Array, nLevel );
			hItem = TreeView_GetNextSibling( m_hwndTree, hItem );
		}
		nLevel--;
	}

	void SaveSnippets()
	{
		CSnippetArray Array;
		int nLevel = 1;
		HTREEITEM hItem = TreeView_GetRoot( m_hwndTree );
		while( hItem != NULL ){
			SerializeTree( hItem, Array, nLevel );
			hItem = TreeView_GetNextSibling( m_hwndTree, hItem );
		}

		if( Array.size() == 0 ){
			EraseEntry( _T("SnippetArray") );
		}
		else {
			DWORD dwCount = sizeof(DWORD) + sizeof( int );
			CSnippetArray::iterator it;
			for( it = Array.begin(); it != Array.end(); it++ ){
				dwCount += (DWORD)it->m_sText.length() * sizeof(WCHAR) + sizeof( int ) + sizeof( BYTE ) * 4;
			}
			char* pBuf = new char[dwCount];
			if( pBuf != NULL ){
				char* p = pBuf;
				*((DWORD*)p) = SIGNATURE_SNIPPETS;
				p += sizeof( DWORD );
				*((int*)p) = (int)Array.size();
				p += sizeof( int );
				for( it = Array.begin(); it != Array.end(); it++ ){
					*((int*)p) = (int)it->m_sText.length();
					p += sizeof( int );
					wmemcpy( (WCHAR*)p, it->m_sText.c_str(), it->m_sText.length() );
					p += it->m_sText.length() * sizeof(WCHAR);
					_ASSERTE( it->m_nLevel <= MAX_LEVEL );
					*((BYTE*)p) = it->m_nLevel;
					p += sizeof( BYTE );
					*((BYTE*)p) = it->m_bFolder;
					p += sizeof( BYTE );
					p += sizeof( BYTE );  // dummy
					p += sizeof( BYTE );  // dummy
				}
				_ASSERTE( p == pBuf + dwCount );
				WriteProfileBinary( _T("SnippetArray"), (LPBYTE)pBuf, dwCount, true );
				delete [] pBuf;
			}
		}
	}

	// pszText buffer must be at least MAX_SNIPPET_LENGTH
	bool GetItemText( HTREEITEM hItem, LPWSTR pszText )
	{
		TVITEM item = { 0 };
		*pszText = 0;
		item.hItem = hItem;
		item.mask = TVIF_IMAGE | TVIF_TEXT;
		item.pszText = pszText;
		item.cchTextMax = MAX_SNIPPET_LENGTH;
		BOOL bRet = TreeView_GetItem( m_hwndTree, &item );
		_ASSERTE( bRet );
		if( bRet ){
			if( item.iImage != IMAGE_PAPER ){
				return true;
			}
		}
		return false;
	}

	void OnInsertText( HTREEITEM hItem )
	{
		if( hItem == NULL )  return;
		_ASSERTE( m_hwndTree );
		WCHAR szText[MAX_SNIPPET_LENGTH];
		bool bFolder = GetItemText( hItem, szText );
		if( !bFolder ){
			wstring s = UnescapeString( szText );
			Editor_InsertStringW( m_hWnd, s.c_str(), true );
			m_bFocusView = true;
		}
	}

	void OnTreeContextMenu( bool bUseCursorPos )
	{
		HMENU hMainMenu = LoadMenu( EEGetInstanceHandle(), MAKEINTRESOURCE(IDR_CONTEXT_MENU) );
		HMENU hMenu = GetSubMenu( hMainMenu, 0 );
		HTREEITEM hItem;
		SetMenuDefaultItem( hMenu, ID_INSERT, FALSE );
		POINT ptPos;
		if( bUseCursorPos ){
			GetCursorPos( &ptPos );
		}
		else {
			hItem = TreeView_GetSelection( m_hwndTree );
			if( hItem != NULL ){
				RECT rc;
				TreeView_GetItemRect( m_hwndTree, hItem, &rc, TRUE );
				ptPos.y = rc.bottom;
				ptPos.x = rc.left;
			}
			else {
				ptPos.y = 4;
				ptPos.x = 4;
			}
			ClientToScreen( m_hwndTree, &ptPos );
		}
		int nID = TrackPopupMenu( hMenu, TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD, ptPos.x, ptPos.y, 0, m_hwndTree, NULL );
		DestroyMenu( hMainMenu );
		if( bUseCursorPos ){
			TVHITTESTINFO ht = { 0 };
			ScreenToClient( m_hwndTree, &ptPos );
			ht.pt.x = ptPos.x;
			ht.pt.y = ptPos.y;
			hItem = TreeView_HitTest( m_hwndTree, &ht );
		}
		else {
			hItem = TreeView_GetSelection( m_hwndTree );
		}
		if( nID == ID_NEW_TEXT || nID == ID_NEW_FOLDER ){
			OnTreeNew( hItem, nID == ID_NEW_FOLDER );
		}
		else if( nID == ID_MOVE_UP || nID == ID_MOVE_DOWN ){
			OnTreeMove( hItem, nID == ID_MOVE_DOWN );
		}
		else if( nID == ID_DELETE ){
			OnTreeDelete( hItem );
		}
		else if( nID == ID_RENAME ){
			OnTreeRename( hItem );
		}
		else if( nID == ID_INSERT ){
			OnInsertText( hItem );
		}
	}

	void OnTreeRename( HTREEITEM hItem )
	{
		if( hItem ){
			TreeView_EditLabel( m_hwndTree, hItem );
		}
	}

	int GetTreeLevel( HTREEITEM hItem )
	{
		int nLevel = 1;
		do {
			hItem = TreeView_GetParent( m_hwndTree, hItem );
			nLevel++;
		} while( hItem );
		return nLevel;
	}

	void OnTreeNew( HTREEITEM hItem, bool bFolder )
	{
		WCHAR szText[MAX_SNIPPET_LENGTH];
		bool bSelectedFolder = (hItem == NULL || GetItemText( hItem, szText ));
		HTREEITEM hParentItem = hItem;
		if( !bSelectedFolder ){
			hParentItem = TreeView_GetParent( m_hwndTree, hItem );
		}

		if( bFolder ){
			int nLevel = GetTreeLevel( hParentItem );
			if( nLevel >= MAX_LEVEL ){
				return;
			}
		}

		TVINSERTSTRUCT tvi;
		ZeroMemory( &tvi, sizeof( tvi ) );
		tvi.hParent = hParentItem;
		tvi.hInsertAfter = hItem == NULL ? TVI_LAST : hItem;
		tvi.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
		tvi.item.pszText = L"New Item";
		tvi.item.iImage = tvi.item.iSelectedImage = bFolder ? IMAGE_FOLDER_CLOSE : IMAGE_PAPER;

		HTREEITEM hNewItem = TreeView_InsertItem( m_hwndTree, &tvi );
		if( hNewItem != NULL ){
			TreeView_Expand( m_hwndTree, tvi.hParent, TVE_EXPAND );
			TreeView_SelectItem( m_hwndTree, hNewItem );
			TreeView_EditLabel( m_hwndTree, hNewItem );
		}
	}

	void OnTreeEndLabelEdit( NMTVDISPINFO* /*ptvdi*/ )
	{
		m_bSaveSnippets = true;
	}

	void OnTreeKeyDown( NMTVKEYDOWN *ptvkd )
	{
		if( ptvkd->wVKey == VK_DELETE ){
			HTREEITEM hItem = TreeView_GetSelection( m_hwndTree );
			OnTreeDelete( hItem );
		}
		else if( ptvkd->wVKey == VK_INSERT ){
			HTREEITEM hItem = TreeView_GetSelection( m_hwndTree );
			OnTreeNew( hItem, false );
		}
		else if( ptvkd->wVKey == VK_F2 ){
			HTREEITEM hItem = TreeView_GetSelection( m_hwndTree );
			OnTreeRename( hItem );
		}
		else if( ptvkd->wVKey == VK_ESCAPE || ptvkd->wVKey == VK_F6 ){
			bool bCtrl = GetKeyState( VK_CONTROL ) < 0;
			if( !bCtrl ){
				Editor_ExecCommand( m_hWnd, EEID_ACTIVE_PANE );
			}
		}
	}

	void DeleteItem( HTREEITEM hItem )
	{
		if( hItem == NULL )  return;
		TreeView_DeleteItem( m_hwndTree, hItem );
	}

	void OnTreeDelete( HTREEITEM hItem )
	{
		if( hItem == NULL )  return;
		TCHAR sz[260];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), TreeView_GetChild( m_hwndTree, hItem ) == NULL ? IDS_SURE_DELETE : IDS_SURE_DELETE_FOLDER, sz, _countof( sz ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, _countof( szAppName ) );
		if( MessageBox( m_hwndTree, sz, szAppName, MB_YESNO | MB_DEFBUTTON2 | MB_ICONEXCLAMATION ) != IDYES )  return;
		DeleteItem( hItem );
		m_bSaveSnippets = true;
	}

	void MoveItem( HTREEITEM hItemFrom, HTREEITEM hItemTo, bool bAfter, bool bInFolder )
	{
		if( hItemFrom == hItemTo ){
			return;
		}

		// Cannot move a folder to the child or grandchild of the same tree
		if( IsFolder( hItemFrom ) ){
			HTREEITEM hItem = hItemTo;
			do {
				hItem = TreeView_GetParent( m_hwndTree, hItem );
				if( hItem == hItemFrom )  return;
			} while( hItem );
		}

		CSnippetArray Array;
		int nLevel = 1;
		SerializeTree( hItemFrom, Array, nLevel );
		TreeView_DeleteItem( m_hwndTree, hItemFrom );

		HTREEITEM hParent;
		HTREEITEM hInsertAfter;
		if( bInFolder ){
			hParent = hItemTo;
			hInsertAfter = hItemTo;
		}
		else if( bAfter ){
			hParent = TreeView_GetParent( m_hwndTree, hItemTo );
			hInsertAfter = hItemTo;
		}
		else {
			hParent = TreeView_GetParent( m_hwndTree, hItemTo );
			hInsertAfter = TreeView_GetPrevSibling( m_hwndTree, hItemTo );
		}
		if( hInsertAfter == NULL ){
			hInsertAfter = TVI_FIRST;
		}
		HTREEITEM ahParentItem[ MAX_LEVEL + 1 ];
		ZeroMemory( ahParentItem, sizeof( ahParentItem ) );
		for( int i = 0; i < MAX_LEVEL + 1; i++ ){
			ahParentItem[ i ] = hParent;
		}

		TVINSERTSTRUCT tvi;
		ZeroMemory( &tvi, sizeof( tvi ) );
		tvi.item.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE;

		HTREEITEM hFirstItem = NULL;
		HTREEITEM hItem = hInsertAfter;
		for( CSnippetArray::iterator it = Array.begin(); it != Array.end(); it++ ){
			_ASSERTE( it->m_nLevel <= MAX_LEVEL );
			tvi.hParent = ahParentItem[ it->m_nLevel - 1 ];
			tvi.hInsertAfter = hItem;
			tvi.item.pszText = (LPWSTR)it->m_sText.c_str();
			tvi.item.iImage = tvi.item.iSelectedImage = it->m_bFolder ? IMAGE_FOLDER_CLOSE : IMAGE_PAPER;
			hItem = TreeView_InsertItem( m_hwndTree, &tvi );
			if( hFirstItem == NULL ){
				hFirstItem = hItem;
			}
			if( hItem != NULL ){
				TreeView_Expand( m_hwndTree, tvi.hParent, TVE_EXPAND );
				_ASSERTE( it->m_nLevel <= MAX_LEVEL );
				for( int i = it->m_nLevel; i < MAX_LEVEL + 1; i++ ){
					ahParentItem[ i ] = hItem;
				}
			}
		}
		TreeView_SelectItem( m_hwndTree, hFirstItem );
		m_bSaveSnippets = true;;
	}

	void OnTreeMove( HTREEITEM hSelectedItem, bool bDown )
	{
		if( hSelectedItem == NULL )  return;
		HTREEITEM hItemTo;
		bool bAfter = false;
		if( bDown ){
			TreeView_Expand( m_hwndTree, hSelectedItem, TVE_COLLAPSE );
			hItemTo = TreeView_GetNextVisible( m_hwndTree, hSelectedItem );
			if( hItemTo == NULL )  return;
			HTREEITEM hItem = TreeView_GetNextVisible( m_hwndTree, hItemTo );
			if( hItem ){
				HTREEITEM hNextItem = TreeView_GetNextSibling( m_hwndTree, hItemTo );
				if( !hNextItem && hItem != TreeView_GetChild( m_hwndTree, hItemTo ) ){
					bAfter = true;
				}
				else if( hItemTo == TreeView_GetNextSibling( m_hwndTree, hSelectedItem ) ){
					hItemTo = hItem;
				}
			}
			else  bAfter = true;
		}
		else {
			hItemTo = TreeView_GetPrevVisible( m_hwndTree, hSelectedItem );
			HTREEITEM hPrevItem = TreeView_GetPrevSibling( m_hwndTree, hSelectedItem );
			if( hPrevItem && hPrevItem != hItemTo ){
				bAfter = true;
			}
			if( hItemTo == NULL )  return;
		}
		MoveItem( hSelectedItem, hItemTo, bAfter, false );
	}

	void OnTreeBeginDrag( NMTREEVIEW* lpnmtv )
	{
		HIMAGELIST himl;
		m_hSrcItem = lpnmtv->itemNew.hItem;
		himl = TreeView_CreateDragImage(m_hwndTree, lpnmtv->itemNew.hItem); 
		ImageList_BeginDrag( himl, 0, 0, 0 );
		ImageList_DragEnter( m_hwndTree, 0, 0 );
		SetCapture( m_hwndTree ); 
		m_bDragging = TRUE; 
	}

	void OnTreeMouseMove( LONG x, LONG y )
	{
		TVHITTESTINFO tvht;
		int nHeight = TreeView_GetItemHeight( m_hwndTree );
		if( m_bDragging ) { 
			ImageList_DragMove( x, y ); 
			tvht.pt.x = x; 
			tvht.pt.y = y; 
			m_bAfterTarget = false;
			m_bInFolderTarget = false;
			m_hTargetItem = TreeView_HitTest( m_hwndTree, &tvht );
			if( m_hTargetItem ) { 
				RECT rcItem;
				if( TreeView_GetItemRect( m_hwndTree, m_hTargetItem, &rcItem, FALSE ) ){
					if( y > rcItem.top + nHeight / 2 ){
						if( !TreeView_GetChild( m_hwndTree, m_hTargetItem ) ){
							m_bAfterTarget = true;
						}
					}
					if( y >= rcItem.top + nHeight / 4 && y < rcItem.top + 3 * nHeight / 4 ){
						WCHAR szText[MAX_SNIPPET_LENGTH];
						bool bFolder = GetItemText( m_hTargetItem, szText );
						if( bFolder ){
							m_bInFolderTarget = true;
						}
					}
				}
			} 
			else {
				tvht.pt.y -= nHeight;
				m_hTargetItem = TreeView_HitTest( m_hwndTree, &tvht );
				if( m_hTargetItem ) { 
					m_bAfterTarget = true;
				}
			}
			if( m_hTargetItem ){
				if( m_bInFolderTarget ){
					TreeView_SelectDropTarget( m_hwndTree, m_hTargetItem );
					TreeView_SetInsertMark( m_hwndTree, NULL, m_bAfterTarget );
				}
				else {
					TreeView_SetInsertMark( m_hwndTree, m_hTargetItem, m_bAfterTarget );
					TreeView_SelectDropTarget( m_hwndTree, NULL );
				}
			}
			else {
				if( y < 0 ){
					SendMessage( m_hwndTree, WM_VSCROLL, SB_LINEUP, 0 );
				}
				else {
					SendMessage( m_hwndTree, WM_VSCROLL, SB_LINEDOWN, 0 );
				}
			}
		} 
	}

	void OnTreeMouseUp()
	{
		if( m_bDragging ){ 
			ImageList_EndDrag(); 
			ReleaseCapture(); 
			m_bDragging = false; 
			TreeView_SetInsertMark( m_hwndTree, NULL, FALSE );
			TreeView_SelectDropTarget( m_hwndTree, NULL );
			if( m_hTargetItem ){
				MoveItem( m_hSrcItem, m_hTargetItem, m_bAfterTarget, m_bInFolderTarget );
			}
		} 
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		TCHAR sz[80];
		for( int i = 0; i < 4; i++ ){
			LoadString( EEGetInstanceHandle(), IDS_POS_LEFT + i, sz, _countof( sz ) );
			SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_ADDSTRING, 0, (LPARAM)sz );
		}
		SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_SETCURSEL, m_iPos, 0 );
		m_iOldPos = m_iPos;
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, sz, _countof( sz ) );
		SetWindowText( hwnd, sz );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WPARAM wParam )
	{
		switch( wParam ){
		case IDOK:
			{
				m_iPos = (int)SendDlgItemMessage( hwnd, IDC_COMBO_POS, CB_GETCURSEL, 0, 0 );
				WriteProfileInt( _T("CustomBarPos"), m_iPos );
				EndDialog( hwnd, IDOK );

				if( m_iPos != m_iOldPos ){
					if( m_hwndTree ){
						OnCommand( NULL );
						OnCommand( NULL );
					}
				}
			}
			break;

		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
		return;
	}

};

INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			_ASSERTE( pFrame );
			pFrame->OnDlgCommand( hwnd, wParam );
		}
		break;
	}
	return bResult;
}

LRESULT CALLBACK TreeProc( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg ){
	case OCM_NOTIFY:
		{
			NMHDR* pnmh = (NMHDR*)lParam;
			switch( pnmh->code ) {
			case NM_DBLCLK:
			case NM_RETURN:
				{
					HTREEITEM hItem = TreeView_GetSelection( hwnd );
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					_ASSERTE( pFrame != NULL );
					if( pFrame != NULL ){
						pFrame->OnInsertText( hItem );
					}
				}
				break;
			case NM_RCLICK:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeContextMenu( true );
					}
				}
				break;
			case TVN_ENDLABELEDIT:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeEndLabelEdit( (NMTVDISPINFO*)lParam );
						return TRUE;
					}
				}
				break;
			case TVN_KEYDOWN:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeKeyDown( (NMTVKEYDOWN*)lParam );
					}
				}
				break;
			case TVN_BEGINDRAG:
				{
					CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
					if( pFrame != NULL ){
						pFrame->OnTreeBeginDrag( (NMTREEVIEW*)lParam );
					}
				}
				break;
			}
		}
		break;
	case WM_MOUSEMOVE:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			if( pFrame != NULL ){
				pFrame->OnTreeMouseMove( GET_X_LPARAM( lParam ), GET_Y_LPARAM( lParam ) );
			}
		}
		break;
	case WM_LBUTTONUP:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			if( pFrame != NULL ){
				pFrame->OnTreeMouseUp();
			}
		}
		break;
	case WM_CONTEXTMENU:
		{
			CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
			if( pFrame != NULL ){
				pFrame->OnTreeContextMenu( false );
			}
		}
		break;
	}
	CMyFrame* pFrame = (CMyFrame*)GetFrameFromDlg( hwnd );
	if( pFrame != NULL && pFrame->m_lpOldTreeProc != NULL ){
		return CallWindowProc( pFrame->m_lpOldTreeProc, hwnd, msg, wParam, lParam);
	}
	else {
		return 0;
	}
}

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

