#pragma once

// forward declaration
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
int __cdecl CompareLine( void* context, const void* line1, const void* line2 );

#define FLAG_CRLF		0
#define FLAG_CR_ONLY	1
#define FLAG_LF_ONLY	2
#define SORT_DECIMAL	1
#define IGNORE_PREFIX	2

#ifdef DESCEND
#define IDS_MENU_TEXT IDS_MENU_TEXT_D
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_D
#define LESS_THAN	(1)
#else
#define IDS_MENU_TEXT IDS_MENU_TEXT_A
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_A
#define LESS_THAN	(-1)
#endif

LPCTSTR szLocale = _T("Locale");
LPCTSTR szFlags = _T("Flags");

class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_16C_24			};
	enum { _IDB_256C_16_DEFAULT = IDB_256C_16_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_256C_16_HOT		};
	enum { _IDB_256C_16_BW		= IDB_256C_16_BW		};
	enum { _IDB_256C_24_DEFAULT = IDB_256C_24_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_256C_24_HOT		};
	enum { _IDB_256C_24_BW		= IDB_256C_24_BW		};
	enum { _IDB_TRUE_16_DEFAULT = IDB_TRUE_16_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_TRUE_16_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_TRUE_16_BW		};
	enum { _IDB_TRUE_24_DEFAULT = IDB_TRUE_24_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_TRUE_24_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_TRUE_24_BW		};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	DWORD m_dwFlags;

	CMyFrame()
	{
		m_dwFlags = 0;
	}

	~CMyFrame()
	{
	}

	void OnCommand( HWND hwndView )
	{
		m_dwFlags = LoadProfile();
		POINT_PTR ptStart, ptEnd;
		Editor_GetSelStart( hwndView, POS_LOGICAL_W, &ptStart );
		Editor_GetSelEnd( hwndView, POS_LOGICAL_W, &ptEnd );
		ptStart.x = 0;
		bool bEndNotRet = false;
		if( ptEnd.x != 0 ){
			if( ptEnd.y == (int)Editor_GetLines( hwndView, POS_LOGICAL_W ) - 1 ){
				bEndNotRet = true;
			}
			ptEnd.x = 0;
			ptEnd.y++;
		}
		INT_PTR nSize = ptEnd.y - ptStart.y;
		if( nSize <= 1 )  return;
		int nCrLf = FLAG_CRLF;
		LPWSTR pszFirstLine = GetLine( hwndView, 0 );
		if( pszFirstLine != NULL ){
			size_t nLen = wcslen( pszFirstLine );
			if( pszFirstLine[nLen-1] == L'\r' ){
				nCrLf = FLAG_CR_ONLY;
			}
			else if( nLen >= 2 && pszFirstLine[nLen-2] == L'\r' && pszFirstLine[nLen-1] == L'\n' ) {
				nCrLf = FLAG_CRLF;
			}
			else {
				nCrLf = FLAG_LF_ONLY;
			}
			delete [] pszFirstLine;
		}
		if( bEndNotRet ){
			Editor_ExecCommand( hwndView, EEID_BOTTOM );
			Editor_InsertStringW( hwndView, nCrLf == FLAG_CRLF ? L"\r\n" : nCrLf == FLAG_CR_ONLY ? L"\r" : L"\n" );
		}
		LPWSTR* apszLine = new LPWSTR[ nSize ];
		if( apszLine == NULL )  return;
		ZeroMemory( apszLine, sizeof( LPWSTR ) * nSize );
		LPWSTR* p = apszLine;
		bool bSuccess = true;
		for( INT_PTR y = ptStart.y; y < ptEnd.y; y++ ){
			*p = GetLine( hwndView, y );
			if( *p == NULL ){
				bSuccess = false;
				break;
			}
			p++;
		}
		if( bSuccess ){
			qsort_s( apszLine, nSize, sizeof( LPWSTR ), CompareLine, this );
			POINT_PTR ptStartView, ptEndView;
			Editor_Redraw( hwndView, FALSE );
			Editor_LogicalToView( hwndView, &ptStart, &ptStartView );
			Editor_LogicalToView( hwndView, &ptEnd, &ptEndView );
			Editor_SetSelView( hwndView, &ptStartView, &ptEndView );
			Editor_ExecCommand( hwndView, EEID_DELETE );
			p = apszLine;
			for( int i = 0; i < nSize; i++ ){
				Editor_InsertStringW( hwndView, *p++ );
			}
			Editor_LogicalToView( hwndView, &ptStart, &ptStartView );
			Editor_LogicalToView( hwndView, &ptEnd, &ptEndView );
			Editor_SetSelView( hwndView, &ptStartView, &ptEndView );
			Editor_Redraw( hwndView, TRUE );
		}
		p = apszLine;
		for( int i = 0; i < nSize; i++ ){
			delete [] *p++;
		}
		delete [] apszLine;
	}

	BOOL QueryStatus( HWND hwndView, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwndView, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwndView ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwndView, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwndView, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80];
		TCHAR szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			TCHAR szKey[MAX_PATH];
			if( GetRootKeyName( szKey ) ){
				RegDeleteKey( HKEY_CURRENT_USER, szKey );
			}
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_SORT_NUMBER ), hDlg, PropDlg );
		return TRUE;
	}

	// user defined methods below.
	DWORD LoadProfile()
	{
		DWORD dwFlags = 0;
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			dwFlags = GetProfileIntReg( hKey, szFlags, 0 );
			RegCloseKey( hKey );
		}
		return dwFlags;
	}

	BOOL SaveProfile( DWORD dwFlags )
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			WriteProfileIntReg( hKey, szFlags, dwFlags );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	LPWSTR GetLine( HWND hwnd, INT_PTR yLine )
	{
		GET_LINE_INFO gli;
		gli.cch = 0;
		gli.flags = FLAG_LOGICAL | FLAG_WITH_CRLF;
		gli.yLine = (UINT_PTR)yLine;
		UINT_PTR nSize = Editor_GetLineW( hwnd, &gli, NULL );
		LPWSTR pBuf = new WCHAR[ nSize ];
		if( pBuf != NULL ){
			gli.cch = nSize;
			Editor_GetLineW( hwnd, &gli, pBuf );
		}
		return pBuf;
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		TCHAR sz[256];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, sz, _countof( sz ) );
		SetWindowText( hwnd, sz );
		DWORD dwFlags = LoadProfile();
		CheckDlgButton( hwnd, IDC_IGNORE_PREFIX, !!(dwFlags & IGNORE_PREFIX) );
		CheckRadioButton( hwnd, IDC_INTEGER, IDC_DECIMAL, (dwFlags & SORT_DECIMAL) ? IDC_DECIMAL : IDC_INTEGER );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WORD wCmdID )
	{
		switch( wCmdID ){
		case IDOK:
			{
				DWORD dwFlags = 0;
				if( IsDlgButtonChecked( hwnd, IDC_DECIMAL ) ){
					dwFlags |= SORT_DECIMAL;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_PREFIX ) ){
					dwFlags |= IGNORE_PREFIX;
				}
				SaveProfile( dwFlags );
				EndDialog( hwnd, IDOK );
			}
			break;
		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
	}
};


INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	}
	return bResult;
}


int __cdecl CompareLine( void* context, const void* line1, const void* line2 )
{
	CMyFrame* pFrame = (CMyFrame*)context;
	LPWSTR psz1 = *(LPWSTR*)line1;
	LPWSTR psz2 = *(LPWSTR*)line2;
	if( psz1 != NULL && psz2 != NULL ){
		if( pFrame->m_dwFlags & IGNORE_PREFIX ){
			while( *psz1 != L'\0' && *psz1 != L'-' && *psz1 != L'+' && *psz1 != L'.' && !iswdigit( *psz1 ) )  psz1++;
			while( *psz2 != L'\0' && *psz2 != L'-' && *psz2 != L'+' && *psz2 != L'.' && !iswdigit( *psz2 ) )  psz2++;
		}
		if( pFrame->m_dwFlags & SORT_DECIMAL ){
			LPWSTR end;
			double d1 = wcstod( psz1, &end );
			double d2 = wcstod( psz2, &end );
			double d = (d1-d2);
			return d == 0 ? 0 : d < 0 ? LESS_THAN : (- LESS_THAN);
		}
		else {
			int n1 = _wtoi( psz1 );
			int n2 = _wtoi( psz2 );
			int n = n1 - n2;
			return n == 0 ? 0 : n < 0 ? LESS_THAN : (- LESS_THAN);
		}
	}
	return 0;
}

// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT


