// SortStringA.cpp
//

#include "stdafx.h"
#include "resource.h"
#include <plugin.h>


#define EMEDITOR_API extern "C"
#define FLAG_CRLF		0
#define FLAG_CR_ONLY	1
#define FLAG_LF_ONLY	2

#ifdef DESCEND
#define IDS_MENU_TEXT IDS_MENU_TEXT_D
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_D

#else
#define IDS_MENU_TEXT IDS_MENU_TEXT_A
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_A

#endif


HINSTANCE g_hInstance;
UINT g_nCmdID;
LPCTSTR szRootKey = _T("Software\\EmSoft\\EmEditorPlugIns\\");
LPCTSTR szLocale = _T("Locale");
LPCTSTR szFlags = _T("Flags");


int GetProfileIntReg( HKEY hSecKey, LPCTSTR lpszEntry, int nDefault )
{
	ASSERT( lpszEntry != NULL );
	if( hSecKey == NULL )  return nDefault;
	DWORD dwValue;
	DWORD dwType;
	DWORD dwCount = sizeof(DWORD);
	LONG lResult = RegQueryValueEx(hSecKey, lpszEntry, NULL, &dwType, (LPBYTE)&dwValue, &dwCount);
	if (lResult == ERROR_SUCCESS){
		ASSERT(dwType == REG_DWORD);
		ASSERT(dwCount == sizeof(dwValue));
		return (int)dwValue;
	}
	return nDefault;
}

void WriteProfileIntReg( HKEY hSecKey, LPCTSTR lpszEntry, int nValue )
{
	ASSERT( hSecKey != NULL );
	ASSERT( lpszEntry != NULL );
	if( hSecKey == NULL )  return;
	RegSetValueEx( hSecKey, lpszEntry, NULL, REG_DWORD, (LPBYTE)&nValue, sizeof(nValue) );
}

BOOL GetModuleFile( LPTSTR szFileName )
{
	TCHAR szPath[MAX_PATH];
	if( !GetModuleFileName( g_hInstance, szPath, _countof( szPath ) ) ){
		return FALSE;
	}
	TCHAR szBuf[MAX_PATH];
	LPTSTR pszFile = szBuf;
	GetFullPathName( szPath, MAX_PATH, szBuf, &pszFile );
	LPTSTR p = _tcschr( pszFile, '.' );
	if( p != NULL )  *p = _T('\0');
	lstrcpy( szFileName, pszFile );
	return TRUE;
}

BOOL GetRootKeyName( LPTSTR szKey )
{
	TCHAR szFileName[MAX_PATH];
	if( !GetModuleFile( szFileName ) )  return FALSE;
	lstrcpy( szKey, szRootKey );
	lstrcat( szKey, szFileName );
	return TRUE;
}

HKEY GetRootKey()
{
	TCHAR szKey[MAX_PATH];
	if( !GetRootKeyName( szKey ) )  return NULL;
	HKEY hKey = NULL;
	DWORD dw;
	RegCreateKeyEx( HKEY_CURRENT_USER, szKey, 0, REG_NONE, REG_OPTION_NON_VOLATILE, KEY_WRITE | KEY_READ, NULL, &hKey, &dw);
	return hKey;
}

BOOL LoadProfile( LCID& lcid, DWORD& dwFlags )
{
	HKEY hKey = GetRootKey();
	if( hKey != NULL ){
		lcid = GetProfileIntReg( hKey, szLocale, GetSystemDefaultLCID() );
		dwFlags = GetProfileIntReg( hKey, szFlags, 0 );
		RegCloseKey( hKey );
		return TRUE;
	}
	return FALSE;
}

BOOL SaveProfile( LCID lcid, DWORD dwFlags )
{
	HKEY hKey = GetRootKey();
	if( hKey != NULL ){
		WriteProfileIntReg( hKey, szLocale, lcid );
		WriteProfileIntReg( hKey, szFlags, dwFlags );
		RegCloseKey( hKey );
		return TRUE;
	}
	return FALSE;
}

BOOL APIENTRY DllMain( HINSTANCE hModule, DWORD ul_reason_for_call, LPVOID lpReserved )
{
    if( ul_reason_for_call == DLL_PROCESS_ATTACH ){
		g_hInstance = hModule;
	}
    return TRUE;
}

LCID g_lcid;
DWORD g_dwFlags;

LPWSTR GetLine( HWND hwnd, int yLine )
{
	GET_LINE_INFO gli;
	gli.cch = 0;
	gli.flags = FLAG_LOGICAL | FLAG_WITH_CRLF;
	gli.yLine = yLine;
	int nSize = Editor_GetLineW( hwnd, &gli, NULL );
	LPWSTR pBuf = new WCHAR[ nSize ];
	if( pBuf != NULL ){
		gli.cch = nSize;
		Editor_GetLineW( hwnd, &gli, pBuf );
	}
	return pBuf;
}


int __cdecl CompareLineW( const void* line1, const void* line2 )
{
	LPWSTR psz1 = *(LPWSTR*)line1;
	LPWSTR psz2 = *(LPWSTR*)line2;
	int nResult = 0;
	if( psz1 != NULL && psz2 != NULL ){
		int n1 = lstrlenW( psz1 );
		if( n1 > 0 && psz1[n1-1] == '\r' || psz1[n1-1] == '\n' )  n1--;
		if( n1 > 0 && psz1[n1-1] == '\r' )  n1--;
		int n2 = lstrlenW( psz2 );
		if( n2 > 0 && psz2[n2-1] == '\r' || psz2[n2-1] == '\n' )  n2--;
		if( n2 > 0 && psz2[n2-1] == '\r' )  n2--;
		nResult = CompareStringW( g_lcid, g_dwFlags, psz1, n1, psz2, n2 );
	}
	if( nResult == CSTR_LESS_THAN ){
#ifdef DESCEND
		return 1;
#else
		return -1;
#endif
	}
	else if( nResult == CSTR_GREATER_THAN ){
#ifdef DESCEND
		return -1;
#else
		return 1;
#endif
	}
	else {
		return 0;
	}
}

int __cdecl CompareLineA( const void* line1, const void* line2 )
{
	LPWSTR psz1 = *(LPWSTR*)line1;
	LPWSTR psz2 = *(LPWSTR*)line2;
	int nResult = 0;
	if( psz1 != NULL && psz2 != NULL ){
		int nBuf1 = wcslen( psz1 ) * 2 + 1;
		char* pszA1 = new char[ nBuf1 ];
		int nBuf2 = wcslen( psz2 ) * 2 + 1;
		char* pszA2 = new char[ nBuf2 ];
		if( pszA1 != NULL && pszA2 != NULL ){
			WideCharToMultiByte( CP_ACP, 0, psz1, -1, pszA1, nBuf1, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0, psz2, -1, pszA2, nBuf2, NULL, NULL );
			int n1 = lstrlenA( pszA1 );
			if( n1 > 0 && pszA1[n1-1] == '\r' || pszA1[n1-1] == '\n' )  n1--;
			if( n1 > 0 && pszA1[n1-1] == '\r' )  n1--;
			int n2 = lstrlenA( pszA2 );
			if( n2 > 0 && pszA2[n2-1] == '\r' || pszA2[n2-1] == '\n' )  n2--;
			if( n2 > 0 && pszA2[n2-1] == '\r' )  n2--;
			nResult = CompareStringA( g_lcid, g_dwFlags, pszA1, n1, pszA2, n2 );
		}
		delete [] pszA1;
		delete [] pszA2;
	}
	if( nResult == CSTR_LESS_THAN ){
#ifdef DESCEND
		return 1;
#else
		return -1;
#endif
	}
	else if( nResult == CSTR_GREATER_THAN ){
#ifdef DESCEND
		return -1;
#else
		return 1;
#endif
	}
	else {
		return 0;
	}
}

EMEDITOR_API void OnCommand( HWND hwnd )
{
	LCID lcid;
	DWORD dwFlags;
	LoadProfile( lcid, dwFlags );
	g_lcid = lcid;
	g_dwFlags = dwFlags;
	POINT ptStart, ptEnd;
	Editor_GetSelStart( hwnd, POS_LOGICAL_W, &ptStart );
	Editor_GetSelEnd( hwnd, POS_LOGICAL_W, &ptEnd );
	ptStart.x = 0;
	bool bEndNotRet = false;
	if( ptEnd.x != 0 ){
		if( ptEnd.y == (int)Editor_GetLines( hwnd, POS_LOGICAL_W ) - 1 ){
			bEndNotRet = true;
		}
		ptEnd.x = 0;
		ptEnd.y++;
	}
	int nSize = ptEnd.y - ptStart.y;
	if( nSize <= 1 )  return;
	int nCrLf = FLAG_CRLF;
	LPWSTR pszFirstLine = GetLine( hwnd, 0 );
	if( pszFirstLine != NULL ){
		int nLen = wcslen( pszFirstLine );
		if( pszFirstLine[nLen-1] == L'\r' ){
			nCrLf = FLAG_CR_ONLY;
		}
		else if( nLen >= 2 && pszFirstLine[nLen-2] == L'\r' && pszFirstLine[nLen-1] == L'\n' ) {
			nCrLf = FLAG_CRLF;
		}
		else {
			nCrLf = FLAG_LF_ONLY;
		}
		delete [] pszFirstLine;
	}
	if( bEndNotRet ){
		Editor_ExecCommand( hwnd, EEID_BOTTOM );
		Editor_InsertStringW( hwnd, nCrLf == FLAG_CRLF ? L"\r\n" : nCrLf == FLAG_CR_ONLY ? L"\r" : L"\n" );
	}
	LPWSTR* apszLine = new LPWSTR[ nSize ];
	if( apszLine == NULL )  return;
	ZeroMemory( apszLine, sizeof( LPWSTR ) * nSize );
	LPWSTR* p = apszLine;
	bool bSuccess = true;
	for( int y = ptStart.y; y < ptEnd.y; y++ ){
		*p = GetLine( hwnd, y );
		if( *p == NULL ){
			bSuccess = false;
			break;
		}
		p++;
	}
	if( bSuccess ){
		OSVERSIONINFO osvi;
		ZeroMemory( &osvi, sizeof( osvi ) );
		osvi.dwOSVersionInfoSize = sizeof( osvi );
		GetVersionEx( &osvi );
		bool bUnicode = (osvi.dwPlatformId == VER_PLATFORM_WIN32_NT);
		qsort( apszLine, nSize, sizeof( LPWSTR ), bUnicode ? CompareLineW : CompareLineA );
		POINT ptStartView, ptEndView;
		Editor_Redraw( hwnd, FALSE );
		Editor_LogicalToView( hwnd, &ptStart, &ptStartView );
		Editor_LogicalToView( hwnd, &ptEnd, &ptEndView );
		Editor_SetSelView( hwnd, &ptStartView, &ptEndView );
		Editor_ExecCommand( hwnd, EEID_DELETE );
		p = apszLine;
		for( int i = 0; i < nSize; i++ ){
			Editor_InsertStringW( hwnd, *p++ );
		}
		Editor_LogicalToView( hwnd, &ptStart, &ptStartView );
		Editor_LogicalToView( hwnd, &ptEnd, &ptEndView );
		Editor_SetSelView( hwnd, &ptStartView, &ptEndView );
		Editor_Redraw( hwnd, TRUE );
	}
	p = apszLine;
	for( int i = 0; i < nSize; i++ ){
		delete [] *p++;
	}
	delete [] apszLine;
}


EMEDITOR_API BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
{
	*pbChecked = FALSE;
	BOOL bReadOnly;
	Editor_QueryStatus( hwnd, EEID_READ_ONLY, &bReadOnly );
	if( bReadOnly )  return FALSE;
	int nFlags = (Editor_GetSelType( hwnd ) & SEL_TYPE_MASK);
	return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
}


EMEDITOR_API void OnEvents( HWND hwnd, UINT nEvent, LPARAM lParam )
{
	if( nEvent & EVENT_CREATE ){
		g_nCmdID = (UINT)lParam;
	}
	if( nEvent & EVENT_SEL_CHANGED ){
		Editor_UpdateToolbar( hwnd, g_nCmdID );
	}
}


EMEDITOR_API UINT GetMenuTextID()
{
	return IDS_MENU_TEXT;
}

EMEDITOR_API UINT GetStatusMessageID()
{
	return IDS_STATUS_MESSAGE;
}

EMEDITOR_API UINT GetBitmapID()
{
	return IDB_BITMAP;
}

HWND g_hwndComboLocale;

BOOL CALLBACK LocaleProc( LPTSTR lpLocaleString )
{
	LPTSTR pEnd;
	LCID lcid = _tcstol( lpLocaleString, &pEnd, 16 );
	TCHAR sz[1024];
	int n = GetLocaleInfo( lcid, LOCALE_SLANGUAGE | LOCALE_USE_CP_ACP, sz, _countof( sz ) - 8 );
	if( n > 0 ){
		WORD wSortID = SORTIDFROMLCID( lcid );
		if( wSortID != SORT_DEFAULT ){
			lstrcpy( sz + n - 1, " " );
			GetLocaleInfo( lcid, LOCALE_SSORTNAME | LOCALE_USE_CP_ACP , sz + n, _countof( sz ) - 8 );
		}
		int nIndex = SendMessage( g_hwndComboLocale, CB_ADDSTRING, 0, (LPARAM)sz );
		if( nIndex >= 0 ){
			SendMessage( g_hwndComboLocale, CB_SETITEMDATA, nIndex, lcid );
		}
	}
	return TRUE;
}


BOOL CALLBACK SortStringDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			bResult = TRUE;
			TCHAR sz[256];
			LoadString( g_hInstance, IDS_MENU_TEXT, sz, _countof( sz ) );
			SetWindowText( hwnd, sz );
			LCID lcid;
			DWORD dwFlags;
			LoadProfile( lcid, dwFlags );
			g_hwndComboLocale = GetDlgItem( hwnd, IDC_COMBO_LOCALE );
			if( !EnumSystemLocales( LocaleProc, LCID_SUPPORTED | LCID_ALTERNATE_SORTS ) ){
				DWORD dwError = GetLastError();
				if( dwError == ERROR_INVALID_FLAGS ){  // Windows 98 does not support LCID_ALTERNATE_SORTS
					EnumSystemLocales( LocaleProc, LCID_SUPPORTED );
				}
			}
			int nCount = SendMessage( g_hwndComboLocale, CB_GETCOUNT, 0, 0 );
			for( int i = 0; i < nCount; i++ ){
				if( (LCID)SendMessage( g_hwndComboLocale, CB_GETITEMDATA, i, 0 ) == lcid ){
					SendMessage( g_hwndComboLocale, CB_SETCURSEL, i, 0 );
					break;
				}
			}
			CheckDlgButton( hwnd, IDC_IGNORE_CASE, !!(dwFlags & NORM_IGNORECASE) );
			CheckDlgButton( hwnd, IDC_IGNORE_KANA_TYPE, !!(dwFlags & NORM_IGNOREKANATYPE) );
			CheckDlgButton( hwnd, IDC_IGNORE_NONSPACE, !!(dwFlags & NORM_IGNORENONSPACE) );
			CheckDlgButton( hwnd, IDC_IGNORE_SYMBOLS, !!(dwFlags & NORM_IGNORESYMBOLS) );
			CheckDlgButton( hwnd, IDC_IGNORE_WIDTH, !!(dwFlags & NORM_IGNOREWIDTH) );
			CheckDlgButton( hwnd, IDC_STRING_SORT, !!(dwFlags & SORT_STRINGSORT) );
		}
		break;
	case WM_COMMAND:
		switch( LOWORD( wParam ) ){
		case IDOK:
			{
				int nIndex = SendMessage( g_hwndComboLocale, CB_GETCURSEL, 0, 0 );
				LCID lcid = 0;
				if( nIndex >= 0 ){
					lcid = SendMessage( g_hwndComboLocale, CB_GETITEMDATA, nIndex, 0 );
				}
				DWORD dwFlags = 0;
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_CASE ) ){
					dwFlags |= NORM_IGNORECASE;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_KANA_TYPE ) ){
					dwFlags |= NORM_IGNOREKANATYPE;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_NONSPACE ) ){
					dwFlags |= NORM_IGNORENONSPACE;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_SYMBOLS ) ){
					dwFlags |= NORM_IGNORESYMBOLS;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_WIDTH ) ){
					dwFlags |= NORM_IGNOREWIDTH;
				}
				if( IsDlgButtonChecked( hwnd, IDC_STRING_SORT ) ){
					dwFlags |= SORT_STRINGSORT;
				}
				SaveProfile( lcid, dwFlags );
				EndDialog( hwnd, IDOK );
			}
			break;
		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
		break;
	}
	return bResult;
}

EMEDITOR_API LRESULT PlugInProc( HWND hwnd, UINT nMsg, WPARAM wParam, LPARAM lParam )
{
	TCHAR sz[80];
	TCHAR szAppName[80];
	LRESULT lResult = 0;
	switch( nMsg ){
	case EP_QUERY_PROPERTIES:
		lResult = TRUE;
		break;
	case EP_SET_PROPERTIES:
		DialogBox( g_hInstance, MAKEINTRESOURCE( IDD_SORT_STRING ), hwnd, SortStringDlg );
		lResult = TRUE;
		break;
	case EP_GET_NAMEA:
		LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		lResult = lstrlen( szAppName ) + 1;
		if( lParam != NULL ){
			lstrcpyn( (LPTSTR)lParam, szAppName, wParam );
		}
		break;
	case EP_GET_VERSIONA:
		LoadString( g_hInstance, IDS_VERSION, sz, sizeof( sz ) / sizeof( TCHAR ) );
		lResult = lstrlen( sz ) + 1;
		if( lParam != NULL ){
			lstrcpyn( (LPTSTR)lParam, sz, wParam );
		}
		break;
	case EP_QUERY_UNINSTALL:
		lResult = TRUE;
		break;
	case EP_SET_UNINSTALL:
		{
			LoadString( g_hInstance, IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
			LoadString( g_hInstance, IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
			TCHAR szKey[MAX_PATH];
			if( MessageBox( hwnd, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
				if( GetRootKeyName( szKey ) ){
					RegDeleteKey( HKEY_CURRENT_USER, szKey );
				}
				lResult = TRUE;
			}
		}
		break;
	case EP_GET_BITMAP:
		if( wParam & BITMAP_LARGE ){
			if( wParam & BITMAP_24BIT_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_24_TRUE_DISABLED;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_24_TRUE_HOT;
				}
				else {
					lResult = IDB_24_TRUE_DEFAULT;
				}
			}
			else if( wParam & BITMAP_256_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_24_256C_DISABLED;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_24_256C_HOT;
				}
				else {
					lResult = IDB_24_256C_DEFAULT;
				}
			}
			else {
				lResult = IDB_LARGE_BITMAP;
			}
		}
		else {
			if( wParam & BITMAP_24BIT_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_16_TRUE_DISABLED;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_16_TRUE_HOT;
				}
				else {
					lResult = IDB_16_TRUE_DEFAULT;
				}
			}
			else if( wParam & BITMAP_256_COLOR ){
				if( wParam & BITMAP_DISABLED ){
					lResult = IDB_16_256C_DISABLED;
				}
				else if( wParam & BITMAP_HOT ){
					lResult = IDB_16_256C_HOT;
				}
				else {
					lResult = IDB_16_256C_DEFAULT;
				}
			}
			else {
				lResult = IDB_BITMAP;
			}
		}
		break;
	case EP_GET_MASK:
		if( wParam & BITMAP_24BIT_COLOR ){
			lResult = CLR_NONE;
		}
		else if( wParam & BITMAP_256_COLOR ){
			lResult = RGB( 255, 0, 255 );
		}
		break;
	}
	return lResult;
}

