// implementatin of this specific plug-in is here:
//

// forward declaration
INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam );
BOOL CALLBACK LocaleProc( LPTSTR lpLocaleString );
int __cdecl CompareLineW( void* context, const void* line1, const void* line2 );
#ifndef UNICODE
int __cdecl CompareLineA( void* context, const void* line1, const void* line2 );
#endif

#define FLAG_CRLF		0
#define FLAG_CR_ONLY	1
#define FLAG_LF_ONLY	2

#ifdef DESCEND
#define IDS_MENU_TEXT IDS_MENU_TEXT_D
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_D
#else
#define IDS_MENU_TEXT IDS_MENU_TEXT_A
#define IDS_STATUS_MESSAGE IDS_STATUS_MESSAGE_A
#endif

LPCTSTR szLocale = _T("Locale");
LPCTSTR szFlags = _T("Flags");

HWND g_hwndComboLocale;


class CMyFrame : public CETLFrame<CMyFrame>
{
public:
	// string ID
	enum { _IDS_MENU			= IDS_MENU_TEXT			};   // name of command, menu
	enum { _IDS_STATUS			= IDS_STATUS_MESSAGE	};   // description of command, status bar
	enum { _IDS_NAME			= IDS_MENU_TEXT			};   // name of plug-in, plug-in settings dialog box
	enum { _IDS_VER				= IDS_VERSION			};   // version string of plug-in, plug-in settings dialog box

	// bitmaps
	enum { _IDB_BITMAP			= IDB_BITMAP			};
	enum { _IDB_16C_24			= IDB_LARGE_BITMAP		};
	enum { _IDB_256C_16_DEFAULT = IDB_16_256C_DEFAULT	};
	enum { _IDB_256C_16_HOT		= IDB_16_256C_HOT		};
	enum { _IDB_256C_16_BW		= IDB_16_256C_DISABLED	};
	enum { _IDB_256C_24_DEFAULT = IDB_24_256C_DEFAULT	};
	enum { _IDB_256C_24_HOT		= IDB_24_256C_HOT		};
	enum { _IDB_256C_24_BW		= IDB_24_256C_DISABLED	};
	enum { _IDB_TRUE_16_DEFAULT = IDB_16_TRUE_DEFAULT	};
	enum { _IDB_TRUE_16_HOT		= IDB_16_TRUE_HOT		};
	enum { _IDB_TRUE_16_BW		= IDB_16_TRUE_DISABLED	};
	enum { _IDB_TRUE_24_DEFAULT = IDB_24_TRUE_DEFAULT	};
	enum { _IDB_TRUE_24_HOT		= IDB_24_TRUE_HOT		};
	enum { _IDB_TRUE_24_BW		= IDB_24_TRUE_DISABLED	};

	// masks
	enum { _MASK_TRUE_COLOR		= CLR_NONE				};
	enum { _MASK_256_COLOR		= RGB( 255, 0, 255 )	};

	// whether to allow a file is opened in the same window group during the plug-in execution.
	enum { _ALLOW_OPEN_SAME_GROUP = TRUE				};

	// whether to allow multiple instances.
	enum { _ALLOW_MULTIPLE_INSTANCES = TRUE				};

	// supporting EmEditor newest version * 1000
	enum { _MAX_EE_VERSION		= 5000					};

	// supporting EmEditor oldest version * 1000
	enum { _MIN_EE_VERSION		= 4000					};

	// supports EmEditor Professional
	enum { _SUPPORT_EE_PRO		= TRUE					};

	// supports EmEditor Standard
	enum { _SUPPORT_EE_STD		= TRUE					};

	LCID m_lcid;
	DWORD m_dwFlags;

	void OnCommand( HWND hwnd )
	{
		LCID lcid;
		DWORD dwFlags;
		LoadProfile( lcid, dwFlags );
		m_lcid = lcid;
		m_dwFlags = dwFlags;
		POINT_PTR ptStart, ptEnd;
		Editor_GetSelStart( hwnd, POS_LOGICAL_W, &ptStart );
		Editor_GetSelEnd( hwnd, POS_LOGICAL_W, &ptEnd );
		ptStart.x = 0;
		bool bEndNotRet = false;
		if( ptEnd.x != 0 ){
			if( ptEnd.y == (int)Editor_GetLines( hwnd, POS_LOGICAL_W ) - 1 ){
				bEndNotRet = true;
			}
			ptEnd.x = 0;
			ptEnd.y++;
		}
		INT_PTR nSize = ptEnd.y - ptStart.y;
		if( nSize <= 1 )  return;
		int nCrLf = FLAG_CRLF;
		LPWSTR pszFirstLine = GetLine( hwnd, 0 );
		if( pszFirstLine != NULL ){
			size_t nLen = wcslen( pszFirstLine );
			if( pszFirstLine[nLen-1] == L'\r' ){
				nCrLf = FLAG_CR_ONLY;
			}
			else if( nLen >= 2 && pszFirstLine[nLen-2] == L'\r' && pszFirstLine[nLen-1] == L'\n' ) {
				nCrLf = FLAG_CRLF;
			}
			else {
				nCrLf = FLAG_LF_ONLY;
			}
			delete [] pszFirstLine;
		}
		if( bEndNotRet ){
			Editor_ExecCommand( hwnd, EEID_BOTTOM );
			Editor_InsertStringW( hwnd, nCrLf == FLAG_CRLF ? L"\r\n" : nCrLf == FLAG_CR_ONLY ? L"\r" : L"\n" );
		}
		LPWSTR* apszLine = new LPWSTR[ nSize ];
		if( apszLine == NULL )  return;
		ZeroMemory( apszLine, sizeof( LPWSTR ) * nSize );
		LPWSTR* p = apszLine;
		bool bSuccess = true;
		for( INT_PTR y = ptStart.y; y < ptEnd.y; y++ ){
			*p = GetLine( hwnd, y );
			if( *p == NULL ){
				bSuccess = false;
				break;
			}
			p++;
		}
		if( bSuccess ){
#ifdef UNICODE
			qsort_s( apszLine, nSize, sizeof( LPWSTR ), CompareLineW, this );
#else
			OSVERSIONINFO osvi;
			ZeroMemory( &osvi, sizeof( osvi ) );
			osvi.dwOSVersionInfoSize = sizeof( osvi );
			GetVersionEx( &osvi );
			bool bUnicode = (osvi.dwPlatformId == VER_PLATFORM_WIN32_NT);
			qsort_s( apszLine, nSize, sizeof( LPWSTR ), bUnicode ? CompareLineW : CompareLineA, this );
#endif
			POINT_PTR ptStartView, ptEndView;
			Editor_Redraw( hwnd, FALSE );
			Editor_LogicalToView( hwnd, &ptStart, &ptStartView );
			Editor_LogicalToView( hwnd, &ptEnd, &ptEndView );
			Editor_SetSelView( hwnd, &ptStartView, &ptEndView );
			Editor_ExecCommand( hwnd, EEID_DELETE );
			p = apszLine;
			for( int i = 0; i < nSize; i++ ){
				Editor_InsertStringW( hwnd, *p++ );
			}
			Editor_LogicalToView( hwnd, &ptStart, &ptStartView );
			Editor_LogicalToView( hwnd, &ptEnd, &ptEndView );
			Editor_SetSelView( hwnd, &ptStartView, &ptEndView );
			Editor_Redraw( hwnd, TRUE );
		}
		p = apszLine;
		for( int i = 0; i < nSize; i++ ){
			delete [] *p++;
		}
		delete [] apszLine;
	}

	BOOL QueryStatus( HWND hwnd, LPBOOL pbChecked )
	{		
		*pbChecked = FALSE;
		BOOL bReadOnly;
		Editor_QueryStatus( hwnd, EEID_READ_ONLY, &bReadOnly );
		if( bReadOnly )  return FALSE;
		int nFlags = (Editor_GetSelType( hwnd ) & SEL_TYPE_MASK);
		return (nFlags == SEL_TYPE_CHAR) || (nFlags == SEL_TYPE_LINE);
	}

	void OnEvents( HWND hwnd, UINT nEvent )
	{
		if( nEvent & EVENT_SEL_CHANGED ){
			Editor_UpdateToolbar( hwnd, EEGetCmdID() );
		}
	}

	BOOL QueryUninstall( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetUninstall( HWND hDlg )
	{
		TCHAR sz[80], szAppName[80];
		LoadString( EEGetInstanceHandle(), IDS_SURE_TO_UNINSTALL, sz, sizeof( sz ) / sizeof( TCHAR ) );
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, szAppName, sizeof( szAppName ) / sizeof( TCHAR ) );
		TCHAR szKey[MAX_PATH];
		if( MessageBox( hDlg, sz, szAppName, MB_YESNO | MB_ICONEXCLAMATION ) == IDYES ){
			if( GetRootKeyName( szKey ) ){
				RegDeleteKey( HKEY_CURRENT_USER, szKey );
			}
			return TRUE;
		}
		return FALSE;
	}

	BOOL QueryProperties( HWND /*hDlg*/ )
	{
		return TRUE;
	}

	BOOL SetProperties( HWND hDlg )
	{
		DialogBox( EEGetInstanceHandle(), MAKEINTRESOURCE( IDD_SORT_STRING ), hDlg, PropDlg );
		return TRUE;
	}

	// user defined methods below.
	BOOL LoadProfile( LCID& lcid, DWORD& dwFlags )
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			lcid = GetProfileIntReg( hKey, szLocale, GetSystemDefaultLCID() );
			dwFlags = GetProfileIntReg( hKey, szFlags, 0 );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	BOOL SaveProfile( LCID lcid, DWORD dwFlags )
	{
		HKEY hKey = GetRootKey();
		if( hKey != NULL ){
			WriteProfileIntReg( hKey, szLocale, lcid );
			WriteProfileIntReg( hKey, szFlags, dwFlags );
			RegCloseKey( hKey );
			return TRUE;
		}
		return FALSE;
	}

	LPWSTR GetLine( HWND hwnd, UINT_PTR yLine )
	{
		GET_LINE_INFO gli;
		gli.cch = 0;
		gli.flags = FLAG_LOGICAL | FLAG_WITH_CRLF;
		gli.yLine = yLine;
		UINT_PTR nSize = Editor_GetLineW( hwnd, &gli, NULL );
		LPWSTR pBuf = new WCHAR[ nSize ];
		if( pBuf != NULL ){
			gli.cch = nSize;
			Editor_GetLineW( hwnd, &gli, pBuf );
		}
		return pBuf;
	}

	BOOL OnInitDialog( HWND hwnd )
	{
		TCHAR sz[256];
		LoadString( EEGetInstanceHandle(), IDS_MENU_TEXT, sz, _countof( sz ) );
		SetWindowText( hwnd, sz );
		LCID lcid;
		DWORD dwFlags;
		LoadProfile( lcid, dwFlags );
		HWND hwndComboLocale = GetDlgItem( hwnd, IDC_COMBO_LOCALE );

		{
			// use critication section to protect global variable g_hwndComboLocale from being overwritten by other threads.
			CETLLock lock;
			g_hwndComboLocale = hwndComboLocale;
			if( !EnumSystemLocales( LocaleProc, LCID_SUPPORTED | LCID_ALTERNATE_SORTS ) ){
				DWORD dwError = GetLastError();
				if( dwError == ERROR_INVALID_FLAGS ){  // Windows 98 does not support LCID_ALTERNATE_SORTS
					EnumSystemLocales( LocaleProc, LCID_SUPPORTED );
				}
			}
		}

		int nCount = (int)SendMessage( hwndComboLocale, CB_GETCOUNT, 0, 0 );
		for( int i = 0; i < nCount; i++ ){
			if( (LCID)SendMessage( hwndComboLocale, CB_GETITEMDATA, i, 0 ) == lcid ){
				SendMessage( hwndComboLocale, CB_SETCURSEL, i, 0 );
				break;
			}
		}
		CheckDlgButton( hwnd, IDC_IGNORE_CASE, !!(dwFlags & NORM_IGNORECASE) );
		CheckDlgButton( hwnd, IDC_IGNORE_KANA_TYPE, !!(dwFlags & NORM_IGNOREKANATYPE) );
		CheckDlgButton( hwnd, IDC_IGNORE_NONSPACE, !!(dwFlags & NORM_IGNORENONSPACE) );
		CheckDlgButton( hwnd, IDC_IGNORE_SYMBOLS, !!(dwFlags & NORM_IGNORESYMBOLS) );
		CheckDlgButton( hwnd, IDC_IGNORE_WIDTH, !!(dwFlags & NORM_IGNOREWIDTH) );
		CheckDlgButton( hwnd, IDC_STRING_SORT, !!(dwFlags & SORT_STRINGSORT) );
		return TRUE;
	}

	void OnDlgCommand( HWND hwnd, WORD wCmdID )
	{
		switch( wCmdID ){
		case IDOK:
			{
				HWND hwndComboLocale = GetDlgItem( hwnd, IDC_COMBO_LOCALE );
				int nIndex = (int)SendMessage( hwndComboLocale, CB_GETCURSEL, 0, 0 );
				LCID lcid = 0;
				if( nIndex >= 0 ){
					lcid = (LCID)SendMessage( hwndComboLocale, CB_GETITEMDATA, nIndex, 0 );
				}
				DWORD dwFlags = 0;
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_CASE ) ){
					dwFlags |= NORM_IGNORECASE;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_KANA_TYPE ) ){
					dwFlags |= NORM_IGNOREKANATYPE;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_NONSPACE ) ){
					dwFlags |= NORM_IGNORENONSPACE;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_SYMBOLS ) ){
					dwFlags |= NORM_IGNORESYMBOLS;
				}
				if( IsDlgButtonChecked( hwnd, IDC_IGNORE_WIDTH ) ){
					dwFlags |= NORM_IGNOREWIDTH;
				}
				if( IsDlgButtonChecked( hwnd, IDC_STRING_SORT ) ){
					dwFlags |= SORT_STRINGSORT;
				}
				SaveProfile( lcid, dwFlags );
				EndDialog( hwnd, IDOK );
			}
			break;
		case IDCANCEL:
			EndDialog( hwnd, IDCANCEL );
			break;
		}
		return;
	}
};


INT_PTR CALLBACK PropDlg( HWND hwnd, UINT msg, WPARAM wParam, LPARAM /*lParam*/ )
{
	BOOL bResult = FALSE;
	switch( msg ){
	case WM_INITDIALOG:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			bResult = pFrame->OnInitDialog( hwnd );
		}
		break;
	case WM_COMMAND:
		{
			CMyFrame* pFrame = static_cast<CMyFrame*>(GetFrameFromDlg( hwnd ));
			pFrame->OnDlgCommand( hwnd, LOWORD( wParam ) );
		}
		break;
	}
	return bResult;
}


int __cdecl CompareLineW( void* context, const void* line1, const void* line2 )
{
	CMyFrame* pFrame = (CMyFrame*)context;
	LPWSTR psz1 = *(LPWSTR*)line1;
	LPWSTR psz2 = *(LPWSTR*)line2;
	int nResult = 0;
	if( psz1 != NULL && psz2 != NULL ){
		int n1 = lstrlenW( psz1 );
		if( n1 > 0 && psz1[n1-1] == '\r' || psz1[n1-1] == '\n' )  n1--;
		if( n1 > 0 && psz1[n1-1] == '\r' )  n1--;
		int n2 = lstrlenW( psz2 );
		if( n2 > 0 && psz2[n2-1] == '\r' || psz2[n2-1] == '\n' )  n2--;
		if( n2 > 0 && psz2[n2-1] == '\r' )  n2--;
		nResult = CompareStringW( pFrame->m_lcid, pFrame->m_dwFlags, psz1, n1, psz2, n2 );
	}
	if( nResult == CSTR_LESS_THAN ){
#ifdef DESCEND
		return 1;
#else
		return -1;
#endif
	}
	else if( nResult == CSTR_GREATER_THAN ){
#ifdef DESCEND
		return -1;
#else
		return 1;
#endif
	}
	else {
		return 0;
	}
}


#ifndef UNICODE
int __cdecl CompareLineA( void* context, const void* line1, const void* line2 )
{
	CMyFrame* pFrame = (CMyFrame*)context;
	LPWSTR psz1 = *(LPWSTR*)line1;
	LPWSTR psz2 = *(LPWSTR*)line2;
	int nResult = 0;
	if( psz1 != NULL && psz2 != NULL ){
		size_t nBuf1 = wcslen( psz1 ) * 2 + 1;
		char* pszA1 = new char[ nBuf1 ];
		size_t nBuf2 = wcslen( psz2 ) * 2 + 1;
		char* pszA2 = new char[ nBuf2 ];
		if( pszA1 != NULL && pszA2 != NULL ){
			WideCharToMultiByte( CP_ACP, 0, psz1, -1, pszA1, (int)nBuf1, NULL, NULL );
			WideCharToMultiByte( CP_ACP, 0, psz2, -1, pszA2, (int)nBuf2, NULL, NULL );
			int n1 = lstrlenA( pszA1 );
			if( n1 > 0 && pszA1[n1-1] == '\r' || pszA1[n1-1] == '\n' )  n1--;
			if( n1 > 0 && pszA1[n1-1] == '\r' )  n1--;
			int n2 = lstrlenA( pszA2 );
			if( n2 > 0 && pszA2[n2-1] == '\r' || pszA2[n2-1] == '\n' )  n2--;
			if( n2 > 0 && pszA2[n2-1] == '\r' )  n2--;
			nResult = CompareStringA( pFrame->m_lcid, pFrame->m_dwFlags, pszA1, n1, pszA2, n2 );
		}
		delete [] pszA1;
		delete [] pszA2;
	}
	if( nResult == CSTR_LESS_THAN ){
#ifdef DESCEND
		return 1;
#else
		return -1;
#endif
	}
	else if( nResult == CSTR_GREATER_THAN ){
#ifdef DESCEND
		return -1;
#else
		return 1;
#endif
	}
	else {
		return 0;
	}
}
#endif


BOOL CALLBACK LocaleProc( LPTSTR lpLocaleString )
{
	LPTSTR pEnd;
	LCID lcid = _tcstol( lpLocaleString, &pEnd, 16 );
	TCHAR sz[1024];
	int n = GetLocaleInfo( lcid, LOCALE_SLANGUAGE | LOCALE_USE_CP_ACP, sz, _countof( sz ) - 8 );
	if( n > 0 ){
		WORD wSortID = SORTIDFROMLCID( lcid );
		if( wSortID != SORT_DEFAULT ){
			StringCat( sz + n - 1, _countof( sz ) - n + 1, _T(" ") );
			GetLocaleInfo( lcid, LOCALE_SSORTNAME | LOCALE_USE_CP_ACP , sz + n, _countof( sz ) - 8 );
		}
		int nIndex = (int)SendMessage( g_hwndComboLocale, CB_ADDSTRING, 0, (LPARAM)sz );
		if( nIndex >= 0 ){
			SendMessage( g_hwndComboLocale, CB_SETITEMDATA, nIndex, lcid );
		}
	}
	return TRUE;
}


// the following line is needed after CMyFrame definition
_ETL_IMPLEMENT

