﻿#pragma once

#include <windows.h>
#include <vector>
#include "plugin.h"

namespace customize {
//----------------------------------------------------------------------------

	//	レジストリ/INIファイルからバイナリデータ読み取り
	extern auto Editor_RegQueryBinary(::HWND hwnd, ::DWORD dwKey, ::LPCWSTR pszConfig, ::LPCWSTR pszValue)->std::vector<::BYTE>;

//----------------------------------------------------------------------------

	//	文書タイプごとの設定
	class customize_info_t {
	public:
		customize_info_t(::HWND em, wchar_t const* config);

		//	メンバー値取得
		template<typename T>
		T	operator()(const T CCustomizeInfo::* member_ptr, T&& default_value) const;
	private:
		std::vector<::BYTE>	buffer_;
		auto	get() const {
			return reinterpret_cast<CCustomizeInfo const*>(buffer_.data());
		}
		//	指定メンバー位置までは読み取れているか
		template<typename T>
		bool	is_available(T const& member) const;
	};

//----------------------------------------------------------------------------

	//	文書タイプごとの設定
	inline customize_info_t::customize_info_t(::HWND em, wchar_t const* config) :
		buffer_{ Editor_RegQueryBinary(em, EEREG_CONFIG, config, L"Cust") }
	{
	}

	//	指定メンバー位置までは読み取れているか
	template<typename T>
	inline bool	customize_info_t::is_available(T const& member) const
	{
		auto const req_top{ reinterpret_cast<::BYTE const*>(&member) };
		auto const req_btm{ req_top + sizeof(T) };
		auto const buf_top{ buffer_.data() };
		auto const buf_btm{ buf_top + buffer_.size() };
		return	buf_top <= req_top && req_btm <= buf_btm;
	}

	//	メンバー値取得
	template<typename T>
	inline T	customize_info_t::operator()(const T CCustomizeInfo::* member_ptr, T&& default_value) const
	{
		T const& member(get()->*member_ptr);
		if (is_available(member))
			return	member;
		else
			return	std::forward<T>(default_value);
	}

//----------------------------------------------------------------------------
}
