﻿#include "stdafx.h"
#include "option.h"
#include "tools.h"
#include <cwchar>
#include "resource.h"

#undef min
#undef max

static_assert(sizeof(::UINT32) == sizeof(::DWORD),	"DWORD size mismatch.");
static_assert(sizeof(::UINT32) == sizeof(::INT32),	"INT32 size mismatch.");
static_assert(sizeof(::UINT32) == sizeof(float),	"float size mismatch.");

namespace option
{
	namespace detail
	{
		Base::Base( ::HWND const em ): 
			em_{	 tools::FindMostParentWindow(em) },
			config_{ tools::GetString(IDS_SYSNAME)	 }
		{
		}
	}

//----------------------------------------------------------------------------

	//	データ読み取り
	::LONG	Reader::QueryValue( wchar_t const*const name, ::DWORD const type, void*const data, ::DWORD& size ) const
	{
		return	Editor_RegQueryValue( em_, EEREG_EMEDITORPLUGIN, config_.c_str(), name, type, reinterpret_cast<::BYTE*>(data), &size, 0 );
	}

	//	32bit符号なし整数読み取り
	::UINT32	Reader::UInt32( wchar_t const*const name, ::UINT32 const defaultValue ) const
	{
		::DWORD	value{ defaultValue };
		::DWORD	size{ sizeof(value) };
		return	(QueryValue( name, REG_DWORD, &value, size ) == ERROR_SUCCESS && size == sizeof(value)) ? value : defaultValue;
	}

	//	32bit符号付き整数読み取り
	::INT32	Reader::Int32( wchar_t const*const name, ::INT32 const defaultValue ) const
	{
		::UINT32 const value{ UInt32(name, *reinterpret_cast<::UINT32 const*>(&defaultValue)) };
		return	*reinterpret_cast<::INT32 const*>(&value);
	}

	//	単精度浮動小数点数読み取り
	float	Reader::Float( wchar_t const*const name, float const defaultValue ) const
	{
		::UINT32 const value{ UInt32(name, *reinterpret_cast<::UINT32 const*>(&defaultValue)) };
		return	*reinterpret_cast<float const*>(&value);
	}

	//	論理値読み取り
	bool	Reader::Bool(wchar_t const*const name, bool const defaultValue) const
	{
		return	UInt32(name, defaultValue ? 1u : 0u) != 0u;
	}

	//	文字列読み取り
	auto	Reader::QueryString(wchar_t const*const name) const->std::pair<std::wstring, bool>
	{
		wchar_t	buf[4096];
		::DWORD	size{ sizeof(buf) - sizeof(wchar_t) };
		if( QueryValue( name, REG_SZ, buf, size ) == ERROR_SUCCESS ){
			buf[std::extent<decltype(buf)>::value - 1] = L'\0';
			return	std::make_pair(std::wstring(buf),true);
		}else
			return	std::make_pair(std::wstring(), false);
	}
	auto	Reader::String(wchar_t const*const name, wchar_t const*const defaultValue) const->std::wstring
	{
		auto rsl(QueryString(name));
		if (rsl.second) return std::move(rsl.first);
		if (defaultValue) return defaultValue;
		return std::wstring();
	}
	auto	Reader::String(wchar_t const*const name, std::wstring&&	defaultValue) const->std::wstring
	{
		auto rsl(QueryString(name));
		if (rsl.second) return std::move(rsl.first);
		return std::move(defaultValue);
	}
	auto	Reader::String(wchar_t const*const name, std::wstring const& defaultValue) const->std::wstring
	{
		auto rsl(QueryString(name));
		if (rsl.second) return std::move(rsl.first);
		return defaultValue;
	}

//----------------------------------------------------------------------------

	//	データ書き込み
	::LONG	Writer::SetValue( wchar_t const*const name, ::DWORD const type, void const*const data, ::DWORD size )
	{
		return	Editor_RegSetValue(	em_, EEREG_EMEDITORPLUGIN, config_.c_str(), name, type, reinterpret_cast<::BYTE const*>(data), size, 0 );
	}

	//	32bit符号なし整数書き込み
	bool	Writer::UInt32( wchar_t const*const name, ::UINT32 const value )
	{
		return	SetValue( name, REG_DWORD, &value, sizeof(::UINT32) ) != ERROR_SUCCESS;
	}

	//	32bit符号付き整数書き込み
	bool	Writer::Int32( wchar_t const*const name, ::INT32 const value )
	{
		return	UInt32(name, *reinterpret_cast<::UINT32 const*>(&value));
	}

	//	単精度浮動小数点数書き込み
	bool	Writer::Float( wchar_t const*const name, float const value )
	{
		return	UInt32( name, *reinterpret_cast<::UINT32 const*>(&value) );
	}

	//	論理値書き込み
	bool	Writer::Bool(wchar_t const*const name, bool const value)
	{
		return	UInt32(name, value ? 1u : 0u);
	}

	//	文字列書き込み
	bool	Writer::String( wchar_t const*const name, wchar_t const*const value )
	{
		return	SetValue( name, REG_SZ, value ? value : L"", static_cast<::DWORD>((value ? (std::wcslen(value) + 1) : 1) * sizeof(wchar_t)) ) != ERROR_SUCCESS;
	}

//----------------------------------------------------------------------------
}
