﻿#pragma once

#include <windows.h>
#include <string>
#include <functional>

namespace tools
{
	//	初期化
	extern void	InitializeProcess( ::HINSTANCE instance		 ) noexcept;
	extern void	InitializePlugin( ::HWND em, ::LPARAM lParam ) noexcept;

	//	インスタンスハンドル
	extern auto	Instance() noexcept -> ::HINSTANCE;

	//	コマンドID
	extern int	CommandID() noexcept;

	//	ストリングテーブルから文字列取得
	extern auto	GetString( ::UINT id ) -> std::wstring;
	extern auto	GetString( ::UINT id, ::UINT_PTR cb, wchar_t* buf ) -> ::LONG_PTR;

	//	最も親のウィンドウを探す
	extern auto	FindMostParentWindow( ::HWND hwnd ) noexcept -> ::HWND;

	//	ウィンドウが、指定クラスか？
	extern bool	IsClassedWindow(::HWND const hwnd, wchar_t const* class_name);
	extern bool	IsFrameWindow(	::HWND hwnd );	//	EmEditorMainFrame3か？
	extern bool	IsViewWindow(	::HWND hwnd );	//	EmEditorViewか？

	//	親子関係にあるウィンドウから、指定クラスのものを探す
	extern auto	FindClassedWindow(::HWND const hwnd, wchar_t const* class_name) -> ::HWND;
	extern auto	FindFrameWindow(::HWND hwnd ) -> ::HWND; //	EmEditorMainFrame3か？
	extern auto	FindViewWindow(	::HWND hwnd ) -> ::HWND; //	EmEditorViewか？

	//	同プロセスに属する子ウィンドウにメッセージを送る
	extern void	PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam );	//	※すべての子ウィンドウ
	extern void	PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, std::function<bool (::HWND hwnd)> const& predicate);
}
