﻿#pragma once

#include <windows.h>
#include <string>

namespace option {
#pragma region detail::Base
	namespace detail
	{
		class Base {
		public:
			explicit operator bool	() const noexcept { return !em_; }
			bool	 operator !		() const noexcept { return  em_ == nullptr; }
		protected:
			explicit Base( ::HWND em );
			::HWND		 const	em_;
			std::wstring const	config_;
		private:
			Base(			 Base const& ) = delete;
			Base& operator=( Base const& ) = delete;
		};
	}
#pragma endregion
//----------------------------------------------------------------------------

	//	オプションリーダー
	class Reader final: public detail::Base {
	public:
		explicit Reader( ::HWND em ): detail::Base(em) {}

		//	読み取り
		auto	Bool(	wchar_t const* name, bool			defaultValue = false	) const -> bool;			//	論理値
		auto	UInt32(	wchar_t const* name, ::UINT32		defaultValue = 0u		) const -> ::UINT32;		//	32bit符号なし整数
		auto	Int32(	wchar_t const* name, ::INT32		defaultValue = 0		) const -> ::INT32;			//	32bit符号付き整数
		auto	Float(	wchar_t const* name, float			defaultValue = 0.f		) const -> float;			//	単精度浮動小数点数
		auto	String(	wchar_t const* name, wchar_t const*	defaultValue = nullptr	) const -> std::wstring;	//	文字列
		auto	String(	wchar_t const* name, std::wstring&&	defaultValue			) const -> std::wstring;	//	文字列
		auto	String(	wchar_t const* name, std::wstring const& defaultValue		) const -> std::wstring;	//	文字列
	public:
		//	データ読み取り
		::LONG	QueryValue(	wchar_t const* name, ::DWORD type, void* data, ::DWORD& size ) const;
		auto	QueryString(wchar_t const* name) const->std::pair<std::wstring, bool>;
	};

//----------------------------------------------------------------------------

	//	オプションライター
	class Writer final : public detail::Base {
	public:
		explicit Writer( ::HWND em ): detail::Base(em) {}

		//	書き込み
		bool	Bool(	wchar_t const* name, bool			value );	//	論理値
		bool	UInt32(	wchar_t const* name, ::UINT32		value );	//	32bit符号なし整数
		bool	Int32(	wchar_t const* name, ::INT32		value );	//	32bit符号付き整数
		bool	Float(	wchar_t const* name, float			value );	//	単精度浮動小数点数
		bool	String(	wchar_t const* name, wchar_t const*	value );	//	文字列
	public:
		//	データ書き込み
		::LONG	SetValue( wchar_t const* name, ::DWORD type, void const* data, ::DWORD size );
	};

}
