﻿#include "stdafx.h"
#include "SplitBox.h"
#include "tools.h"
#include "resource.h"

using namespace std;

//----------------------------------------------------------------------------

//	プラグインへのメッセージを使って、さまざまな設定や取得を行います。 
EXTERN_C ::LRESULT	WINAPI PlugInProc( ::HWND const em, ::UINT const nMsg, ::WPARAM const wParam, ::LPARAM const lParam ) 
{
	switch( nMsg ){
	case EP_GET_BITMAP:			return	0;																				//	ツールバーに表示される様々なサイズと色数のプラグイン ボタンのビットマップのリソースIDを取得します。 
	case EP_GET_INFO:			return	SplitBox::GetPluginInfo( em, wParam );											//	プラグインに関するさまざまな情報を取得します。(Version 5.00 以上で対応) 
	case EP_GET_MASK:			return	RGB(255,0,255);																	//	ツールバーに表示されるプラグイン ボタンのマスク カラーを取得します 
	case EP_GET_NAME:			return	tools::GetString( IDS_NAME,		wParam, reinterpret_cast<wchar_t*>(lParam) );	//	プラグインの名前を取得します。 
	case EP_GET_VERSION:		return	tools::GetString( IDS_VERSION,	wParam, reinterpret_cast<wchar_t*>(lParam) );	//	プラグインのバージョンを取得します。 
	case EP_QUERY_PROPERTIES:	return	SplitBox::HasProperty();														//	プロパティが利用可能かどうかを調べます。 
	case EP_SET_PROPERTIES:		return	SplitBox::ShowProperty( em );													//	プロパティの表示を指示します。 
	case EP_QUERY_UNINSTALL:	return	TRUE;																			//	アンインストールが利用可能かどうかを調べます。 
	case EP_SET_UNINSTALL:		return	UNINSTALL_SIMPLE_DELETE;														//	アンインストールを実行します。 
	}
	return	0;
}

//	リソースID取得
EXTERN_C ::UINT	WINAPI GetMenuTextID(){			return	IDS_MENUTEXT;		}	//	プラグインのメニューアイテムテキストのリソースIDを取得します 
EXTERN_C ::UINT	WINAPI GetStatusMessageID(){	return	IDS_STATUSMESSAGE;	}	//	ステータスバーテキストとツールバーのツールチップ用テキストを \n で結合した文字列のリソースIDを取得します。 
EXTERN_C ::UINT	WINAPI GetBitmapID(){			return	IDB_BUTTON;			}	//	ツールバーに表示されるプラグイン ボタンのビットマップのリソースIDを取得します 

//	プラグインが実行可能か、またはチェックされた状態かを調べます 
EXTERN_C BOOL	WINAPI QueryStatus( ::HWND const em, ::LPBOOL const pbChecked )
{
	if( pbChecked ) *pbChecked = SplitBox::IsChecked( em );
	return	SplitBox::CanCommand( em );
}

//	メニューかツールバーからプラグインを選択したときに呼び出されます 
EXTERN_C void	WINAPI OnCommand( ::HWND const em )
{
	SplitBox::OnCommand( em );
}

//	状態が変更されたときにイベントが指定されて呼び出されます 
EXTERN_C void	WINAPI OnEvents( ::HWND const em, ::UINT const nEvent, ::LPARAM const lParam ) 
{
	if( nEvent & EVENT_CREATE ) tools::InitializePlugin( em, lParam );
	SplitBox::OnEvents( em, nEvent, lParam );
}

//----------------------------------------------------------------------------

//	メイン
EXTERN_C BOOL WINAPI DllMain( ::HINSTANCE const instance, ::DWORD const reason, ::LPVOID )
{
	switch( reason ){
	case DLL_PROCESS_ATTACH: tools::InitializeProcess(instance);	break;	//	プロセスにアタッチするとき
	case DLL_PROCESS_DETACH:										break;	//	プロセスからデタッチするとき
	case DLL_THREAD_DETACH:	 SplitBox::OnThreadDetach();			break;	//	スレッドからデタッチするとき
	}
	return	true;
}

//----------------------------------------------------------------------------
