﻿#include "stdafx.h"
#include "tools.h"
#include <type_traits>
#include <cwchar>
#include "resource.h"

namespace tools {
//----------------------------------------------------------------------------
	namespace
	{
		//	インスタンスハンドル
		::HINSTANCE	instance_;

		//	コマンドID
		int command_;
	}

	//	インスタンスハンドル
	::HINSTANCE	Instance() noexcept
	{
		return	instance_;
	}

	//	コマンドID
	int		CommandID() noexcept
	{
		return	command_;
	}

	//	プロセス初期化
	void	InitializeProcess( ::HINSTANCE const instance ) noexcept
	{
		instance_ = instance;
	}

	//	プラグイン初期化
	void	InitializePlugin( ::HWND const em, ::LPARAM const lParam ) noexcept
	{
		command_ = LOWORD(lParam);
	}

//----------------------------------------------------------------------------

	//	ストリングテーブルから文字列取得
	std::wstring	GetString( ::UINT const id )
	{
		wchar_t	name[4096];
		auto const len{ ::LoadStringW(instance_, id, name, static_cast<int>(std::extent<decltype(name)>::value)) };
		return	len ? std::wstring(name,len) : std::wstring();
	}

	//	ストリングテーブルから文字列取得
	::LONG_PTR GetString( ::UINT const id, ::UINT_PTR const cb, wchar_t*const buf )
	{
		//	ストリングテーブルからロード
		wchar_t	name[4096];
		if( !::LoadStringW( instance_, id, name, static_cast<int>(std::extent<decltype(name)>::value) ) ) *name = L'\0';

		//	要求されてればコピー
		if( buf && cb > 0 )
			::wcscpy_s( buf, cb, name );

		//	文字列長+1を返す
		return	std::wcslen(name) + 1;
	}

//----------------------------------------------------------------------------

	//	最も親のウィンドウを探す
	::HWND	FindMostParentWindow( ::HWND hwnd ) noexcept
	{
		auto const hw{ ::GetAncestor(hwnd, GA_ROOTOWNER) };
		return hw ? hw : hwnd;
	}

//----------------------------------------------------------------------------
	namespace
	{
		auto const frame_class_name{ L"EmEditorMainFrame3" };
		auto const  view_class_name{ L"EmEditorView" };
	}

	//	ウィンドウが、指定クラスか？
	bool	IsClassedWindow(::HWND const hwnd, wchar_t const* class_name)
	{
		wchar_t	name[64];
		if (::GetClassNameW(hwnd, name, std::extent<decltype(name)>::value) > 0)
			return	std::wcscmp(name, class_name) == 0;
		return	false;
	}

	//	ウィンドウが、EmEditorViewか？
	bool	IsViewWindow(::HWND const hwnd)
	{
		return	IsClassedWindow(hwnd, view_class_name);
	}

	//	ウィンドウが、EmEditorMainFrame3か？
	bool	IsFrameWindow(::HWND const hwnd)
	{
		return	IsClassedWindow(hwnd, frame_class_name);
	}

	//	親子関係にあるウィンドウから、指定クラスのものを探す
	::HWND	FindClassedWindow(::HWND const hwnd, wchar_t const* class_name)
	{
		//	自身がそれか？
		if (!hwnd || IsClassedWindow(hwnd, class_name)) return hwnd;

		//	親を探す
		auto parent{ hwnd };
		while (auto wnd = ::GetParent(parent)) {
			parent = wnd;
			if (IsClassedWindow(parent, class_name)) return parent;
		}

		//	子を探す
		struct work_t {
			::HWND	child;
			wchar_t const* class_name;
			work_t(wchar_t const* name) : child{}, class_name(name) {}
		};
		work_t const work{ class_name };
		::EnumChildWindows(hwnd, [](::HWND const wnd, ::LPARAM const lParam) {
			auto& work{ *reinterpret_cast<work_t*>(lParam) };
			if (IsClassedWindow(wnd, work.class_name)) {
				work.child = wnd;
				return FALSE;
			}
			return TRUE;
		}, reinterpret_cast<::LPARAM>(&work));
		return work.child;
	}

	//	親子関係にあるウィンドウから、EmEditorViewを探す
	::HWND	FindViewWindow( ::HWND const hwnd )
	{
		return	FindClassedWindow(hwnd, view_class_name);
	}

	//	親子関係にあるウィンドウから、EmEditorMainFrame3を探す
	::HWND	FindFrameWindow(::HWND const hwnd)
	{
		return	FindClassedWindow(hwnd, frame_class_name);
	}

//----------------------------------------------------------------------------

	struct pw2cw_t {
		::DWORD	 process_id;
		::UINT	 msg;
		::WPARAM wParam;
		::LPARAM lParam;
		pw2cw_t( ::UINT const m, ::WPARAM const w, ::LPARAM const l ) noexcept : 
			process_id{ ::GetCurrentProcessId() }, msg{ m }, wParam{ w }, lParam{ l } {}
	};
	struct pw2cw_ex final: public pw2cw_t {
		std::function<bool (::HWND hwnd)> const& predicate;
		pw2cw_ex( ::UINT const m, ::WPARAM const w, ::LPARAM const l, std::function<bool (::HWND hwnd)> const& pred):
			pw2cw_t{ m, w, l }, predicate{ pred } {}
	};

	//	同プロセスに属するすべての子ウィンドウにメッセージを送る
	void	PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam )
	{
		struct local {
			static ::BOOL CALLBACK ChildProc( ::HWND const child, ::LPARAM const lParam ){
				auto const& dat{ *reinterpret_cast<pw2cw_t const*>(lParam) };
				::PostMessage( child, dat.msg, dat.wParam, dat.lParam );
				return TRUE;
			}
			static ::BOOL CALLBACK TopLevelProc( ::HWND const hwnd, ::LPARAM const lParam ){
				::DWORD id{ 0 };
				::GetWindowThreadProcessId( hwnd, &id );
				if( id == reinterpret_cast<pw2cw_t const*>(lParam)->process_id ){
					::EnumChildWindows( hwnd, ChildProc, lParam );
				}
				return TRUE;
			}
		};
		::EnumWindows(local::TopLevelProc, reinterpret_cast<::LPARAM>(&pw2cw_t{ msg, wParam, lParam }));
	}

	//	同プロセスに属する子ウィンドウにメッセージを送る
	void	PostMessageToChildWindow( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, std::function<bool (::HWND hwnd)> const& predicate)
	{
		struct local {
			static ::BOOL CALLBACK ChildProc( ::HWND const child, ::LPARAM const lParam ){
				auto const& dat{ *reinterpret_cast<pw2cw_ex const*>(lParam) };
				if( dat.predicate(child) )
					::PostMessage( child, dat.msg, dat.wParam, dat.lParam );
				return TRUE;
			}
			static ::BOOL CALLBACK TopLevelProc( ::HWND const hwnd, ::LPARAM const lParam ){
				::DWORD id{ 0 };
				::GetWindowThreadProcessId( hwnd, &id );
				if( id == reinterpret_cast<pw2cw_ex const*>(lParam)->process_id ){
					::EnumChildWindows( hwnd, ChildProc, lParam );
				}
				return TRUE;
			}
		};
		::EnumWindows(local::TopLevelProc, reinterpret_cast<::LPARAM>(&pw2cw_ex{ msg, wParam, lParam, predicate }));
	}

//----------------------------------------------------------------------------
}
