﻿#include "stdafx.h"
#include "customize.h"

#undef min
#undef max

namespace customize
{
	//	INIファイルからバイナリを読み取る作業バッファのサイズ
	auto const ini_buffer_size{ 1024 * 1024 };

//----------------------------------------------------------------------------

	//	レジストリ/INIファイルからバイナリデータ読み取り
	auto Editor_RegQueryBinary(::HWND hwnd, ::DWORD dwKey, ::LPCWSTR pszConfig, ::LPCWSTR pszValue) -> std::vector<::BYTE>
	{
		std::vector<::BYTE>	binary;
		if (Editor_Info(hwnd, EI_USE_INI, 0)) {
			//	INI運用
			std::vector<wchar_t> buffer;
			buffer.reserve(ini_buffer_size);
			buffer.resize(buffer.capacity() - 1);
			::DWORD	size{ (static_cast<::DWORD>(buffer.size()) - 1) * sizeof(wchar_t) };
			auto rsl{ Editor_RegQueryValue(hwnd, dwKey, pszConfig, pszValue, REG_SZ, reinterpret_cast<::BYTE*>(buffer.data()), &size, 0) };
			if (rsl == ERROR_SUCCESS) {
				buffer.emplace_back(L'\0');
				auto const length(wcslen(buffer.data()));
				binary.reserve(length / 2);
				for (auto const* p(buffer.data()), *e(p + length - 1); p < e;) {
					::BYTE n{ 0 };
					for (int i(1); i >= 0;--i, ++p) {
						if (iswdigit(*p)) n += (*p - L'0');
						else if (iswxdigit(*p)) {
							if (iswlower(*p))	n += ((*p - L'a') + 10);
							else				n += ((*p - L'A') + 10);
						}
						if (i)
							n *= 16;
					}
					binary.emplace_back(n);
				}
			}
		}else{
			//	レジストリ運用
			::DWORD	size{};
			auto rsl{ Editor_RegQueryValue(hwnd, dwKey, pszConfig, pszValue, REG_BINARY, nullptr, &size, 0) };
			if (rsl == ERROR_SUCCESS) {
				binary.resize(size);
				rsl = Editor_RegQueryValue(hwnd, dwKey, pszConfig, pszValue, REG_BINARY, binary.data(), &size, 0);
				if (rsl == ERROR_SUCCESS)
					binary.resize((std::min)(binary.size(), static_cast<size_t>(size)));
				else
					binary.clear();
			}
		}
		return	std::move(binary);
	}

//----------------------------------------------------------------------------
}
