#include "stdafx.h"
#include "main.h"
#include "resource.h"

//-----------------------------------------------------------------------------

//	XgOe[u當擾
std::wstring	GetStringFromTable( UINT id )
{
	wchar_t	name[4096];
	return	LoadStringW( GetInstanceHandle(), id, name, sizeof(name) / sizeof(name[0]) ) ? name : std::wstring();
}

//	XgOe[u當擾
INT_PTR	GetStringFromTable( UINT id, UINT_PTR cb, wchar_t* buf )
{
	if( buf && cb > 0 ){
		return	::LoadStringW( GetInstanceHandle(), id, buf, static_cast<int>(cb) ) + 1;
	}else{
		wchar_t	name[4096];
		return	::LoadStringW( GetInstanceHandle(), id, name, sizeof(name) / sizeof(name[0]) ) + 1;
	}
}

//	ƂẽEBhE擾
HWND GetTopParent( HWND wnd )
{
	if( wnd ){
		HWND	hw;
		while( hw = GetParent(wnd) ) wnd = hw;
	}
	return	wnd;
}

//-----------------------------------------------------------------------------

//	IvV擾	TCY
DWORD	GetRegSize( HWND wnd, wchar_t const* key )
{
	DWORD	size(0);
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_BINARY, NULL, &size, 0 ) == ERROR_SUCCESS) ? size : 0;
}

//	IvV擾	_l
bool	GetRegBool( HWND wnd, wchar_t const* key, bool defaultValue )
{
	DWORD	value( defaultValue  );
	DWORD	size(  sizeof(value) );
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, reinterpret_cast<BYTE*>(&value), &size, 0 ) == ERROR_SUCCESS && size == sizeof(value)) ? (value != 0) : defaultValue;
}

//	IvVݒ	_l
void	SetRegBool( HWND wnd, wchar_t const* key, bool newValue )
{
	DWORD const	value( newValue ? 1 : 0 );
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, reinterpret_cast<BYTE const*>(&value), sizeof(value), 0 );
}

//	IvV擾	32bit
INT32	GetRegInt32( HWND wnd, wchar_t const* key, INT32 defaultValue )
{
	DWORD	value( defaultValue  );
	DWORD	size(  sizeof(value) );
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, reinterpret_cast<BYTE*>(&value), &size, 0 ) == ERROR_SUCCESS && size == sizeof(value)) ? value : defaultValue;
}

//	IvVݒ	32bit
void	SetRegInt32( HWND wnd, wchar_t const* key, INT32 newValue )
{
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_DWORD, reinterpret_cast<BYTE const*>(&newValue), sizeof(newValue), 0 );
}

//	IvV擾	
std::wstring	GetRegString( HWND wnd, wchar_t const* key, wchar_t const* defaultValue )
{
	wchar_t	buf[4096];
	DWORD	size( sizeof(buf) - sizeof(wchar_t) );
	if( Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_SZ, reinterpret_cast<BYTE*>(buf), &size, 0 ) == ERROR_SUCCESS ){
		buf[sizeof(buf) / sizeof(buf[0]) - 1] = L'\0';
		return	buf;
	}
	return	defaultValue ? defaultValue : L"";
}

//	IvVݒ	
void	SetRegString( HWND wnd, wchar_t const* key, wchar_t const* newValue )
{
	if( !newValue ) newValue = L"";
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_SZ, reinterpret_cast<BYTE const*>(&newValue), ((DWORD)wcslen(newValue) + 1) * sizeof(wchar_t), 0 );
}

//	IvV擾	oCi
bool	GetRegBinary( HWND wnd, wchar_t const* key, void* buffer, DWORD& size )
{
	return	(Editor_RegQueryValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_BINARY, reinterpret_cast<BYTE*>(buffer), &size, 0 ) == ERROR_SUCCESS);
}

//	IvVݒ	oCi
void	SetRegBinary( HWND wnd, wchar_t const* key, void const* buffer, DWORD size )
{
	Editor_RegSetValue( wnd, EEREG_EMEDITORPLUGIN, GetStringFromTable(IDS_SYSNAME).c_str(), key, REG_BINARY, reinterpret_cast<BYTE const*>(buffer), size, 0 );
}
